<?php
class Policy_model extends CI_Model
{
    public function get($id = null)
    {
        $this->db->from('letters')->where(['type' => 'policy', 'deleted_at' => null]);
        if ($id) {
            return $this->db->where('id', $id)->get()->row();
        }
        return $this->db->get()->result();
    }
    public function add($data)
    {
        $res = $this->db->insert('letters', [
            'title' => $data['title'],
            'footer_note' => trim($data['footer_note']),
            'body' => $data['body'],
            'type' => 'policy',
            'author_type' => 'hr',
            'requires_admin_approval' => 0,
            'added_by' => $this->session->userdata('id'),
            'updated_by' => $this->session->userdata('id'),
            'added_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
        if ($res) {
            $res = $this->db->insert_id();

            $this->activity
                ->set_url('incident/policies/view/' . $res)
                ->log([
                    'policy_inserted',
                    $data['title'],
                    $res,
                ]);
            return $res;
        }
        return false;
    }
    public function update($id, $data)
    {
        $res = $this->db->where('id', $id)->update('letters', [
            'title' => $data['title'],
            'footer_note' => trim($data['footer_note']),
            'body' => $data['body'],
            'type' => 'policy',
            'author_type' => 'hr',
            'requires_admin_approval' => 0,
            'updated_by' => $this->session->userdata('id'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
        if ($res) {
            $this->activity
                ->set_url('incident/policies/view/' . $id)
                ->log([
                    'policy_updated',
                    $data['title'],
                    $id,
                ]);
            return $id;
        }
        return false;
    }
    public function delete($id)
    {
        $policy_rec = $this->get($id);
        if($policy_rec){
            $this->activity
                ->set_url('incident/policies/view/' . $id)
                ->log([
                    'policy_deleted',
                    $policy_rec->title,
                    $id,
                ]);
        }
        return $this->db->where('id', $id)->update('letters', [
            'deleted_by' => $this->session->userdata('id'),
            'deleted_at' => date('Y-m-d H:i:s'),
        ]);
    }
    public function get_email_model($id)
    {
        return $this->db->select('incidents.incident_type as subject,
        COALESCE(emp.business_email, emp.home_email, emp.email) as eto,
        email_templates.email_from as efrom,
        incidents.file_path as attachment,
        COALESCE(supervisor.business_email, supervisor.home_email, supervisor.email) as cc')
            ->where('incidents.id', $id)
            ->where('incidents.status', 'approved')
            ->join('employee_history emp', 'incidents.employee_id=emp.employee_id', 'left')
            ->join('employee_history supervisor', 'supervisor.employee_id=emp.super_visor_id', 'left')
            ->join(' email_templates', 'email_templates.division_id=emp.division_id', 'left')
            ->get('incidents')->row();
    }
    public function countAllRows()
    {
        return $this->db->where('type', 'policy')->count_all('letters');
    }
    public function countDatatable($orWhere = [])
    {
        $this->db->where(['letters.type' => 'policy', 'deleted_at' => null]);
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db
            ->join('user add_user', 'add_user.id=added_by', 'left')
            ->join('employee_history add_emp', 'add_emp.email=add_user.email', 'left')
            ->join('user upd_user', 'upd_user.id=updated_by', 'left')
            ->join('employee_history upd_emp', 'upd_emp.email=upd_user.email', 'left');
        return $this->db->count_all_results('letters');
    }
    public function getDatatable($orWhere = [])
    {
        $post = $this->input->post();
        $this->db
            ->select('letters.id, letters.title, CONCAT(\' \', add_emp.first_name, add_emp.last_name) as adder, letters.added_at, CONCAT(\' \', upd_emp.first_name, upd_emp.last_name) as updater, letters.updated_at')
            ->where(['letters.type' => 'policy', 'deleted_at' => null]);
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db
            ->join('user add_user', 'add_user.id=added_by', 'left')
            ->join('employee_history add_emp', 'add_emp.email=add_user.email', 'left')
            ->join('user upd_user', 'upd_user.id=updated_by', 'left')
            ->join('employee_history upd_emp', 'upd_emp.email=upd_user.email', 'left')
            ->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get('letters')->result_array();
    }
    public function send_email($data)
    {
        $this->load->model('letter_model');
        $this->load->library(['TemplateMailer' => 'mailer']);

        $policy = $this->policy_model->get($data['policy_id']);
        if (!is_dir(FCPATH . 'uploads/temp/' . date('Y-m-d'))) {
            mkdir(FCPATH . 'uploads/temp/' . date('Y-m-d'));
        }
        $emp_rec = $this->db->select('business_email')->where('employee_id', $data['employee_id'])->limit(1)->get('employee_history')->row();
        $file = $this->letter_model->generate_pdf_policy($data['policy_id'], $data['employee_id'], $data['division'], true, FCPATH . 'uploads/temp/' . date('Y-m-d') . '/');
        if ($this->mailer->config($data['division'])->_send($emp_rec->business_email, null, $data['subject'], $data['body'], $data['cc'], $data['bcc'], [$policy->title . '.pdf' => $file])) {
            $this->activity->log([
                'letter_policy_sent',
                $policy->title,
                $data['policy_id'],
                $emp_rec->business_email
            ]);
            sendJson(['success' => 'Emails has been sent successfully']);
        } else {
            sendJson(['error' => 'Unable to send email, try again']);
        }
    }
    private function get_employees_email_by_division($division_id)
    {
        $employees = $this->db->select('business_email')->where('division_id', $division_id)->order_by('business_email', 'asc')->get('employee_history')->result();
        $employees = array_column($employees, 'business_email');
        $employees = array_filter($employees, function ($val) {
            return !empty($val);
        });
        return array_unique($employees);
    }

    public function get_tag_suggestion()
    {
        $employee_fields = [
            'hrm_id',
            'prefix',
            'first_name',
            'middle_name',
            'last_name',
            'email',
            'phone',
            'alter_phone',
            'present_address',
            'parmanent_address',
            'father_name',
            'degree_name',
            'institute_name',
            'cgp',
            'passing_year',
            'state',
            'city',
            'dob',
            'home_email',
            'business_email',
            'home_phone',
            'business_phone',
            'cell_phone',
            'emerg_contct',
            'probation_period',
            'performance_duration',
            'resignation_date',
            'cnic',
            'eobi',
            'work_from_home',
            'transportation_required',
            'primary_project',
            'team',
            'campaign',
            'pseudo',
            'medflow_id',
            'skype_id',
            'replacement',
            'last_employer',
            'last_employer_address',
            'account_title',
            'account_number',
            'account_iban',
            'branch_code',
            'branch_address',
            'full_name',
            'supervisor',
            'indirect_supervisor',
            'designation',
            'department',
            'marital_status',
            'religion',
            'gender',
            'date_of_confirmation',
            'date_of_joining',
            'date_of_termination',
            'basic_salary',
            'basic_salary_words',
            'gross_salary',
            'gross_salary_words',
            'title_prefix',
            'relation_of',
            'address_justified',
        ];

        sort($employee_fields);

        $suggestions = array_map(function ($val) {
            return 'employee:' . $val;
        }, $employee_fields);

        $suggestions = array_merge($suggestions, [
            /* Policy */
            'policy:title',
            /* Current */
            'current:date',
            'current:datetime',
            'current:time',
            /* Division */
            'division:name',
            'division:prefix',
            'division:email',
            'division:phone_no',
            'division:address',
            'division:address_justified',
        ]);

        $suggestions = array_merge($suggestions, array_map(function ($val) {
            return 'author:' . $val;
        }, $employee_fields));
        return $suggestions;
    }
}
