<?php
class Incident_type_model extends CI_Model
{
    public function get($id = null)
    {
        $where = [];
        if ($id) {
            $where['incident_type.id'] = $id;
        }
        $res = getByWhere('incident_type, letters-letters.id=incident_type.required_letter_id-left', 'letters.*, incident_type.*', $where, ['incident_type.id', 'asc']);
        if ($id) {
            return @$res[0];
        } else {
            return $res;
        }
    }
    public function add($data)
    {
        $res = $this->db->insert('incident_type', [
            'type' => $data['type'],
            'required_letter_id' => empty($data['required_letter_id']) ? null : $data['required_letter_id'],
        ]);
        if ($res) {
            $res = $this->db->insert_id();
            $this->activity
                ->set_url('incident/Incident/types')
                ->log([
                    'incident_type_inserted',
                    $data['type'],
                ]);
            return $res;
        }
        return $res;
    }
    public function update($id, $data)
    {
        $incident_type = $this->get($id);
        $res = $this->db->where('id', $id)->update('incident_type', [
            'type' => $data['type'],
            'required_letter_id' => empty($data['required_letter_id']) ? null : $data['required_letter_id'],
        ]);
        if ($res) {
            $this->activity
                ->set_url('incident/Incident/types')
                ->log([
                    'incident_type_updated',
                    $incident_type->type,
                    $data['type'],
                ]);
            return $id;
        }
        return $res;
    }
    public function delete($id)
    {
        $type_rec = $this->get($id);
        $this->activity->log([
            'incident_type_deleted',
            $type_rec->type,
            $id
        ]);
        return $this->db->where('id', $id)->delete('incident_type');
    }
}
