<?php
class Incident_model extends CI_Model
{
    private $status_text = [
        'pending' => 'Pending',
        'pending-admin' => 'Pending',
        'rejected' => 'Rejected',
        'approved' => 'Approved',
        'contested-p' => 'Contested',
        'contested-a' => 'Contestation Approved',
        'contested-r' => 'Contestation Rejected',
    ];
    public function get($id = null)
    {
        $this->db->from('incidents');
        if ($id) {
            return $this->db->where('id', $id)->get()->row();
        }
        return $this->db->get()->result();
    }
    public function get_details($id = null)
    {
        $this->db->select(
            'incidents.*,
            employee.first_name as employee_first_name,
            employee.last_name as employee_last_name,
            emp_adder.first_name as adder_first_name,
            emp_adder.last_name as adder_last_name,
            emp_editor.first_name as editor_first_name,
            emp_editor.last_name as editor_last_name'
        )->from('incidents');
        $this->db->join('employee_history employee', 'employee.employee_id=incidents.employee_id', 'left');
        $this->db->join('user adder', 'incidents.added_by=adder.id', 'left');
        $this->db->join('employee_history emp_adder', 'emp_adder.email=adder.email', 'left');
        $this->db->join('user editor', 'incidents.updated_by=editor.id', 'left');
        $this->db->join('employee_history emp_editor', 'emp_editor.email=editor.email', 'left');
        if ($id) {
            return $this->db->where('incidents.id', $id)->get()->row();
        }
        return $this->db->get()->result();
    }
    public function get_employee_incidents($employee_id, $type = null)
    {
        if ($type) {
            $this->db->where('status', $type);
        }
        return $this->db->where(['employee_id' => $employee_id/* 'type' => 'incident' */])->get('incidents')->result();
    }
    public function get_email_model($id)
    {
        return $this->db->select('incidents.incident_type as subject,
        COALESCE(emp.business_email, emp.home_email, emp.email) as eto,
        email_templates.email_from as efrom,
        incidents.file_path as attachment,
        COALESCE(supervisor.business_email, supervisor.home_email, supervisor.email) as cc,
        emp.division_id')
            ->where('incidents.id', $id)
            ->where('incidents.status', 'approved')
            ->join('employee_history emp', 'incidents.employee_id=emp.employee_id', 'left')
            ->join('employee_history supervisor', 'supervisor.employee_id=emp.super_visor_id', 'left')
            ->join(' email_templates', 'email_templates.division_id=emp.division_id', 'left')
            ->get('incidents')->row();
    }
    public function get_status_text($status)
    {
        return $this->status_text[$status];
    }
    public function get_subordinates($include = true, $override = false)
    {
        $this->load->model('employee/employees_model');
        return $this->employees_model->get_subordinates(null, $include, $override);
    }
    public function get_employees()
    {
        if ($this->permission->module('generate_hr_letters')->access()) {
        } elseif ($this->session->userdata('supervisor')) {
            $subordinates = array_column($this->get_subordinates(false), 'employee_id');
            if (!$subordinates) {
                $this->db->where_in('employee_id', [0]);
            } else {
                $this->db->where_in('employee_id', $subordinates);
            }
        } else {
            return [];
        }
        if (!$this->permission->module('show_inactive_employees')->access()) {
            $this->db->where('status', 'active');
        }
        $recs = $this->db->order_by('first_name', 'asc')->get('employee_history')->result();
        return array_map(function ($val) {
            return decrypt_employee_data($val);
        }, $recs);
    }
    public function countAllRows($types)
    {
        if ($this->permission->full('incident')->access() || $this->permission->method('incident_pending', 'update')->access() || $this->permission->method('incident_approved', 'update')->access() || $this->permission->method('incident_rejected', 'update')->access()) {
        } else {
            $this->db->group_start()->where('incidents.added_by', $this->session->userdata('id'));

            if (in_array('approved', $types)) {
                $this->db->or_where('incidents.employee_id', $this->session->userdata('employee_id'));
            }

            if ($this->session->userdata('supervisor')) {
                $emp_ids = $this->get_supervisor_subordinates(true);
                if (!empty($emp_ids)) {
                    $this->db->or_where_in('incidents.employee_id', $emp_ids);
                }
            }

            $this->db->group_end();
        }
        return $this->db->where_in('status', $types)->count_all('incidents');
    }
    public function countDatatable($types, $orWhere = [])
    {
        $this->db->select(
            'incidents.*,
            coalesce(incidents.reason, incidents.description) as details,
            coalesce(employee_name, CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name)) as employee_name,
            CONCAT_WS(\' \', em2.first_name, em2.last_name) as adder'
        )->where_in('incidents.status', $types);
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'after', false);
            }
            $this->db->group_end();
        }
        if ($this->permission->full('incident')->access() || $this->permission->method('incident_pending', 'update')->access() || $this->permission->method('incident_approved', 'update')->access() || $this->permission->method('incident_rejected', 'update')->access()) {
        } else {
            $this->db->group_start()->where('incidents.added_by', $this->session->userdata('id'));

            if (in_array('approved', $types)) {
                $this->db->or_where('incidents.employee_id', $this->session->userdata('employee_id'));
            }

            if ($this->session->userdata('supervisor')) {
                $emp_ids = $this->get_supervisor_subordinates(true);
                if (!empty($emp_ids)) {
                    $this->db->or_where_in('incidents.employee_id', $emp_ids);
                }
            }

            $this->db->group_end();
        }
        $this->db->join('employee_history', 'employee_history.employee_id=incidents.employee_id', 'left');
        $this->db->join('user', 'user.id=incidents.added_by', 'left');
        $this->db->join('employee_history em2', 'em2.email=user.email', 'left');
        return $this->db->count_all_results('incidents');
    }
    public function getDatatable($types, $orWhere = [])
    {
        $post = $this->input->post();

        $this->db->select(
            'incidents.*,
            coalesce(incidents.reason, incidents.description) as details,
            coalesce(incidents.employee_name, CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name)) as employee_name,
            IF (CONCAT_WS(\' \', em2.first_name, em2.last_name) = \'\', \'HR Admin\', CONCAT_WS(\' \', em2.first_name, em2.last_name)) as adder')
            ->where_in('incidents.status', $types);
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }

        if ($this->permission->full('incident')->access() || $this->permission->method('incident_pending', 'update')->access() || $this->permission->method('incident_approved', 'update')->access() || $this->permission->method('incident_rejected', 'update')->access()) {
        } else {
            $this->db->group_start()->where('incidents.added_by', $this->session->userdata('id'));

            if (in_array('approved', $types)) {
                $this->db->or_where('incidents.employee_id', $this->session->userdata('employee_id'));
            }

            if ($this->session->userdata('supervisor')) {
                $emp_ids = $this->get_supervisor_subordinates(true);
                if (!empty($emp_ids)) {
                    $this->db->or_where_in('incidents.employee_id', $emp_ids);
                }
            }

            $this->db->group_end();
        }
        $this->db->join('employee_history', 'employee_history.employee_id=incidents.employee_id', 'left');
        $this->db->join('user', 'user.id=incidents.added_by', 'left');
        $this->db->join('employee_history em2', 'em2.email=user.email', 'left');
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get('incidents')->result_array();
    }
    public function get_logs($id)
    {
        $incident = $this->get($id);
        $incident->logs = $this->db->select('incident_logs.*, CONCAT_WS(\' \', COALESCE(employee_history.first_name, user.firstname), COALESCE(employee_history.last_name, user.lastname)) as sender')
            ->join('user', 'user.id=incident_logs.userId', 'left')
            ->join('employee_history', 'user.email=employee_history.email', 'left')
            ->where('letter_id', $id)->order_by('id', 'desc')->get('incident_logs')->result();
        return $incident;
    }
    public function approve($id)
    {
        $this->load->model('letter_model');
        $incident = $this->get($id);

        $this->db->trans_start();
        $genID = '';

        if (!empty($incident->employee_name)) {
            $inputs = [];
            parse_str($incident->inputs, $inputs);
            $div_id = getByWhere('divisions', 'id', [], [], 1, null, ['name' => $inputs['division_name']])[0];
            $genID = $this->letter_model->generate_letter_id($incident->employee_name, $div_id->id);
        } else {
            $genID = $this->letter_model->generate_letter_id($incident->employee_id);
        }
        $this->letter_model->set_inputs($incident->inputs);

        $this->db->where('id', $id)->update('incidents', [
            'genID' => $genID,
            'status' => 'approved',
            'updated_by' => $this->session->userdata('id'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
        $body = $this->letter_model->return_body($id, true);
        $this->db->where('id', $id)->update('incidents', [
            'body' => $body,
        ]);
        $this->db->insert('incident_logs', [
            'userId' => $this->session->userdata('id'),
            'letter_id' => $this->input->post('id'),
            'old_status' => $incident->status,
            'new_status' => 'approved',
            'remarks' => '',
            'added_at' => date('Y-m-d H:i:s'),
        ]);

        /**
         * Make a copy into employee profile
         */
        if ($incident->letter_id && empty($incident->employee_name)) {
            $filename = $this->letter_model->generate_pdf($incident->id, true, FCPATH . 'assets/employee_documents/');
            $doc_type = $this->db->like('title', str_replace(' ', '%', $incident->incident_type), 'both', false)->limit(1)->get('upload_documents_type')->row();
            if ($doc_type) {
                $doc_type = $doc_type->id;
            } else {
                $this->db->insert('upload_documents_type', [
                    'title' => $incident->incident_type,
                ]);
                $doc_type = $this->db->insert_id();
            }
            $this->db->where('id', $id)->update('incidents', [
                'generated_copy_name' => basename($filename),
            ]);
            $this->db->insert('upload_documents', [
                'employee_id' => $incident->employee_id,
                'documents' => basename($filename),
                'created_date' => date('Y-m-d'),
                'document_type' => $doc_type,
            ]);

            /**
             * Process letter penalties
             */
            $letter = $this->letter_model->get_letter_object($incident->letter_id);
            $questions = $letter->get_questions();
            $user_input = $this->letter_model->get_inputs();

            // process letter penalities
            $penalties = $letter->get_penalties();
            if ($penalties) {
                if ($penalties['leave']) {
                    $this->db->insert('employee_penalties', [
                        'employee_id' => $incident->employee_id,
                        'incident_id' => $incident->id,
                        'type' => 'leave',
                        'amount' => $penalties['leave'],
                        'effective' => date('Y-m-01'),
                    ]);
                    $leave_quota = $this->db->where(['emp_id' => $incident->employee_id, 'year' => date('Y')])->order_by('leave_type', 'asc')->get('employee_leaves')->result_array();
                    if($leave_quota) {
                        $sum = 0;
                        $last_leave_quota = end($leave_quota);
                        reset($leave_quota);
                        foreach ($leave_quota as $leave_qt) {
                            if($leave_qt['leave_qouta'] <= 0) {
                                continue;
                            }
                            if($leave_quota[0] == $leave_qt) {
                                $sum += $leave_qt['leave_qouta'] + $penalties['leave'];
                            } else {
                                $sum = $leave_qt['leave_qouta'] + $sum;
                            }
                            if($sum >= 0) {
                                $this->db
                                ->where('id', $leave_qt['id'])
                                ->update('employee_leaves', [
                                    'leave_qouta' => $sum
                                ]);
                                break;
                            } else {
                                if($last_leave_quota == $leave_qt) {
                                    $this->db
                                    ->where('id', $leave_qt['id'])
                                    ->update('employee_leaves', [
                                        'leave_qouta' => $sum
                                    ]);
                                } else {
                                    $this->db
                                    ->where('id', $leave_qt['id'])
                                    ->update('employee_leaves', [
                                        'leave_qouta' => 0
                                    ]);
                                }
                            }
                        }
                    }
                }
                if ($penalties['salary']) {
                    $this->db->insert('employee_penalties', [
                        'employee_id' => $incident->employee_id,
                        'incident_id' => $incident->id,
                        'type' => 'salary',
                        'amount' => $penalties['salary'],
                        'effective' => date('Y-m-01'),
                    ]);
                }
            }
            // process question based suspension
            foreach ($questions as $question) {
                if (@$question['is_suspension']) {
                    switch ($question['type']) {
                        case 'date':{
                                if ($user_input[$question['name']]) {
                                    $this->db->insert('employee_penalties', [
                                        'employee_id' => $incident->employee_id,
                                        'incident_id' => $incident->id,
                                        'type' => 'suspension',
                                        'date' => convert_excel_date(trim($user_input[$question['name']])),
                                        'effective' => date('Y-m-01'),
                                    ]);
                                }
                                break;
                            }
                        case 'multiple_dates':{
                                $suspension_days = explode(',', $user_input[$question['name']]);
                                foreach ($suspension_days as $suspension_day) {
                                    $this->db->insert('employee_penalties', [
                                        'employee_id' => $incident->employee_id,
                                        'incident_id' => $incident->id,
                                        'type' => 'suspension',
                                        'date' => convert_excel_date(trim($suspension_day)),
                                        'effective' => date('Y-m-01'),
                                    ]);
                                }
                                break;
                            }
                    }
                }
            }
        }
        if (empty($incident->employee_name)) {
            $this->notify->employee($incident->employee_id)->send(
                sprintf('New letter "%s" is issued for you. Please visit HR', $incident->incident_type)
            );
            $emp_rec = $this->db->where('employee_id', $incident->employee_id)->get('employee_history')->row();
            $this->notify->department('hr');
            if ($emp_rec->super_visor_id) {
                $this->notify->employee($emp_rec->super_visor_id);
            }
            if ($incident->added_by) {
                $this->notify->user($incident->added_by);
            }
            $this->notify->send(
                sprintf('Letter "%s" request for %s %s (%s) has been approved', $incident->incident_type, $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                'incident/approved'
            );
        } else {
            $this->notify->department('hr')->user($incident->added_by)->send(
                sprintf('Letter "%s" request for %s has been approved', $incident->incident_type, $incident->employee_name),
                'incident/approved'
            );
        }
        if (empty($incident->employee_name)) {
            $this->activity
                ->set_url('incident/details/' . $incident->id)
                ->set_employee($incident->employee_id)
                ->log([
                    'incident_approved',
                    $incident->type,
                    $incident->incident_type,
                ]);
        } else {
            $this->activity
                ->set_url('incident/details/' . $incident->id)
                ->log([
                    'incident_approved_outside',
                    $incident->type,
                    $incident->incident_type,
                    $incident->employee_name,
                ]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function reject($id, $remarks)
    {
        $incident = $this->get($id);

        $this->db->trans_start();
        $this->db->where('id', $id)->update('incidents', [
            'status' => 'rejected',
            'updated_by' => $this->session->userdata('id'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
        $this->db->insert('incident_logs', [
            'userId' => $this->session->userdata('id'),
            'letter_id' => $this->input->post('id'),
            'old_status' => $incident->status,
            'new_status' => 'rejected',
            'remarks' => htmlspecialchars($remarks),
            'added_at' => date('Y-m-d H:i:s'),
        ]);
        if (empty($incident->employee_name)) {
            $emp_rec = $this->db->where('employee_id', $incident->employee_id)->get('employee_history')->row();
            $this->notify->user($incident->added_by)->send(
                sprintf('Letter "%s" request for %s %s (%s) has been rejected.<br>Reason: %s', $incident->incident_type, $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id, strip_tags($remarks)),
                'incident/rejected'
            );
        } else {
            $this->notify->user($incident->added_by)->send(
                sprintf('Letter "%s" request for %s has been rejected.<br>Reason: %s', $incident->incident_type, $incident->employee_name, strip_tags($remarks)),
                'incident/rejected'
            );
        }
        if (empty($incident->employee_name)) {
            $this->activity
                ->set_url('incident/details/' . $incident->id)
                ->set_employee($incident->employee_id)
                ->log([
                    'incident_rejected',
                    $incident->type,
                    $incident->incident_type,
                ]);
        } else {
            $this->activity
                ->set_url('incident/details/' . $incident->id)
                ->log([
                    'incident_rejected_outside',
                    $incident->type,
                    $incident->incident_type,
                    $incident->employee_name,
                ]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function contest($id, $remarks)
    {
        $this->db->trans_start();
        $incident = $this->get($id);
        $this->db->where('id', $id)->update('incidents', [
            'status' => 'contested-p',
            'updated_by' => $this->session->userdata('id'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
        $this->incident_log($id, 'contested-p', $remarks);

        if (!empty($incident->employee_name)) {
            $author_rec = $this->db->where('employee_id', $this->session->userdata('employee_id'))->get('employee_history')->row();
            $this->notify->department('hr')->user($incident->updated_by)->send(
                sprintf('%s %s (%s) has contested rejection of their letter "%s" for %s.<br>Reason: %s', $author_rec->first_name ?? 'HR', $author_rec->last_name ?? 'Admin', $author_rec->hrm_id ?? 'N/A', $incident->incident_type, $incident->employee_name, strip_tags($remarks)),
                'incident/rejected'
            );
        } else {
            $emp_rec = $this->db->where('employee_id', $incident->employee_id)->get('employee_history')->row();
            $author_rec = $this->db->where('employee_id', $this->session->userdata('employee_id'))->get('employee_history')->row();
            $this->notify->department('hr')->user($incident->updated_by)->send(
                sprintf('%s %s (%s) has contested rejection of their letter "%s" for %s %s (%s).<br>Reason: %s', $author_rec->first_name ?? 'HR', $author_rec->last_name ?? 'Admin', $author_rec->hrm_id ?? 'N/A', $incident->incident_type, $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id, strip_tags($remarks)),
                'incident/rejected'
            );
        }
        if (empty($incident->employee_name)) {
            $this->activity
                ->set_url('incident/details/' . $incident->id)
                ->set_employee($incident->employee_id)
                ->log([
                    'incident_contested',
                    $incident->incident_type,
                ]);
        } else {
            $this->activity
                ->set_url('incident/details/' . $incident->id)
                ->log([
                    'incident_contested_outside',
                    $incident->incident_type,
                    $incident->employee_name,
                ]);

        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function contest_status($id, $status)
    {
        if (!in_array($status, ['accept', 'reject'])) {
            return false;
        }
        $incident = $this->get($id);
        if ($incident->status != 'contested-p') {
            return false;
        }
        $this->db->trans_start();
        $this->db->where('id', $id)->update('incidents', [
            'status' => $status == 'accept' ? 'contested-a' : 'contested-r',
            'updated_by' => $this->session->userdata('id'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
        $this->incident_log($id, $status == 'accept' ? 'contested-a' : 'contested-r');
        if ($status == 'accept') {
            if (empty($incident->employee_name)) {
                $emp_rec = $this->db->where('employee_id', $incident->employee_id)->get('employee_history')->row();
                $this->notify->user($incident->added_by)->send(
                    sprintf('Review of your letter request "%s" for %s %s (%s) is being done.', $incident->incident_type, $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                    'incident/pending'
                );
            } else {
                $this->notify->user($incident->added_by)->send(
                    sprintf('Review of your letter request "%s" for %s is being done.', $incident->incident_type, $incident->employee_name),
                    'incident/pending'
                );
            }
        }
        if (empty($incident->employee_name)) {
            $this->activity
                ->set_url('incident/details/' . $incident->id)
                ->set_employee($incident->employee_id)
                ->log([
                    'incident_contestation_status',
                    $status == 'accept' ? 'Accepted' : 'Rejected',
                    $incident->incident_type,
                ]);
        } else {
            $this->activity
                ->set_url('incident/details/' . $incident->id)
                ->log([
                    'incident_contestation_status_outside',
                    $status == 'accept' ? 'Accepted' : 'Rejected',
                    $incident->incident_type,
                    $incident->employee_name,
                ]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function incident_log($id, $status, $remarks = '')
    {
        $incident = $this->get($id);
        $this->db->insert('incident_logs', [
            'userId' => $this->session->userdata('id'),
            'letter_id' => $id,
            'old_status' => $incident->status,
            'new_status' => $status,
            'remarks' => htmlspecialchars($remarks),
            'added_at' => date('Y-m-d H:i:s'),
        ]);
    }
    public function get_email_status($id)
    {
        return $this->db->select('email_sent')->where('id', $id)->get('incidents')->row()->email_sent == 1;
    }
    public function get_emails($id)
    {
        return $this->db->select('emp.division_id as division_id, emp.business_email as employee, supr.business_email as supervisor')
            ->where('incidents.id', $id)
            ->join('employee_history as emp', 'emp.employee_id=incidents.employee_id', 'left')
            ->join('employee_history as supr', 'emp.super_visor_id=supr.employee_id', 'left')
            ->get('incidents')
            ->row();
    }
    public function get_supervisor_subordinates($override = false)
    {
        $emps = $this->get_subordinates(false, $override);
        return array_column($emps, 'employee_id');
    }
    
    public function regenerate($id)
    {
        $this->load->model('letter_model');
        $incident = $this->get($id);

        $this->db->trans_start();
        $this->letter_model->set_inputs($incident->inputs);
        $body = $this->letter_model->return_body($id, true, true);
        $this->db->where('id', $id)->update('incidents', [
            'body' => $body,
        ]);

        /**
         * Make a copy into employee profile
         */
        if ($incident->letter_id && empty($incident->employee_name)) {
            @unlink(FCPATH . 'assets/employee_documents/' . $incident->generated_copy_name);
            $this->letter_model->generate_pdf($incident->id, true, FCPATH . 'assets/employee_documents/', $incident->generated_copy_name);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
}
