<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Policies extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('policy_model');
    }
    public function add()
    {
        $this->permission->method('policies_add', 'create')->redirect();
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'title',
                    'label' => 'Title',
                    'rules' => 'trim|strip_tags|required|min_length[3]|max_length[255]',
                ),
                array(
                    'field' => 'footer_note',
                    'label' => 'Footer Note',
                    'rules' => 'trim|strip_tags|max_length[145]',
                ),
                array(
                    'field' => 'body',
                    'label' => 'Body',
                    'rules' => 'required',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === true) {
                if ($this->policy_model->add($this->input->post())) {
                    $this->session->set_flashdata('success', 'Policy added successfully');
                    redirect('incident/policies/all');
                } else {
                    $this->session->set_flashdata('exception', 'Unable to add policy, try again later');
                }
            } else {
                $this->session->set_flashdata('exception', validation_errors());
            }
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = 'Add Policy';
        $data['module'] = 'incident';
        $data['full_suggestions'] = $this->policy_model->get_tag_suggestion();
        $data['page'] = 'policies/add';
        echo Modules::run('template/layout', $data);
    }
    public function view($id)
    {
        $this->permission->method('policies_list', 'read')->redirect();
        $data['policy'] = $this->policy_model->get($id);
        if (!$data['policy']) {
            $this->session->set_flashdata('exception', 'Policy not found / Incorrect policy ID');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = $data['policy']->title;
        $data['divisions'] = $this->db->select('id, name')->order_by('name')->get('divisions')->result();
        $data['employees'] = $this->db->select('employee_id, first_name, last_name, hrm_id')->order_by('first_name', 'asc')->get('employee_history')->result();
        $data['email_templates'] = $this->db->select('id, name')->where('category_id <', 17)->or_where('category_id >', 22)->order_by('name')->get('document_template')->result();
        $data['module'] = 'incident';
        $data['page'] = 'policies/view';
        echo Modules::run('template/layout', $data);
    }
    public function update($id)
    {
        $this->permission->method('policies_list', 'update')->redirect();
        $after_submit = false;
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'title',
                    'label' => 'Title',
                    'rules' => 'trim|strip_tags|required|min_length[3]|max_length[255]',
                ),
                array(
                    'field' => 'footer_note',
                    'label' => 'Footer Note',
                    'rules' => 'trim|strip_tags|max_length[145]',
                ),
                array(
                    'field' => 'body',
                    'label' => 'Body',
                    'rules' => 'required',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === true) {
                if ($this->policy_model->update($id, $this->input->post())) {
                    $this->session->set_flashdata('success', 'Policy updated successfully');
                    redirect('incident/policies/all');
                } else {
                    $this->session->set_flashdata('exception', 'Unable to save policy, try again later');
                }
            } else {
                $this->session->set_flashdata('exception', validation_errors());
            }
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = 'Update Policy';
        $data['module'] = 'incident';
        $data['page'] = 'policies/update';
        $data['full_suggestions'] = $this->policy_model->get_tag_suggestion();
        $data['after_submit'] = $after_submit;
        $data['policy'] = $this->policy_model->get($id);
        if (!$data['policy']) {
            $this->session->set_flashdata('exception', 'Policy not found / Incorrect policy ID');
            redirect($_SERVER['HTTP_REFERER']);
        }
        echo Modules::run('template/layout', $data);
    }
    public function delete($id)
    {
        $this->permission->method('policies_list', 'delete')->redirect();
        if ($this->policy_model->delete($id)) {
            $this->session->set_flashdata('success', 'Policy deleted successfully');
        } else {
            $this->session->set_flashdata('exception', 'Unable to delete policy, try again later');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function all()
    {
        $this->permission->method('policies_list', 'read')->redirect();
        if ($this->input->post() && $this->input->is_ajax_request()) {
            $this->get_datatable();
        }
        $data['divisions'] = $this->db->select('id, name')->order_by('name')->get('divisions')->result();
        $data['employees'] = $this->db->select('employee_id, first_name, last_name, hrm_id')->order_by('first_name', 'asc')->get('employee_history')->result();
        $data['email_templates'] = $this->db->select('id, name')->where('category_id <', 17)->or_where('category_id >', 22)->order_by('name')->get('document_template')->result();
        $data['title'] = display('policies');
        $data['module'] = 'incident';
        $data['page'] = 'policies/list';
        echo Modules::run('template/layout', $data);
    }
    public function test($id)
    {
        $this->permission->method('policies_list', 'read')->redirect();
        $division = $this->db->select('id')->order_by('id', 'asc')->limit(1)->get('divisions')->row();
        $emp = $this->db->select('employee_id')->order_by('employee_id', 'asc')->limit(1)->get('employee_history')->row();
        $this->load->model('letter_model');
        $this->letter_model->generate_pdf_policy($id, $emp->employee_id, $division->id);
    }
    function print($id, $division_id, $employee_id) {
        $this->permission->method('policies_list', 'read')->redirect();
        $this->load->model('letter_model');
        $this->letter_model->generate_pdf_policy($id, $employee_id, $division_id);
    }
    private function get_datatable()
    {
        $search_arr = [];
        $search_columns = [
            'letters.id',
            'letters.title',
            'add_user.firstname',
            'add_user.lastname',
            'upd_user.firstname',
            'upd_user.lastname',
            'DATE_FORMAT(letters.updated_at, \'%d-%m-%Y %r\')',
            'CONCAT(\' \', add_emp.first_name, add_emp.middle_name, add_emp.last_name)',
            'CONCAT(\' \', upd_emp.first_name, upd_emp.middle_name, upd_emp.last_name)',
            'CONCAT(\' \', add_user.firstname, add_user.lastname)',
            'CONCAT(\' \', upd_user.firstname, upd_user.lastname)',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->policy_model->countAllRows();
        $out_arr["recordsFiltered"] = $this->policy_model->countDatatable($search_arr);
        $rows = $this->policy_model->getDatatable($search_arr);
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'updated_by':{
                            if ($rec['updater']) {
                                $tdData = $rec['updater'];
                            } else {
                                $tdData = $rec['adder'];
                            }
                            if (!$tdData) {
                                $tdData = 'HR Admin';
                            }
                            break;
                        }
                    case 'updated_at':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'action':{
                            $tdData = '<div class="btn-group"><button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Action <span class="caret"></span></button><ul class="dropdown-menu">';
                            $btns = [];
                            $btns[] = '<li><a href="' . base_url('incident/policies/view/' . $rec['id']) . '" >View</a></li>';
                            $btns[] = '<li role="separator" class="divider"></li>';
                            if ($this->permission->method('policies_list', 'update')->access()) {
                                $btns[] = '<li><a href="' . base_url('incident/policies/update/' . $rec['id']) . '" >Edit</a></li>';
                                $btns[] = '<li role="separator" class="divider"></li>';
                            }
                            $btns[] = '<li><a href="#" class="btnprint" data-id="' . $rec['id'] . '">Print</a></li>';
                            $btns[] = '<li><a href="#" class="btnemail" data-id="' . $rec['id'] . '">Send as email</a></li>';
                            //$btns[] = '<li role="separator" class="divider"></li>';
                            //$btns[] = '<li><a target="_blank" href="' . base_url('incident/policies/test/' . $rec['id']) . '" >View PDF Sample</a></li>';
                            if ($this->permission->method('policies_list', 'delete')->access()) {
                                $btns[] = '<li role="separator" class="divider"></li>';
                                $btns[] = '<li><a href="#" onclick="confirmdelete(\'Are you sure you want to delete this policy?\', \'' . base_url('incident/policies/delete/' . $rec['id']) . '\')">Delete</a></li>';
                            }
                            if (!$btns) {
                                $tdData = '';
                                break;
                            }
                            $tdData .= implode('', $btns);
                            $tdData .= '</ul></div>';
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function get_div_from()
    {
        if ($this->input->post('id') && $this->input->is_ajax_request()) {
            $rec = $this->db
                ->select('email_from')
                ->where('division_id', $this->input->post('id'))
                ->get('email_templates')
                ->row();
            if ($rec) {
                sendJson(['success' => $rec]);
            }
            sendJson(['error' => 'Unable to find the division\'s email settings']);
        }
    }
    public function get_email_template()
    {
        if ($this->input->post('id') && $this->input->is_ajax_request()) {
            $rec = $this->db
                ->select('subjects as subject, template as body')
                ->where('id', $this->input->post('id'))
                ->get('document_template')
                ->row();
            if ($rec) {
                sendJson(['success' => $rec]);
            }
            sendJson(['error' => 'Unable to load requested email template']);
        }
    }
    public function send_email()
    {
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'division',
                    'label' => 'Division',
                    'rules' => 'trim|required|is_natural',
                ),
                array(
                    'field' => 'employee_id',
                    'label' => 'To',
                    'rules' => 'trim|required|is_natural',
                ),
                array(
                    'field' => 'subject',
                    'label' => 'Subject',
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'body',
                    'label' => 'Body',
                    'rules' => 'trim|required',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                $errs = [];
                foreach ($_POST as $key => $value) {
                    if (form_error($key)) {
                        $errs[] = [$key, form_error($key)];
                    }
                }
                if(trim(strip_tags($_POST['body']))){
                    $errors[] = ['body', 'The body field is required'];
                }
                sendJson(['errors' => $errs]);
            }
            $this->policy_model->send_email($this->input->post());
        }
    }
}
