<script>
    $(document).ready(function () {
        $('span.upload-span button').on('click', function () {
            $this = $(this).closest('span.upload-span')
            var myFormData = new FormData();
            if(!$this.find('input[type=file]')[0].files.length) {
                alert('Please select a file to upload')
                return
            }
            myFormData.append('file', $this.find('input[type=file]')[0].files[0]);
            myFormData.append('id', $this.find('input[type=file]').data('id'));

            $.ajax({
                type: 'POST',
                url: '<?= base_url('employee/employees_documents/upload') ?>',
                processData: false,
                contentType: false,
                data: myFormData,
                beforeSend: function () {
                    $this.hide()
                    $this.closest('td').append('<div class="progress"><div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" aria-valuenow="45" aria-valuemin="0" aria-valuemax="100" style="width: 0%">0%</div></div>');
                },
                error: function() {
                    $this.show()
                    $this.siblings('.progress').hide()
                },
                xhr: function () {
                var myXhr = $.ajaxSettings.xhr();
                    if (myXhr.upload) {
                        myXhr.upload.addEventListener('progress', function (e) {
                            if (e.lengthComputable) {
                                let progress = Math.round((e.loaded / e.total) * 100) + '%';
                                let bar = $this.closest('div').find('.progress-bar');
                                bar.text(progress)
                                bar.css('width', progress)
                            }
                        }, false);
                    }
                    return myXhr;
                },
                complete: function(){
                    $this.siblings('.progress').hide()
                },
                success: function (res) {
                    if(res.success) {
                        $this.closest('td').html(`<a href="${res.success}">${res.success.substr(res.success.lastIndexOf('/') + 1)}</a>`)
                    } else if (res.error) {
                        $this.show()
                        alert(res.error)
                    } else {
                        $this.show()
                        alert('Unknown error, try again');
                        console.log(res);
                    }
                }
            });
        });
        $('button.upload-multi').on('click', function () {
            var myFormData = new FormData();
            let hasFiles = 0;
            $this = $('table')
            $this.find('tr').removeClass('errorTR')
            let errors = 0
            $this.find('input').each(function(){
                if($(this).data('required') && !$(this)[0].files.length) {
                    if(errors < 1){
                        alert('Please select a file to upload')
                    }
                    $(this).closest('tr').addClass('errorTR')
                    errors++;
                    return
                }
                if($(this)[0].files.length) {
                    myFormData.append('file_' + $(this).data('id'), $(this)[0].files[0]);
                    hasFiles++;
                }
            })
            if(errors > 0) {
                return
            }
            if(hasFiles < 1) {
                alert('Select a file first')
                return
            }
            $.ajax({
                type: 'POST',
                url: '<?= base_url('employee/employees_documents/upload_ajax_multi') ?>',
                processData: false,
                contentType: false,
                data: myFormData,
                beforeSend: function () {
                    $this.hide()
                    $this.closest('div').append('<div class="progress"><div class="progress-bar progress-bar-success progress-bar-striped active" role="progressbar" aria-valuenow="45" aria-valuemin="0" aria-valuemax="100" style="width: 0%">0%</div></div>');
                },
                error: function() {
                    $this.show()
                    $this.siblings('.progress').hide()
                },
                xhr: function () {
                var myXhr = $.ajaxSettings.xhr();
                    if (myXhr.upload) {
                        myXhr.upload.addEventListener('progress', function (e) {
                            if (e.lengthComputable) {
                                let progress = Math.round((e.loaded / e.total) * 100) + '%';
                                let bar = $this.closest('div').find('.progress-bar');
                                bar.text(progress)
                                bar.css('width', progress)
                            }
                        }, false);
                    }
                    return myXhr;
                },
                complete: function(){
                    $this.siblings('.progress').hide()
                },
                success: function (res) {
                    if(res.success) {
                        res.success.forEach(file => {
                            $(`.file_${file[0]}`).closest('td').html(`<a target="_blank" href="${file[1]}">${file[1]}</a>`)
                        });
                        alert('All Documents are uploaded');
                        $('.se-pre-con').show()
                        location.reload()
                    } else if (res.errors) {
                        res.errors.forEach(err => {
                            $(`.${err[0]}`).closest('tr').addClass('errorTR')
                            alert(err[1])
                        });
                        $this.show()
                    } else if (res.error) {
                        $this.show()
                        alert(res.error)
                    } else {
                        $this.show()
                        alert('Unknown error, try again');
                        console.log(res);
                    }
                }
            });
        });
    });
</script>