<style>
    label.error {
        color: red;
    }
</style>
<script src="<?= base_url() ?>assets/plugins/jquery-validation/jquery.validate.min.js"></script>
<script src="<?= base_url() ?>assets/plugins/jquery-validation/additional-methods.min.js"></script>
<script>
$(document).ready(function() {
    $('[name=cnic]').inputmask("99999-9999999-9")
    $('[name=account_iban]').inputmask("A{2}9{2} A{4} 9{16,}")
    $('form#emp_form').validate({
        ignore: [],
        rules: {
            first_name: {
                required: true,
            },
            last_name: {
                required: true,
            },
            email: {
                required: true,
                email: true,
            },
            phone: {
                required: true,
            },
            h_phone: {
                required: true,
            },
            c_phone: {
                required: true,
            },
            cnic: {
                required: true,
                maxlength: 15,
            },
            division: {
                required: true,
            },
            department: {
                required: true,
            },
            designation: {
                required: true,
            },
            status: {
                required: true,
            },
            duty_type: {
                required: true,
            },
            shift: {
                required: true,
            },
            hiredate: {
                required: true,
            },
            ohiredate: {
                required: true,
            },
            rate_type: {
                required: true,
            },
            hired_salary: {
                required: true,
            },
            dob: {
                required: true,
            },
            gender: {
                required: true,
            },
            account_number: {
                minlength: 13,
                maxlength: 20,
            },
            account_iban: {
                minlength: 24,
                maxlength: 24,
                normalizer: function(value) {
                    let newval = $.trim(value.replace(/[\s\_\-]+/g, ''));
                    console.log(newval);
                    return newval
                }
            }
        },
        invalidHandler: function(form, validator) {
            if(validator.numberOfInvalids() > 0) {
                let id = $(validator.errorList[0].element).closest('.tab-pane').attr('id');
                $('ul.nav-tabs').find(`a[href="#${id}"]`).trigger('click')
                setTimeout(() => {
                    $('html, body').animate({
                        scrollTop: $(validator.errorList[0].element).offset().top - 30
                    }, 1000);
                }, 200);
            }
            validator.focusInvalid();
        },
        submitHandler: function(form) {
            form.submit()
        }
    });
});
</script>