<script>
$(document).ready(function() {
    $('#btn-generate-domain').on('click', function() {
        if(!confirm('Do you want to send request to IT department for domain generation?')) {
            return;
        }
        myajax({
            type: "GET",
            url: "<?=base_url('employee/domain_request/create/' . $data->employee_id)?>",
            success: function(res) {
                if (res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    )
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
            }
        });
    })
    $('#btn-generate-creds').on('click', function() {
        var data = {
            id: '<?=$data->employee_id?>'
        }
        var $pseudo = $('#menu1 [name=pseudo]');
        var $first_name = $('#home [name=first_name]')
        var $last_name = $('#home [name=last_name]')
        var name = [$first_name.val(), $last_name.val()].join(' ');
        if (!$.trim($pseudo.val())) {
            if (confirm(`Pseudo field is empty. Do you want to generate credentials using the employee name "${name}"?`)) {
                while (name.length > 20) {
                    name = prompt(`Employee name "${name}" is longer than 20 characters. Please enter different name for MLM portal IDs`)
                }
                while (name.length < 3) {
                    name = prompt(`Employee name "${name}" length is less than 3 characters. Please enter different name for MLM portal IDs`)
                }
                data.name = name
            } else {
                return
            }
        } else {
            data.pseudo = $pseudo.val()
        }
        myajax({
            type: "POST",
            url: "<?=base_url('recruitment/hired/generate_credentials')?>",
            data: data,
            success: function(res) {
                if (res.success) {
                    let $modal = $('#modelCreds');
                    $modal.find('.modal-body').html(res.success)
                    $modal.modal('show')
                    $modal.find('select').selectize({
                        plugins: ["remove_button"]
                    })
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
            }
        });
    })
    $('#modelCreds form').on('submit', function(e) {
        e.preventDefault()
        var $form = $(this)
        myajax({
            type: "POST",
            url: "<?=base_url('recruitment/hired/process_credentials')?>",
            data: $form.serialize(),
            beforeSend: function() {
                $form.find('.error').remove()
            },
            success: function(res) {
                if (res.success) {
                    Swal.fire(
                        '<?= display('success') ?>!',
                        res.success,
                        'success'
                    )
                    let $modal = $('#modelCreds');
                    $modal.modal('hide')
                } else if (res.errors) {
                    res.errors.forEach(err => {
                        let el = $form.find(`[name=${err[0]}]`)
                        el.closest('div.form-group').addClass('has_error')
                        el.closest('div.form-group').append(
                            `<div class="error">${err[1]}</div>`)
                    });
                } else if (res.error) {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        res.error,
                        'error'
                    )
                } else {
                    Swal.fire(
                        '<?= display('error') ?>!',
                        'Unknown server error, try again',
                        'error'
                    )
                }
                if (res.reload) {
                    location.reload()
                }
            }
        });
    })
});
</script>
<div class="modal fade" id="modelCreds" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <form action="#" method="POST">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>