<style>
table#pinfo-panel {
    color: #05253a;
    text-transform: initial;
    font-weight: 600;
}

.accord {
    border-style: unset;
    border-radius: 7px !important;
    display: block;
    font-size: 14px;
    text-transform: uppercase;
    word-spacing: 3px;
    text-decoration: none;
}

.panel-title>a,
.panel-title>a:active {
    display: block;
    color: #555;
    font-size: 16px;
    font-weight: bold;
    text-transform: uppercase;
    letter-spacing: 1px;
    word-spacing: 3px;
    text-decoration: none;
}

.panel-heading a:before {
    font-family: 'Glyphicons Halflings';
    content: "\e114";
    float: right;
    transition: all 0.5s;
}

.panel-heading.active a:before {
    -webkit-transform: rotate(180deg);
    -moz-transform: rotate(180deg);
    transform: rotate(180deg);
}

td .editpencil {
    margin-left: 5px;
    cursor: pointer;
    color: blue;
    font-size: 16px;
}

#jedit-form *:not(.btn) {
    display: block;
    margin-bottom: 10px;
}

#jedit-form .btn {
    margin: 0px 2px;
}
#jedit-form .jedit-input-child {
    width: 100%;
}

p.pending-request {}
</style>
<div class="row profile_page accordion_wrapper">
    <div class="profile_header">
        <div class="col-md-2">
            <div class="profile_img">
                <div class="user_photo"><?php echo "<img src='" . base_url().$row->picture."'  class=img-circle>";?>
                </div>
                <button type="button" class="btn btn-warning" style="margin: 0 0 15px 0" id="btnPrint"
                    autocomplete="off"><i class="fa fa-print"></i></button>
                <button type="button" class="btn btn-success" style="margin: 0 0 15px 0" id="btnPdf"
                    autocomplete="off"><i class="fa fa-download"></i></button>
            </div>
        </div>
        <div class="col-md-10">
            <div class="profile_content">
                <div class="card-content-member">
                    <h4 class="m-t-0"><?php echo $row->first_name."  " .$row->last_name;?><span style="color:#F39C12">
                        </span></h4>
                    <h5>ID: <?= $row->hrm_id ?></h5>
                    <h5>Department: <?= $row->department_name; ?></h5>
                    <p class="m-0"><i class="fa fa-mobile" aria-hidden="true"></i><?php echo $row->phone ;?></p>
                    <br><br>
                    <p class="m-0">Status: <?= slug_to_readable($row->status) ?></p>
                </div>
            </div>
        </div>
    </div>
    <div class="row center-block">
        <div class="col-sm-12 col-md-6 col-xl-6 col-lg-6">
            <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                <div class="panel panel-default accord">
                    <div class="panel-heading active accord" role="tab" id="headingOne">
                        <h4 class="panel-title">
                            <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseOne"
                                aria-expanded="true" aria-controls="collapseOne">
                                <?php echo display('biographicalinfo')?> </a>
                        </h4>
                    </div>
                    <div id="collapseOne" class="panel-collapse collapse in" role="tabpanel"
                        aria-labelledby="headingOne">
                        <div class="panel-body">
                            <table class="table table-hover" width="100%" id="biographicalinfo-panel">
                                <tr>
                                    <th><?php echo display('dob')?></th>
                                    <td><?= formatted_date($row->dob);?></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('gender')?></th>
                                    <td><?= $row->gender ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('marital_status')?></th>
                                    <td><span class="td-marital_status"><?= $row->marital_status ?></span></td>
                                </tr>
                                <tr>
                                    <th>Religion </th>
                                    <td><?php echo $row->ethnic_group ;?></td>
                                </tr>
                                <!--<tr>-->
                                <!--    <th><?php echo display('eeo_class_gp')?></th>-->
                                <!--    <td><?php echo $row->eeo_class_gp ;?></td>-->
                                <!--</tr>-->
                                <tr>
                                    <th>CNIC</th>
                                    <td><?= cnic_with_dashes($row->cnic) ;?></td>
                                </tr>
                                <tr>
                                    <th>Qualification (Last Degree)</th>
                                    <td><?= $row->degree_name ;?></td>
                                </tr>
                                <tr>
                                    <th>Passing Date</th>
                                    <td><?= formatted_date($row->passing_year) ;?></td>
                                </tr>
                                <tr>
                                    <th>CGPA / Division / %</th>
                                    <td><?= $row->cgp ;?></td>
                                </tr>
                                <tr>
                                    <th>Institute</th>
                                    <td><?= $row->institute_name ;?></td>
                                </tr>
                                <tr>
                                    <th>Last Employer</th>
                                    <td><?= $row->last_employer ;?></td>
                                </tr>
                                <tr>
                                    <th>Last Employer Address</th>
                                    <td><?= $row->last_employer_address ;?></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="panel panel-default accord">
                    <div class="panel-heading accord" role="tab" id="headingThree">
                        <h4 class="panel-title">
                            <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion"
                                href="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                <?php echo display('positional_information')?> </a>
                        </h4>
                    </div>
                    <div id="collapseThree" class="panel-collapse collapse" role="tabpanel"
                        aria-labelledby="headingThree">
                        <div class="panel-body">
                            <table class="table table-hover" width="100%" id="slide-panel">
                                <tr>
                                    <th><?php echo display('department')?></th>
                                    <td><span class="td-dept_id"><?= $row->department_name; ?></span></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('division')?></th>
                                    <td><?= $row->division_name ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('designation')?></th>
                                    <td><?php echo $row->position_name;?></td>
                                </tr>
                                <tr>
                                    <th>Primary Project</th>
                                    <td><?php echo $row->primary_project;?></td>
                                </tr>
                                <tr>
                                    <th>Team</th>
                                    <td><span class="td-team"><?php echo $row->team;?></span></td>
                                </tr>
                                <tr>
                                    <th>Campaign</th>
                                    <td><span class="td-campaign"><?php echo $row->campaign;?></span></td>
                                </tr>
                                <tr>
                                    <th>Pseudo</th>
                                    <td><?php echo $row->pseudo;?></td>
                                </tr>
                                <tr>
                                    <th>Medflow ID</th>
                                    <td><?php echo $row->medflow_id ?></td>
                                </tr>
                                <tr>
                                    <th>Skype ID</th>
                                    <td><?php echo $row->skype_id ?></td>
                                </tr>
                                <tr>
                                    <th>Hiring in Replacement Of</th>
                                    <td><?php echo $row->replacement ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('duty_type')?></th>
                                    <td><?= $row->duty_type ?></td>
                                </tr>
                                <tr>
                                    <th>Probation Period</th>
                                    <td><?php echo $row->probation_period;?> Months
                                        (<?= formatted_date($row->probation_starts_on)?> -
                                        <?= formatted_date($row->probation_expires_on)?>)</td>
                                </tr>
                                <tr>
                                    <th>Recent Probation Extension</th>
                                    <td><?= $row->probation_extended_on ? formatted_date($row->probation_extended_on, true) : 'N/A' ?>
                                    </td>
                                </tr>
                                <?php if($row->duty_type_id == 3) :?>
                                <tr>
                                    <th>Contract Period</th>
                                    <td><?php echo $row->contract_period;?> Months
                                        (<?= formatted_date($row->contract_starts_on)?> -
                                        <?= formatted_date($row->contract_expires_on)?>)</td>
                                </tr>
                                <tr>
                                    <th>Recent Contract Extension</th>
                                    <td><?= $row->contract_extended_on ? formatted_date($row->contract_extended_on, true) : 'N/A' ?>
                                    </td>
                                </tr>
                                <?php endif?>
                                <tr>
                                    <th>Work From Home</th>
                                    <td><?php echo $row->work_from_home == 0 ? 'No' : 'Yes';?></td>
                                </tr>
                                <tr>
                                    <th>Transportation</th>
                                    <td><?php echo $row->transportation_required == 0 ? 'No' : 'Yes';?></td>
                                </tr>
                                <tr>
                                    <th>Shift</th>
                                    <td><?php echo getByWhere('shift', 'name', ['id'=>$row->shift])[0]->name ?></td>
                                </tr>
                                <tr>
                                    <th>Performance Reivew Duration</th>
                                    <td><?php echo $row->performance_duration;?> Months</td>
                                </tr>
                                <tr>
                                    <th><?php echo display('hire_date')?></th>
                                    <td><?= formatted_date($row->hire_date)?></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('original_hire_date')?></th>
                                    <td><?= formatted_date($row->original_hire_date)?></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('rate_type')?></th>
                                    <td><?php if($row->rate_type == 1){
              echo 'Hourly';
          }else{
            echo 'Monthly';
        }?></td>
                                </tr>
                                <?php if($row->employee_id == $this->session->userdata('employee_id') || $this->permission->method('employee_salary_permission', 'read')->access()): ?>
                                <tr>
                                    <th>Hired <?php echo display('s_rate')?></th>
                                    <td><?= number_format($row->hired_salary);?></td>
                                </tr>
                                <?php foreach ($increments as $num => $increment) :?>
                                    <tr>
                                        <th><?= addOrdinalNumberSuffix($num + 1) ?> <?= display('s_rate')?> Raise</th>
                                        <td><?= number_format($increment['amount']) ?> (<?= formatted_date($increment['date']) ?>)</td>
                                    </tr>
                                <?php endforeach?>
                                <tr>
                                    <th>Basic <?php echo display('s_rate')?></th>
                                    <td><?= number_format($row->rate);?></td>
                                </tr>
                                <tr>
                                    <th>Gross <?php echo display('s_rate')?></th>
                                    <td><?= number_format($row->current_salary);?></td>
                                </tr>
                                <?php endif?>
                                <tr>
                                    <th>EOBI</th>
                                    <td><?php echo $row->eobi == 0 ? 'No' : 'Yes';?></td>
                                </tr>
                                <!-- 
    <tr>
        <th>EOBI Amount</th>
        <td><?php echo $row->eobi;?></td>
    </tr> -->
                                <tr>
                                    <th>Direct <?php echo display('super_visor_name')?></th>
                                    <td><strong><span class="td-super_visor_id"><?= $row->direct_supervisor_name ?></span></strong></td>
                                </tr>
                                <tr>
                                    <th>Indirect <?php echo display('super_visor_name')?></th>
                                    <td><strong><span class="td-indirect_super_visor_id"><?= $row->indirect_supervisor_name ?></span></strong></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('is_super_visor')?></th>
                                    <td><strong><?php
                 if($row->is_super_visor==1){echo 'Yes';}else{
                                  echo 'No';
                                } 
             ?></strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="panel panel-default accord">
                    <div class="panel-heading accord" role="tab" id="headingfive">
                        <h4 class="panel-title">
                            <a class="collapsed emp-txt" role="button" data-toggle="collapse" data-parent="#accordion"
                                href="#collapsefive" aria-expanded="false" aria-controls="collapsefive">
                                Leaves
                            </a>
                        </h4>
                    </div>
                    <div id="collapsefive" class="panel-collapse collapse" role="tabpanel"
                        aria-labelledby="headingfive">
                        <div class="panel-body">
                            <table class="table table-hover" width="100%" id="slide-leaves">
                                <?php  foreach($employee_leaves as $lvalue){?>
                                <tr>
                                    <td><strong><?php echo $lvalue->ltype;?></strong></td>
                                    <td><strong><?php echo $lvalue->leaves;?></strong></td>
                                </tr>
                                <?php } ?>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--col 1 end-->
        <div class="col-sm-12 col-md-6 col-xl-6 col-lg-6">
            <div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
                <div class="panel panel-default accord">
                    <div class="panel-heading accord" role="tab" id="headingTwo">
                        <h4 class="panel-title">
                            <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion"
                                href="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                <?php echo display('personal_information')?> </a>
                        </h4>
                    </div>
                    <div id="collapseTwo" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingTwo">
                        <div class="panel-body">
                            <table class="table table-hover" width="100%" id="pinfo-panel">
                                <tr>
                                    <th>Prefix</th>
                                    <td><?= $row->prefix ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('first_name')?></th>
                                    <td><?php echo $row->first_name ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('last_name')?></th>
                                    <td><?php echo $row->last_name ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('middle_name')?></th>
                                    <td><span class="td-middle_name"><?php echo $row->middle_name ?></span></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('phone')?></th>
                                    <td><span class="td-phone"><?php echo $row->phone ;?></span></td>
                                </tr>
                                <tr>
                                    <th>Alternative Phone</th>
                                    <td><span class="td-alter_phone"><?php echo $row->alter_phone ;?></span></td>
                                </tr>
                                <tr>
                                    <th>Home Phone</th>
                                    <td><span class="td-home_phone"><?php echo $row->home_phone ;?></span></td>
                                </tr>
                                <tr>
                                    <th>Cell Phone</th>
                                    <td><span class="td-cell_phone"><?php echo $row->cell_phone;?></span></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('email')?></th>
                                    <td><?php echo $row->email  ;?></td>
                                </tr>
                                <tr>
                                    <th>Personal Email</th>
                                    <td><span class="td-home_email"><?php echo $row->home_email  ;?></span></td>
                                </tr>
                                <tr>
                                    <th>Business Email</th>
                                    <td><?php echo $row->business_email  ;?></td>
                                </tr>
                                <tr>
                                    <th>Father Name</th>
                                    <td><?php echo $row->father_name  ;?></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('state')?></th>
                                    <td><?php echo $row->state ;?></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('city')?></th>
                                    <td><?php echo $row->city ;?></td>
                                </tr>
                                <tr>
                                    <th>Present Address</th>
                                    <td><?= $row->present_address ;?></td>
                                </tr>
                                <tr>
                                    <th>Permanent Address</th>
                                    <td><?= $row->parmanent_address ;?></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="panel panel-default accord">
                    <div class="panel-heading accord" role="tab" id="headingfour">
                        <h4 class="panel-title">
                            <a class="collapsed emp-txt" role="button" data-toggle="collapse" data-parent="#accordion"
                                href="#collapsefour" aria-expanded="false" aria-controls="collapsefour">
                                <?php echo display('benifits')?>
                            </a>
                        </h4>
                    </div>
                    <div id="collapsefour" class="panel-collapse collapse" role="tabpanel"
                        aria-labelledby="headingfour">
                        <div class="panel-body">
                            <table class="table table-hover" width="100%" id="slide-benefits">
                                <tr>
                                    <th>Account Title</th>
                                    <td><?= $row->account_title ?></td>
                                </tr>
                                <tr>
                                    <th>Account Number</th>
                                    <td><?= $row->account_number ?></td>
                                </tr>
                                <tr>
                                    <th>Account IBAN</th>
                                    <td><?= $row->account_iban ?></td>
                                </tr>
                                <tr>
                                    <th>Branch Code</th>
                                    <td><?= $row->branch_code ?></td>
                                </tr>
                                <tr>
                                    <th>Branch Address</th>
                                    <td><?= $row->branch_address ?></td>
                                </tr>
                                <?php  foreach($benifit as $benif){?>
                                <tr>
                                    <th>Benefits</th>
                                    <td><?php
                    // echo $benif->benefit_id;
                       echo $this->db->select('*')->from('benefits')->where('id',$benif->benefit_id)->get()->first_row()->name;
                    ?></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('benifit_desc')?></th>
                                    <td><?php echo $benif->bnf_cl_code_des;?></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('benifit_acc_date')?></th>
                                    <td><?= formatted_date($benif->bnff_acural_date)?></td>
                                </tr>
                                <?php } ?>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="panel panel-default accord">
                    <div class="panel-heading accord" role="tab" id="headingsix">
                        <h4 class="panel-title">
                            <a class="collapsed emp-txt" role="button" data-toggle="collapse" data-parent="#accordion"
                                href="#collapsesix" aria-expanded="false" aria-controls="collapsesix">
                                Emergency Contact
                            </a>
                        </h4>
                    </div>
                    <div id="collapsesix" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingsix">
                        <div class="panel-body">
                            <table class="table table-hover" width="100%" id="slide-emergency">
                                <tr>
                                    <th><?= display(['emergency', 'contact', 'name']) ?></th>
                                    <td><span class="td-emergency_contact_name"><?= $row->emergency_contact_name;?></span></td>
                                </tr>
                                <tr>
                                    <th><?php echo display('emerg_contct')?></th>
                                    <td><span class="td-emerg_contct"><?php echo $row->emerg_contct;?></span></td>
                                </tr>
                                <tr>
                                    <th>Emergency Contact Relation</th>
                                    <td><span class="td-emergency_contact_relation"><?= $row->emergency_contact_relation;?></span></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--col 2 end-->
    </div>
    <!--row end-->
    <div class="row center-block">
        <div class="col-sm-12 col-md-12 col-xl-12 col-lg-12">
            <div class="panel panel-default accord">
                <div class="panel-heading accord" role="tab" id="headingsev">
                    <h4 class="panel-title">
                        <a class="collapsed emp-txt" role="button" data-toggle="collapse" data-parent="#accordion"
                            href="#collapsesev" aria-expanded="false" aria-controls="collapsesev">
                            Award
                        </a>
                    </h4>
                </div>
                <div id="collapsesev" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingsev">
                    <div class="panel-body">
                        <table class="table table-hover" id="slide-award">
                            <thead>
                                <tr>
                                    <th><?php echo display('award_name')?></th>
                                    <th><?php echo display('aw_description')?></th>
                                    <th><?php echo display('awr_gift_item')?></th>
                                    <th><?php echo display('date')?></th>
                                    <th><?php echo display('awarded_by')?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($award as  $awrd) {?>
                                <tr>
                                    <td><?php echo $awrd->award_name;?></td>
                                    <td><?php echo $awrd->aw_description;?></td>
                                    <td><?php echo $awrd->awr_gift_item;?></td>
                                    <td><?=formatted_date($awrd->date)?></td>
                                    <td><?php echo $awrd->awarded_by;?></td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row center-block">
        <div class="col-sm-12 col-md-12 col-xl-12 col-lg-12">
            <div class="panel panel-default accord">
                <div class="panel-heading accord" role="tab" id="headingsinc">
                    <h4 class="panel-title">
                        <a class="collapsed emp-txt" role="button" data-toggle="collapse" data-parent="#accordion"
                            href="#collapsesinv" aria-expanded="false" aria-controls="collapsesinv">
                            Incidents
                        </a>
                    </h4>
                </div>
                <div id="collapsesinv" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingsinc">
                    <div class="panel-body">
                        <table class="table table-hover" id="slide-incident">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Details / Reason</th>
                                    <th>Letter</th>
                                    <th>Remove</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($incidents as  $incident) {?>
                                <tr>
                                    <td><?= $incident->genID;?></td>
                                    <td><?= $incident->incident_type;?></td>
                                    <td><?= $incident->description ?? $incident->reason?></td>
                                    <td><?= $incident->generated_copy_name ? '<a href="'.base_url('employee/document/emp/') . $incident->generated_copy_name .'">'.$incident->generated_copy_name.'</a>' : 'N/A' ?>
                                    </td>
                                    <?php if($this->permission->method('employee_document_permission', 'delete')->access()):?>
                                    <td><a class="btn btn-danger btn-sm btn-letter-delete" href="#" role="button"
                                            data-title="<?= addslashes($incident->incident_type) ?>"
                                            data-id="<?= $incident->id; ?>"><i class="fa fa-trash"></i></a></td>
                                    <?php endif?>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if(isset($all_documents)): ?>
    <div class="row center-block">
        <div class="col-sm-12 col-md-12 col-xl-12 col-lg-12">
            <div class="panel panel-default accord">
                <div class="panel-heading accord" role="tab">
                    <h4 class="panel-title">
                        <a class="collapsed emp-txt" role="button" data-toggle="collapse" data-parent="#accordion"
                            href="#collapsesdoc" aria-expanded="false" aria-controls="collapsesdoc">
                            Documents
                        </a>
                    </h4>
                </div>
                <div id="collapsesdoc" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingsinc">
                    <div class="panel-body">
                        <table class="table table-hover" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>File</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($all_documents as  $document) {?>
                                <tr>
                                    <td><?= $document->title;?></td>
                                    <td><a href="<?= base_url('employee/document/my/') . $document->file ?>"><?= $document->file ?></a></td>
                                    <td><?= formatted_date($document->date) ?></td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif?>
    <!--page end-->
    <?php 
$editable_fields = [];

if($this->session->userdata('employee_id') == $row->employee_id) {
    $editable_fields = [
      'marital_status' => [
        'type' => 'select',
        'url' => base_url('employee/employees/getselect/marital_status?selected=') . urlencode($row->marital_status_id)
      ],
      'middle_name' => [
        'type' => 'text',
        'maxlength' => 50
      ],
      'phone' => [
        'type' => 'text',
        'pattern' => '[\\\\d\\\\+]+',
        'maxlength' => 20
      ],
      'alter_phone' => [
        'type' => 'text',
        'pattern' => '[\\\\d\\\\+]+',
        'maxlength' => 20
      ],
      'home_phone' => [
        'type' => 'text',
        'pattern' => '[\\\\d\\\\+]+',
        'maxlength' => 20
      ],
      'emerg_contct' => [
        'type' => 'text',
        'pattern' => '[\\\\d\\\\+]+',
        'maxlength' => 20
      ],
      'emergency_contact_relation' =>  [
        'type' => 'select',
        'url' => base_url('employee/employees/getselect/emergency_contact_relation?selected=') . urlencode($row->emergency_contact_relation)
      ],
      'emergency_contact_name' =>  [
        'type' => 'text',
        'maxlength' => 50
      ],
      'cell_phone' => [
        'type' => 'text',
        'pattern' => '[\\\\d\\\\+]+',
        'maxlength' => 20
      ],
      'home_email' => [
        'type' => 'email',
        'maxlength' => 100
      ]
    ];
}
if($is_subordinate && $row->employee_id != $this->session->userdata('employee_id')) {
    $editable_fields = [
        'dept_id' => [
            'type' => 'select',
            'url' => base_url('employee/employees/getselect/dept_id?selected=') . urlencode($row->dept_id)
        ],
        'team' => [
            'type' => 'select',
            'url' => base_url('employee/employees/getselect/team?selected=') . urlencode($row->team)
        ],
        'campaign' => [
            'type' => 'select',
            'url' => base_url('employee/employees/getselect/campaign?selected=') . urlencode($row->campaign)
        ],
        'super_visor_id' => [
            'type' => 'select',
            'url' => base_url('employee/employees/getselect/super_visor_id?selected=') . urlencode($row->super_visor_id)
        ],
        'indirect_super_visor_id' => [
            'type' => 'select',
            'url' => base_url('employee/employees/getselect/indirect_super_visor_id?selected=') . urlencode($row->indirect_super_visor_id)
        ],
    ];
}

?>
    <script>
    var jeditable_opts = {
        showfn: (form) => {
            $(form).show();
            $(form).find('select').select2()
        },
        placeholder: '',
        onblur: 'ignore',
        formid: 'jedit-form',
        event: "dblclick",
        submit: 'Save',
        cancel: 'Cancel',
        inputcssclass: 'jedit-input-child',
        cancelcssclass: 'btn btn-danger',
        submitcssclass: 'btn btn-success',
        onedit: (settings) => {
            toggle_pencils(settings, false)
        },
        onreset: (settings) => {
            toggle_pencils(settings, true)
        },
        onsubmit: (settings) => {
            toggle_pencils(settings, true)
        },
        callback: (res, settings) => {
            let target_class = $(`.${settings.my_target_class}`);
            target_class.text(target_class.data('original_value'))
            target_class.siblings('.pending-request').remove();
            $('.se-pre-con').hide()
            if (res == 'NOCHANGE') {
                alert(
                    `Request Denied: Value of this field is already set to "${target_class.data('original_value')}"`);
            } else {
                alert(res);
            }
        }
    }

    function toggle_pencils(settings, show) {
        let target_class = settings.my_target_class;
        if (show) {
            $(`.${target_class}`).siblings('.editpencil').show()
        } else {
            $(`.${target_class}`).siblings('.editpencil').hide()
        }
        return true;
    }
    $(document).on('click', 'i.editpencil', function() {
        $(this).siblings('span').trigger('dblclick')
    });
    <?php if($row->employee_id == $this->session->userdata('employee_id') || $is_subordinate): ?>
    $(document).ready(function() {
        let new_props = {}
        <?php foreach($editable_fields as $editable_field => $props): ?>
        new_props = {}
        new_props.type = "<?= $props['type'] ?>"
        new_props.my_target_class = "td-<?= $editable_field ?>"
        <?php if(isset($props['url'])): ?>
        new_props.loadurl = "<?= $props['url'] ?>";
        <?php endif ?>
        <?php if(isset($props['pattern'])): ?>
        new_props.pattern = "<?= $props['pattern'] ?>";
        <?php endif ?>
        <?php if(isset($props['maxlength'])): ?>
        new_props.maxlength = "<?= $props['maxlength'] ?>";
        <?php endif ?>
        var target_td = $(".td-<?= $editable_field ?>");
        target_td.parent().append(
            '<i class="fa fa-pencil editpencil" aria-hidden="true" data-toggle="tooltip" title="Click to edit this field"></i>'
            );
        <?php if(isset($pending_data[$editable_field])): ?>
        target_td.parent().append(
            '<p class="pending-request">Pending Change Request: <?= addslashes($pending_data[$editable_field]) ?></p>'
            );
        <?php endif ?>
        target_td.data('original_value', $(target_td[0]).text())
        target_td.editable("<?= base_url('employee/employees/save_field?id='. $row->employee_id .'&field=' . $editable_field) ?>", $.extend({}, jeditable_opts, new_props));
        <?php endforeach ?>
    });
    <?php endif ?>
    $(function() {
        $('#btnPrint').on('click', function() {
            $('body').append(
                `<iframe src="<?= base_url() ?>employee/Employees/cv_print/<?= $row->employee_id ?>?print" frameborder="0" style="display:none"></iframe>`
                )
        })
        $('#btnPdf').on('click', function() {
            $('body').append(
                `<iframe src="<?= base_url() ?>employee/Employees/cv_pdf/<?= $row->employee_id ?>" frameborder="0" style="display:none"></iframe>`
                )
        })
        $('#collapsesdoc .table').dataTable($.extend({}, {
            "columnDefs": [ {
                "targets": [2],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY')
                    }
                    return data;
                }
            } ],
            "order": [[ 2, "desc" ]]
        }, window.default_datatable_opts))
    });
    $('.panel-collapse').on('show.bs.collapse', function() {
        $(this).siblings('.panel-heading').addClass('active');
    });
    $('.panel-collapse').on('hide.bs.collapse', function() {
        $(this).siblings('.panel-heading').removeClass('active');
    });
    $('.btn-letter-delete').on('click', function(e) {
        e.preventDefault()
        $this = $(this);
        Swal.fire({
            title: `Are you sure?`,
            html: `Pressing 'Yes' will remove incident "<strong>${$this.data('title')}</strong>" and all its rewards/penalties and suspensions<br>You won't be able to revert this action!`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>employee/employees_documents/delete_incident",
                    data: {
                        id: $this.data('id')
                    },
                    success: function(res) {
                        if (res.success) {
                            Swal.fire(
                                '<?= display('deleted') ?>!',
                                res.message,
                                'success'
                            )
                            $this.closest('tr').remove()
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.message,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                        if (res.reload) {
                            window.dtable.ajax.reload()
                        }
                    }
                });
            }
        })
    })
    </script>