<style>
    .btn-success {
        background-color: green !important;
    }
    .btn-danger {
        background-color: red !important;
    }
</style>
<div class="container-fluid">
    <table class="datatable table table-hover">
        <thead>
            <tr>
                <th><?= display('employee') ?></th>
                <th><?= display('document') ?></th>
                <th><?= display('file') ?></th>
                <th class="hideexport"><?= display('action') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($documents as $document) :?>
                <tr>
                    <td><?= $document->employee_name ?> (<?= $document->hrm_id ?>)</td>
                    <td><?= $document->title ?></td>
                    <td>
                        <a target="_blank" href="<?= base_url('employee/document/pending/' . $document->documents) ?>"><?= $document->documents ?></a>
                    </td>
                    <td>
                        <?php if($this->permission->method('employee_documents_pending', 'update')->access()) :?>
                            <form method="post">
                                <input type="hidden" name="id" value="<?= $document->id ?>">
                                <button type="submit" name="type" value="approve" class="btn btn-success">Approve</button>
                                <button type="submit" name="type" value="reject" class="btn btn-danger">Reject</button>
                            </form>
                        <?php endif?>
                    </td>
                </tr>
            <?php endforeach?>
        </tbody>
    </table>
</div>
<script>
    $(document).ready(function () {
        $('button[type=submit]').on('click', function(e) {
            $form = $(this).closest('form');
            if(this.value == 'reject') {
                let reason = prompt('Enter reason for rejection');
                if($.trim(reason).length < 1) {
                    alert('Rejection reason is required');
                    e.preventDefault();
                    return;
                }
                $form.append(`<input type="hidden" name="remarks" value="${reason}">`)
            }
        })
        $('form').on('submit', function(){
            $('.se-pre-con').show()
        })
    });
</script>