<?php
class Average
{
    private $_sum = 0;
    private $_num = 0;
    public function add($value)
    {
        $value = floatval(sprintf('%s', trim($value)));
        if (!$value) {
            return;
        }
        $this->_sum += $value;
        $this->_num++;
        return $this;
    }
    public function clear()
    {
        $this->_sum = 0;
        $this->_num = 0;
        return $this;
    }
    public function get()
    {
        return number_format($this->_num > 0 ? $this->_sum / $this->_num : 0, 2);
    }
}
class AverageCollection
{
    private $_collection = [];
    public function add($num, $value)
    {
        if (!isset($this->_collection[$num])) {
            $this->_collection[$num] = new Average();
        }
        $this->_collection[$num]->add($value);
        return $this;
    }
    public function clearAll()
    {
        foreach ($this->_collection as $avg) {
            $avg->clear();
        }
        return $this;
    }
    public function get($num)
    {
        if (!isset($this->_collection[$num])) {
            return null;
        }
        return $this->_collection[$num]->get();
    }
}
