<div class="container-fluid">
    <form action="#" method="post">
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="txtTitle" class="required"><?= display('title') ?></label>
                    <input type="text" maxlength="45" class="form-control" name="label" id="txtTitle"
                        value="<?= set_value('label') ?>">
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label for="txtWeightage" class="required"><?= display('Weightage') ?></label>
                    <input type="number" min="1" max="100" class="form-control" name="weightage" id="txtWeightage" value="<?= set_value('weightage') ?>">
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label for="txtDesc" class="required"><?= display(['Aligns', 'To']) ?></label>
                    <textarea class="form-control" name="description" id="txtDesc"
                        rows="3"><?= set_value('description') ?></textarea>
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label for="txtMetrics" class="required"><?= display(['Metrics', '&', 'Milestones']) ?></label>
                    <textarea class="form-control" name="metrics" id="txtMetrics"
                        rows="3"><?= set_value('metrics') ?></textarea>
                </div>
            </div>
            <div class="col-md-12">
                <table class="table table-bordered">
                    <caption><?= display(['Objective', 'Score', 'Threshold']) ?></caption>
                    <thead>
                        <tr>
                            <th><?= display('Score') ?></th>
                            <th><?= display('Threshold') ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($scale as $sc) :?>
                            <tr>
                                <td><?= $sc->score ?></td>
                                <td><input type="text" class="form-control" name="sc[<?= $sc->id ?>]" value="<?= set_value('sc[<?= $sc->id ?>]') ?>"></td>
                            </tr>
                        <?php endforeach?>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="row">
            <h4><?= display(['Applies', 'To']) ?></h4>
            <hr>
            <div class="row">
                <div class="col-sm-4">
                    <div class="form-check">
                        <label class="form-check-label">
                            <input type="radio" class="form-check-input" name="all_departments" value="1"
                                <?= set_radio('all_departments', 1, true) ?>>
                            <?= display('all_departments') ?>
                        </label>
                    </div>
                    <div class="form-check">
                        <label class="form-check-label">
                            <input type="radio" class="form-check-input" name="all_departments" value="0"
                                <?= set_radio('all_departments', 0) ?>>
                            <?= display('selected_departments') ?>
                        </label>
                    </div>
                </div>
                <div class="col-sm-8 global-selections" style="display: none;">
                    <div class="form-group">
                        <select id="selDept" class="form-control dont-select-me" name="departments[]" multiple
                            style="width: 100%;">
                            <?php foreach ($departments as $department) :?>
                            <option value="<?= $department->id ?>" <?= set_select('departments', $department->id) ?>>
                                <?= $department->name ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                </div>
            </div>
            <br>
            <div class="row global-selections" style="display: none;">
                <div class="col-sm-4">
                    <div class="form-check">
                        <label class="form-check-label">
                            <input type="radio" class="form-check-input" name="all_positions" value="1"
                                <?= set_radio('all_positions', 1, true) ?>>
                            <?= display('all_positions') ?>
                        </label>
                    </div>
                    <div class="form-check">
                        <label class="form-check-label">
                            <input type="radio" class="form-check-input" name="all_positions" value="0"
                                <?= set_radio('all_positions', 0) ?>>
                            <?= display('selected_positions') ?>
                        </label>
                    </div>
                </div>
                <div class="col-sm-8 global-selections-positions" style="display: none;">
                    <div class="form-group">
                        <select id="selPos" class="form-control dont-select-me" name="positions[]" multiple
                            style="width: 100%;">
                            <?php foreach ($positions as $position) :?>
                            <option value="<?= $position->id ?>" <?= set_select('positions', $position->id) ?>>
                                <?= $position->name ?></option>
                            <?php endforeach?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <button type="submit" class="btn btn-success pull-right"><?= display('save') ?></button>
    </form>
</div>
<?php $this->load->view('employee/evaluation/scripts/dept_multi_selection') ?>