<div class="container-fluid">
    <div class="row">
        <div class="col-md-2">
        </div>
        <div class="col-md-8">
            <form action="#" method="post">
                <div class="form-group">
                    <label for="employee_id"><?= display('employee') ?></label>
                    <select class="form-control" name="employee_id" id="employee_id" required>
                        <option value=""><?= display(['select', 'employee']) ?></option>
                        <?php foreach ($employees as $employee) :?>
                        <option value="<?= $employee->employee_id ?>">
                            <?= sprintf('%s %s (%s)', $employee->first_name, $employee->last_name, $employee->hrm_id) ?>
                        </option>
                        <?php endforeach;?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="year"><?= display(['report', 'year']) ?></label>
                    <select class="form-control" name="year" id="year" required>
                        <option value=""><?= display(['select', 'year']) ?></option>
                    </select>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary" name="action" value="list"><?= display(['Submit', 'and', 'view', 'list']) ?></button>
                    <button type="submit" class="btn btn-primary pull-right" name="action" value="add"><?= display(['Submit', 'and', 'add', 'more']) ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
    $(document).ready(function () {
        $('form select#employee_id').on('change', function() {
            let $select = $('select#year')
            if(this.value) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>employee/evaluation/get_employee_years",
                    data: {
                        id: this.value
                    },
                    beforeSend: function() {
                        $select.html('').trigger('change');
                    },
                    success: function (res) {
                        if(res.success) {
                            let html = '<option value=""><?= display(['select', 'year']) ?></option>';
                            res.success.forEach(year => {
                                html += `<option>${year}</option>`
                            });
                            $select.html(html).trigger('change')
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error ?? "<?= display(['invalid', 'response', 'from', 'server'], true) ?>",
                                'error'
                            )
                        }
                    }
                });
            }
        }).trigger('change')
    });
</script>