<?php
    require_once(APPPATH . 'modules/employee/views/evaluation/scripts/average.php');
    $_average_collection = new AverageCollection();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?= display(['Evaluation', 'Report']) ?>: (<?=$employee->hrm_id?>) <?=$employee->full_name?></title>

    <!-- Bootstrap CSS -->
    <link href="<?=base_url()?>assets/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="<?=base_url()?>assets/plugins/grid-chart/rating-chart.css">
    <style>
    body {
        background-image:url(<?= $bg_image ?>);
        background-image-resize:6
    }
    table.table>tbody>tr.border-top {
        border-top: 2px solid black;
    }

    table.table td,
    table.table th {
        padding: 12px !important;
    }
    </style>
</head>

<body>
    <div class="container">
        <div class="row">
            <h2 class="text-center"><?= display(['Evaluation', 'Report']) ?> <?=$report->year?></h2>
        </div>
        <br>
        <br>
        <div class="row">
            <table class="table table-bordered">
                <colgroup>
                    <col style="width: 200px;">
                    <col style="width: 400px;">
                    <col style="width: 200px;">
                    <col style="width: 400px;">
                </colgroup>
                <tbody>
                    <tr>
                        <th><?=display(['Employee', 'Name'])?></th>
                        <td><?=$employee->full_name?></td>
                        <th><?=display(['Review', 'Period'])?></th>
                        <td><?=$report->year?></td>
                    </tr>
                    <tr>
                        <th><?=display(['Employee', 'Pseudo'])?></th>
                        <td><?=$employee->pseudo?></td>
                        <th><?=display(['Job', 'Title'])?></th>
                        <td><?=$employee->position?></td>
                    </tr>
                    <tr>
                        <th><?=display(['Employee', 'DOJ'])?></th>
                        <td><?=formatted_date($employee->hire_date)?></td>
                        <?php if($approved_report): ?>
                        <td colspan="2"></td>
                        <?php else: ?>
                        <th><?=display('Status')?></th>
                        <td><?=display($report->status)?></td>
                        <?php endif?>
                    </tr>
                    <tr>
                        <th><?=display(['Employee', 'ID'])?></th>
                        <td><?=$employee->hrm_id?></td>
                        <?php if($report->next_deadline) : ?>
                        <th><?=display(['Last', 'Date', 'of', 'Submission'])?></th>
                        <td><?=formatted_date($report->next_deadline)?></td>
                        <?php else: ?>
                        <td colspan="2">&nbsp;</td>
                        <?php endif?>
                    </tr>
                </tbody>
            </table>
        </div>
        <div class="row">
            <h3><?= display(['Behavioral', 'Rating']) ?></h3>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th colspan="2"><?= display('Type') ?></th>
                        <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                        <th><?= $scoring_block ?></th>
                        <?php endforeach?>
                    </tr>
                </thead>
                <tbody>
                    <?php $_average_collection->clearAll() ?>
                    <?php $behavior_average = []  ?>
                    <?php foreach ($behaviors as $behavior): ?>
                    <tr>
                        <td colspan="2"><?= $behavior->label ?></td>
                        <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                        <?php $_average_collection->add($num, $results[$num]['behavior'][$behavior->id]) ?>
                        <td class="behavior_scoring_block_<?= $num ?><?= $behavior->id ?>">
                            <?=$results[$num]['behavior'][$behavior->id]?></td>
                        <?php endforeach?>
                    </tr>
                    <?php endforeach?>
                    <tr class="border-top">
                        <th colspan="2"><?= display(['Average', 'Behavior', 'Ratings']) ?></th>
                        <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                        <th><?= $behavior_average[$num] = $_average_collection->get($num) ?></th>
                        <?php endforeach?>
                    </tr>
                </tbody>
            </table>
        </div>
        <div style="page-break-after:always"></div>
        <div class="row">
            <h3><?= display(['Objectives', 'Rating']) ?></h3>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th colspan="2"><?= display('Type') ?></th>
                        <th><?= display('Weightage') ?></th>
                        <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                        <th><?= $scoring_block ?></th>
                        <?php endforeach?>
                    </tr>
                </thead>
                <tbody>
                    <?php $objectives_average = []; ?>
                    <?php foreach ($objectives as $objective): ?>
                    <tr>
                        <td colspan="2"><?= $objective->label ?></td>
                        <td><?= $objective->weightage ?>%</td>
                        <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                        <?php $objectives_average[$num] += ($results[$num]['objective'][$objective->id]['result'] * ($objective->weightage / 100)) ?>
                        <td class="objective_scoring_block_<?= $num ?><?= $objective->id ?>">
                            <?= ($results[$num]['objective'][$objective->id]['result']) ?>
                        </td>
                        <?php endforeach?>
                    </tr>
                    <?php endforeach?>
                    <tr class="border-top">
                        <th colspan="3"><?= display(['Average', 'Objective', 'Ratings']) ?></th>
                        <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                        <th><?= $objectives_average[$num] ?></th>
                        <?php endforeach?>
                    </tr>
                </tbody>
            </table>
        </div>
        <div style="page-break-inside: avoid">
        <div class="row">
            <h3><?= display(['Rating', 'Summary']) ?></h3>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th><?= display('type') ?></th>
                        <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                        <th><?= $scoring_block ?></th>
                        <?php endforeach?>
                    </tr>
                </thead>
                <tbody>
                    <?php $_average_collection->clearAll(); $final_rating = [];?>
                    <tr>
                        <td><?= display('Objectives') ?></td>
                        <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                        <?php $_average_collection->add($num, $objectives_average[$num]) ?>
                        <td><?= $objectives_average[$num] ?></td>
                        <?php endforeach?>
                    </tr>
                    <tr>
                        <td><?= display('Behaviors') ?></td>
                        <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                        <?php $_average_collection->add($num, $behavior_average[$num]) ?>
                        <td><?= $behavior_average[$num] ?></td>
                        <?php endforeach?>
                    </tr>
                    <tr class="border-top">
                        <th><?= display(['Final', 'Overall', 'Ratings']) ?></th>
                        <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                        <th class="final_rating_average_<?= $num ?>">
                            <?= $final_rating[$num] = $_average_collection->get($num) ?></th>
                        <?php endforeach?>
                    </tr>
                </tbody>
            </table>
        </div>