<?php
$editable = false;
$_self = $report->employee_id == $this->session->userdata('employee_id');
if ($this->session->userdata('isAdmin') && !$approved_report) {
    $editable = true;
} else {
    switch ($report->status) {
        case 'pending-employee':{
                $editable = $report->employee_id == $this->session->userdata('employee_id');
                break;
            }
        case 'pending-dm':{
                $editable = $report->dm_id == $this->session->userdata('employee_id');
                break;
            }
        case 'pending-idm':{
                $editable = $report->idm_id == $this->session->userdata('employee_id');
                break;
            }
        case 'pending-hr':{
                $editable = $this->permission->method('evaluations_pending', 'update')->access();
                break;
            }
    }
}
if($approved_report) {
    $editable = false;
}
?>
<link rel="stylesheet" href="<?=base_url()?>assets/plugins/smartwizard/smart_wizard_all.min.css">
<link rel="stylesheet" href="<?=base_url()?>assets/plugins/grid-chart/rating-chart.css">
<style>
.sw-theme-progress>.nav .nav-link.active::after {
    background-color: #425985;
}

.nav.nav-tabs li:not(.active) a {
    pointer-events: all;
}

span.error {
    color: red;
}

div.comments_block {
    min-height: 250px;
    min-width: 250px;
    border: 2px solid black;
    padding: 5px;
}
</style>
<div class="container-fluid" id="main_report">
    <div class="row">
        <table class="table table-bordered">
            <colgroup>
                <col style="width: 200px;">
                <col style="width: 400px;">
                <col style="width: 200px;">
                <col style="width: 400px;">
            </colgroup>
            <tbody>
                <tr>
                    <th><?=display(['Employee', 'Name'])?></th>
                    <td><?=$employee->full_name?></td>
                    <th><?=display(['Review', 'Period'])?></th>
                    <td><?=$report->year?></td>
                </tr>
                <tr>
                    <th><?=display(['Employee', 'Pseudo'])?></th>
                    <td><?=$employee->pseudo?></td>
                    <th><?=display(['Job', 'Title'])?></th>
                    <td><?=$employee->position?></td>
                </tr>
                <tr>
                    <th><?=display(['Employee', 'DOJ'])?></th>
                    <td><?=formatted_date($employee->hire_date)?></td>
                    <?php if($approved_report): ?>
                    <td colspan="2"></td>
                    <?php else: ?>
                    <th><?=display('Status')?></th>
                    <td><?=display($report->status)?></td>
                    <?php endif?>
                </tr>
                <tr>
                    <th><?=display(['Employee', 'ID'])?></th>
                    <td><?=$employee->hrm_id?></td>
                    <?php if($report->next_deadline) : ?>
                    <th><?=display(['Last', 'Date', 'of', 'Submission'])?></th>
                    <td><?=formatted_date($report->next_deadline)?></td>
                    <?php else: ?>
                    <td colspan="2">&nbsp;</td>
                    <?php endif?>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="row">
        <ul class="nav nav-tabs nav_tab_2">
            <li class="active">
                <a data-toggle="tab" data-target="#behaviors" href="#behaviors"><?=display('Behaviors')?></a>
            </li>
            <?php if (!$_self || $approved_report): ?>
            <li>
                <a data-toggle="tab" data-target="#objectives" href="#objectives"><?=display('Objectives')?></a>
            </li>
            <li>
                <a data-toggle="tab" data-target="#summary" href="#summary"><?=display(['Rating', 'Summary'])?></a>
            </li>
            <li>
                <a data-toggle="tab" data-target="#analysis" href="#analysis"><?=display(['Overall', 'Analysis'])?></a>
            </li>
            <?php if(!$_self): ?>
            <li>
                <a data-toggle="tab" data-target="#comments" href="#comments"><?=display('Comments')?></a>
            </li>
            <?php endif?>
            <li>
                <a data-toggle="tab" data-target="#val_db" href="#val_db"><?=display('val_db')?></a>
            </li>
            <?php endif?>
        </ul>
        <div class="tab-content">
            <div class="main-tabs tab-pane fade in active" id="behaviors">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <?php if($behaviors): ?>
                        <div class="row">
                            <div class="col-md-8">
                                <h3><?=display(['Rate', 'Behaviors'])?></h3>
                                <p><?=display(['Consider', 'the', 'individuals', 'demonstration', 'of', 'each', 'behavior', 'and', 'enter', 'a', 'numerical', 'rating', 'from', $rating['range'][1], 'to', $rating['range'][0], 'in', 'the', 'boxes', 'below'], true)?>.
                                </p>
                            </div>
                            <div class="col-md-4">
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <th colspan="2"><?= display(['Average', 'Behavior', 'Ratings']) ?></th>
                                        </tr>
                                        <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                                        <tr>
                                            <th><?= $scoring_block ?></th>
                                            <td class="average_block_<?= $num ?>">0</td>
                                            <?php foreach ($behaviors as $behavior):?>
                                            <td style="display: none;"
                                                class="behavior_scoring_block_<?= $num ?><?= $behavior->id ?>"></td>
                                            <?php endforeach?>
                                        </tr>
                                        <?php endforeach?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div id="behaviors-wizard" class="wizard">
                            <?php $wizard_steps = 0?>
                            <ul class="nav">
                                <?php foreach ($behaviors as $behavior): $wizard_steps++;?>
                                <li>
                                    <a class="nav-link" href="#step-<?=$wizard_steps?>" data-step="<?=$wizard_steps?>">
                                        <?=$behavior->label?>
                                    </a>
                                </li>
                                <?php endforeach?>
                            </ul>
                            <?php $wizard_steps = 0?>
                            <div class="tab-content">
                                <?php foreach ($behaviors as $behavior): $wizard_steps++;?>
                                <div id="step-<?=$wizard_steps?>" data-step="<?=$wizard_steps?>" class="tab-pane"
                                    role="tabpanel">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="row">
                                                    <div class="col-sm-12 wizard_intro">
                                                        <div class="col-md-12">
                                                            <h4 class="wizard_tab_title"><?=$behavior->label?></h4>
                                                            <p><?=$behavior->description?></p>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div>
                                                                <div class="row">
                                                                    <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                                                                    <div class="rating_block_reviews">
                                                                        <div class="rating_bar">
                                                                            <div class="form-group">
                                                                                <div class="col-lg-4">
                                                                                    <label
                                                                                        for="<?=($report->num != $num || !$editable) ? null : 'behavior_scoring_block_' . $behavior->id?>"><?=$scoring_block?></label>
                                                                                    <input type="number"
                                                                                        class="form-control rating_inputs"
                                                                                        min="<?=$rating['range'][0]?>"
                                                                                        max="<?=$rating['range'][1]?>"
                                                                                        name="<?=($report->num != $num || !$editable) ? null : 'behavior_scoring_block_' . $behavior->id?>"
                                                                                        id="<?=($report->num != $num || !$editable) ? null : 'behavior_scoring_block_' . $behavior->id?>"
                                                                                        value="<?=$results[$num]['behavior'][$behavior->id]?>"
                                                                                        data-init="<?=$results[$num]['behavior'][$behavior->id]?>"
                                                                                        data-num="<?= $num ?>"
                                                                                        data-beh="<?= $behavior->id ?>"
                                                                                        <?=($report->num != $num || !$editable) ? 'disabled' : null?>>
                                                                                </div>
                                                                                <div class="col-lg-8">
                                                                                    <span class="rating_details"></span>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-sm-12">
                                                                        <hr class="lineBar1" />
                                                                    </div>
                                                                    <?php if($remarks[$num]['behavior'][$behavior->id] && !$_self) :?>
                                                                    <div class="col-lg-12">
                                                                        <h4 class="wizard_tab_title">
                                                                            <?= display('Updates') ?>:</h4>
                                                                        <?php foreach ($remarks[$num]['behavior'][$behavior->id] as $remark) :?>
                                                                        <div class="table-responsive remarks_table">
                                                                            <table class="table">
                                                                                <tbody>
                                                                                    <tr>
                                                                                        <td><strong><?= display('Rating') ?>:</strong>
                                                                                            <?= $remark->old_value ?> ->
                                                                                            <?= $remark->new_value ?>
                                                                                        </td>
                                                                                        <td><strong><?= display('Time') ?>:</strong><?= formatted_date($remark->added_at, true) ?>
                                                                                        </td>
                                                                                        <td><strong><?= display('Remarks', 'By') ?>:</strong><small><?= $remark->full_name ?><?= $remark->hrm_id ? " ({$remark->hrm_id})" : null ?></small>
                                                                                        </td>
                                                                                    </tr>
                                                                                    <tr>
                                                                                        <td colspan="3">
                                                                                            <strong><?= display('Reason') ?>:</strong><?= $remark->remarks ?>
                                                                                        </td>
                                                                                    </tr>
                                                                                </tbody>
                                                                            </table>
                                                                        </div>
                                                                        <?php endforeach?>
                                                                    </div>
                                                                    <?php endif?>
                                                                    <?php endforeach?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <br>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach?>
                            </div>
                        </div>
                        <div class="col-sm-12" style="margin-top: 20px;">
                            <div class="panel panel-primary">
                                <div class="panel-heading">
                                    <h3 class="panel-title">
                                        <?=display(['Use', 'these', 'definitions', 'if', 'you', 'are', 'unsure', 'about', 'which', 'category', 'applies', 'to', 'the', 'employee'], true)?>.
                                    </h3>
                                </div>
                                <div class="panel-body">
                                    <div class="row">
                                        <div class="wizard_details col-sm-12">
                                            <table class="table table-bordered">
                                                <tbody>
                                                    <?php foreach ($roles as $role): ?>
                                                    <tr>
                                                        <td>
                                                            <h5 class="wz_details_title">
                                                                <?=$role->label?></h5>
                                                            <p><?=$role->description?></p>
                                                            <u><?=$behavior->label?></u><br>
                                                            <p><?=$role->behavior_description[$behavior->id]?>
                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php else: ?>
                        <h3><?= display(['No', 'behaviors', 'are', 'assigned', 'to', 'you'], true) ?></h3>
                        <h4><?= display(['Please', 'contact', 'HR'], true) ?></h3>
                            <?php endif?>
                    </div>
                </div>
            </div>
            <?php if (!$_self || $approved_report): ?>
            <div class="main-tabs tab-pane fade" id="objectives">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <?php if($objectives): ?>
                        <div class="container-fluid">
                            <div class="row">
                                <table class="table table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th colspan="2"></th>
                                            <?php foreach ($objectives as $objective): ?>
                                            <th colspan="2"><?=$objective->label?></th>
                                            <?php endforeach?>
                                            <th><?= display('Average') ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                                        <tr>
                                            <td colspan="2"><?=$scoring_block?>
                                                <?= display(['rating', '&', 'weight', '(%)']) ?></td>
                                            <?php $weightage_sum = 0 ?>
                                            <?php foreach ($objectives as $objective): ?>
                                            <?php $weightage_sum += floatval($objective->weightage) ?>
                                            <td class="<?='objective_scoring_block_' . $num . $objective->id?>">
                                                <?=$results[$num]['objective'][$objective->id]['result']?>
                                            </td>
                                            <td><?=$objective->weightage?>%</td>
                                            <?php endforeach?>
                                            <td class="objective_average_block_<?=$num?>"></td>
                                        </tr>
                                        <?php endforeach?>
                                        <tr>
                                            <td><?= display(['total', 'weight', ]) ?></td>
                                            <td><?= $weightage_sum ?>%</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div id="objectives-wizard" class="wizard">
                            <?php $wizard_steps = 0?>
                            <ul class="nav">
                                <?php foreach ($objectives as $objective): $wizard_steps++;?>
                                <li>
                                    <a class="nav-link" href="#step-obj-<?=$wizard_steps?>">
                                        <?=$objective->label?>
                                    </a>
                                </li>
                                <?php endforeach?>
                            </ul>
                            <?php $wizard_steps = 0?>
                            <div class="tab-content wizard_obj_content">
                                <?php foreach ($objectives as $objective): $wizard_steps++;?>
                                <div id="step-obj-<?=$wizard_steps?>" data-step="<?=$wizard_steps?>" class="tab-pane"
                                    role="tabpanel">
                                    <div class="container-fluid">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="row">
                                                    <div class="table-responsive">
                                                        <table class="table table-bordered obj_remarks_table">
                                                            <thead>
                                                                <tr>
                                                                    <th><?=display('Objective')?></th>
                                                                    <th><?=display('Weightage')?></th>
                                                                    <th><?=display(['Align', 'To'])?></th>
                                                                    <th><?=display(['METRICS', '&', 'MILESTONES'])?>
                                                                    </th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <tr>
                                                                    <td><?=$objective->label?></td>
                                                                    <td><?=$objective->weightage?>%</td>
                                                                    <td><?=$objective->description?></td>
                                                                    <td><?=$objective->metrics?></td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="obj_remarks_details">
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <div class="panel panel-bd fixed-height-panel">
                                                                    <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                                                                    <div class="rating_block_reviews col-md-12">
                                                                        <div class="form-group">
                                                                            <label
                                                                                for="<?=($report->num != $num || $objective->data_model || !$editable) ? null : 'objective_scoring_block_' . $objective->id?>"><?=$scoring_block?></label>
                                                                            <input type="number"
                                                                                class="form-control rating_inputs"
                                                                                min="<?=$rating['range'][0]?>"
                                                                                max="<?=$rating['range'][1]?>"
                                                                                name="<?=($report->num != $num || $objective->data_model || !$editable) ? null : 'objective_scoring_block_' . $objective->id?>"
                                                                                id="<?=($report->num != $num || $objective->data_model || !$editable) ? null : 'objective_scoring_block_' . $objective->id?>"
                                                                                value="<?=$results[$num]['objective'][$objective->id]['result']?>"
                                                                                data-init="<?=$results[$num]['objective'][$objective->id]['result']?>"
                                                                                data-value="<?=$results[$num]['objective'][$objective->id]['value']?>"
                                                                                data-weight="<?=$objective->weightage / 100?>"
                                                                                data-num="<?= $num ?>"
                                                                                data-obj="<?= $objective->id ?>"
                                                                                <?=($report->num != $num || $objective->data_model || !$editable) ? 'disabled' : null?>>
                                                                            <span class="rating_details"></span>
                                                                        </div>
                                                                    </div>
                                                                    <?php if($remarks[$num]['objective'][$objective->id] && !$_self) :?>
                                                                    <div class="col-lg-12">
                                                                        <h4 class="wizard_tab_title">
                                                                            <?= display('Updates') ?>:</h4>
                                                                        <?php foreach ($remarks[$num]['objective'][$objective->id] as $remark) :?>
                                                                        <div class="table-responsive remarks_table">
                                                                            <table class="table">
                                                                                <tbody>
                                                                                    <tr>
                                                                                        <td><strong><?= display('Rating') ?>:</strong>
                                                                                            <?= $remark->old_value ?> ->
                                                                                            <?= $remark->new_value ?>
                                                                                        </td>
                                                                                        <td><strong><?= display('Time') ?>:</strong><?= formatted_date($remark->added_at, true) ?>
                                                                                        </td>
                                                                                        <td><strong><?= display('Remarks', 'By') ?>:</strong><small><?= $remark->full_name ?><?= $remark->hrm_id ? " ({$remark->hrm_id})" : null ?></small>
                                                                                        </td>
                                                                                    </tr>
                                                                                    <tr>
                                                                                        <td colspan="3">
                                                                                            <strong><?= display('Reason') ?>:</strong><?= $remark->remarks ?>
                                                                                        </td>
                                                                                    </tr>
                                                                                </tbody>
                                                                            </table>
                                                                        </div>
                                                                        <?php endforeach?>
                                                                    </div>
                                                                    <?php endif?>
                                                                    <?php endforeach?>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-12">
                                                                <?php if ($objective->scores): ?>
                                                                <div class="panel panel-bd fixed-height-panel"
                                                                    style="background-color: rgba(66, 89, 133, 0.1);">
                                                                    <table class="table table-bordered">
                                                                        <div class="panel-title">
                                                                            <h4><?=ucfirst(display(['Rating', 'Threshold']))?>
                                                                            </h4>
                                                                        </div>
                                                                        <thead>
                                                                            <tr>
                                                                                <?php foreach ($rating['data'] as $scale): ?>
                                                                                <th
                                                                                    style="vertical-align: top; text-align: center">
                                                                                    <?=$scale->score?>
                                                                                </th>
                                                                                <?php endforeach?>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <tr>
                                                                                <?php foreach ($rating['data'] as $scale): ?>
                                                                                <td><?=$objective->scores[$scale->id]?>
                                                                                </td>
                                                                                <?php endforeach?>
                                                                            </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                                <?php endif?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach?>
                            </div>
                        </div>
                        <?php else: ?>
                        <h3><?= display(['No', 'objectives', 'are', 'assigned', 'to', 'you'], true) ?></h3>
                        <h4><?= display(['Please', 'contact', 'HR'], true) ?></h3>
                            <?php endif?>
                    </div>
                </div>
            </div>
            <div class="main-tabs tab-pane fade" id="summary">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <div class="container-fluid">
                            <div class="row">
                                <table class="table table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                                            <th><?= $scoring_block ?></th>
                                            <?php endforeach?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><?= display('Objectives') ?></td>
                                            <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                                            <td class="objective_average_block_<?= $num ?>"></td>
                                            <?php endforeach?>
                                        </tr>
                                        <tr>
                                            <td><?= display('Behaviors') ?></td>
                                            <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                                            <td class="average_block_<?= $num ?>"></td>
                                            <?php endforeach?>
                                        </tr>
                                        <tr>
                                            <td colspan="3"></td>
                                        </tr>
                                        <tr>
                                            <th><?= display(['Final', 'Overall', 'Ratings']) ?></th>
                                            <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                                            <th class="final_rating_average_<?= $num ?>"></th>
                                            <?php endforeach?>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="row" style="display:flex; flex-direction: row">
                                <p style="transform: rotate(-90deg); height: 20px; position:sticky; margin-top: 170px">
                                    <?= display('Objectives') ?></p>
                                <div id="rating-chart-summary" style="margin-bottom: 20px">
                                </div>
                                <p style="float:right; position:absolute; left: 250px; bottom: 0%">
                                    <?= display('Behaviors') ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="main-tabs tab-pane fade" id="analysis">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-md-6">
                                    <canvas id="objectives_summary_chart" height="200"></canvas>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="performance_summary_chart" height="200"></canvas>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <canvas id="behaviors_summary_chart" height="200"></canvas>
                                </div>
                                <div class="col-md-6">
                                    <canvas id="final_rating_chart" height="200"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php if(!$_self): ?>
            <div class="main-tabs tab-pane fade" id="comments">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <div class="container-fluid">
                            <div class="row">
                                <h4><?= display(['Manager', 'Summary', 'Comments']) ?>:</h4>
                                <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                                <?php $text = null;?>
                                <?php foreach ($subreports as $subreport) {
                                    if($subreport->num == $num) {
                                        $text = $subreport->manager_comments;
                                    }
                                } ?>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="manager_comments_<?= $num ?>"><?= $scoring_block ?></label>
                                        <?php if($report->num == $num && $editable) : ?>
                                        <textarea class="form-control tiny_textarea" name="manager_comments"
                                            id="manager_comments_<?= $num ?>" rows="3"><?= $text ?></textarea>
                                        <?php else: ?>
                                        <div class="comments_block"><?= $text ?></div>
                                        <?php endif?>
                                    </div>
                                </div>
                                <?php endforeach?>
                            </div>
                            <div class="row">
                                <h4><?= display(['Employee', 'Comments', '(If Any)', 'From', 'Feedback', 'Discussion']) ?>:
                                </h4>
                                <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
                                <?php $text = null;?>
                                <?php foreach ($subreports as $subreport) {
                                    if($subreport->num == $num) {
                                        $text = $subreport->employee_comments;
                                    }
                                } ?>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="employee_comments_<?= $num ?>"><?= $scoring_block ?></label>
                                        <?php if($report->num == $num && $editable) : ?>
                                        <textarea class="form-control tiny_textarea" name="employee_comments"
                                            id="employee_comments_<?= $num ?>" rows="3"><?= $text ?></textarea>
                                        <?php else:?>
                                        <div class="comments_block"><?= $text ?></div>
                                        <?php endif?>
                                    </div>
                                </div>
                                <?php endforeach?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif?>
            <?php if($this->permission->method('evaluations_pending', 'update')->access()): ?>
            <div class="main-tabs tab-pane fade" id="val_db">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <div class="container-fluid">
                            <div class="table-responsive">
                                <table class="table table-hover table-striped">
                                    <thead>
                                        <tr>
                                            <th>Sr#</th>
                                            <th><?= display('Period') ?></th>
                                            <th><?= display(['Employee', 'ID', 'Number']) ?></th>
                                            <th><?= display(['Employee', 'Name']) ?></th>
                                            <th><?= display(['Employee', 'Pseudo']) ?></th>
                                            <th><?= display(['Employee', 'DOJ']) ?></th>
                                            <th><?= display(['Team', 'Manager']) ?></th>
                                            <th><?= display(['Job', 'Title']) ?></th>
                                            <th><?= display(['Attendance']) ?></th>
                                            <th><?= display(['Attendance', 'Rating']) ?></th>
                                            <th><?= display(['Monthly', 'Target']) ?></th>
                                            <th><?= display(['Achieved', 'For', 'The', 'Month']) ?></th>
                                            <th><?= display(['Achieved', 'For', 'The', 'Month', '%']) ?></th>
                                            <th><?= display(['Achieved', 'Rating']) ?></th>
                                            <th><?= display(['#', 'Of', 'Files', 'Touched', 'Target']) ?></th>
                                            <th><?= display(['#', 'Of', 'Files', 'Touched']) ?></th>
                                            <th><?= display(['#', 'Of', 'Files', 'Touched', '%']) ?></th>
                                            <th><?= display(['Rating1']) ?></th>
                                            <th><?= display(['#', 'Of', 'New', 'Follow', 'ups', 'put', 'on', 'calendar', 'target']) ?>
                                            </th>
                                            <th><?= display(['#', 'Of', 'New', 'Follow', 'ups', 'put', 'on', 'calendar']) ?>
                                            </th>
                                            <th><?= display(['#', 'Of', 'New', 'Follow', 'ups', 'put', 'on', 'calendar', '%']) ?>
                                            </th>
                                            <th><?= display(['Rating2']) ?></th>
                                            <th><?= display(['AR', 'Assigned']) ?></th>
                                            <th><?= display(['AR', 'On', 'Calendar']) ?></th>
                                            <th><?= display(['AR', 'On', 'Calendar', '%']) ?></th>
                                            <th><?= display(['Rating3']) ?></th>
                                            <th><?= display(['#', 'Of', 'Call', 'Target']) ?></th>
                                            <th><?= display(['#', 'Of', 'Call', 'Made']) ?></th>
                                            <th><?= display(['#', 'Of', 'Call', 'Made', '%']) ?></th>
                                            <th><?= display(['Rating4']) ?></th>
                                            <th><?= display(['#', 'of', 'faxes', 'sent', 'target']) ?></th>
                                            <th><?= display(['#', 'of', 'faxes', 'sent']) ?></th>
                                            <th><?= display(['#', 'of', 'faxes', 'sent', '%']) ?></th>
                                            <th><?= display(['Rating5']) ?></th>
                                            <th><?= display(['Threshold', 'Rating', '(Total)']) ?></th>
                                            <th><?= display(['Threshold', 'Rating', '(Total %)']) ?></th>
                                            <th><?= display(['Threshold', '%']) ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $s_no = 0; foreach ($scoring_blocks as $num => $scoring_block): ?>
                                        <?php $s_no++; ?>
                                        <tr>
                                            <td><?= $s_no ?></td>
                                            <td><?= $scoring_block ?></td>
                                            <td><?= $employee->hrm_id ?></td>
                                            <td><?= $employee->full_name ?></td>
                                            <td><?= $employee->pseudo ?></td>
                                            <td><?= formatted_date($employee->hire_date) ?></td>
                                            <td><?= $report->dm_id ? $this->db->select('full_name')->where('employee_id', $report->dm_id)->get('employee_details')->row()->full_name : $this->db->select('direct_manager_name as full_name')->where('employee_id', $report->employee_id)->get('employee_details')->row()->full_name ?>
                                            </td>
                                            <td><?= $employee->position ?></td>
                                            <td><?= round($results[$num]['objective'][array_pop(array_filter($objectives, function($obj) {
                                                return $obj->data_model == 'attendance';
                                            }))->id]['value'] ?? 0) ?>%</td>
                                            <td><?= $results[$num]['objective'][array_pop(array_filter($objectives, function($obj) {
                                                return $obj->data_model == 'attendance';
                                            }))->id]['result'] ?></td>
                                            <td>
                                                <?php if($num == $report->num): ?>
                                                <input type="number" style="width: 100px !important;"
                                                    class="form-control target_input val_data" min="0" name="target_monthly"
                                                    value="<?= $field_data[$num]['target_monthly'] ?>">
                                                <?php else: ?>
                                                <?= $field_data[$num]['target_monthly'] ?>
                                                <?php endif?>
                                            </td>
                                            <td>
                                                <?php if($num == $report->num): ?>
                                                <input type="number" style="width: 100px !important;"
                                                    class="form-control target_input val_data" min="0" name="target_achieved"
                                                    value="<?= $field_data[$num]['target_achieved'] ?>">
                                                <?php else:?>
                                                <?= $field_data[$num]['target_achieved'] ?>
                                                <?php endif?>
                                            </td>
                                            <td class="target_percentage"></td>
                                            <td class="target_rating"></td>
                                            <td>
                                                <?php if($num == $report->num): ?>
                                                <input type="number" style="width: 100px !important;"
                                                    class="form-control files_input val_data" min="0" name="files_target"
                                                    value="<?= $field_data[$num]['files_target'] ?>">
                                                <?php else:?>
                                                <?= $field_data[$num]['files_target'] ?>
                                                <?php endif?>
                                            </td>
                                            <td>
                                                <?php if($num == $report->num): ?>
                                                <input type="number" style="width: 100px !important;"
                                                    class="form-control files_input val_data" min="0" name="files_touched"
                                                    value="<?= $field_data[$num]['files_touched'] ?>">
                                                <?php else: ?>
                                                <?= $field_data[$num]['files_touched'] ?>
                                                <?php endif?>
                                            </td>
                                            <td class="files_percentage"></td>
                                            <td class="files_rating"></td>
                                            <td>
                                                <?php if($num == $report->num): ?>
                                                <input type="number" style="width: 100px !important;"
                                                    class="form-control followup_input val_data" min="0" name="followup_target"
                                                    value="<?= $field_data[$num]['followup_target'] ?>">
                                                <?php else: ?>
                                                <?= $field_data[$num]['followup_target'] ?>
                                                <?php endif?>
                                            </td>
                                            <td>
                                                <?php if($num == $report->num): ?>
                                                <input type="number" style="width: 100px !important;"
                                                    class="form-control followup_input val_data" min="0"
                                                    name="followup_achieved"
                                                    value="<?= $field_data[$num]['followup_achieved'] ?>">
                                                <?php else: ?>
                                                <?= $field_data[$num]['followup_achieved'] ?>
                                                <?php endif?>
                                            </td>
                                            <td class="followup_percentage"></td>
                                            <td class="followup_rating"></td>
                                            <td>
                                                <?php if($num == $report->num): ?>
                                                <input type="number" style="width: 100px !important;"
                                                    class="form-control ar_input val_data" name="ar_target" min="0"
                                                    value="<?= $field_data[$num]['ar_target'] ?>">
                                                <?php else:?>
                                                <?= $field_data[$num]['ar_target'] ?>
                                                <?php endif?>
                                            </td>
                                            <td>
                                                <?php if($num == $report->num): ?>
                                                <input type="number" style="width: 100px !important;"
                                                    class="form-control ar_input val_data" name="ar_achieved" min="0"
                                                    value="<?= $field_data[$num]['ar_achieved'] ?>">
                                                <?php else:?>
                                                <?= $field_data[$num]['ar_achieved'] ?>
                                                <?php endif?>
                                            </td>
                                            <td class="ar_percentage"></td>
                                            <td class="ar_rating"></td>
                                            <td>
                                                <?php if($num == $report->num): ?>
                                                <input type="number" style="width: 100px !important;"
                                                    class="form-control calls_input val_data" name="calls_target" min="0"
                                                    value="<?= $field_data[$num]['calls_target'] ?>">
                                                <?php else:?>
                                                <?= $field_data[$num]['calls_target'] ?>
                                                <?php endif?>
                                            </td>
                                            <td>
                                                <?php if($num == $report->num): ?>
                                                <input type="number" style="width: 100px !important;"
                                                    class="form-control calls_input val_data" name="calls_achieved" min="0"
                                                    value="<?= $field_data[$num]['calls_achieved'] ?>">
                                                <?php else:?>
                                                <?= $field_data[$num]['calls_achieved'] ?>
                                                <?php endif?>
                                            </td>
                                            <td class="calls_percentage"></td>
                                            <td class="calls_rating"></td>
                                            <td>
                                                <?php if($num == $report->num): ?>
                                                <input type="number" style="width: 100px !important;"
                                                    class="form-control fax_input val_data" name="fax_target" min="0"
                                                    value="<?= $field_data[$num]['fax_target'] ?>">
                                                <?php else:?>
                                                <?= $field_data[$num]['fax_target'] ?>
                                                <?php endif?>
                                            </td>
                                            <td>
                                                <?php if($num == $report->num): ?>
                                                <input type="number" style="width: 100px !important;"
                                                    class="form-control fax_input val_data" name="fax_achieved" min="0"
                                                    value="<?= $field_data[$num]['fax_achieved'] ?>">
                                                <?php else:?>
                                                <?= $field_data[$num]['fax_achieved'] ?>
                                                <?php endif?>
                                            </td>
                                            <td class="fax_percentage"></td>
                                            <td class="fax_rating"></td>
                                            <td class="threshold_value"></td>
                                            <td class="threshold_percentage"></td>
                                            <td class="threshold_rating"></td>
                                        </tr>
                                        <?php endforeach?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="row text-center">
                                <div class="col-sm-12" style="margin-top: 5px;">
                                    <button type="button" class="btn btn-primary"
                                        id="submit_valdb"><?= display(['save', 'val', 'db', 'fields']) ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif ?>
            <?php endif?>
        </div>
        <?php if($editable && ($objectives || $behaviors)): ?>
        <div class="row">
            <div class="col-xs-12 text-right">
                <button type="button" class="btn btn-primary"
                    id="submit"><?=display(['Submit', 'evaluation'])?></button>
            </div>
        </div>
        <?php endif?>
    </div>
</div>
<div class="modal fade" id="questions-modal" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog"
    aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <form method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Required Questions</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"
                        onclick="delete window.promotion_required; delete window.increment_required">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="container-fluid">

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="button" class="btn btn-secondary"
                        onclick="delete window.promotion_required; delete window.increment_required"
                        data-dismiss="modal">Cancel</button>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="modal fade" id="initial-submit-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
    role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
        <form method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?= display(['Select', 'Applicable', 'Boxes']) ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-check">
                        <label class="form-check-label">
                            <input type="checkbox" class="form-check-input" name="promote_employee" value="1" checked>
                            <?= display(['Promote', 'Employee']) ?>
                        </label>
                    </div>
                    <div class="form-check">
                        <label class="form-check-label">
                            <input type="checkbox" class="form-check-input" name="give_increment" value="1" checked>
                            <?= display(['Give', 'Appraisal']) ?>
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary"><?= display('submit') ?></button>
                    <button type="button" class="btn btn-secondary"
                        data-dismiss="modal"><?= display('cancel') ?></button>
                </div>
            </div>
        </form>
    </div>
</div>
<script src="<?=base_url()?>assets/plugins/smartwizard/jquery.smartWizard.min.js"></script>
<script src="<?=base_url()?>assets/plugins/grid-chart/rating-chart.js"></script>
<script src="<?= base_url() ?>assets/plugins/tinymce/tinymce.min.js"></script>
<script src="<?= base_url() ?>assets/plugins/tinymce/jquery.tinymce.min.js"></script>
<script>
window.all_editors = [];
window.letter_data = null;
var objectives_summary_chart = behaviors_summary_chart = performance_summary_chart = final_rating_chart = null;

function calculate_behavior_averages() {
    let $inputs = $('#behaviors-wizard input.rating_inputs');
    let results = {}
    $inputs.each(function() {
        let slug = `.average_block_${$(this).data('num')}`;
        $(`.behavior_scoring_block_${$(this).data('num')}${$(this).data('beh')}`).text($(this).val())
        if (!results[slug]) {
            results[slug] = {
                sum: 0,
                num: 0
            }
        }
        if ($(this).val()) {
            results[slug].sum += parseFloat($(this).val())
        }
        results[slug].num++
    })
    for (const key in results) {
        let avg = (results[key].sum / results[key].num).toFixed(2);
        $(key).text(isNaN(avg) ? 0 : avg)
    }
}

function calculate_objective_averages() {
    let $inputs = $('#objectives-wizard input.rating_inputs');
    let results = {}
    $inputs.each(function() {
        $(`td.objective_scoring_block_${$(this).data('num')}${$(this).data('obj')}`).text($(this).val())
        let slug = `.objective_average_block_${$(this).data('num')}`;
        if (!results[slug]) {
            results[slug] = {
                sum: 0,
                num: 0
            }
        }
        if ($(this).val()) {
            results[slug].sum += (parseFloat($(this).val()) * parseFloat($(this).data('weight')))
        }
        results[slug].num++
    })
    for (const key in results) {
        let avg = results[key].sum;
        /* let avg = (results[key].sum / results[key].num); */
        $(key).text(isNaN(avg) ? 0 : avg.toFixed(2))
    }
}

function calculate_summary_average() {
    let term_vals = {};
    <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
    if (!term_vals[<?= $num ?>]) {
        term_vals[<?= $num ?>] = []
    }
    term_vals[<?= $num ?>].push(parseFloat($('#summary .objective_average_block_<?= $num ?>').text()))
    term_vals[<?= $num ?>].push(parseFloat($('#summary .average_block_<?= $num ?>').text()))
    <?php endforeach ?>

    for (const num in term_vals) {
        $(`.final_rating_average_${num}`).text(get_average(term_vals[num]).toFixed(2))
        rChart.set(num, term_vals[num][0], term_vals[num][1])
    }
    if (objectives_summary_chart) {
        objectives_summary_chart.data.datasets = objectives_dataset()
        objectives_summary_chart.update()
    }
    if (behaviors_summary_chart) {
        behaviors_summary_chart.data.datasets = behaviors_dataset()
        behaviors_summary_chart.update()
    }
    if (performance_summary_chart) {
        performance_summary_chart.data.datasets = performance_dataset()
        performance_summary_chart.update()
    }
    if (final_rating_chart) {
        final_rating_chart.data.datasets = final_rating_dataset()
        final_rating_chart.update()
    }
}

function get_average(arr) {
    let len = arr.length;
    let sum = arr.reduce((s, v) => {
        return s + v
    }, 0)
    return sum / len
}

function validate_inputs($inputs) {
    let no_error = true;
    $inputs.each(function() {
        if (!no_error) {
            return;
        }
        $(this).closest('div').find('span.error').remove()
        if (!this.checkValidity() || !this.value) {
            var _this = this;
            no_error = false;
            let navId = $(_this).closest('div.main-tabs').attr('id');
            $('.nav-tabs a[href="#' + navId + '"]').tab('show');
            let id = $(_this).closest('div.wizard').attr('id');
            let step = parseInt($(_this).closest('.tab-pane').data('step')) - 1;
            if ($(`#${id}`).smartWizard("getStepIndex") != step) {
                $(`#${id}`).one("showStep", () => {
                    setTimeout(() => {
                        $('html, body').animate({
                            scrollTop: $(_this).offset().top - 300
                        }, 'slow', function() {
                            $(_this).focus();
                        });
                    }, 100);
                });
                $(`#${id}`).smartWizard("goToStep", step)
            } else {
                $('html, body').animate({
                    scrollTop: $(_this).offset().top - 300
                }, 'slow', function() {
                    $(_this).focus();
                });
            }
            $(_this).closest('div').append(
                '<span class="error"><?=addslashes(display(['Please', 'enter', 'a', 'number', 'between', $rating['range'][0], 'and', $rating['range'][1]], true))?></span>'
            )
            return
        }
    })
    return no_error
}

function validate_textarea($inputs) {
    let no_error = true;
    $inputs.each(function() {
        if (!no_error) {
            return;
        }
        $(this).closest('div').find('span.error').remove()
        this.value = $.trim(this.value)
        if (!this.value) {
            var _this = this;
            no_error = false;
            let navId = $(_this).closest('div.main-tabs').attr('id');
            $('.nav-tabs a[href="#' + navId + '"]').tab('show');
            let id = $(_this).closest('div.wizard').attr('id');
            let step = parseInt($(_this).closest('.tab-pane').data('step')) - 1;
            if ($(`#${id}`).smartWizard("getStepIndex") != step) {
                $(`#${id}`).one("showStep", () => {
                    setTimeout(() => {
                        $('html, body').animate({
                            scrollTop: $(_this).offset().top - 300
                        }, 'slow', function() {
                            $(_this).focus();
                        });
                    }, 100);
                });
                $(`#${id}`).smartWizard("goToStep", step)
            } else {
                $('html, body').animate({
                    scrollTop: $(_this).offset().top - 300
                }, 'slow', function() {
                    $(_this).focus();
                });
            }
            $(_this).closest('div').append(
                '<span class="error"><?=addslashes(display(['Please', 'enter', 'a', 'valid', 'reason', 'for', 'update'], true))?></span>'
            )
            return
        }
    })
    return no_error
}

function all_reviewed() {
    let $tabs = $('#objectives-wizard .nav-link:not(.viewed), #behaviors-wizard .nav-link:not(.viewed)');
    if ($tabs.length > 0) {
        Swal.fire(
            '<?= display('error') ?>!',
            '<?= display(['Please', 'review', 'all', 'pages', 'before', 'submission'], true) ?>',
            'error'
        )
    }
    return $tabs.length < 1;
}

function final_average() {
    let vals = {
        sum: 0,
        num: 0
    };
    let n = 0;
    <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
    n = parseFloat($('#summary .final_rating_average_<?= $num ?>').text());
    vals.sum += (n ? n : 0);
    vals.num++;
    <?php endforeach ?>
    return vals.sum / vals.num
}

function objectives_dataset() {
    return [{
            label: '<?= display('Expected') ?>',
            backgroundColor: "#d04f58",
            data: [<?= implode(', ', array_fill(0, count($objectives), $max_score)) ?>]
        },
        <?php foreach ($scoring_blocks as $num => $scoring_block): ?> {
            label: '<?= $scoring_block ?>',
            backgroundColor: "#<?= $num < 2 ? '7a8aa9' : '05253a' ?>",
            data: [<?php foreach ($objectives as $c => $objective): ?>
                parseFloat($('.objective_scoring_block_<?= $num ?><?= $objective->id ?>')
                    .text()) <?= $c < (count($objectives) - 1) ? ', ' : null ?>
                <?php endforeach ?>
            ]
        },
        <?php endforeach ?>
    ];
}

function behaviors_dataset() {
    return [{
            label: '<?= display('Expected') ?>',
            backgroundColor: "#d04f58",
            data: [<?= implode(', ', array_fill(0, count($behaviors), $max_score)) ?>]
        },
        <?php foreach ($scoring_blocks as $num => $scoring_block): ?> {
            label: '<?= $scoring_block ?>',
            backgroundColor: "#<?= $num < 2 ? '7a8aa9' : '05253a' ?>",
            data: [<?php foreach ($behaviors as $c => $behavior): ?>
                parseFloat($('.behavior_scoring_block_<?= $num ?><?= $behavior->id ?>')
                    .text()) <?= $c < (count($behaviors) - 1) ? ', ' : null ?>
                <?php endforeach ?>
            ]
        },
        <?php endforeach ?>
    ]
}

function final_rating_dataset() {
    return [{
        label: '<?= display('Earned') ?>',
        backgroundColor: "#d04f58",
        data: [{
            x: final_average(),
            y: final_average(),
            r: 30
        }]
    }, {
        label: '<?= display('Rating') ?>',
        backgroundColor: "#7a8aa9",
        data: [
            <?php for ($i=0; $i <= $max_score + 1; $i++): ?> {
                x: <?= $i ?>,
                y: <?= $i ?>,
                r: <?= $i == 0 || $i == ($max_score + 1) ? 0 : 30 ?>
            }
            <?= $i != ($max_score + 1) ? ', ' : null ?>
            <?php endfor ?>
        ]
    }]
}

function performance_dataset() {
    return [{
        label: '',
        data: [
            <?php foreach ($scoring_blocks as $num => $scoring_block): ?>
            parseFloat($('.final_rating_average_<?= $num ?>')
                .text()) <?= $num < count($scoring_blocks) ? ', ' : null ?>
            <?php endforeach ?>
        ]
    }]
}
var rChartColors = {
    1: 'red',
    2: 'blue'
}
var rChart = new Rating_chart('rating-chart-summary', JSON.parse(
    '<?= addslashes(json_encode(array_column($rating['data'], 'label'))) ?>'));
<?php foreach ($scoring_blocks as $num => $scoring_block): ?>
rChart.add(<?= $num ?>, '<?= $scoring_block ?>', rChartColors[<?= $num ?>])
<?php endforeach ?>

var rating_details = {};
<?php foreach ($rating['data'] as $scale): ?>
rating_details[<?=$scale->score?>] =
    '<span class="rating_btn rating_<?=$scale->score?>"><?=addslashes($scale->label)?></span><br><p class="rating_details"><?=addslashes($scale->description)?></p>';
<?php endforeach?>
$(document).ready(function() {
    $('.nav-tabs a').on('shown.bs.tab', function(e) {
        if ($(e.target).data('target') == '#objectives') {
            $('#objectives-wizard').smartWizard({
                selected: 0,
                theme: 'progress',
                justified: true,
                autoAdjustHeight: true,
                cycleSteps: false,
                backButtonSupport: true,
                enableURLhash: false,
                transition: {
                    animation: 'slide-vertical',
                    speed: '400',
                    easing: ''
                },
                toolbarSettings: {
                    toolbarPosition: 'bottom',
                },
                anchorSettings: {
                    enableAllAnchors: true,
                    markDoneStep: false,
                    markAllPreviousStepsAsDone: false,
                    removeDoneStepOnNavigateBack: false,
                    enableAnchorOnDoneStep: true
                },
                keyboardSettings: {
                    keyNavigation: true,
                    keyLeft: [37],
                    keyRight: [39]
                },
                lang: {
                    previous: "<< <?=display('Previous')?>",
                    next: "<?=display('Next')?> >>"
                },
                disabledSteps: [],
                errorSteps: [],
                hiddenSteps: []
            });
            $("#objectives-wizard").on("leaveStep", function(e, anchorObject, currentStepIndex,
                nextStepIndex, stepDirection) {
                let $inputs = $(`#step-obj-${currentStepIndex + 1} input[type=number]`).filter(
                    function() {
                        return !$(this).attr('disabled') && !$(this).attr('readonly')
                    })
                let $reasons = $(
                    `#step-obj-${currentStepIndex + 1} textarea:not(.tiny_textarea):not(.swal2-textarea)`
                )
                return validate_inputs($inputs) && validate_textarea($reasons)
            });
            $("#objectives-wizard").on("showStep", function(e, anchorObject, stepIndex, stepDirection) {
                $(anchorObject).addClass('viewed')
            });
        }
        
        if ($(e.target).data('target') == '#comments') {
            tinymce.init({
                selector: 'textarea.tiny_textarea',
                height: 250,
                paste_remove_styles: true,
                paste_as_text: true,
                plugins: 'print preview paste importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists wordcount textpattern noneditable help charmap emoticons',
                menubar: false,
                toolbar: 'undo redo | numlist bullist | bold italic underline strikethrough | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | ltr rtl',
                toolbar_sticky: true,
                remove_script_host: false,
                autosave_ask_before_unload: true,
                autosave_interval: '240s',
                autosave_prefix: '{path}{query}-{id}-',
                autosave_restore_when_empty: false,
                autosave_retention: '2m',
                noneditable_noneditable_class: 'mceNonEditable',
                toolbar_mode: 'sliding',
                contextmenu: false,
                content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:14px }',
                setup: function(editor) {
                    window.all_editors.push(editor)
                }
            });
        }
    })
    $('#behaviors-wizard').smartWizard({
        selected: 0,
        theme: 'progress',
        justified: true,
        autoAdjustHeight: true,
        cycleSteps: false,
        backButtonSupport: true,
        enableURLhash: false,
        transition: {
            animation: 'slide-vertical',
            speed: '400',
            easing: ''
        },
        toolbarSettings: {
            toolbarPosition: 'bottom',
        },
        anchorSettings: {
            enableAllAnchors: true,
            markDoneStep: false,
            markAllPreviousStepsAsDone: false,
            removeDoneStepOnNavigateBack: false,
            enableAnchorOnDoneStep: true
        },
        keyboardSettings: {
            keyNavigation: true,
            keyLeft: [37],
            keyRight: [39]
        },
        lang: {
            previous: "<< <?=display('Previous')?>",
            next: "<?=display('Next')?> >>"
        },
        disabledSteps: [],
        errorSteps: [],
        hiddenSteps: []
    });
    $("#behaviors-wizard").on("leaveStep", function(e, anchorObject, currentStepIndex, nextStepIndex,
        stepDirection) {
        let $inputs = $(`#step-${currentStepIndex + 1} input[type=number]`).filter(function() {
            return !$(this).attr('disabled') && !$(this).attr('readonly')
        })
        let $reasons = $(
            `#step-${currentStepIndex + 1} textarea:not(.tiny_textarea):not(.swal2-textarea)`)
        return validate_inputs($inputs) && validate_textarea($reasons)
    });
    $("#behaviors-wizard").on("showStep", function(e, anchorObject, stepIndex, stepDirection) {
        $(anchorObject).addClass('viewed')
    });
    <?php if (!$_self || $approved_report): ?>
    var ctx_objectives_summary_chart = document.getElementById("objectives_summary_chart").getContext("2d");
    var ctx_behaviors_summary_chart = document.getElementById("behaviors_summary_chart").getContext("2d");
    var ctx_performance_summary_chart = document.getElementById("performance_summary_chart").getContext("2d");
    var ctx_final_rating_chart = document.getElementById("final_rating_chart").getContext("2d");
    var objectives_data = {
        labels: JSON.parse('<?= addslashes(json_encode(array_column($objectives, 'label'))) ?>'),
        datasets: objectives_dataset()
    };
    var behaviors_data = {
        labels: JSON.parse('<?= addslashes(json_encode(array_column($behaviors, 'label'))) ?>'),
        datasets: behaviors_dataset()
    };
    var performance_data = {
        labels: JSON.parse('<?= addslashes(json_encode(array_values($scoring_blocks))) ?>'),
        datasets: performance_dataset()
    };
    var final_rating_data = {
        datasets: final_rating_dataset()
    };

    objectives_summary_chart = new Chart(ctx_objectives_summary_chart, {
        type: 'bar',
        data: objectives_data,
        options: {
            title: {
                display: true,
                text: '<?= display('Objectives') ?>'
            },
            scales: {
                yAxes: [{
                    ticks: {
                        min: 0,
                    }
                }]
            }
        }
    });
    behaviors_summary_chart = new Chart(ctx_behaviors_summary_chart, {
        type: 'bar',
        data: behaviors_data,
        options: {
            title: {
                display: true,
                text: '<?= display('Behaviors') ?>'
            },
            scales: {
                yAxes: [{
                    ticks: {
                        min: 0,
                    }
                }]
            }
        }
    });
    performance_summary_chart = new Chart(ctx_performance_summary_chart, {
        type: 'line',
        data: performance_data,
        options: {
            title: {
                display: true,
                text: '<?= display(['Change', 'in', 'performance', 'level']) ?>'
            },
            legend: {
                display: false
            },
            scales: {
                yAxes: [{
                    ticks: {
                        min: 0,
                    }
                }]
            }
        }
    });
    final_rating_chart = new Chart(ctx_final_rating_chart, {
        type: 'bubble',
        data: final_rating_data,
        options: {
            title: {
                display: true,
                text: '<?= display(['Final', 'Rating']) ?>'
            },
            scales: {
                yAxes: [{
                    ticks: {
                        min: 0,
                    }
                }]
            }
        }
    });
    <?php endif ?>
});

function percentage_to_rating(perc) {
    if (perc >= 100) {
        return 5
    }
    if (perc < 100 && perc >= 95) {
        return 4
    }
    if (perc < 95 && perc >= 90) {
        return 3
    }
    if (perc < 90 && perc >= 85) {
        return 2
    }
    if (perc >= 1) {
        return 1
    }
    return 0
}

function calculate_threshold(parent) {
    let sum = 0;
    //sum += parseInt(parent.find('.target_rating').text())
    sum += parseInt(parent.find('.files_rating').text())
    sum += parseInt(parent.find('.followup_rating').text())
    sum += parseInt(parent.find('.ar_rating').text())
    sum += parseInt(parent.find('.calls_rating').text())
    sum += parseInt(parent.find('.fax_rating').text())

    let perc = Math.round((sum / 25) * 100);
    parent.find('.threshold_value').text(sum)
    parent.find('.threshold_percentage').text(perc + '%')
    parent.find('.threshold_rating').text(sum / 5)
}
$('input.target_input').on('change', function() {
    var parent = $(this).closest('tr');
    let a = parent.find('[name=target_achieved]').val();
    let b = parent.find('[name=target_monthly]').val();
    if (a && b) {
        let perc = Math.round((a / b) * 100);
        parent.find('.target_percentage').text(perc + '%')
        parent.find('.target_rating').text(percentage_to_rating(perc))
    } else {
        parent.find('.target_percentage').text('0%')
        parent.find('.target_rating').text('0')
    }
    calculate_threshold(parent)
}).trigger('change')
$('input.files_input').on('change', function() {
    var parent = $(this).closest('tr');
    let a = parent.find('[name=files_touched]').val();
    let b = parent.find('[name=files_target]').val();
    if (a && b) {
        let perc = Math.round((a / b) * 100);
        parent.find('.files_percentage').text(perc + '%')
        parent.find('.files_rating').text(percentage_to_rating(perc))
    } else {
        parent.find('.files_percentage').text('0%')
        parent.find('.files_rating').text('0')
    }
    calculate_threshold(parent)
}).trigger('change')
$('input.followup_input').on('change', function() {
    var parent = $(this).closest('tr');
    let a = parent.find('[name=followup_achieved]').val();
    let b = parent.find('[name=followup_target]').val();
    if (a && b) {
        let perc = Math.round((a / b) * 100);
        parent.find('.followup_percentage').text(perc + '%')
        parent.find('.followup_rating').text(percentage_to_rating(perc))
    } else {
        parent.find('.followup_percentage').text('0%')
        parent.find('.followup_rating').text('0')
    }
    calculate_threshold(parent)
}).trigger('change')
$('input.ar_input').on('change', function() {
    var parent = $(this).closest('tr');
    let a = parent.find('[name=ar_achieved]').val();
    let b = parent.find('[name=ar_target]').val();
    if (a && b) {
        let perc = Math.round((a / b) * 100);
        parent.find('.ar_percentage').text(perc + '%')
        parent.find('.ar_rating').text(percentage_to_rating(perc))
    } else {
        parent.find('.ar_percentage').text('0%')
        parent.find('.ar_rating').text('0')
    }
    calculate_threshold(parent)
}).trigger('change')
$('input.calls_input').on('change', function() {
    var parent = $(this).closest('tr');
    let a = parent.find('[name=calls_achieved]').val();
    let b = parent.find('[name=calls_target]').val();
    if (a && b) {
        let perc = Math.round((a / b) * 100);
        parent.find('.calls_percentage').text(perc + '%')
        parent.find('.calls_rating').text(percentage_to_rating(perc))
    } else {
        parent.find('.calls_percentage').text('0%')
        parent.find('.calls_rating').text('0')
    }
    calculate_threshold(parent)
}).trigger('change')
$('input.fax_input').on('change', function() {
    var parent = $(this).closest('tr');
    let a = parent.find('[name=fax_achieved]').val();
    let b = parent.find('[name=fax_target]').val();
    if (a && b) {
        let perc = Math.round((a / b) * 100);
        parent.find('.fax_percentage').text(perc + '%')
        parent.find('.fax_rating').text(percentage_to_rating(perc))
    } else {
        parent.find('.fax_percentage').text('0%')
        parent.find('.fax_rating').text('0')
    }
    calculate_threshold(parent)
}).trigger('change')
$('input.rating_inputs').on('change', function() {
    $(this).closest('div.form-group').find('span.rating_details').html('')
    if (parseInt(this.value) < 1 && !$(this).attr('disabled')) {
        this.value = null;
    }
    let tab = $(this).closest('.main-tabs');
    <?php if($report->status != 'pending-employee'): ?>
    if (!$(this).attr('disabled') && !isNaN(parseFloat($(this).data('init')))) {
        if ($(this).val() != $(this).data('init')) {
            if (!$(this).closest('div.form-group').parent().find('div.reason_block').length) {
                $(this).closest('div.form-group').parent().append(`<div class="col-xs-12 reason_block">
                <div class="form-group">
                <label><?= display(['Reason', 'for', 'update']) ?></label>
                <textarea class="form-control" name="reason_${$(this).attr('name')}" rows="3"></textarea></div></div>`)
            }
        } else {
            $(this).closest('div.row').find('div.reason_block').remove()
        }
    }
    <?php endif ?>
    $(this).closest('div.form-group').find('span.rating_details').html(rating_details[this.value])
    calculate_behavior_averages()
    calculate_objective_averages()
    calculate_summary_average()
}).trigger('change')
$('input.rating_inputs').on('keyup', function() {
    if (!this.checkValidity()) {
        this.value = '';
        alert(
            '<?=addslashes(display(['Please', 'enter', 'a', 'number', 'between', $rating['range'][0], 'and', $rating['range'][1]], true))?>'
        )
    } else {
        $(this).closest('div.form-group').find('span.rating_details').html(rating_details[this.value])
        $(this).closest('div.form-group').find('span.error').remove()
    }
}).trigger('keyup')
<?php if($report->status == 'pending-hr' && $promotion_letter) : ?>
$('#initial-submit-modal').on('submit', 'form', function(e) {
    e.preventDefault();
    let $form = $(this);
    $form.find('input').each(function() {
        if ($(this).attr('name') == 'promote_employee') {
            window.promotion_required = $(this).is(':checked')
        }
        if ($(this).attr('name') == 'give_increment') {
            window.increment_required = $(this).is(':checked')
        }
    })
    $('#initial-submit-modal').modal('hide');
    $('button#submit').trigger('click')
})
$('#questions-modal').on('submit', 'form', function(e) {
    e.preventDefault();
    var isErr = false
    tinymce.editors.forEach(editor => {
        var content = editor.getContent({
            format: 'text'
        });
        var editor = $(editor.getElement());
        if (!isErr && editor.data('required') && $.trim(content) == '') {
            var label = editor.closest('div').find('label').text()
            alert(label + ' is required')
            isErr = true;
        }
    });
    $(this).find('input').each(function() {
        if (!isErr && $(this).attr('readonly') !== undefined && $(this).attr('required') !==
            undefined && !$(this).val()) {
            $(this).focus()
            alert(`${$(this).siblings('label').text()} field is required`)
            isErr = true
        }
    })
    if (isErr) {
        return false
    }
    window.letter_data = {
        'letter_id': <?= $promotion_letter ?>,
        'input': btoa($(this).serialize())
    };
    $('button#submit').trigger('click')
})
<?php endif ?>
$('button#submit').on('click', function() {
    $('span.error').remove()
    let $inputs = $('#main_report input[type=number]:not(.val_data)').filter(function() {
        return !$(this).attr('disabled') && !$(this).attr('readonly')
    })
    let $reasons = $('textarea:not(.tiny_textarea)')
    if (!validate_inputs($inputs)) {
        return
    }
    if (!validate_textarea($reasons)) {
        return
    }
    if (!all_reviewed()) {
        return
    }
    <?php if($report->status == 'pending-hr' && $promotion_letter) : ?>
    if (window.promotion_required === undefined && window.increment_required === undefined) {
        $('#initial-submit-modal').modal('show');
        return
    }
    if (!window.letter_data && !window.noFields && (window.promotion_required === true ||
            window.increment_required === true)) {
        let $qModal = $('#questions-modal')
        myajax({
            type: "POST",
            url: "<?= base_url() ?>incident/letter_details",
            data: {
                letter_id: window.increment_required === true ? <?= $promotion_letter_with_appraisal ?> : <?= $promotion_letter ?>
            },
            success: function(res) {
                if (res.fields) {
                    $qModal.find('.modal-body .container-fluid').html('')
                    $qModal.find('.modal-body').html(res.fields)
                    if (window.increment_required) {
                        $qModal.find('.modal-body>.container-fluid').first().prepend(
                            `<div class="form-group">
                            <label for="dd_inceffective_date"><?= display(['Increment', 'Effective', 'Date']) ?> *</label>
                            <input type="date" class="form-control" name="inc_effective_date" id="dd_inceffective_date" placeholder="<?= display(['Increment', 'Effective', 'Date']) ?>" required="required">
                        </div><div class="form-group">
                            <label for="dd_incamount"><?= display(['Increment', 'Amount']) ?> *</label>
                            <input type="number" class="form-control" name="inc_amount" id="dd_incamount" placeholder="<?= display(['Increment', 'Amount']) ?>" required="required">
                        </div>`)
                    }
                    $qModal.modal('show');
                    return
                } else {
                    window.noFields = true
                }
            }
        });
        return
    }
    <?php endif ?>
    let data = {};
    let reasons = {};
    $inputs.each(function() {
        let name = $(this).attr('name').split('_');
        if (!data[name[0]]) {
            data[name[0]] = {};
        }
        data[name[0]][name[3]] = this.value
    })
    $reasons.each(function() {
        let input = $(this).closest('div.rating_block_reviews').find('input[type=number]')
        let name = $(this).attr('name').split('_');
        if (!reasons[name[1]]) {
            reasons[name[1]] = {};
        }
        reasons[name[1]][name[4]] = {
            old_value: input.data('init'),
            new_value: input.val(),
            remarks: this.value
        }
    })
    let manager_comments = '';
    let employee_comments = '';
    window.all_editors.forEach(editor => {
        if (editor.targetElm.name == 'employee_comments') {
            employee_comments = editor.getContent()
        }
        if (editor.targetElm.name == 'manager_comments') {
            manager_comments = editor.getContent()
        }
    });
    myajax({
        type: "POST",
        data: {
            status: '<?= $report->status ?>',
            inputs: data,
            reasons: reasons,
            employee_comments: btoa(employee_comments),
            manager_comments: btoa(manager_comments),
            promotion_required: window.promotion_required,
            increment_required: window.increment_required,
            letter_data: window.letter_data
        },
        success: function(res) {
            if (res.success) {
                Swal.fire(
                    '<?= display('success') ?>!',
                    res.success,
                    'success'
                )
                location.reload()
            } else if (res.error) {
                Swal.fire(
                    '<?= display('error') ?>!',
                    res.error,
                    'error'
                )
            } else {
                Swal.fire(
                    '<?= display('error') ?>!',
                    '<?= display(['Unknown', 'server', 'error', ',', 'try', 'again'], true) ?>',
                    'error'
                )
            }
            if (res.reload) {
                location.reload()
            }
        }
    });
})
$('button#submit_valdb').on('click', function() {
    let data = {};
    $('#val_db input.val_data').each(function() {
        data[$(this).attr('name')] = $(this).val()
    })
    $.ajax({
        type: "POST",
        url: "<?= base_url() ?>employee/evaluation/save_val_db_data/<?= $report->id ?>",
        data: data,
        success: function(res) {
            if (res.success) {
                Swal.fire(
                    '<?= display('success') ?>!',
                    res.success,
                    'success'
                )
                location.reload()
            } else if (res.error) {
                Swal.fire(
                    '<?= display('error') ?>!',
                    res.error,
                    'error'
                )
            } else {
                Swal.fire(
                    '<?= display('error') ?>!',
                    '<?= display(['Unknown', 'server', 'error', ',', 'try', 'again'], true) ?>',
                    'error'
                )
            }
            if (res.reload) {
                location.reload()
            }
        }
    });
})
</script>