<div class="container-fluid">
    <?php if($this->permission->method('evaluation_behaviors', 'create')->access()): ?>
    <div class="row">
        <a role="button" href="<?= base_url() ?>employee/evaluation_behaviors/add" class="btn btn-primary pull-right"><?= display('add') ?> <?= $title ?></a>
    </div>
    <br>
    <?php endif ?>
    <div class="row">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th><?= display('title') ?></th>
                    <th><?= display('description') ?></th>
                    <?php if ($this->permission->method('evaluation_behaviors', 'update')->access() || $this->permission->method('evaluation_behaviors', 'delete')->access()): ?>
                    <th class="hideexport"><?= display('action') ?></th>
                    <?php endif?>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<script>
$(document).ready(function() {
    window.dtable = $('table').DataTable($.extend({}, window.default_datatable_opts, {
        responsive: false,
        processing: true,
        serverSide: true,
        ajax: {
            method: 'post',
            beforeSend: function() {},
        },
        columns: [{
                'data': 'label',
            }, {
                'data': 'description',
            },
            <?php if ($this->permission->method('evaluation_behaviors', 'update')->access() || $this->permission->method('evaluation_behaviors', 'delete')->access()): ?> {
                'data': 'action',
                'className': 'action-buttons',
                'sortable': false
            },
            <?php endif ?>
        ],
    }))
    $('table').on('click', '.btn-delete', function(e) {
        e.preventDefault()
        let $this = $(this);
        Swal.fire({
            title: '<?= addslashes(display('delete_confirm_title')) ?>',
            html: '<?= addslashes(display('delete_confirm_description')) ?>',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: '<?= addslashes(display('delete_confirm_yes_button')) ?>',
            confirmCancelText: '<?= addslashes(display('delete_confirm_cancel_button')) ?>'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "DELETE",
                    url: "<?= base_url() ?>employee/evaluation/behaviors_rest/" +
                        $this.data('id'),
                    success: function(res) {
                        if (res.success) {
                            window.dtable.ajax.reload()
                            Swal.fire(
                                '<?= display('success') ?>!',
                                res.success,
                                'success'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        }
                    }
                });
            }
        })
    })
});
</script>