<div class="row">
    <div class="col-sm-12">
        <div class="panel panel-default">
            <div class="panel-body">
                <?= form_open('',array('class' => 'form-inline', 'id' => 'validate'));?>
                    <label class="select"><?= display('search') ?>:</label>
                    <select name="col_name" id="col_name" class="form-control" required="required">
                        <option value="">Select One</option>
                        <?php foreach ($search_columns as $key => $column):?>
                            <option value="<?= $key ?>"><?= display($column) ?></option>
                        <?php endforeach?>
                    </select>
                    <input type="text" name="what_you_search" class="form-control" placeholder='<?= display('what_you_search') ?>' id="what_you_search" required>
                    <button type="submit" class="btn btn-primary"><?= display('search') ?></button>
                    <button type="reset" class="btn btn-warning"><?= display('reset') ?></button>
                <?= form_close()?>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <!--  table area -->
    <div class="col-sm-12">
        <div class="panel panel-default thumbnail"> 
            <div class="panel-body table-responsive">
                <table width="100%" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                           <th><?= display('cid') ?></th>
                            <?php foreach ($columns as $column): ?>
                                <th><?= display($column) ?></th>
                            <?php endforeach?>
                           <th class="hideexport"><?= display('action')?></th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script>
    $(function () {
        window.dtable = $('table.table').DataTable($.extend({},
            window.default_datatable_opts, {
                searching: false,
                responsive: true,
                processing: true,
                serverSide: true,
                ajax: {
                    method: 'post',
                    data: function(d) {
                        d.search = {
                            column: $.trim($('#col_name').val()),
                            value: $.trim($('#what_you_search').val())
                        }
                    }
                },
                columnDefs: [ {
                    targets: [18, 19, 20, 23, 28],
                    type: "date",
                    render: function ( data, type ) {
                    if(type === 'sort'){
                        return data ? moment(data, 'DD-MM-YYYY') : null
                    }
                    return data;
                }
            
            } ],
                order: [[ 4, "asc" ]],
                columns: [
                    {
                        'data': 'index',
                        'sortable': false
                    },
                    <?php
                    foreach ($columns as $key => $value) {
                        echo "{'data': '{$key}'";
                        if(in_array($key, $encrypted_cols)) {
                            echo ", 'sortable': false";
                        }
                        echo "},";
                    }
                    ?>
                    {
                        'data': 'action',
                        'sortable': false
                    },
                ],
            }
        ))
        $('form#validate').on('submit', function (e) {
            e.preventDefault();
            window.dtable.ajax.reload();    
    });
        $('form#validate').on('reset', function () {
            $('#col_name').val(null).trigger('change');
            $('#what_you_search').val(null)
            window.dtable.ajax.reload();    
        });
    });
    $('table.table').on('click', '.btn-delete', function(e) {
        e.preventDefault()
        $this = $(this);
        Swal.fire({
            title: `Are you sure?`,
            html: `Pressing 'Yes' will remove all data of "<strong>${$this.data('name')}</strong>", do you really want to proceed?<br>You won't be able to revert this action!`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>employee/employees/delete_employhistory_ajax",
                    data: {
                        id: $this.data('id')
                    },
                    success: function (res) {
                        if(res.success) {
                            Swal.fire(
                                '<?= display('deleted') ?>!',
                                res.message,
                                'success'
                            )
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.message,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                        if(res.reload) {
                            window.dtable.ajax.reload()
                        }       
                    }
                });
            }
        })
    })
</script>