<style>
    .progress {
        background-color: #dbdada;
        height: 15px;
    }
    .progress-bar {
        height: 15px;
    }
    .errorTR {
        border: 2px solid red;
    }
    input[type=file] {
        border-radius: 0px;
    }
</style>
<div class="container-fluid">
    <table class="table table-hover">
        <caption><?= display('missing_documents') ?></caption>
        <thead>
            <tr>
                <th><?= display('document') ?></th>
                <th><?= display('status') ?></th>
                <th><?= display('remarks') ?></th>
                <th><?= display('deadline') ?></th>
                <th><?= display('file') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($documents as $document) :?>
                <tr>
                    <td><?= $document->title ?></td>
                    <td><?= ucfirst($document->status) ?></td>
                    <td><?= $document->rejection_reason ?></td>
                    <td><?= formatted_date($document->period_end) ?></td>
                    <td style="width: 300px">
                        <span class="upload-span">
                            <input type="file" class="file_<?= $document->id ?>" data-id="<?= $document->id ?>" <?= empty(trim($document->period_end)) ? null : 'data-required="yes"' ?>>
                            <small class="form-text text-muted">Max File Size: 2MB</small>
                        </span>
                    </td>
                </tr>
            <?php endforeach?>
        </tbody>
    </table>
    <?php if($documents): ?>
        <button type="button" class="btn btn-primary pull-right upload-multi">Save</button>
    <?php endif?>
</div>
<?php include APPPATH . 'modules/employee/views/script/upload-script.php' ?>