<?php
class Rating_scale_model extends CI_Model
{
    private $table = 'rating_scale';
    public function score_exists($score, $id = null)
    {
        return $this->db->where(['score' => $score, 'id <>' => $id])->count_all_results($this->table) > 0;
    }
    public function label_exists($label, $id = null)
    {
        return $this->db->where(['label' => $label, 'id <>' => $id])->count_all_results($this->table) > 0;
    }
    public function get($id = null)
    {
        $this->db->from($this->table);
        if ($id) {
            return $this->db->where('id', $id)->get()->row();
        }
        return $this->db->get()->result();
    }
    public function max()
    {
        return $this->db->select_max('score')->get($this->table)->row()->score;
    }
    public function save($data)
    {
        $id = null;
        $this->db->trans_start();
        if (empty($data['id'])) {
            $this->db->insert($this->table, $data);
            $id = $this->db->insert_id();
            $this->activity->log([
                'rating_item_added',
                $data['label'],
                $id,
            ]);
        } else {
            $id = $data['id'];
            $this->db->where('id', $data['id'])->update($this->table, $data);
            $this->activity->log([
                'rating_item_updated',
                $data['label'],
                $id,
            ]);
        }
        $this->db->trans_complete();
        if ($this->db->trans_status()) {
            return $id;
        }
        return false;
    }
    public function delete($id)
    {
        $rec = $this->get($id);
        if ($rec) {
            $this->db->trans_start();
            $this->db->where('id', $id)->delete($this->table);
            $this->activity->log([
                'rating_item_deleted',
                $rec->label,
                $id,
            ]);
            $this->db->trans_complete();
            return $this->db->trans_status();
        }
        return false;
    }
    public function countAllRows()
    {
        return $this->db->count_all($this->table);
    }
    public function countDatatable($orWhere = [])
    {
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        return $this->db->count_all_results($this->table);
    }
    public function getDatatable($orWhere = [])
    {
        $post = $this->input->post();

        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);

        return $this->db->get($this->table)->result_array();
    }
}
