<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Options_model extends CI_Model
{
    private $table = 'employee_options';
    private $col_alt = [
        'campaign' => 'campaign',
        'primary_project' => 'primary_project',
        'religion' => 'ethnic_group',
        'team' => 'team',
        'city' => 'city',
    ];
    public function get_types()
    {
        return array_column($this->db->select('type')->distinct()->order_by('type', 'asc')->get($this->table)->result_array(), 'type');
    }
    public function get($id = null)
    {
        if ($id) {
            return $this->db->where('id', $id)->get($this->table)->row();
        }
        $recs = $this->db->select('type, value')->order_by('type', 'asc')->get($this->table)->result_array();
        $data = [];
        foreach ($recs as $rec) {
            if (!isset($data[$rec['type']])) {
                $data[$rec['type']] = [];
            }
            $data[$rec['type']][] = $rec['value'];
        }
        $data = array_map(function ($dt) {
            sort($dt);
            return $dt;
        }, $data);
        return $data;
    }
    public function exists($type, $value, $exlude_id = null)
    {
        if ($exlude_id) {
            $this->db->where('id <>', $exlude_id);
        }
        return $this->db->where([
            'type' => $type,
            'value' => $value,
        ])->count_all_results($this->table);
    }
    public function add($type, $value)
    {
        $value = strip_tags($value);
        $this->db->trans_start();
        $this->db->insert($this->table, [
            'type' => $type,
            'value' => $value,
        ]);
        $this->activity->log([
            'dropdown_value_added',
            $value,
            slug_to_readable($type),
        ]);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function update($id, $type, $value)
    {
        $value = strip_tags($value);
        $this->db->trans_start();
        $rec = $this->get($id);
        $this->db->where('id', $id)->update($this->table, [
            'type' => $type,
            'value' => $value,
        ]);
        $this->db->where($this->col_alt[$type], $rec->value)->update('employee_history', [
            $this->col_alt[$type] => $value,
        ]);
        $this->activity->log([
            'dropdown_value_updated',
            $rec->value,
            $value,
            slug_to_readable($type),
        ]);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function delete($id)
    {
        $this->db->trans_start();
        $rec = $this->get($id);
        $this->db->where('id', $id)->delete($this->table);
        $this->activity->log([
            'dropdown_value_deleted',
            $rec->value,
            slug_to_readable($rec->type),
        ]);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function check_employees($id)
    {
        $rec = $this->get($id);
        return $this->db->select('employee_id, hrm_id, first_name, last_name')->where($this->col_alt[$rec->type], $rec->value)->get('employee_history')->result();
    }
    public function countAllRows($type)
    {
        return $this->db->where('type', $type)->count_all_results($this->table);
    }
    public function countDatatable($type, $orWhere = [])
    {
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        return $this->db->where('type', $type)->count_all_results($this->table);
    }
    public function getDatatable($type, $orWhere = [])
    {
        $post = $this->input->post();

        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db->where('type', $type)
            ->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);

        return $this->db->get($this->table)->result_array();
    }
}
