<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Fields_model extends CI_Model
{
    private $field_aliases = [
        'marital_status' => 'Marital Status',
        'middle_name' => 'Middle Name',
        'phone' => 'Phone',
        'alter_phone' => 'Alternative Phone',
        'home_phone' => 'Home Phone',
        'emerg_contct' => 'Emergency Contact Number',
        'cell_phone' => 'Cell Phone',
        'home_email' => 'Personal Email',
        'dept_id' => 'Department',
        'super_visor_id' => 'Direct Supervisor Name',
        'indirect_super_visor_id' => 'Indirect Supervisor Name',
        'team' => 'Team',
        'campaign' => 'Campaign',
    ];
    private $_join_fields = [
        'marital_status' => [
            'table' => 'marital_info',
            'field' => 'id',
            'label' => 'marital_sta',
        ],
        'dept_id' => [
            'table' => 'department',
            'field' => 'dept_id',
            'label' => 'department_name',
        ],
        'super_visor_id' => [
            'table' => 'employee_history',
            'field' => 'employee_id',
            'label' => 'CONCAT_WS(\' \', first_name, last_name, CONCAT(\'(\', hrm_id, \')\'))',
        ],
        'indirect_super_visor_id' => [
            'table' => 'employee_history',
            'field' => 'employee_id',
            'label' => 'CONCAT_WS(\' \', first_name, last_name, CONCAT(\'(\', hrm_id, \')\'))',
        ],
    ];
    public function get_aliases($key = null)
    {
        if ($key) {
            return $this->field_aliases[$key] ?? slug_to_readable($key);
        }
        return $this->field_aliases;
    }
    public function get($employee_id)
    {
        $data = [];
        $recs = getByWhere('employee_pending_fields', 'col_name, col_value', ['employee_id' => $employee_id, 'status' => 'pending']);

        if ($recs) {
            foreach ($recs as $rec) {
                if ($this->_join_fields[$rec->col_name]) {
                    $table_info = $this->_join_fields[$rec->col_name];
                    $rec_info = $this->db->select($table_info['label'] . ' as res')->where($table_info['field'], $rec->col_value)->get($table_info['table'])->row_array();
                    if ($rec_info) {
                        $rec->col_value = $rec_info['res'];
                    }
                }
                $data[$rec->col_name] = $rec->col_value;
            }
        }
        return decrypt_employee_data($data);
    }
    public function get_all($status = 'pending')
    {
        $employees_data = [];
        $recs = getByWhereAsArray(
            'employee_pending_fields,
            employee_history-employee_pending_fields.employee_id=employee_history.employee_id-left,
            employee_history requestor-employee_pending_fields.added_by=requestor.employee_id-left',
            'employee_pending_fields.*,
            COALESCE(employee_pending_fields.updated_at, employee_pending_fields.added_at) as requested_at,
            CONCAT_WS(\' \', employee_history.first_name, employee_history.middle_name, employee_history.last_name) as employee_name,
            CONCAT_WS(\' \', requestor.first_name, requestor.middle_name, requestor.last_name, CONCAT(\'(\', requestor.hrm_id, \')\')) as requestor,
            employee_history.hrm_id',
            ['employee_pending_fields.status' => $status]
        );
        return array_map(function ($rec) use ($employees_data) {
            if ($this->_join_fields[$rec['col_name']]) {
                $table_info = $this->_join_fields[$rec['col_name']];
                $rec_info = $this->db->select($table_info['label'] . ' as res')->where($table_info['field'], $rec['col_value'])->get($table_info['table'])->row_array();
                if ($rec_info) {
                    $rec['col_value'] = $rec_info['res'];
                }
            }
            if (!isset($employees_data[$rec['employee_id']])) {
                $_em_rec = $this->db->select('employee_history.*, marital_info.marital_sta as marital_status, department.department_name as dept_id, CONCAT_WS(\' \', supervisor_data.first_name, supervisor_data.last_name, CONCAT(\'(\', supervisor_data.hrm_id, \')\')) as super_visor_id, CONCAT_WS(\' \', id_supervisor_data.first_name, id_supervisor_data.last_name, CONCAT(\'(\', id_supervisor_data.hrm_id, \')\')) as indirect_super_visor_id')
                    ->where('employee_history.employee_id', $rec['employee_id'])
                    ->join('marital_info', 'marital_info.id=employee_history.marital_status', 'left')
                    ->join('department', 'department.dept_id=employee_history.dept_id', 'left')
                    ->join('employee_history supervisor_data', 'employee_history.super_visor_id=supervisor_data.employee_id', 'left')
                    ->join('employee_history id_supervisor_data', 'employee_history.super_visor_id=id_supervisor_data.employee_id', 'left')
                    ->get('employee_history')->row_array();
                if (!$_em_rec) {
                    return null;
                }
                $employees_data[$rec['employee_id']] = decrypt_employee_data($_em_rec);
            }
            $rec['old_value'] = $employees_data[$rec['employee_id']][$rec['col_name']];

            $rec['col_value'] = decrypt_employee_data([$rec['col_name'] => $rec['col_value']])[$rec['col_name']];
            return $rec;
        }, $recs);
    }
    public function save($data, $employee_id = null)
    {
        if (!$employee_id) {
            $employee_id = $this->session->userdata('employee_id');
        }
        $data = encrypt_employee_data($data);
        $emp_rec = $this->db->select('first_name, last_name, hrm_id')->where('employee_id', $employee_id)->get('employee_history')->row();
        $this->db->trans_begin();
        foreach ($data as $key => $value) {
            $chck = $this->db->select('col_name')->where([
                'employee_id' => $employee_id,
                'col_name' => $key,
                'status' => 'pending',
            ])->get('employee_pending_fields')->row();

            if ($chck) {
                $this->db->where([
                    'employee_id' => $employee_id,
                    'col_name' => $key,
                    'status' => 'pending',
                ])->update('employee_pending_fields', [
                    'col_value' => $value,
                    'updated_at' => date('Y-m-d H:i:s'),
                    'added_by' => $this->session->userdata('employee_id'),
                ]);
            } else {
                $this->db->insert('employee_pending_fields', [
                    'employee_id' => $employee_id,
                    'col_name' => $key,
                    'col_value' => $value,
                    'added_at' => date('Y-m-d H:i:s'),
                    'added_by' => $this->session->userdata('employee_id'),
                ]);
            }
            if ($employee_id != $this->session->userdata('employee_id')) {
                $this->notify->department('hr')->send(
                    sprintf('%s (%s) added a change request for %s of \'%s %s (%s)\'', $this->session->userdata('fullname'), $this->session->userdata('hrm_id'), $this->get_aliases($key), $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                    'employee/Pending_changes/list'
                );
            } else {
                $this->notify->department('hr')->send(
                    sprintf('%s %s (%s) added a change request for their %s', $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id, $this->get_aliases($key)),
                    'employee/Pending_changes/list'
                );
            }
        }
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
            return true;
        }
        return false;
    }
    public function process($process, $data)
    {
        $this->load->model('employees_model');
        $this->db->trans_begin();
        $rec = getByWhere('employee_pending_fields, employee_history-employee_pending_fields.added_by=employee_history.employee_id-left', 'employee_pending_fields.col_name, employee_pending_fields.col_value, employee_pending_fields.employee_id, employee_pending_fields.added_by, CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name, CONCAT(\'(\', employee_history.hrm_id, \')\')) as requestor', ['employee_pending_fields.employee_id' => $data['employee_id'], 'employee_pending_fields.status' => 'pending', 'employee_pending_fields.col_name' => $data['col_name']], ['employee_pending_fields.added_at, employee_pending_fields.updated_at', 'desc'])[0];
        $is_self_request = $rec->added_by == $rec->employee_id;
        $requestor = $rec->added_by == $rec->employee_id ? 'Self' : $rec->requestor;
        $emp_rec = $this->db->select('CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name, CONCAT(\'(\', employee_history.hrm_id, \')\')) as full_name, employee_history.division_id, divisions.url')->where('employee_id', $rec->employee_id)->join('divisions', 'employee_history.division_id=divisions.id', 'left')->get('employee_history')->row();
        $requestor_rec = null;
        if (!$is_self_request) {
            $requestor_rec = $this->db->select('CONCAT_WS(\' \', first_name, last_name, CONCAT(\'(\', hrm_id, \')\')) as full_name')->where('employee_id', $rec->added_by)->get('employee_history')->row();
        }

        $old_data = decrypt_employee_data($this->db->select($rec->col_name)->where('employee_id', $data['employee_id'])->get('employee_history')->row_array());
        $new_data = decrypt_employee_data([$rec->col_name => $rec->col_value]);
        if ($process == 'approve') {
            if ($rec) {
                $this->db->where('employee_id', $data['employee_id'])->update('employee_history', [
                    $rec->col_name => $rec->col_value,
                ]);
            }
            if ($rec->added_by != $rec->employee_id) {
                $this->notify->employee($rec->added_by)->send(
                    sprintf('Your request to update \'%s\' of %s was approved.', $this->get_aliases($data['col_name']), $emp_rec->full_name),
                    'employee/employees/cv/' . $data['employee_id']
                );
            } else {
                $this->notify->employee($data['employee_id'])->send(
                    sprintf('Your request to update \'%s\' was approved.', $this->get_aliases($data['col_name'])),
                    'employee/employees/cv/' . $data['employee_id']
                );
            }
            $this->employees_model->log_employee_change($data['employee_id'], $new_data, $old_data, [], 'employee_update_request', sprintf(' (Requestor: %s) ', $requestor));
        }
        if ($process == 'reject') {
            $this->employees_model->log_employee_change($data['employee_id'], $new_data, $old_data, [], 'employee_update_request_rejected', sprintf(' (Requestor: %s) ', $requestor));
            if ($rec->added_by != $rec->employee_id) {
                $this->notify->employee($rec->added_by)->send(
                    sprintf('Your request to update \'%s\' of %s was rejected.', $this->get_aliases($data['col_name']), $emp_rec->full_name),
                    'employee/employees/cv/' . $data['employee_id']
                );
            } else {
                $this->notify->employee($data['employee_id'])->send(
                    sprintf('Your request to update \'%s\' was rejected.', $this->get_aliases($data['col_name'])),
                    'employee/employees/cv/' . $data['employee_id']
                );
            }
        }
        $this->db->where(['employee_id' => $data['employee_id'], 'status' => 'pending', 'col_name' => $data['col_name']])->delete('employee_pending_fields');
        $this->template_mail->send_to_employee(
            sprintf('Request to change your \'%s\' is %s', $this->get_aliases($data['col_name']), $process == 'approve' ? 'approved' : 'declined'),
            $this->load->view('employee/email/change_request', [
                'employee_full_name' => $emp_rec->full_name,
                'field_name' => $this->get_aliases($data['col_name']),
                'action' => $process == 'approve' ? 'approved' : 'declined',
                'old_value' => $this->employees_model->field_value($data['col_name'], $old_data[$data['col_name']]),
                'new_value' => $this->employees_model->field_value($data['col_name'], $new_data[$data['col_name']]),
                'requestor' => $is_self_request ? 'Self' : $requestor_rec->full_name,
                'employee_id' => $rec->employee_id,
                'url' => $emp_rec->url,
            ], true),
            $rec->employee_id,
            true,
            false,
            true
        );
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
            return true;
        }
        return false;
    }
}
