<?php
class Evaluation_ajax_model extends CI_Model
{
    private function query_pending($filter = [], $orWhere = [])
    {
        $this->db->from('evaluation_report')
            ->select(
                'evaluation_report.id as parent_id,
                evaluation_report.year,
                employee_history.hrm_id,
                CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name) as first_name,
                evaluation_report_instance.*')
            ->join('evaluation_report_instance', 'evaluation_report.id = evaluation_report_instance.ev_id', 'left')
            ->join('employee_history', 'evaluation_report_instance.employee_id = employee_history.employee_id', 'left');

            $this->db->where('evaluation_report_instance.status <>', 'completed');
        if (!$this->permission->method('evaluations_pending', 'update')->access()) {
            $this->db->group_start()
                ->or_where('evaluation_report_instance.employee_id', $this->session->userdata('employee_id'))
                ->or_where('evaluation_report_instance.dm_id', $this->session->userdata('employee_id'))
                ->or_where('evaluation_report_instance.idm_id', $this->session->userdata('employee_id'))
                ->group_end();
        }

        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }

        if($filter['num']) {
            $this->db->where('evaluation_report_instance.num', $filter['num']);
        }
        if($filter['period']) {
            $this->db->where('evaluation_report.year', $filter['period']);
        }
    }
    public function countAllRows_pending()
    {
        $this->query_pending();
        return $this->db->count_all_results();
    }
    public function countDatatable_pending($filter = [], $orWhere = [])
    {
        $this->query_pending($filter, $orWhere);
        return $this->db->count_all_results();
    }
    public function getDatatable_pending($post, $filter = [], $orWhere = [])
    {
        $this->query_pending($filter, $orWhere);
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get()->result_array();
    }
    private function query_approved($filter = [], $orWhere = [])
    {
        $this->db->from('evaluation_report')
            ->select(
                'evaluation_report.id as parent_id,
                evaluation_report.year,
                employee_history.hrm_id,
                CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name) as first_name,
                evaluation_report_instance.*')
            ->join('evaluation_report_instance', 'evaluation_report.id = evaluation_report_instance.ev_id', 'left')
            ->join('employee_history', 'evaluation_report_instance.employee_id = employee_history.employee_id', 'left')
            ->group_by('evaluation_report.id, evaluation_report_instance.employee_id');

        if (!$this->session->userdata('isAdmin')) {
            $this->db->group_start()
                ->or_where('evaluation_report_instance.employee_id', $this->session->userdata('employee_id'))
                ->or_where('evaluation_report_instance.dm_id', $this->session->userdata('employee_id'))
                ->or_where('evaluation_report_instance.idm_id', $this->session->userdata('employee_id'))
                ->group_end();
        }
        $this->db->where('evaluation_report_instance.status', 'completed');

        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        if($filter['period']) {
            $this->db->where('evaluation_report.year', $filter['period']);
        }
    }
    public function countAllRows_approved()
    {
        $this->query_approved();
        return $this->db->count_all_results();
    }
    public function countDatatable_approved($filter = [], $orWhere = [])
    {
        $this->query_approved($filter, $orWhere);
        return $this->db->count_all_results();
    }
    public function getDatatable_approved($post, $filter = [], $orWhere = [])
    {
        $this->query_approved($filter, $orWhere);
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get()->result_array();
    }
}
