<?php
class Eval_attendance_model extends CI_Model
{
    public function get($report)
    {
        $employee = $this->db->select('employee_id, hire_date, shift')->where('employee_id', $report->employee_id)->get('employee_history')->row();
        $attendance = $this->generate_attendance($employee, $report->start, $report->end);
        $days_range = date_range($report->start, $report->end, '+1 day', 'Y-m-d');

        $res = (($attendance['presents'] + $attendance['late_arrivals'] + $attendance['offs'] + $attendance['half_days'] + $attendance['unpaid_half_days']) / count($days_range)) * 100;

        return [
            'value' => $this->convert_percentage_to_scale($res),
            'percentage' => $res,
        ];
    }
    private function convert_percentage_to_scale($percentage)
    {
        if ($percentage >= 95) {
            return 5;
        } elseif ($percentage <= 94 && $percentage >= 90) {
            return 4;
        } elseif ($percentage <= 89 && $percentage >= 85) {
            return 3;
        } elseif ($percentage <= 84 && $percentage >= 80) {
            return 2;
        } elseif ($percentage <= 79 && $percentage >= 75) {
            return 1;
        }
        return 0;
    }
    private function generate_attendance($employee, $start, $end)
    {
        $this->load->model('payroll/payroll_model', 'payroll');
        $days_range = date_range($start, $end, '+1 day', 'Y-m-d');
        $weekends = $this->payroll->get_weekends();
        $holidays = $this->payroll->get_holidays($start, $end);
        $attendance = $this->payroll->get_attendance($employee->employee_id, $start, $end);
        $suspensions = $this->payroll->get_suspensions($employee->employee_id, $start, $end);
        $leaves = $this->payroll->get_leaves($employee->employee_id, $start, $end);
        $special_leaves = $this->payroll->get_special_leaves($employee->employee_id, $start, $end);

        $count_presents = 0;
        $count_paid_leaves = 0;
        $count_special_leaves = 0;
        $count_unpaid_leaves = 0;
        $count_suspensions = 0;
        $count_ncns = 0;
        $count_late = 0;
        $count_offs = 0;
        $count_half_days = 0;
        $count_unpaid_half_days = 0;

        $start_of_today = strtotime('00:00:00');
        foreach ($days_range as $day) {
            if (strtotime($day) < strtotime($employee->hire_date)) {
                continue;
            }

            $flag = null;
            if (isset($suspensions[$day])) {
                $flag = 'sus';
                $count_suspensions++;
            } elseif (isset($holidays[$day]) && in_array($employee->shift, $holidays[$day])) {
                $flag = 'off';
                $count_offs++;
            } elseif (in_array(date('l', strtotime($day)), $weekends[$employee->shift] ?? $weekends[0])) {
                $flag = 'off';
                $count_offs++;
            } elseif (isset($special_leaves[$day]) && $special_leaves[$day] == 'full_day') {
                $flag = 'pl';
                $count_special_leaves++;
            } elseif (isset($special_leaves[$day]) && $special_leaves[$day] == 'half_day') {
                if (isset($attendance[$day]) && (in_array('FD', $attendance[$day]) || in_array('OT', $attendance[$day]) || in_array('UH-D', $attendance[$day]))) {
                    $flag = 'h-d';
                    $count_half_days += 0.5;
                    $count_special_leaves += 0.5;
                } else {
                    $flag = 'hpl';
                    $count_unpaid_leaves += 0.5;
                    $count_unpaid_half_days += 0.5;
                }
            } elseif (isset($leaves[$day]) && $leaves[$day] == 'full_day') {
                $flag = 'pl';
                $count_paid_leaves++;
            } elseif (isset($leaves[$day]) && $leaves[$day] == 'half_day') {
                if (isset($attendance[$day]) && (in_array('FD', $attendance[$day]) || in_array('OT', $attendance[$day]) || in_array('UH-D', $attendance[$day]))) {
                    $flag = 'h-d';
                    $count_half_days += 0.5;
                    $count_paid_leaves += 0.5;
                } else {
                    $flag = 'hpl';
                    $count_unpaid_leaves += 0.5;
                    $count_unpaid_half_days += 0.5;
                }
            } elseif (isset($attendance[$day])) {
                if (in_array('FD', $attendance[$day]) || in_array('OT', $attendance[$day])) {
                    $count_presents++;
                    $flag = 'p';
                } elseif (in_array('UH-D', $attendance[$day])) {
                    $count_unpaid_leaves += 0.5;
                    $count_unpaid_half_days += 0.5;
                    $flag = 'uh-d';
                } elseif (in_array('A', $attendance[$day])) {
                    if (strtotime($day) >= $start_of_today) {
                        $flag = 'p';
                        $count_presents++;
                    } else {
                        $flag = 'a';
                        $count_ncns++;
                    }
                } elseif (in_array('P', $attendance[$day])) {
                    $count_presents++;
                    $flag = 'p';
                } elseif (in_array('LA', $attendance[$day])) {
                    $count_late++;
                    $flag = 'la';
                } else {
                    if (strtotime($day) >= $start_of_today) {
                        $flag = 'p';
                        $count_presents++;
                    } else {
                        $flag = 'a';
                        $count_ncns++;
                    }
                }
                if ($flag == 'p' && in_array('LA', $attendance[$day])) {
                    $count_presents--;
                    $count_late++;
                    $flag = 'la';
                }
            } else {
                if (strtotime($day) >= $start_of_today) {
                    $flag = 'p';
                    $count_presents++;
                } else {
                    $flag = 'a';
                    $count_ncns++;
                }
            }
        }
        return [
            'presents' => $count_presents,
            'paid_leaves' => $count_paid_leaves,
            'special_leaves' => $count_special_leaves,
            'offs' => $count_offs,
            'ncns' => $count_ncns,
            'suspensions' => $count_suspensions,
            'late_arrivals' => $count_late,
            'unpaid_leaves' => $count_unpaid_leaves,
            'half_days' => $count_half_days,
            'unpaid_half_days' => $count_unpaid_half_days,
        ];
    }
}
