<?php
class Employee_roles_model extends CI_Model
{
    private $table = 'evaluation_employee_roles';
    public function get($id = null, $select = '*')
    {
        $this->db->select($select)->from($this->table);
        if ($id) {
            return $this->db->where('id', $id)->get()->row();
        }
        return $this->db->get()->result();
    }
    public function save($data)
    {
        $id = null;
        $this->db->trans_start();
        if (empty($data['id'])) {
            $this->db->insert($this->table, $data);
            $id = $this->db->insert_id();
            $this->activity->log([
                'employee_roles_added',
                $data['label'],
                $id,
            ]);
        } else {
            $id = $data['id'];
            $this->db->where('id', $data['id'])->update($this->table, $data);
            $this->activity->log([
                'employee_roles_updated',
                $data['label'],
                $id,
            ]);
        }
        $this->db->trans_complete();
        if ($this->db->trans_status()) {
            return $id;
        }
        return false;
    }
    public function delete($id)
    {
        $rec = $this->get($id);
        if ($rec) {
            $this->db->trans_start();
            $this->db->where('id', $id)->delete($this->table);
            $this->db->where('role_id', $id)->delete('eval_rel_role_behaviors');
            $this->activity->log([
                'employee_roles_deleted',
                $rec->label,
                $id,
            ]);
            $this->db->trans_complete();
            return $this->db->trans_status();
        }
        return false;
    }
    public function countAllRows()
    {
        return $this->db->count_all($this->table);
    }
    public function countDatatable($orWhere = [])
    {
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        return $this->db->count_all_results($this->table);
    }
    public function getDatatable($orWhere = [])
    {
        $post = $this->input->post();

        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);

        return $this->db->get($this->table)->result_array();
    }
}
