<?php defined('BASEPATH') or exit('No direct script access allowed');
class Employee_ajax_model extends CI_Model
{
    private $_bool_cols = [
        'work_from_home',
        'transportation_required',
        'voluntary_termination',
        'is_super_visor'
    ];
    private $_date_cols = [
        'hire_date',
        'original_hire_date',
        'termination_date',
        'rehire_date',
        'dob'
    ];
    private $_alt_cols = [];
    public function get_bool_cols()
    {
        return $this->_bool_cols;
    }
    public function get_date_cols()
    {
        return $this->_date_cols;
    }
    public function get_alt_cols()
    {
        return $this->_alt_cols;
    }
    public function search_columns()
    {
        return [
            'business_email' => 'business_email',
            'campaign' => 'campaign',
            'department' => 'department',
            'division' => 'division',
            'duty_type' => 'duty_type',
            'full_name' => 'full_name',
            'hrm_id' => 'hrm_id',
            'position' =>'designation',
            'pseudo' => 'Pseudo',
            'status' => 'status',
        ];
    }
    public function view_columns()
    {
        $cols = [
            'hrm_id' => 'hrm_id',
            'status' => 'status',
            'picture' => 'picture',
            'first_name' => 'first_name',
            'last_name' => 'last_name',
            'phone' => 'phone',
            'email' => 'email',
            'state' => 'state',
            'city' => 'city',
            'employee_id' => 'attendance_machine_id',
            'present_address' => 'present_address',
            'division' => 'division',
            'department' => 'department',
            'position' =>'designation',
            'duty_type' => 'duty_type',
            'shift' => 'shift',
            'hire_date' => 'hire_date',
            'original_hire_date' => 'original_h_date',
            'termination_date' => 'separation_date',
            'termination_reason' => 'separation_reason',
            'voluntary_termination' => 'voluntary_resignation',
            'direct_manager_name' => 'super_visor_name',
            'indirect_manager_name' => 'indirect_supervisor_name',
            'dob' => 'dob',
            'gender' => 'gender',
            'marital_status' => 'marital_stats',
            'religion' => 'religion',
            'cnic' => 'cnic',
            'business_email' => 'business_email',
            'personal_phone' => 'home_phone',
            'emergency_contact' => 'emergency_contact',
            'cell_phone' => 'cell_phone',
            'campaign' => 'campaign',
            'primary_project' => 'primary_project',
            'pseudo' => 'pseudo',
            'work_from_home' => 'work_from_home',
            'transportation_required' => 'transportation_required'
        ];
        if($this->permission->method('employee_salary_permission', 'read')->access()) {
            $cols = array_merge($cols, [
                'current_salary' => 'gross_salary',
            ]);
        }
        return $cols;
    }
    private function query($employees = [])
    {
        $this->load->model('Employees_model');
        $subords = [];
        if ($this->session->userdata('supervisor') == 1) {
            $subords = array_column($this->Employees_model->get_subordinates(), 'employee_id');
        }
        $this->db->select('*');
        $this->db->from('employee_details p');

        if ($this->session->userdata('isAdmin') == 1 || $this->permission->method('manage_employee', 'read')->access()) {
            if($employees) {
                $this->db->where_in('employee_id', $employees);
            }
        }elseif ($this->session->userdata('supervisor') == 1) {
            if($employees) {
                $this->db->where_in('employee_id', $employees);
            } else {
                $this->db->where_in('employee_id', $subords);
            }
        } else {
            $this->db->where('employee_id', $this->session->userdata('employee_id'));
        }
        if(!$this->permission->method('show_inactive_employees', 'read')->access()) {
            $this->db->where('status', 'active');
        }
    }
    public function countAllRows()
    {
        if(!$this->permission->method('show_inactive_employees', 'read')->access()) {
            $this->db->where('status', 'active');
        }
        return $this->db->count_all_results('employee_history');
    }
    public function countDatatable($orWhere = [], $employees = [])
    {
        if(is_null($employees)) {
            return 0;
        }
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                if(strpos($value, '%') === false) {
                    $this->db->or_where($key, $value);
                } else {
                    $this->db->or_like($key, $value, 'right', false);
                }
            }
            $this->db->group_end();
        }
        $this->query($employees);
        return $this->db->count_all_results();
    }
    public function getDatatable($orWhere = [], $employees = [])
    {
        if(is_null($employees)) {
            return [];
        }
        $post = $this->input->post();

        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                if(strpos($value, '%') === false) {
                    $this->db->or_where($key, $value);
                } else {
                    $this->db->or_like($key, $value, 'right', false);
                }
            }
            $this->db->group_end();
        }
        $this->query($employees);
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        $query = $this->db->get()->result_array();
        return array_map(function($val){
            return decrypt_employee_data($val, ['personal_phone', 'emergency_contact']);
        }, $query);
    }
    public function search_encrypted($col_name, $value)
    {
        if($col_name == 'cnic') {
            $value = str_replace(['-'], '', $value);
        }
        $this->db->select("employee_id, {$col_name}");
        if($this->permission->method('manage_employee', 'read')->access()) {
        } elseif ($this->session->userdata('supervisor')) {
            $this->load->model('Employees_model');
            $subords = array_column($this->Employees_model->get_subordinates(), 'employee_id');
            $this->db->where_in('employee_id', $subords);
        } else {
            $this->db->where('employee_id', $this->session->userdata('employee_id'));
        }
        $employees = $this->db->get('employee_history')->result_array();
        $employees = array_map('decrypt_employee_data', $employees);
        $employees = array_filter($employees, function($employee) use($col_name, $value) {
            if(empty($employee)) {
                return false;
            }
            return stripos($employee[$col_name], $value) !== false;
        });
        return array_column($employees, 'employee_id');
    }
}
