<?php
class Domain_model extends CI_Model
{
    private $table = 'domain_requests';
    public function create_request($employee_id)
    {
        return $this->db->insert($this->table, [
            'employee_id' => $employee_id,
            'added_by' => $this->session->userdata('employee_id') ?? 0,
            'added_at' => date('Y-m-d H:i:s'),
        ]);
    }
    public function get($id)
    {
        return $this->db->where('id', $id)->get($this->table)->row();
    }
    public function process_request($data)
    {
        $rec = $this->get($data['id']);
        if (!$rec) {
            return false;
        }
        $this->db->trans_start();
        $this->load->model('employees_model');

        $emp_rec = decrypt_employee_data($this->db->select('hrm_id, full_name, domain_name, domain_password, division_id, division, department, position')->where('employee_id', $rec->employee_id)->get('employee_details')->row_array());

        $this->db->where('id', $data['id'])->update($this->table, [
            'status' => 'processed',
            'updated_by' => $this->session->userdata('employee_id'),
            'updated_at' => date('Y-m-d H:i:s'),
        ]);
        $this->db->where('employee_id', $rec->employee_id)->update('employee_history', encrypt_employee_data([
            'domain_name' => $data['domain_name'], 'domain_password' => $data['domain_password'],
        ]));
        $this->employees_model->log_employee_change(
            $rec->employee_id,
            ['domain_name' => $data['domain_name'], 'domain_password' => $data['domain_password']],
            ['domain_name' => $emp_rec['domain_name'], 'domain_password' => $emp_rec['domain_password']],
            [],
            'employee_update',
            'via ' . display('domain_requests')
        );
        $this->notify->department('hr')->send(
            sprintf('Domain request for %s (%s) has been processed.', $emp_rec['full_name'], $emp_rec['hrm_id']),
            'employee/employees/cv/' . $rec->employee_id
        );
        $this->template_mail->send_to_department(
            $emp_rec['division_id'],
            'hr',
            sprintf('Domain Info Generated: %s (%s)', $emp_rec['full_name'], $emp_rec['hrm_id']),
            $this->load->view('employee/email/it_domain_generate', ['employee' => $emp_rec], true),
            [],
            [],
            true
        );
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function countAllRows()
    {
        return $this->db->count_all($this->table);
    }
    private function query($orWhere = [])
    {
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db->select('request.*, emp.hrm_id, emp.full_name, emp.department, emp.division, CONCAT_WS(\' \', updater.first_name, updater.last_name) as updater_name')
            ->from($this->table . ' as request')
            ->join('employee_details as emp', 'request.employee_id = emp.employee_id', 'left')
            ->join('employee_history as updater', 'request.updated_by = updater.employee_id', 'left');
    }
    public function countDatatable($orWhere = [])
    {
        $this->query($orWhere);
        return $this->db->count_all_results();
    }
    public function getDatatable($orWhere = [])
    {
        $post = $this->input->post();

        $this->query($orWhere);
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get()->result_array();
    }
}
