<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Credentials_model extends CI_Model
{
    public function countAllRows()
    {
        return $this->db
        ->join('employee_history', 'employee_credentials.employee_id = employee_history.employee_id', 'left')
        ->where('employee_history.employee_id <>', null)
        ->count_all_results('employee_credentials');
    }
    public function countDatatable($orWhere = [])
    {
        $this->db->select(
            'employee_credentials.*, CONCAT_WS(\' \', employee_history.first_name, employee_history.middle_name, employee_history.last_name) as full_name, employee_history.hrm_id'
        )
            ->join('employee_history', 'employee_credentials.employee_id = employee_history.employee_id', 'left');
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db->where('employee_history.employee_id <>', null);
        return $this->db->count_all_results('employee_credentials');
    }
    public function getDatatable($post = [], $orWhere = null)
    {
        $this->db->select(
            'employee_credentials.*, CONCAT_WS(\' \', employee_history.first_name, employee_history.middle_name, employee_history.last_name) as full_name, employee_history.hrm_id'
        )
            ->join('employee_history', 'employee_credentials.employee_id = employee_history.employee_id', 'left');
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db->where('employee_history.employee_id <>', null);
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get('employee_credentials')
            ->result_array();
    }
}
