<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Form_options extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'options_model',
        ]);
    }
    function list() {
        $this->permission->method('employee_form_options', 'read')->redirect();
        $data['types'] = $this->options_model->get_types();

        $data['title'] = display('employee_form_options');
        $data['module'] = 'employee';
        $data['page'] = 'options';
        echo Modules::run('template/layout', $data);
    }
    public function get()
    {
        $this->permission->method('employee_form_options', 'read')->redirect();
        if ($this->input->post('id')) {
            $rec = $this->options_model->get($this->input->post('id'));
            if ($rec) {
                sendJson(['success' => $rec]);
            }
        }
        sendJson(['error' => 'Item not found']);
    }
    public function save()
    {
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'value',
                    'label' => 'Value',
                    'rules' => 'trim|required',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                sendJson(['error' => 'Value is required']);
            }
            if($this->options_model->exists($this->input->post('type'), $this->input->post('value'), $this->input->post('id'))) {
                sendJson(['error' => sprintf('%s already exists in %s dropdown', $this->input->post('value'), slug_to_readable($this->input->post('type')))]);
            }
            if (!$this->input->post('id')) {
                if(!$this->permission->method('employee_form_options', 'create')->access()) {
                    sendJson(['error' => 'You don\' have permission to perform this action']);
                }
                if ($this->options_model->add($this->input->post('type'), $this->input->post('value'))) {
                    sendJson(['success' => 'Option saved successfully']);
                }
            } else {
                if(!$this->permission->method('employee_form_options', 'update')->access()) {
                    sendJson(['error' => 'You don\' have permission to perform this action']);
                }
                if ($this->options_model->update($this->input->post('id'), $this->input->post('type'), $this->input->post('value'))) {
                    sendJson(['success' => 'Option saved successfully']);
                }
            }
            sendJson(['error' => 'Unable to save option, try again later']);
        }
        sendJson(['error' => 'Invalid request'], 400);
    }
    public function delete()
    {
        $this->permission->method('employee_form_options', 'delete')->redirect();
        if ($this->input->post('id')) {
            $employees = $this->options_model->check_employees($this->input->post('id'));
            if($employees) {
                sendJson(['used' => $employees]);
            }
            if ($this->options_model->delete($this->input->post('id'))) {
                sendJson(['success' => 'Option deleted successfully']);
            }
            sendJson(['error' => 'Unable to delete option, try again later']);
        }
        sendJson(['error' => 'Invalid request'], 400);
    }
    public function table($type = null)
    {
        if (!$type) {
            return show_404();
        }
        $search_arr = [];
        $search_columns = [
            'type',
            'value',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->options_model->countAllRows($type);
        $out_arr["recordsFiltered"] = $this->options_model->countDatatable($type, $search_arr);
        $rows = $this->options_model->getDatatable($type, $search_arr);

        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'action':{
                            $tdData = '';
                            if ($this->permission->method('employee_form_options', 'update')->access()) {
                                $tdData .= '<a href="#" class="btn btn-xs btn-success btn-edit" data-id="' . $rec['id'] . '"><i class="fa fa-pencil"></i></a>';
                            }
                            if ($this->permission->method('employee_form_options', 'delete')->access()) {
                                $tdData .= '<a href="#" data-id="' . $rec['id'] . '" class="btn btn-xs btn-danger btn-delete"><i class="fa fa-trash"></i></a>';
                            }
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
}
