<?php
class Evaluation_objectives extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'objectives_model',
        ]);
    }
    public function add()
    {
        $this->permission->method('evaluation_objectives', 'create')->redirect();
        if ($this->input->post()) {
            $this->__save();
        }
        $data['title'] = display('add') . ' ' . display('evaluation_objectives');
        $data['departments'] = $this->objectives_model->get_departments();
        $data['positions'] = $this->objectives_model->get_positions();
        $data['scale'] = $this->objectives_model->get_rating_scale();
        $data['module'] = "employee";
        $data['page'] = "evaluation/objective_add";
        echo Modules::run('template/layout', $data);
    }
    public function edit($id)
    {
        $this->permission->method('evaluation_objectives', 'update')->redirect();
        if ($this->input->post()) {
            $this->__save($id);
        }
        $data['objective'] = $this->objectives_model->get($id);
        if (!$data['objective']) {
            show_404();
        }
        $data['title'] = display('update') . ' ' . display('evaluation_objectives') . ' - ' . $data['objective']->label;
        $data['id'] = $id;
        $data['departments'] = $this->objectives_model->get_departments();
        $data['positions'] = $this->objectives_model->get_positions();
        $data['scale'] = $this->objectives_model->get_rating_scale();
        $data['_after_submit'] = count($_POST) > 0;
        $data['module'] = "employee";
        $data['page'] = "evaluation/objective_update";
        echo Modules::run('template/layout', $data);
    }
    private function __save($id = null)
    {
        $rules_config = array(
            array(
                'field' => 'label',
                'label' => display('title'),
                'rules' => 'trim|required|alpha_numeric_spaces|max_length[45]',
            ),
            array(
                'field' => 'weightage',
                'label' => display('Weightage'),
                'rules' => 'trim|required|is_natural|greater_than_equal_to[1]|less_than_equal_to[100]',
            ),
            array(
                'field' => 'description',
                'label' => display(['Aligns', 'To']),
                'rules' => 'trim|required',
            ),
            array(
                'field' => 'metrics',
                'label' => display(['Metrics', '&', 'Milestones']),
                'rules' => 'trim|required',
            ),
        );
        if ($this->input->post('all_departments') == 0) {
            $rules_config[] = array(
                'field' => 'departments[]',
                'label' => display('departments'),
                'rules' => 'required',
            );
        }
        if ($this->input->post('all_positions') == 0) {
            $rules_config[] = array(
                'field' => 'positions[]',
                'label' => display('positions'),
                'rules' => 'required',
            );
        }
        $this->form_validation->set_rules($rules_config);
        if ($this->form_validation->run() === false) {
            return;
        }
        if ($this->objectives_model->save($id, $this->input->post())) {
            $this->session->set_flashdata('success', sprintf(display('data_saved_successfully'), display('evaluation_objectives')));
            redirect('employee/evaluation/objectives');
        } else {
            $this->session->set_flashdata('exception', sprintf(display('data_try_again'), display('evaluation_objectives')));
            return;
        }
    }
}
