<?php
class Evaluation extends Loggedin_Controller
{
    public function __construct()
    {
        $disabled = true;
        if($disabled) {
            $this->session->userdata('exception', 'Evaluation module is disabled');
            redirect($_SERVER['HTTP_REFERER']);
        }
        parent::__construct();
        $this->load->model([
            'rating_scale_model',
            'employee_roles_model',
            'behaviors_model',
            'objectives_model',
            'evaluation_report_model',
            'evaluation_ajax_model',
            'evaluation_instance_model',
        ]);
    }
    public function pending($id = null)
    {
        if ($id) {
            $this->report($id);return;
        }
        if ($this->input->post()) {
            $search_arr = [];
            $search_columns = [
                'evaluation_report.year',
                'employee_history.hrm_id',
                'CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name)',
                'evaluation_report_instance.type',
                'evaluation_report_instance.status',
                'evaluation_report_instance.next_deadline',
            ];
            if (!empty(@$this->input->post('search')['value'])) {
                $searchVal = $this->input->post('search')['value'];
                if (preg_match('#^\d{2}\-\d{2}\-\d{4}$#', $searchVal)) {
                    $search_arr['evaluation_report_instance.next_deadline'] = sql_date($searchVal);
                } elseif (stripos($searchVal, 'awaiting employee') === 0) {
                    $search_arr['evaluation_report_instance.status'] = 'pending-employee';
                } elseif (stripos($searchVal, 'awaiting direct') === 0) {
                    $search_arr['evaluation_report_instance.status'] = 'pending-dm';
                } elseif (stripos($searchVal, 'awaiting indirect') === 0) {
                    $search_arr['evaluation_report_instance.status'] = 'pending-idm';
                } elseif (stripos($searchVal, 'awaiting hr') === 0) {
                    $search_arr['evaluation_report_instance.status'] = 'pending-hr';
                } else {
                    foreach ($search_columns as $value) {
                        $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
                    }
                }
            };
            $filter = [
                'num' => $this->input->post('num'),
                'period' => $this->input->post('period'),
            ];
            $out_arr['draw'] = $_POST['draw'];
            $out_arr['data'] = array();
            $out_arr["recordsTotal"] = $this->evaluation_ajax_model->countAllRows_pending();
            $out_arr["recordsFiltered"] = $this->evaluation_ajax_model->countDatatable_pending($filter, $search_arr);
            $rows = $this->evaluation_ajax_model->getDatatable_pending($this->input->post(), $filter, $search_arr);
            foreach ($rows as $index => $rec) {
                foreach ($_POST['columns'] as $col) {
                    $tdData = null;
                    switch ($col['data']) {
                        case 'status':{
                                $tdData = display($rec[$col['data']]);
                                break;
                            }
                        case 'next_deadline':{
                                if ($rec[$col['data']]) {
                                    $tdData = formatted_date($rec[$col['data']]);
                                } else {
                                    $tdData = '';
                                }
                                break;
                            }
                        case 'action':{
                                $tdData = '<a href="' . base_url('employee/evaluation/pending/' . $rec['id']) . '" class="btn btn-primary"><i class="fa fa-eye"></i></a><br>';
                                if ($this->permission->method('evaluations_pending', 'update')->access()) {
                                    $tdData .= '<a href="#" data-id="' . $rec['parent_id'] . '" class="btn btn-danger btn-reload-data"><i class="fa fa-refresh"></i></a><br>';
                                    $tdData .= '<a href="#" data-id="' . $rec['id'] . '" class="btn btn-success btn-download"><i class="fa fa-download"></i></a><br>';
                                }
                                break;
                            }
                        default:{
                                $tdData = $rec[$col['data']];
                                break;
                            }
                    }
                    $out_arr['data'][$index][$col['data']] = $tdData;
                }
            }
            sendJson($out_arr);
        }
        $data['title'] = display('evaluations_pending');
        $data['scoring_blocks'] = $this->evaluation_report_model::__WORDING[$this->evaluation_report_model::_SELECTED_TYPE];
        $min_year = $this->db->select_min('year')->get('evaluation_report')->row();
        if (!$min_year) {
            $min_year = date('Y');
        } else {
            $min_year = $min_year->year;
        }
        $data['selection_years'] = range(date('Y'), $min_year);
        $data['module'] = "employee";
        $data['page'] = "evaluation/evaluations_pending";
        echo Modules::run('template/layout', $data);
    }
    public function approved($id = null)
    {
        if ($id) {
            $this->report($id, 'approved');return;
        }
        if ($this->input->post()) {
            $search_arr = [];
            $search_columns = [
                'evaluation_report.year',
                'employee_history.hrm_id',
                'CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name)',
            ];
            if (!empty(@$this->input->post('search')['value'])) {
                $searchVal = $this->input->post('search')['value'];
                foreach ($search_columns as $value) {
                    $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
                }
            };
            $filter = [
                'period' => $this->input->post('period'),
            ];
            $out_arr['draw'] = $_POST['draw'];
            $out_arr['data'] = array();
            $out_arr["recordsTotal"] = $this->evaluation_ajax_model->countAllRows_approved();
            $out_arr["recordsFiltered"] = $this->evaluation_ajax_model->countDatatable_approved($filter, $search_arr);
            $rows = $this->evaluation_ajax_model->getDatatable_approved($filter, $this->input->post(), $search_arr);
            foreach ($rows as $index => $rec) {
                foreach ($_POST['columns'] as $col) {
                    $tdData = null;
                    switch ($col['data']) {
                        case 'action':{
                                $tdData = '<a href="' . base_url('employee/evaluation/approved/' . $rec['id']) . '" class="btn btn-primary"><i class="fa fa-eye"></i></a><br>';
                                if ($this->permission->method('evaluations_pending', 'update')->access()) {
                                    $tdData .= '<a href="#" data-id="' . $rec['id'] . '" class="btn btn-success btn-download"><i class="fa fa-download"></i></a><br>';
                                }
                                break;
                            }
                        default:{
                                $tdData = $rec[$col['data']];
                                break;
                            }
                    }
                    $out_arr['data'][$index][$col['data']] = $tdData;
                }
            }
            sendJson($out_arr);
        }
        $data['title'] = display('evaluations_approved');
        $min_year = $this->db->select_min('year')->get('evaluation_report')->row();
        if (!$min_year) {
            $min_year = date('Y');
        } else {
            $min_year = $min_year->year;
        }
        $data['selection_years'] = range(date('Y'), $min_year);
        $data['module'] = "employee";
        $data['page'] = "evaluation/evaluations_approved";
        echo Modules::run('template/layout', $data);
    }
    public function refresh($id)
    {
        if (!$this->permission->method('evaluations_pending', 'update')->access()) {
            sendJson(['error' => display(['You', 'are', 'not', 'allowed', 'to', 'perform', 'this', 'action'], true)]);
        }
        $report = $this->evaluation_instance_model->get_report($id);
        if (!$report) {
            sendJson(['error' => display(['Report', "doesn't", 'exist'], true)]);
        }
        $this->db->trans_start();
        $this->evaluation_report_model->refresh_report($id);
        $this->activity->log([
            'evaluation_year_data_re_fetched',
            $report->year,
        ]);
        $this->db->trans_complete();
        if ($this->db->trans_status()) {
            sendJson(['success' => display(['Report', 'data', 'is', 'refreshed', 'successfully'], true)]);
        }
        sendJson(['error' => display(['Unable', 'to', 'fetch', 'report', 'data,', 'try', 'again', 'later'], true)]);
    }
    private function report($id, $status = 'pending')
    {
        $this->load->model('evaluation_instance_model');
        if ($this->input->post()) {
            if (!$this->evaluation_instance_model->verify_update($id)) {
                sendJson(['error' => display(['Invalid', 'request'])]);
            }
            if ($this->evaluation_instance_model->save_report($id, $this->input->post())) {
                $msg = display(['Evaluation', 'report', 'submitted', 'successfully'], true);
                $this->session->set_flashdata('success', $msg);
                sendJson(['success' => $msg]);
            } else {
                $msg = display(['Unable', 'to', 'save', 'evaluation', 'report', '.', 'Try', 'again'], true);
                $this->session->set_flashdata('success', $msg);
                sendJson(['error' => $msg]);
            };return;
        }
        if (!$this->evaluation_instance_model->verify($id)) {
            $this->session->set_flashdata('exception', display(['You', 'are', 'not', 'authorized', 'to', 'view', 'this', 'file'], true));
            redirect($_SERVER['HTTP_REFERER']);return;
        }
        $data['title'] = display(['Evaluation', 'Report']);
        $data['report'] = $this->evaluation_instance_model->get_report($id);
        if (!$data['report']) {
            $this->session->set_flashdata('exception', display(['This', 'report', "doesn't", 'exist'], true));
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['approved_report'] = $data['report']->status == 'completed';
        $data['max_score'] = $this->rating_scale_model->max();
        $data['rating'] = $this->evaluation_instance_model->get_rating_scale($data['report']->parent_id);
        $data['roles'] = $this->evaluation_instance_model->get_roles($data['report']->parent_id);
        $data['employee'] = $this->evaluation_instance_model->get_employee($data['report']->parent_id, $data['report']->employee_id);
        $data['behaviors'] = $this->evaluation_instance_model->get_behaviors($data['report']->parent_id, $data['employee']->dept_id, $data['employee']->pos_id);
        $data['objectives'] = $this->evaluation_instance_model->get_objectives($data['report']->parent_id, $data['report'], $data['employee']->dept_id, $data['employee']->pos_id);
        $data['scoring_blocks'] = $this->evaluation_report_model::__WORDING[$this->evaluation_report_model::_SELECTED_TYPE];
        $data['subreports'] = $this->evaluation_instance_model->get_sub_reports($data['report']->parent_id, $data['report']->employee_id, $status == 'approved');
        $data['promotion_letter'] = $this->options->get_system('evaluation.promotion_letter');
        $data['promotion_letter_with_appraisal'] = $this->options->get_system('evaluation.promotion_letter_with_appraisal');
        $data['results'] = [];
        $data['remarks'] = [];
        foreach ($data['subreports'] as $sub_report) {
            $data['results'][$sub_report->num]['objective'] = $this->evaluation_instance_model->get_objective_results($sub_report->id);
            $data['results'][$sub_report->num]['behavior'] = $this->evaluation_instance_model->get_behavior_results($sub_report->id);

            $data['remarks'][$sub_report->num]['objective'] = $this->evaluation_instance_model->get_objective_remarks($sub_report->id);
            $data['remarks'][$sub_report->num]['behavior'] = $this->evaluation_instance_model->get_behavior_remarks($sub_report->id);

            $data['field_data'][$sub_report->num] = $this->evaluation_instance_model->get_fields_data($sub_report->id);
        }
        $data['module'] = "employee";
        $data['page'] = "evaluation/evaluations_report";
        echo Modules::run('template/layout', $data);
    }
    public function save_val_db_data($id)
    {
        $this->permission->method('evaluations_pending', 'update')->redirect();
        if ($this->evaluation_instance_model->save_val_data($id, $this->input->post())) {
            sendJson(['success' => display(['Val', 'DB', 'data', 'saved', 'successfully'], true)]);
        } else {
            sendJson(['error' => display(['Unable', 'to', 'save', 'data.', 'try', 'again'], true)]);
        }
    }
    public function export($id)
    {
        $this->load->model('evaluation_instance_model');
        $data = [];
        if ($this->input->post()) {
            $files = json_decode(base64_decode($this->input->post('files')), true);

            foreach ($files as $key => $file) {
                $data[str_replace('-', '_', $key) . '_image'] = $file;
            }
        }
        if (!$this->evaluation_instance_model->verify($id)) {
            $this->session->set_flashdata('exception', display(['You', 'are', 'not', 'authorized', 'to', 'view', 'this', 'file'], true));
            redirect($_SERVER['HTTP_REFERER']);return;
        }
        $data['title'] = display(['Evaluation', 'Report']);
        $data['report'] = $this->evaluation_instance_model->get_report($id);
        if (!$data['report']) {
            $this->session->set_flashdata('exception', display(['This', 'report', "doesn't", 'exist'], true));
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['direct_manager'] = $this->db->select('hrm_id, full_name')->where('employee_id', $data['report']->dm_id)->get('employee_details')->row();
        if (!$data['direct_manager']) {
            $data['direct_manager'] = $this->db
                ->select('manager.hrm_id, manager.full_name')
                ->where('employee_details.employee_id', $data['report']->employee_id)
                ->join('employee_details manager', 'employee_details.super_visor_id=manager.employee_id', 'left')
                ->get('employee_details')
                ->row();
        }
        $data['approved_report'] = $data['report']->status == 'completed';
        $data['max_score'] = $this->rating_scale_model->max();
        $data['rating'] = $this->evaluation_instance_model->get_rating_scale($data['report']->parent_id);
        $data['roles'] = $this->evaluation_instance_model->get_roles($data['report']->parent_id);
        $data['employee'] = $this->evaluation_instance_model->get_employee($data['report']->parent_id, $data['report']->employee_id);
        $data['behaviors'] = $this->evaluation_instance_model->get_behaviors($data['report']->parent_id, $data['employee']->dept_id, $data['employee']->pos_id);
        $data['objectives'] = $this->evaluation_instance_model->get_objectives($data['report']->parent_id, $data['report'], $data['employee']->dept_id, $data['employee']->pos_id);
        $data['scoring_blocks'] = $this->evaluation_report_model::__WORDING[$this->evaluation_report_model::_SELECTED_TYPE];
        $data['subreports'] = $this->evaluation_instance_model->get_sub_reports($data['report']->parent_id, $data['report']->employee_id, $data['report']->status == 'completed');
        $data['bg_image'] = @$this->db->select('value')->where('name', 'manager_image_' . $data['employee']->division_id)->get('tcpdf_settings')->row_array()['value'];
        $this->load->model('incident/letter_model');
        $data['bg_image'] = base_url(str_replace('\\', '/', $this->letter_model->get_image_path()) . '/' . $data['bg_image']);
        $data['results'] = [];
        $data['remarks'] = [];
        foreach ($data['subreports'] as $sub_report) {
            $data['results'][$sub_report->num]['objective'] = $this->evaluation_instance_model->get_objective_results($sub_report->id);
            $data['results'][$sub_report->num]['behavior'] = $this->evaluation_instance_model->get_behavior_results($sub_report->id);
            $data['remarks'][$sub_report->num]['objective'] = $this->evaluation_instance_model->get_objective_remarks($sub_report->id);
            $data['remarks'][$sub_report->num]['behavior'] = $this->evaluation_instance_model->get_behavior_remarks($sub_report->id);
        }

        if (!$this->input->post()) {
            $this->load->view('employee/evaluation/export/report_template', $data);
        } else {
            $this->load->library('pdfgenerator');
            $html = $this->load->view('employee/evaluation/export/report_export', $data, true);
            $this->pdfgenerator->mpdf($html, sprintf('%s %s %s.pdf', display(['Evaluation', 'Report']), $data['employee']->full_name, $data['employee']->hrm_id), 'D', [
                'margin_top' => 30,
            ]);
        }
    }
    public function rating_scale()
    {
        $this->permission->method('eval_rating_scale', 'read')->redirect();
        if ($this->input->post()) {
            $search_arr = [];
            $search_columns = [
                'score',
                'label',
                'description',
            ];
            if (!empty(@$this->input->post('search')['value'])) {
                $searchVal = $this->input->post('search')['value'];
                foreach ($search_columns as $value) {
                    $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
                }
            };
            $out_arr['draw'] = $_POST['draw'];
            $out_arr['data'] = array();
            $out_arr["recordsTotal"] = $this->rating_scale_model->countAllRows();
            $out_arr["recordsFiltered"] = $this->rating_scale_model->countDatatable($search_arr);
            $rows = $this->rating_scale_model->getDatatable($search_arr);

            foreach ($rows as $index => $rec) {
                foreach ($_POST['columns'] as $col) {
                    $tdData = null;
                    switch ($col['data']) {
                        case 'action':{
                                $tdData = '';
                                if ($this->permission->method('eval_rating_scale', 'update')->access()) {
                                    $tdData .= '<a href="#" class="btn btn-xs btn-success btn-edit" data-id="' . $rec['id'] . '"><i class="fa fa-pencil"></i></a>';
                                }
                                if ($this->permission->method('eval_rating_scale', 'delete')->access()) {
                                    $tdData .= '<a href="#" data-id="' . $rec['id'] . '" class="btn btn-xs btn-danger btn-delete"><i class="fa fa-trash"></i></a>';
                                }
                                break;
                            }
                        default:{
                                $tdData = $rec[$col['data']];
                                break;
                            }
                    }
                    $out_arr['data'][$index][$col['data']] = $tdData;
                }
            }
            sendJson($out_arr);
        }
        $data['title'] = display('eval_rating_scale');
        $data['module'] = "employee";
        $data['page'] = "evaluation/rating_scale";
        echo Modules::run('template/layout', $data);
    }
    public function rating_scale_rest($id = null)
    {
        switch ($this->input->method()) {
            case 'get':{
                    $this->permission->method('eval_rating_scale', 'read')->redirect();
                    if (!$id) {
                        return sendJson(['error' => display('invalid_request')]);
                    }
                    $res = $this->rating_scale_model->get($id);
                    if ($res) {
                        sendJson(['success' => $res]);
                    } else {
                        sendJson(['error' => display('invalid_request')]);
                    }
                    break;
                }
            case 'delete':{
                    $this->permission->method('eval_rating_scale', 'delete')->redirect();
                    if (!$id) {
                        return sendJson(['error' => display('invalid_request')]);
                    }
                    if ($this->rating_scale_model->delete($id)) {
                        sendJson(['success' => sprintf(display('data_deleted_successfully'), display('eval_rating_scale'))]);
                    } else {
                        sendJson(['error' => display('invalid_request')]);
                    }
                    break;
                }
            case 'post':{
                    $this->permission->method('eval_rating_scale', 'update')->redirect();
                    $rules_config = array(
                        array(
                            'field' => 'score',
                            'label' => 'Score',
                            'rules' => 'trim|required|is_natural',
                        ),
                        array(
                            'field' => 'label',
                            'label' => 'Title',
                            'rules' => 'trim|required|alpha_numeric_spaces|max_length[30]',
                        ),
                    );
                    $this->form_validation->set_rules($rules_config);
                    if ($this->form_validation->run() === false) {
                        $errors = [];
                        $fields = array_column($rules_config, 'field');
                        foreach ($fields as $field) {
                            $has_error = form_error($field);
                            if ($has_error) {
                                $errors[] = [$field, $has_error];
                            }
                        }
                        sendJson(['errors' => $errors]);
                    }
                    if ($this->rating_scale_model->score_exists(intval($this->input->post('score')), intval($this->input->post('id')))) {
                        $this->lang->load('form_validation');
                        sendJson(['errors' => [['score', str_replace('{field}', display('score'), $this->lang->line('form_validation_is_unique'))]]]);
                    }
                    if ($this->rating_scale_model->label_exists($this->input->post('label'), intval($this->input->post('id')))) {
                        $this->lang->load('form_validation');
                        sendJson(['errors' => [['label', str_replace('{field}', display('title'), $this->lang->line('form_validation_is_unique'))]]]);
                    }
                    if ($this->rating_scale_model->save($this->input->post())) {
                        sendJson(['success' => sprintf(display('data_saved_successfully'), display('eval_rating_scale'))]);
                    } else {
                        sendJson(['error' => sprintf(display('data_try_again'), display('eval_rating_scale'))]);
                    }
                    break;
                }
        }
    }
    public function employee_roles()
    {
        $this->permission->method('eval_employee_roles', 'read')->redirect();
        if ($this->input->post()) {
            $search_arr = [];
            $search_columns = [
                'label',
                'description',
            ];
            if (!empty(@$this->input->post('search')['value'])) {
                $searchVal = $this->input->post('search')['value'];
                foreach ($search_columns as $value) {
                    $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
                }
            };
            $out_arr['draw'] = $_POST['draw'];
            $out_arr['data'] = array();
            $out_arr["recordsTotal"] = $this->employee_roles_model->countAllRows();
            $out_arr["recordsFiltered"] = $this->employee_roles_model->countDatatable($search_arr);
            $rows = $this->employee_roles_model->getDatatable($search_arr);

            foreach ($rows as $index => $rec) {
                foreach ($_POST['columns'] as $col) {
                    $tdData = null;
                    switch ($col['data']) {
                        case 'action':{
                                $tdData = '';
                                if ($this->permission->method('eval_employee_roles', 'update')->access()) {
                                    $tdData .= '<a href="#" class="btn btn-xs btn-success btn-edit" data-id="' . $rec['id'] . '"><i class="fa fa-pencil"></i></a>';
                                }
                                if ($this->permission->method('eval_employee_roles', 'delete')->access()) {
                                    $tdData .= '<a href="#" data-id="' . $rec['id'] . '" class="btn btn-xs btn-danger btn-delete"><i class="fa fa-trash"></i></a>';
                                }
                                break;
                            }
                        default:{
                                $tdData = $rec[$col['data']];
                                break;
                            }
                    }
                    $out_arr['data'][$index][$col['data']] = $tdData;
                }
            }
            sendJson($out_arr);
        }
        $data['title'] = display('eval_employee_roles');
        $data['module'] = "employee";
        $data['page'] = "evaluation/employee_roles";
        echo Modules::run('template/layout', $data);
    }
    public function employee_roles_rest($id = null)
    {
        switch ($this->input->method()) {
            case 'get':{
                    $this->permission->method('eval_employee_roles', 'read')->redirect();
                    if (!$id) {
                        return sendJson(['error' => display('invalid_request')]);
                    }
                    $res = $this->employee_roles_model->get($id);
                    if ($res) {
                        sendJson(['success' => $res]);
                    } else {
                        sendJson(['error' => display('invalid_request')]);
                    }
                    break;
                }
            case 'delete':{
                    $this->permission->method('eval_employee_roles', 'delete')->redirect();
                    if (!$id) {
                        return sendJson(['error' => display('invalid_request')]);
                    }
                    if ($this->employee_roles_model->delete($id)) {
                        sendJson(['success' => sprintf(display('data_deleted_successfully'), display('eval_employee_roles'))]);
                    } else {
                        sendJson(['error' => display('invalid_request')]);
                    }
                    break;
                }
            case 'post':{
                    $this->permission->method('eval_employee_roles', 'update')->redirect();
                    $rules_config = array(
                        array(
                            'field' => 'label',
                            'label' => 'Title',
                            'rules' => 'trim|required|alpha_numeric_spaces|max_length[45]',
                        ),
                    );
                    $this->form_validation->set_rules($rules_config);
                    if ($this->form_validation->run() === false) {
                        $errors = [];
                        $fields = array_column($rules_config, 'field');
                        foreach ($fields as $field) {
                            $has_error = form_error($field);
                            if ($has_error) {
                                $errors[] = [$field, $has_error];
                            }
                        }
                        sendJson(['errors' => $errors]);
                    }
                    if ($this->employee_roles_model->save($this->input->post())) {
                        sendJson(['success' => sprintf(display('data_saved_successfully'), display('eval_employee_roles'))]);
                    } else {
                        sendJson(['error' => sprintf(display('data_try_again'), display('eval_employee_roles'))]);
                    }
                    break;
                }
        }
    }
    public function behaviors()
    {
        $this->permission->method('evaluation_behaviors', 'read')->redirect();
        if ($this->input->post()) {
            $search_arr = [];
            $search_columns = [
                'label',
                'description',
            ];
            if (!empty(@$this->input->post('search')['value'])) {
                $searchVal = $this->input->post('search')['value'];
                foreach ($search_columns as $value) {
                    $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
                }
            };
            $out_arr['draw'] = $_POST['draw'];
            $out_arr['data'] = array();
            $out_arr["recordsTotal"] = $this->behaviors_model->countAllRows();
            $out_arr["recordsFiltered"] = $this->behaviors_model->countDatatable($search_arr);
            $rows = $this->behaviors_model->getDatatable($search_arr);

            foreach ($rows as $index => $rec) {
                foreach ($_POST['columns'] as $col) {
                    $tdData = null;
                    switch ($col['data']) {
                        case 'action':{
                                $tdData = '';
                                if ($this->permission->method('evaluation_behaviors', 'update')->access()) {
                                    $tdData .= '<a href="' . base_url('employee/evaluation_behaviors/edit/' . $rec['id']) . '" class="btn btn-xs btn-success btn-edit"><i class="fa fa-pencil"></i></a>';
                                }
                                if ($this->permission->method('evaluation_behaviors', 'delete')->access()) {
                                    $tdData .= '<a href="#" data-id="' . $rec['id'] . '" class="btn btn-xs btn-danger btn-delete"><i class="fa fa-trash"></i></a>';
                                }
                                break;
                            }
                        default:{
                                $tdData = $rec[$col['data']];
                                break;
                            }
                    }
                    $out_arr['data'][$index][$col['data']] = $tdData;
                }
            }
            sendJson($out_arr);
        }
        $data['title'] = display('evaluation_behaviors');
        $data['module'] = "employee";
        $data['page'] = "evaluation/behaviors";
        echo Modules::run('template/layout', $data);
    }
    public function behaviors_rest($id = null)
    {
        switch ($this->input->method()) {
            case 'delete':{
                    $this->permission->method('evaluation_behaviors', 'delete')->redirect();
                    if (!$id) {
                        return sendJson(['error' => display('invalid_request')]);
                    }
                    if ($this->behaviors_model->delete($id)) {
                        sendJson(['success' => sprintf(display('data_deleted_successfully'), display('evaluation_behaviors'))]);
                    } else {
                        sendJson(['error' => display('invalid_request')]);
                    }
                    break;
                }
        }
    }
    public function objectives()
    {
        $this->permission->method('evaluation_objectives', 'read')->redirect();
        if ($this->input->post()) {
            $search_arr = [];
            $search_columns = [
                'label',
                'description',
                'weightage',
            ];
            if (!empty(@$this->input->post('search')['value'])) {
                $searchVal = $this->input->post('search')['value'];
                foreach ($search_columns as $value) {
                    $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
                }
            };
            $out_arr['draw'] = $_POST['draw'];
            $out_arr['data'] = array();
            $out_arr["recordsTotal"] = $this->objectives_model->countAllRows();
            $out_arr["recordsFiltered"] = $this->objectives_model->countDatatable($search_arr);
            $rows = $this->objectives_model->getDatatable($search_arr);

            foreach ($rows as $index => $rec) {
                foreach ($_POST['columns'] as $col) {
                    $tdData = null;
                    switch ($col['data']) {
                        case 'action':{
                                $tdData = '';
                                if ($this->permission->method('evaluation_objectives', 'update')->access()) {
                                    $tdData .= '<a href="' . base_url('employee/evaluation_objectives/edit/' . $rec['id']) . '" class="btn btn-xs btn-success btn-edit"><i class="fa fa-pencil"></i></a>';
                                }
                                if (!$rec['data_model'] && $this->permission->method('evaluation_objectives', 'delete')->access()) {
                                    $tdData .= '<a href="#" data-id="' . $rec['id'] . '" class="btn btn-xs btn-danger btn-delete"><i class="fa fa-trash"></i></a>';
                                }
                                break;
                            }
                        default:{
                                $tdData = $rec[$col['data']];
                                break;
                            }
                    }
                    $out_arr['data'][$index][$col['data']] = $tdData;
                }
            }
            sendJson($out_arr);
        }
        $data['title'] = display('evaluation_objectives');
        $data['module'] = "employee";
        $data['page'] = "evaluation/objectives";
        echo Modules::run('template/layout', $data);
    }
    public function objectives_rest($id = null)
    {
        switch ($this->input->method()) {
            case 'delete':{
                    $this->permission->method('evaluation_objectives', 'delete')->redirect();
                    if (!$id) {
                        return sendJson(['error' => display('invalid_request')]);
                    }
                    if ($this->objectives_model->delete($id)) {
                        sendJson(['success' => sprintf(display('data_deleted_successfully'), display('evaluation_objectives'))]);
                    } else {
                        sendJson(['error' => display('invalid_request')]);
                    }
                    break;
                }
        }
    }
    public function generate()
    {
        $this->permission->method('evaluations_generate', 'create')->redirect();
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'employee_id',
                    'label' => display('employee'),
                    'rules' => 'required|is_natural',
                ),
                array(
                    'field' => 'year',
                    'label' => display('year'),
                    'rules' => 'required|is_natural',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                redirect($_SERVER['HTTP_REFERER']);
            }
            $this->evaluation_report_model->generate(
                $this->input->post('employee_id'),
                $this->input->post('year'),
            );
            $this->activity->set_employee($this->input->post('employee_id'))->log([
                'evaluation_report_generated',
                $this->input->post('year')
            ]);
            $this->session->set_flashdata('success', display(['report', 'added', 'successfully']));
            if($this->input->post('action') == 'list') {
                redirect('employee/evaluation/pending');
            }
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = display('evaluations_generate');
        $this->load->model('employees_model');
        $data['employees'] = $this->employees_model->get_employees($this->permission->method('evaluations_pending', 'update')->access());
        $data['module'] = "employee";
        $data['page'] = "evaluation/generate";
        echo Modules::run('template/layout', $data);
    }
    public function _generate()
    {
        if (!$this->session->userdata('isAdmin')) {
            show_404();
        }
        $queries = [
            'TRUNCATE TABLE evaluation_report;',
            'TRUNCATE TABLE report_behaviors;',
            'TRUNCATE TABLE report_employee_roles;',
            'TRUNCATE TABLE report_rating_scale;',
            'TRUNCATE TABLE report_rel_dept_behaviors;',
            'TRUNCATE TABLE report_rel_pos_behaviors;',
            'TRUNCATE TABLE report_rel_role_behaviors;',
            'TRUNCATE TABLE report_employee;',
            'TRUNCATE TABLE evaluation_report_instance;',
            'TRUNCATE TABLE report_objectives;',
            'TRUNCATE TABLE report_rel_dept_objectives;',
            'TRUNCATE TABLE report_rel_pos_objectives;',
            'TRUNCATE TABLE report_rel_rating_objectives;',
            'TRUNCATE TABLE report_results;',
            'TRUNCATE TABLE report_remarks;',
        ];
        if (isset($_GET['refresh'])) {
            foreach ($queries as $query) {
                if (!$this->db->query($query)) {
                    exit('Report generation failed');
                }
            }
        }
        if ($this->evaluation_report_model->auto_generate()) {
            echo 'Report generated';
        } else {
            echo 'Report generation failed';
        }
    }
    public function settings()
    {
        $this->permission->method('general_settings', 'update')->redirect();
        $this->load->model('incident/letter_model');
        if ($this->input->post()) {
            $this->db->trans_start();
            $this->options->set_system('evaluation.notifications.email', $this->input->post('email_notify'));
            $this->options->set_system('evaluation.promotion_letter', $this->input->post('promotion_letter'));
            $this->options->set_system('evaluation.promotion_letter_with_appraisal', $this->input->post('promotion_letter_with_appraisal'));
            $this->options->set_system('evaluation.test.mode', $this->input->post('testmode'));
            $this->db->trans_complete();
            if ($this->db->trans_status()) {
                $this->session->set_flashdata('success', display(['Evaluation', 'settings', 'saved', 'successfully'], true));
            } else {
                $this->session->set_flashdata('exception', display(['Unable', 'to', 'save', 'Evaluation', 'settings.', 'try', 'again'], true));
            }
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = display('general_settings');
        $data['letters'] = $this->letter_model->get_all_letters('id, title');
        $data['form'] = [
            'email_notify' => $this->options->get_system('evaluation.notifications.email'),
            'promotion_letter' => $this->options->get_system('evaluation.promotion_letter'),
            'promotion_letter_with_appraisal' => $this->options->get_system('evaluation.promotion_letter_with_appraisal'),
            'testmode' => $this->options->get_system('evaluation.test.mode'),
        ];
        $data['module'] = "employee";
        $data['page'] = "evaluation/general_settings";
        echo Modules::run('template/layout', $data);
    }
    public function get_employee_years()
    {
        $this->permission->method('evaluations_generate', 'create')->redirect();
        if ($this->input->post('id')) {
            $rec = $this->db->select('DATE_ADD(DATE_ADD(hire_date, INTERVAL probation_period MONTH), INTERVAL 1 YEAR) as year', false)
                ->where('employee_id', $this->input->post('id'))
                ->get('employee_history')
                ->row();
            $years = range($rec->year, $rec->year + 5);

            if (end($years) <= date('Y')) {
                $years = array_merge($years, range(date('Y'), date('Y') + 5));
            }
            $years = array_filter($years, function ($yr) {
                return $this->db
                    ->where(['evaluation_report.year' => $yr, 'evaluation_report.employee_id' => $this->input->post('id')])
                    ->join('evaluation_report', 'evaluation_report_instance.ev_id = evaluation_report.id', 'left')
                    ->count_all_results('evaluation_report_instance') < 2;
            });
            sendJson(['success' => array_values($years)]);
        }
    }
}
