<?php
class Domain_request extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('domain_model');
    }
    function list() {
        $this->permission->method('domain_requests', 'read')->redirect();
        if ($this->input->post()) {
            $this->getdatatable();return;
        }
        $data['title'] = display('domain_requests');
        $data['module'] = "employee";
        $data['page'] = "domain_requests";
        echo Modules::run('template/layout', $data);
    }
    public function process()
    {
        $this->permission->method('domain_requests', 'update')->redirect();
        if ($this->input->post('id')) {
            $rules_config = array(
                array(
                    'field' => 'domain_name',
                    'label' => display('domain_name'),
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'domain_password',
                    'label' => display('domain_password'),
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'conf_domain_password',
                    'label' => display('confirm') . ' ' . display('domain_password'),
                    'rules' => 'trim|required|matches[domain_password]',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                $fields = array_column($rules_config, 'field');
                $errors = [];
                foreach ($fields as $field) {
                    $err = form_error($field);
                    if ($err) {
                        $errors[] = [$field, $err];
                    }
                }
                sendJson(['errors' => $errors]);
            }
            if ($this->domain_model->process_request($this->input->post())) {
                sendJson(['success' => sprintf(display('data_saved_successfully'), display('domain_requests'))]);
            }
        }
        sendJson(['error' => display('invalid_request')]);
    }
    public function create($id)
    {
        if (!$this->permission->method('manage_employee', 'update')->access()) {
            sendJson(['error' => display('invalid_request')]);
        }
        $this->db->trans_start();
        $this->domain_model->create_request($id);
        $this->notify->department('it')->send(
            'A new domain request has been added. Click here to view it',
            'employee/domain_request/list'
        );
        $this->db->trans_complete();
        if ($this->db->trans_status()) {
            sendJson(['success' => 'Your request for domain generation is sent to IT department']);
        }
        sendJson(['error' => display('invalid_request')]);
    }
    private function getdatatable()
    {
        $search_arr = [];
        $search_columns = [
            'emp.hrm_id',
            'emp.full_name',
            'emp.department',
            'emp.division',
            'request.status',
            'CONCAT_WS(\' \', updater.first_name, updater.last_name)',
            'DATE_FORMAT(request.added_at, \'%d-%m-%Y %r\')',
            'DATE_FORMAT(request.updated_at, \'%d-%m-%Y %r\')',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->domain_model->countAllRows();
        $out_arr["recordsFiltered"] = $this->domain_model->countDatatable($search_arr);
        $rows = $this->domain_model->getDatatable($search_arr);
        $status_classes = [
            'pending' => 'primary',
            'processed' => 'success',
        ];
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'updater_name':{
                            if ($rec['status'] == 'processed' && !$rec[$col['data']]) {
                                $tdData = 'HR Admin';
                                break;
                            }
                            $tdData = $rec[$col['data']];
                            break;
                        }
                    case 'added_at':
                    case 'updated_at':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'status':{
                            $tdData = '<span class="label label-' . $status_classes[$rec[$col['data']]] . '">' . ucfirst($rec[$col['data']]) . '</span>';
                            break;
                        }
                    case 'action':{
                            if (!$this->permission->method('domain_requests', 'update')->access()) {
                                break;
                            }
                            if ($rec['status'] == 'pending') {
                                $tdData .= '<a href="#" class="btn btn-success btn-process" data-name="' . addslashes(sprintf('%s (%s)', $rec['full_name'], $rec['hrm_id'])) . '" data-id="' . $rec['id'] . '"><i class="fa fa-check"></i></a>';
                            }
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
}
