<?php

use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Shared\Date;

defined('BASEPATH') or exit('No direct script access allowed');
class Bulk extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'Employees_model',
            'dashboard/User_model',
        ));
        $this->load->library(['excel', 'better_excel']);
    }
    public function import()
    {
        $this->permission->method('add_employee_bulk', 'create')->redirect();
        if ($this->input->method() != 'post') {
            $data['title'] = 'Bulk Import Employees';
            $data['module'] = "employee";
            $data['page'] = "bulk_import";
            echo Modules::run('template/layout', $data);return;
        }
        $column_order = [
            'HRM ID',
            'First Name',
            'Middle Name',
            'Last Name',
            'Father Name',
            'HRM Email Address',
            'Phone',
            'Alternative Phone',
            'Country',
            'City',
            'Division',
            'Department',
            'Designation',
            'Duty Type',
            'Probation Period (Months)',
            'Contract Period (Months)',
            'Shift',
            'Hire Date',
            'Original Hire Date',
            'Separation Date',
            'Separation Reason',
            'Voluntary Resignation',
            'Rehire Date',
            'Salary Type',
            'Performance Review Duration (Months)',
            'Hired Salary',
            'EOBI',
            'EOBI Amount',
            'Is Supervisor',
            'Direct Reporting To',
            'Indirect Reporting To',
            'Date of Birth',
            'Gender',
            'Marital Status',
            'Religion',
            'CNIC',
            'CNIC Expiry Date',
            'Personal Email',
            'Business Email',
            'Home Phone',
            'Emergency Contact Name',
            'Emergency Contact Number',
            'Emergency Contact Relation',
            'Cell Phone',
            'Present Address',
            'Permanent Address',
            'Work From Home',
            'Transportation Required',
            'Password',
            'Role',
            'Prefix',
            'Primary Project',
            'Team',
            'Campaign',
            'Pseudo',
            'Medflow ID',
            'Skype ID',
            'Hiring In Replacement Of',
            'Qualification (Last Degree)',
            'Passing Date',
            'CGPA / Div / %',
            'Institute',
            'Last Employer',
            'Last Employer Address',
            'Account Title',
            'Account Number',
            'Account IBAN',
            'Branch Code',
            'Branch Address',
            'Employee Status',
            'Exit Interview Conducted',
            'Exit Interview Date',
            'Exit Interview Details',
            'Domain Username',
            'Domain Password',
        ];
        $required_cols = [
            'First Name' => 'required',
            'HRM Email Address' => 'email',
            'Phone' => 'required',
            'Division' => 'required',
            'Department' => 'required',
            'Designation' => 'required',
            'Hire Date' => 'required',
            'Original Hire Date' => 'required',
            'Salary Type' => 'required',
            'Hired Salary' => 'required',
            'Date of Birth' => 'required',
            'Gender' => 'required',
            'CNIC' => 'required',
            'CNIC Expiry Date' => 'required',
            'Personal Email' => 'email',
            'Business Email' => 'email',
            'Home Phone' => 'required',
            'Cell Phone' => 'required',
            'Password' => 'required',
            'Role' => 'required',
        ];
        $column_order = array_map(function ($col) {
            return strtolower(trim($col));
        }, $column_order);
        foreach ($required_cols as $key => $value) {
            unset($required_cols[$key]);
            $required_cols[strtolower(trim($key))] = $value;
        }
        $this->load->library('myupload');
        $file = $this->myupload->do_upload(FCPATH . 'uploads/temp/', 'file', true);
        if (!$file) {
            $this->session->set_flashdata('exception', 'File upload failed, try again later!');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $inputFileType = IOFactory::identify($file);
        $reader = IOFactory::createReader($inputFileType);
        $spreadsheet = $reader->load($file);

        $sheet = $spreadsheet->getActiveSheet();

        $header = null;
        $supervisors_data = [];
        $this->db->trans_start();
        foreach ($sheet->getRowIterator() as $row) {
            $row_num = $row->getRowIndex();
            if (!$header) {
                $header = $row;
                continue;
            }
            $empty = true;
            foreach ($row->getCellIterator() as $cell) {
                if (!empty(trim($cell->getValue()))) {
                    $empty = false;
                    break;
                }
            }
            if ($empty) {
                continue;
            }
            $postData = [
                'hrm_id' => '',
                'pos_id' => 0,
                'first_name' => '',
                'middle_name' => '',
                'last_name' => '',
                'father_name' => '',
                'maiden_name' => '',
                'email' => '',
                'phone' => '',
                'alter_phone' => '',
                'present_address' => '',
                'parmanent_address' => '',
                'picture' => '',
                'dept_id' => 0,
                'division_id' => 0,
                'state' => '',
                'city' => '',
                'zip' => '',
                'citizenship' => '',
                'duty_type' => '',
                'hire_date' => null,
                'original_hire_date' => null,
                'termination_date' => null,
                'termination_reason' => null,
                'voluntary_termination' => 0,
                'rehire_date' => null,
                'rate_type' => '',
                'pay_frequency' => '',
                'pay_frequency_txt' => '',
                'hourly_rate2' => '',
                'hourly_rate3' => '',
                'home_department' => '',
                'department_text' => '',
                'class_code' => '',
                'class_code_desc' => '',
                'class_acc_date' => null,
                'class_status' => '',
                'is_super_visor' => 0,
                'dob' => null,
                'gender' => 0,
                'marital_status' => 0,
                'ethnic_group' => '',
                'eeo_class_gp' => '',
                'cnic' => '',
                'cnic_expiry' => null,
                'work_in_state' => '',
                'live_in_state' => '',
                'home_email' => '',
                'business_email' => '',
                'home_phone' => '',
                'business_phone' => '',
                'cell_phone' => '',
                'emerg_contct' => '',
                'emrg_h_phone' => '',
                'emrg_w_phone' => '',
                'emgr_contct_relation' => '',
                'alt_em_contct' => '',
                'alt_emg_h_phone' => '',
                'alt_emg_w_phone' => '',
                'shift' => 0,
                'probation_period' => 0,
                'contract_period' => 0,
                'performance_duration' => 0,
                'eobi_check' => 0,
                'eobi' => 0,
                'work_from_home' => 0,
                'transportation_required' => 0,
                'prefix' => '',
                'primary_project' => '',
                'domain_name' => '',
                'domain_password' => '',
                'team' => '',
                'campaign' => '',
                'pseudo' => '',
                'medflow_id' => '',
                'skype_id' => '',
                'replacement' => '',
                'degree_name' => '',
                'passing_year' => null,
                'cgp' => null,
                'institute_name' => '',
                'last_employer' => '',
                'last_employer_address' => '',
                'account_title' => '',
                'account_number' => '',
                'account_iban' => '',
                'branch_code' => '',
                'branch_address' => '',
                'status' => '',
                'exit_interview' => 0,
                'exit_interview_date' => null,
                'exit_interview_details' => '',
            ];
            $pre_fetched_data = [];

            $div_prefix = '';
            $division = 0;
            $division_email_domain = '';

            $role_id = 0;
            $original_role = '';
            $direct_reporting = '';
            $indirect_reporting = '';
            $user_password = '';
            $header_iterator = $header->getCellIterator();
            $header_iterator->resetStart();
            foreach ($header_iterator as $header_cell) {
                $header_num = Coordinate::indexesFromString($header_cell->getCoordinate())[0];
                $header_label = strtolower(trim($header_cell->getValue()));
                if (!in_array($header_label, $column_order)) {
                    $this->session->set_flashdata('exception', sprintf(display(['unknown', 'value', '%s', 'in', 'sheet', 'header']), $header_cell->getValue()));
                    redirect($_SERVER['HTTP_REFERER']);
                }
                $cell = $sheet->getCellByColumnAndRow($header_num, $row_num);
                $value = trim($cell->getValue());

                if (in_array($header_label, array_keys($required_cols))) {
                    $req_col = explode('|', $required_cols[$header_label]);
                    if (in_array('required', $req_col) && empty($value)) {
                        $this->session->set_flashdata('exception', 'Required column "' . $header_cell->getValue() . '" is empty on ' . $cell->getCoordinate());
                        redirect($_SERVER['HTTP_REFERER']);return;
                    } elseif (!empty($value)) {
                        if (in_array('email', $req_col) && !filter_var($value, FILTER_VALIDATE_EMAIL)) {
                            $this->session->set_flashdata('exception', 'Invalid Email in "' . $header_cell->getValue() . '" in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                        }
                    }
                }
                switch ($header_label) {
                    case 'division':{
                            $pre_fetched_data['division'] = $value;
                            break;
                        }
                    case 'hrm id':{
                            $pre_fetched_data['hrm_id'] = $value;
                            break;
                        }
                }
            }

            /**
             * Check Division exists
             */
            $original_div = $pre_fetched_data['division'];
            $pre_fetched_data['division'] = str_replace(' ', '_', $pre_fetched_data['division']);
            $pre_fetched_data['division'] = preg_replace('/[^\w\d]+/', '%', $pre_fetched_data['division']);
            $div_prefix = '';
            $division = getByWhereAsArray('divisions', 'id, prefix, email_domain', [], [], 0, 0, ['name' => $pre_fetched_data['division']]);
            if ($division) {
                $div_prefix = $division[0]['prefix'];
                $division_email_domain = $division[0]['email_domain'];
                $division = $division[0]['id'];
            } else {
                $this->session->set_flashdata('exception', 'Division "' . $original_div . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            $postData['division_id'] = $division;
            /**
             * Duplicate HRM ID check
             */
            if (empty($pre_fetched_data['hrm_id'])) {
                $pre_fetched_data['hrm_id'] = $div_prefix . '-' . generate_hrm_id($division);
            } else {
                $employee_email_exist = $this->db->select('employee_id')
                    ->where('hrm_id', $pre_fetched_data['hrm_id'])
                    ->from('employee_history')
                    ->get()
                    ->row();
                if ($employee_email_exist) {
                    $this->session->set_flashdata('exception', 'HRM ID "' . $pre_fetched_data['hrm_id'] . '" already exists from row# ' . $row_num);
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
            }
            $postData['hrm_id'] = $pre_fetched_data['hrm_id'];

            $header_iterator->resetStart();
            foreach ($header_iterator as $header_cell) {
                $header_num = Coordinate::indexesFromString($header_cell->getCoordinate())[0];
                $cell = $sheet->getCellByColumnAndRow($header_num, $row_num);
                $value = trim($cell->getValue());
                $header_label = strtolower(trim($header_cell->getValue()));

                if (empty($value) && !in_array($header_label, ['hrm id', 'hrm email address'])) {
                    continue;
                }
                switch ($header_label) {
                    case 'first name':{
                            $postData['first_name'] = $value;
                            break;
                        }
                    case 'middle name':{
                            $postData['middle_name'] = $value;
                            break;
                        }
                    case 'last name':{
                            $postData['last_name'] = $value;
                            break;
                        }
                    case 'father name':{
                            $postData['father_name'] = $value;
                            break;
                        }
                    case 'hrm email address':{
                            if (empty($value)) {
                                $value = strtolower(str_replace('-', '', $postData['hrm_id']) . '@' . $division_email_domain);
                            }
                            $employee_email_exist = $this->db->select('employee_id')
                                ->where('email', $value)
                                ->from('employee_history')
                                ->get()
                                ->row();
                            if ($employee_email_exist) {
                                $this->session->set_flashdata('exception', 'Email "' . $value . '" already exists from cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            /**
                             * Duplicate Email check
                             */
                            $employee_user_email_exist = $this->db->select('id')
                                ->where('email', $value)
                                ->from('user')
                                ->get()
                                ->row();
                            if ($employee_user_email_exist) {
                                $this->session->set_flashdata('exception', 'User with email "' . $value . '" already exists from cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $postData['email'] = $value;
                            break;
                        }
                    case 'phone':{
                            $postData['phone'] = $value;
                            break;
                        }
                    case 'alternative phone':{
                            $postData['alter_phone'] = $value;
                            break;
                        }
                    case 'country':{
                            $postData['state'] = $value;
                            break;
                        }
                    case 'city':{
                            $postData['city'] = $value;
                            break;
                        }
                    case 'department':{
                            /**
                             * Check department exists
                             */
                            $original_deptt = $value;
                            $value = str_replace(' ', '_', $value);
                            $value = preg_replace('/[^\w\d]+/', '%', $value);
                            $department = getByWhereAsArray('department', 'dept_id', [], [], 0, 0, ['department_name' => $value]);
                            if ($department) {
                                $department = $department[0]['dept_id'];
                            } else {
                                $this->session->set_flashdata('exception', 'Invalid department name "' . $original_deptt . '" in cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $postData['dept_id'] = $department;
                            break;
                        }
                    case 'designation':{
                            /**
                             * Check position exists
                             */
                            $original_pos = $value;
                            $value = str_replace(' ', '_', $value);
                            $value = preg_replace('/[^\w\d]+/', '%', $value);
                            $position = getByWhereAsArray('position', 'pos_id', [], [], 0, 0, ['position_name' => $value]);
                            if ($position) {
                                $position = $position[0]['pos_id'];
                            } else {
                                $this->session->set_flashdata('exception', 'Invalid designation/position name "' . $original_pos . '" in cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $postData['pos_id'] = $position;
                            break;
                        }
                    case 'duty type':{
                            /**
                             * Check duty type exists
                             */
                            $original_duty = $value;
                            $value = str_replace(' ', '_', $value);
                            $value = preg_replace('/[^\w\d]+/', '%', $value);
                            $duty_type = getByWhereAsArray('duty_type', 'id', [], [], 0, 0, ['type_name' => $value]);
                            if ($duty_type) {
                                $duty_type = $duty_type[0]['id'];
                            } else {
                                $this->session->set_flashdata('exception', 'Invalid duty type name "' . $original_duty . '" in cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $postData['duty_type'] = $duty_type;
                            break;
                        }
                    case 'probation period (months)':{
                            if (is_numeric($value)) {
                                $postData['probation_period'] = $value;
                            }
                            break;
                        }
                    case 'contract period (months)':{
                            if (is_numeric($value)) {
                                $postData['contract_period'] = $value;
                            }
                            break;
                        }
                    case 'shift':{
                            /**
                             * Check shift exists
                             */
                            $original_shift = $value;
                            $value = str_replace(' ', '_', $value);
                            $value = preg_replace('/[^\w\d]+/', '%', $value);
                            $shift_type = getByWhereAsArray('shift', 'id', [], [], 0, 0, ['name' => $value]);
                            if ($shift_type) {
                                $shift_type = $shift_type[0]['id'];
                            } else {
                                $this->session->set_flashdata('exception', 'Invalid shift name "' . $original_shift . '" in cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $postData['shift'] = $shift_type;
                            break;
                        }
                    case 'hire date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $postData['hire_date'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Hire Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'original hire date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $postData['original_hire_date'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Original Hire Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'separation date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $postData['termination_date'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Separation Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'separation reason':{
                            $postData['termination_reason'] = htmlspecialchars($value);
                        }
                    case 'voluntary resignation':{
                            $postData['voluntary_termination'] = strtolower($value) == 'yes' ? 1 : 0;
                            break;
                        }
                    case 'rehire date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $postData['rehire_date'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Rehire Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'salary type':{
                            /**
                             * Salary Type Check
                             */
                            $original_salary_type = $value;
                            $s_types = [
                                'monthly' => 2,
                            ];
                            if (@$s_types[trim(strtolower($value))]) {
                                $postData['rate_type'] = $s_types[trim(strtolower($value))];
                            } else {
                                $this->session->set_flashdata('exception', 'Invalid salary type "' . $original_salary_type . '" in cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            break;
                        }
                    case 'performance review duration (months)':{
                            if (is_numeric($value)) {
                                $postData['performance_duration'] = $value;
                            }
                            break;
                        }
                    case 'hired salary':{
                            $postData['hired_salary'] = $value;
                            break;
                        }
                    case 'eobi':{
                            $postData['eobi_check'] = strtolower($value) == 'yes' ? 1 : 0;
                            break;
                        }
                    case 'eobi amount':{
                            $postData['eobi'] = $value;
                            break;
                        }
                    case 'is supervisor':{
                            $postData['is_super_visor'] = strtolower($value) == 'yes' ? 1 : 0;
                            break;
                        }
                    case 'direct reporting to':{
                            $direct_reporting = $value;
                            break;
                        }
                    case 'indirect reporting to':{
                            $indirect_reporting = $value;
                            break;
                        }
                    case 'date of birth':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $postData['dob'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Date of Birth column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'gender':{
                            /**
                             * Check gender exists
                             */
                            $gender = getByWhereAsArray('gender', 'id', ['gender_name' => $value]);
                            if ($gender) {
                                $gender = $gender[0]['id'];
                            } else {
                                $this->db->insert('gender', [
                                    'gender_name' => $value,
                                ]);
                                $gender = $this->db->insert_id();
                                $this->activity->log([
                                    'gender_inserted',
                                    $value,
                                ]);
                            }
                            $postData['gender'] = $gender;
                            break;
                        }
                    case 'marital status':{
                            /**
                             * Check marital status exists
                             */
                            $marital_status = getByWhereAsArray('marital_info', 'id', ['marital_sta' => $value]);
                            if ($marital_status) {
                                $marital_status = $marital_status[0]['id'];
                            } else {
                                $this->db->insert('marital_info', [
                                    'marital_sta' => $value,
                                ]);
                                $marital_status = $this->db->insert_id();
                                $this->activity->log([
                                    'marital_status_inserted',
                                    $value,
                                ]);
                            }
                            $postData['marital_status'] = $marital_status;
                            break;
                        }
                    case 'religion':{
                            $postData['ethnic_group'] = $value;
                            break;
                        }
                    case 'cnic':{
                            $postData['cnic'] = preg_replace('@[^\d]@', '', $value);
                            break;
                        }
                    case 'cnic expiry date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $postData['cnic_expiry'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'CNIC Expiry Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'personal email':{
                            $postData['home_email'] = $value;
                            break;
                        }
                    case 'business email':{
                            $postData['business_email'] = $value;
                            break;
                        }
                    case 'home phone':{
                            $postData['home_phone'] = $value;
                            break;
                        }
                    case 'emergency contact name':{
                            $postData['emergency_contact_name'] = $value;
                            break;
                        }
                    case 'emergency contact relation':{
                            $postData['emergency_contact_relation'] = $value;
                            break;
                        }
                    case 'emergency contact number':{
                            $postData['emerg_contct'] = $value;
                            break;
                        }
                    case 'cell phone':{
                            $postData['cell_phone'] = $value;
                            break;
                        }
                    case 'present address':{
                            $postData['present_address'] = htmlspecialchars($value);
                            break;
                        }
                    case 'permanent address':{
                            $postData['parmanent_address'] = htmlspecialchars($value);
                            break;
                        }
                    case 'work from home':{
                            $postData['work_from_home'] = strtolower($value) == 'yes' ? 1 : 0;
                            break;
                        }
                    case 'transportation required':{
                            $postData['transportation_required'] = strtolower($value) == 'yes' ? 1 : 0;
                            break;
                        }
                    case 'password':{
                            $user_password = password_hash($value, PASSWORD_DEFAULT);
                            break;
                        }
                    case 'role':{
                            /**
                             * Check role exists
                             */
                            $original_role = $value;
                            $value = str_replace(' ', '_', $value);
                            $value = preg_replace('/[^\w\d]+/', '%', $value);
                            $role_id = getByWhereAsArray('sec_role_tbl, sec_user_access_tbl-sec_user_access_tbl.fk_role_id=sec_role_tbl.role_id-left', 'sec_role_tbl.role_id', [], [], 0, 0, ['sec_role_tbl.role_name' => $value]);
                            if ($role_id) {
                                $role_id = $role_id[0]['role_id'];
                            } else {
                                $this->session->set_flashdata('exception', 'Invalid role name "' . $original_role . '" in cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            break;
                        }
                    case 'prefix':{
                            $postData['prefix'] = $value;
                            break;
                        }
                    case 'primary project':{
                            $postData['primary_project'] = $value;
                            break;
                        }
                    case 'team':{
                            $postData['team'] = $value;
                            break;
                        }
                    case 'campaign':{
                            $postData['campaign'] = $value;
                            break;
                        }
                    case 'pseudo':{
                            $postData['pseudo'] = $value;
                            break;
                        }
                    case 'medflow id':{
                            $postData['medflow_id'] = $value;
                            break;
                        }
                    case 'skype id':{
                            $postData['skype_id'] = $value;
                            break;
                        }
                    case 'hiring in replacement of':{
                            $postData['replacement'] = $value;
                            break;
                        }
                    case 'qualification (last degree)':{
                            $postData['degree_name'] = $value;
                            break;
                        }
                    case 'passing date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $postData['passing_year'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Passing Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'cgpa / div / %':{
                            $postData['cgp'] = $value;
                            break;
                        }
                    case 'institute':{
                            $postData['institute_name'] = $value;
                            break;
                        }
                    case 'last employer':{
                            $postData['last_employer'] = $value;
                            break;
                        }
                    case 'last employer address':{
                            $postData['last_employer_address'] = htmlspecialchars($value);
                            break;
                        }
                    case 'account title':{
                            $postData['account_title'] = $value;
                            break;
                        }
                    case 'account number':{
                            $postData['account_number'] = $value;
                            break;
                        }
                    case 'account iban':{
                            $postData['account_iban'] = $value;
                            break;
                        }
                    case 'branch code':{
                            $postData['branch_code'] = $value;
                            break;
                        }
                    case 'branch address':{
                            $postData['branch_address'] = $value;
                            break;
                        }
                    case 'employee status':{
                            $postData['status'] = preg_replace('#[^\w]#is', '-', $value);
                            break;
                        }
                    case 'exit interview conducted':{
                            $postData['exit_interview'] = strtolower($value) == 'yes' ? 1 : 0;
                            break;
                        }
                    case 'exit interview date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $postData['exit_interview_date'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Exit Interview Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'exit interview details':{
                            $postData['exit_interview_details'] = htmlspecialchars($value);
                            break;
                        }
                    case 'domain username':{
                            $postData['domain_name'] = $value;
                            break;
                        }
                    case 'domain password':{
                            $postData['domain_password'] = $value;
                            break;
                        }
                }
            }
            $employee_id = $this->Employees_model->create_employee($postData);
            $this->db->insert('user', [
                'firstname' => $postData['first_name'],
                'lastname' => $postData['last_name'],
                'email' => $postData['email'],
                'password' => $user_password,
                'new_algo' => 1
            ]);
            $inserted_user_id = $this->db->insert_id();

            $this->activity->set_employee($employee_id)
                ->set_url('employee/Employees/cv/' . $employee_id)
                ->log('employee_created', $employee_id, 'employee', 'employee_history');

            $this->activity->set_user($inserted_user_id)
                ->set_url('dashboard/user/index')
                ->log('user_inserted', 'settings');

            $this->db->insert('sec_user_access_tbl', [
                'fk_role_id' => $role_id,
                'fk_user_id' => $inserted_user_id,
            ]);
            $this->activity->set_url('dashboard/role/user_access_role')->set_user($inserted_user_id)->log([
                'role_assigned',
                $original_role,
            ], $employee_id, 'settings');
            $coa = $this->Employees_model->headcode();
            if ($coa->HeadCode != null) {
                $headcode = $coa->HeadCode + 1;
            } else {
                $headcode = "502020000001";
            }
            $c_acc = $employee_id . '-' . $postData['first_name'] . $postData['last_name'];
            $createby = $this->session->userdata('fullname');
            $createdate = date('Y-m-d H:i:s');
            $coaData = [
                'HeadCode' => $headcode,
                'HeadName' => $c_acc,
                'PHeadName' => 'Account Payable',
                'HeadLevel' => '2',
                'IsActive' => '1',
                'IsTransaction' => '1',
                'IsGL' => '0',
                'HeadType' => 'L',
                'IsBudget' => '0',
                'IsDepreciation' => '0',
                'DepreciationRate' => '0',
                'CreateBy' => $createby,
                'CreateDate' => $createdate,
            ];
            $this->Employees_model->create_coa($coaData);
            $supervisors_data[$row_num] = [
                'employee_id' => $employee_id,
                'direct_supervisor' => $direct_reporting,
                'indirect_supervisor' => $indirect_reporting,
            ];
        }
        foreach ($supervisors_data as $row_num => $row_data) {
            if (empty($row_data['direct_supervisor']) && empty($row_data['indirect_supervisor'])) {
                continue;
            }
            $direct_supervisor_id = 0;
            if (!empty($row_data['direct_supervisor'])) {
                $direct_supervisor_id = $this->db->select('employee_id')
                    ->where('hrm_id', $row_data['direct_supervisor'])
                    ->from('employee_history')
                    ->get()
                    ->row();
                if ($direct_supervisor_id) {
                    $direct_supervisor_id = $direct_supervisor_id->employee_id;
                } else {
                    $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Direct Supervisor with ID "' . $row_data['direct_supervisor'] . '" doesn\'t exist.<br>Make sure add all the supervisor before other employees');
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
            }
            /**
             * Get Indirect Supervisor ID
             */
            $indirect_supervisor_id = 0;
            if (!empty($row_data['indirect_supervisor'])) {
                $indirect_supervisor_id = $this->db->select('employee_id')
                    ->where('hrm_id', $row_data['indirect_supervisor'])
                    ->from('employee_history')
                    ->get()
                    ->row();
                if ($indirect_supervisor_id) {
                    $indirect_supervisor_id = $indirect_supervisor_id->employee_id;
                } else {
                    $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Indirect Supervisor with ID "' . $row_data['indirect_supervisor'] . '" doesn\'t exist.<br>Make sure add all the supervisor before other employees');
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
            }
            $this->db->where('employee_id', $row_data['employee_id'])->update('employee_history', [
                'super_visor_id' => $direct_supervisor_id,
                'indirect_super_visor_id' => $indirect_supervisor_id,
            ]);
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() === false) {
            $this->session->set_flashdata('exception', 'Error importing data, try again later');
        } else {
            $this->session->set_flashdata('message', 'Data imported successfully');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function update()
    {
        $this->permission->method('update_employee_bulk', 'create')->redirect();
        if ($this->input->method() != 'post') {
            $data['title'] = 'Bulk Update Employees';
            $data['labels'] = $this->get_update_labels();
            $data['module'] = "employee";
            $data['page'] = "bulk_update";
            echo Modules::run('template/layout', $data);return;
        }
        $required_cols = [
            'hrm id' => 'required',
        ];
        $this->load->library('myupload');
        $file = $this->myupload->do_upload(FCPATH . 'uploads/temp/', 'file', true);
        if (!$file) {
            $this->session->set_flashdata('exception', 'File upload failed, try again later!');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $inputFileType = IOFactory::identify($file);
        $reader = IOFactory::createReader($inputFileType);
        $spreadsheet = $reader->load($file);

        $sheet = $spreadsheet->getActiveSheet();

        $header = null;
        $this->db->trans_start();
        foreach ($sheet->getRowIterator() as $row) {
            $row_num = $row->getRowIndex();
            if (!$header) {
                $header = $row;
                if ($sheet->getCellByColumnAndRow(1, 1)->getValue() != 'HRM ID') {
                    $this->session->set_flashdata('exception', 'First column in header must contain HRM ID');
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
                continue;
            }
            $empty = true;
            foreach ($row->getCellIterator() as $cell) {
                if (!empty(trim($cell->getValue()))) {
                    $empty = false;
                    break;
                }
            }
            if ($empty) {
                continue;
            }
            $employee_rec = null;
            $employee_history_data = [];
            $user_data = [];

            $header_iterator = $header->getCellIterator();
            $header_iterator->resetStart();
            foreach ($header_iterator as $header_cell) {
                $header_num = Coordinate::indexesFromString($header_cell->getCoordinate())[0];
                $cell = $sheet->getCellByColumnAndRow($header_num, $row_num);
                $value = trim($cell->getValue());

                $header_label = strtolower(trim($header_cell->getValue()));
                if (in_array($header_label, array_keys($required_cols))) {
                    $req_col = explode('|', $required_cols[$header_label]);
                    if (in_array('required', $req_col) && empty($value)) {
                        $this->session->set_flashdata('exception', 'Required column "' . $header_cell->getValue() . '" is empty on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    } elseif (!empty($value)) {
                        if (in_array('email', $req_col) && !filter_var($value, FILTER_VALIDATE_EMAIL)) {
                            $this->session->set_flashdata('exception', 'Invalid Email in "' . $header_cell->getValue() . '" column in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                        }
                    }
                }

                if (empty($value) && !in_array($header_label, ['hrm id'])) {
                    continue;
                }
                switch ($header_label) {
                    case 'hrm id':{
                            /**
                             * Duplicate HRM ID check
                             */
                            if (empty($value)) {
                                $this->session->set_flashdata('exception', 'Required "HRM ID" Column empty in cell' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            } else {
                                $employee_rec = $this->db->select('*')
                                    ->where('hrm_id', $value)
                                    ->from('employee_history')
                                    ->get()
                                    ->row();
                                if (!$employee_rec) {
                                    $this->session->set_flashdata('exception', 'HRM ID "' . $value . '" doesn\'t exist in cell ' . $cell->getCoordinate());
                                    redirect($_SERVER['HTTP_REFERER']);return;
                                }
                                $employee_rec = decrypt_employee_data($employee_rec);
                            }
                            break;
                        }
                    case 'first name':{
                            $employee_history_data['first_name'] = $user_data['firstname'] = $value;
                            break;
                        }
                    case 'middle name':{
                            $employee_history_data['middle_name'] = $value;
                            break;
                        }
                    case 'last name':{
                            $employee_history_data['last_name'] = $user_data['lastname'] = $value;
                            break;
                        }
                    case 'father name':{
                            $employee_history_data['father_name'] = $value;
                            break;
                        }
                    case 'phone':{
                            $employee_history_data['phone'] = $value;
                            break;
                        }
                    case 'alternative phone':{
                            $employee_history_data['alter_phone'] = $value;
                            break;
                        }
                    case 'country':{
                            $employee_history_data['state'] = $value;
                            break;
                        }
                    case 'city':{
                            $employee_history_data['city'] = $value;
                            break;
                        }
                    case 'division':{
                            /**
                             * Check Division exists
                             */
                            $original_div = $value;
                            $value = str_replace(' ', '_', $value);
                            $value = preg_replace('/[^\w\d]+/', '%', $value);
                            $division = getByWhereAsArray('divisions', 'id, prefix', [], [], 0, 0, ['name' => $value]);
                            if ($division) {
                                $division = $division[0]['id'];
                            } else {
                                $this->session->set_flashdata('exception', 'Invalid division name "' . $original_div . '" in cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }

                            $employee_history_data['division_id'] = $division;
                            break;
                        }
                    case 'department':{
                            /**
                             * Check department exists
                             */
                            $original_deptt = $value;
                            $value = str_replace(' ', '_', $value);
                            $value = preg_replace('/[^\w\d]+/', '%', $value);
                            $department = getByWhereAsArray('department', 'dept_id', [], [], 0, 0, ['department_name' => $value]);
                            if ($department) {
                                $department = $department[0]['dept_id'];
                            } else {
                                $this->session->set_flashdata('exception', 'Invalid department name "' . $original_deptt . '" in cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $employee_history_data['dept_id'] = $department;
                            break;
                        }
                    case 'designation':{
                            /**
                             * Check position exists
                             */
                            $original_pos = $value;
                            $value = str_replace(' ', '_', $value);
                            $value = preg_replace('/[^\w\d]+/', '%', $value);
                            $position = getByWhereAsArray('position', 'pos_id', [], [], 0, 0, ['position_name' => $value]);
                            if ($position) {
                                $position = $position[0]['pos_id'];
                            } else {
                                $this->session->set_flashdata('exception', 'Invalid designation / position name "' . $original_pos . '" in cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $employee_history_data['pos_id'] = $position;
                            break;
                        }
                    case 'duty type':{
                            /**
                             * Check duty type exists
                             */
                            $original_duty = $value;
                            $value = str_replace(' ', '_', $value);
                            $value = preg_replace('/[^\w\d]+/', '%', $value);
                            $duty_type = getByWhereAsArray('duty_type', 'id', [], [], 0, 0, ['type_name' => $value]);
                            if ($duty_type) {
                                $duty_type = $duty_type[0]['id'];
                            } else {
                                $this->session->set_flashdata('exception', 'Invalid duty type "' . $original_duty . '" in cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $employee_history_data['duty_type'] = $duty_type;
                            break;
                        }
                    case 'probation period (months)':{
                            $employee_history_data['probation_period'] = $value;
                            break;
                        }
                    case 'contract period (months)':{
                            $employee_history_data['contract_period'] = $value;
                            break;
                        }
                    case 'shift':{
                            /**
                             * Check shift exists
                             */
                            $original_shift = $value;
                            $value = str_replace(' ', '_', $value);
                            $value = preg_replace('/[^\w\d]+/', '%', $value);
                            $shift_type = getByWhereAsArray('shift', 'id', [], [], 0, 0, ['name' => $value]);
                            if ($shift_type) {
                                $shift_type = $shift_type[0]['id'];
                            } else {
                                $this->session->set_flashdata('exception', 'Invalid shift name "' . $original_shift . '" in cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $employee_history_data['shift'] = $shift_type;
                            break;
                        }
                    case 'hire date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $employee_history_data['hire_date'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Hire Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'original hire date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $employee_history_data['original_hire_date'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Original Hire Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'separation date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $employee_history_data['termination_date'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Separation Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'separation reason':{
                            $employee_history_data['termination_reason'] = htmlspecialchars($value);
                            break;
                        }
                    case 'voluntary resignation':{
                            $employee_history_data['voluntary_termination'] = strtolower($value) == 'yes' ? 1 : 0;
                            break;
                        }
                    case 'rehire date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $employee_history_data['rehire_date'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Rehire Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'salary type':{
                            /**
                             * Salary Type Check
                             */
                            $original_salary_type = $value;
                            $s_types = [
                                'monthly' => 2,
                            ];
                            $s_type = 0;
                            if (@$s_types[trim(strtolower($value))]) {
                                $s_type = $s_types[trim(strtolower($value))];
                            } else {
                                $this->session->set_flashdata('exception', 'Invalid salary type "' . $original_salary_type . '" in cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $employee_history_data['rate_type'] = $s_type;
                            break;
                        }
                    case 'performance review duration (months)':{
                            $postData['employee_history_data'] = $value;
                            break;
                        }
                    case 'hired salary':{
                            $employee_history_data['hired_salary'] = $value;
                            break;
                        }
                    case 'eobi':{
                            $employee_history_data['eobi_check'] = strtolower($value) == 'yes' ? 1 : 0;
                            break;
                        }
                    case 'deduct provident fund':{
                            $employee_history_data['provident_fund_check'] = strtolower($value) == 'yes' ? 1 : 0;
                            break;
                        }
                    case 'eobi amount':{
                            $employee_history_data['eobi'] = $value;
                            break;
                        }
                    case 'is supervisor':{
                            $employee_history_data['is_super_visor'] = strtolower($value) == 'yes' ? 1 : 0;
                            break;
                        }
                    case 'direct reporting to':{
                            $direct_supervisor_id = $this->db->select('employee_id')
                                ->where('hrm_id', $value)
                                ->from('employee_history')
                                ->get()
                                ->row();
                            if ($direct_supervisor_id) {
                                $direct_supervisor_id = $direct_supervisor_id->employee_id;
                            } else {
                                $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Direct Supervisor with ID "' . $value . '" doesn\'t exist.<br>Make sure add all the supervisor before other employees');
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $employee_history_data['super_visor_id'] = $direct_supervisor_id;
                            break;
                        }
                    case 'indirect reporting to':{
                            $indirect_supervisor_id = $this->db->select('employee_id')
                                ->where('hrm_id', $value)
                                ->from('employee_history')
                                ->get()
                                ->row();
                            if ($indirect_supervisor_id) {
                                $indirect_supervisor_id = $indirect_supervisor_id->employee_id;
                            } else {
                                $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Indirect Supervisor with ID "' . $value . '" doesn\'t exist.<br>Make sure add all the supervisor before other employees');
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $employee_history_data['indirect_super_visor_id'] = $indirect_supervisor_id;
                            break;
                        }
                    case 'date of birth':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $employee_history_data['dob'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Date of Birth column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'gender':{
                            /**
                             * Check gender exists
                             */
                            $gender = getByWhereAsArray('gender', 'id', ['gender_name' => $value]);
                            if ($gender) {
                                $gender = $gender[0]['id'];
                            } else {
                                $this->db->insert('gender', [
                                    'gender_name' => $value,
                                ]);
                                $gender = $this->db->insert_id();
                                $this->activity->log([
                                    'gender_inserted',
                                    $value,
                                ]);
                            }
                            $employee_history_data['gender'] = $gender;
                            break;
                        }
                    case 'marital status':{
                            /**
                             * Check marital status exists
                             */
                            $marital_status = getByWhereAsArray('marital_info', 'id', ['marital_sta' => $value]);
                            if ($marital_status) {
                                $marital_status = $marital_status[0]['id'];
                            } else {
                                $this->db->insert('marital_info', [
                                    'marital_sta' => $value,
                                ]);
                                $marital_status = $this->db->insert_id();
                                $this->activity->log([
                                    'marital_status_inserted',
                                    $value,
                                ]);
                            }
                            $employee_history_data['marital_status'] = $marital_status;
                            break;
                        }
                    case 'religion':{
                            $employee_history_data['ethnic_group'] = $value;
                            break;
                        }
                    case 'cnic':{
                            $employee_history_data['cnic'] = preg_replace('@[^\d]@', '', $value);
                            break;
                        }
                    case 'cnic expiry date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $employee_history_data['cnic_expiry'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'CNIC Expiry Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'personal email':{
                            $employee_history_data['home_email'] = $value;
                            break;
                        }
                    case 'business email':{
                            $employee_history_data['business_email'] = $value;
                            break;
                        }
                    case 'home phone':{
                            $employee_history_data['home_phone'] = $value;
                            break;
                        }
                    case 'emergency contact name':{
                            $employee_history_data['emergency_contact_name'] = $value;
                            break;
                        }
                    case 'emergency contact relation':{
                            $employee_history_data['emergency_contact_relation'] = $value;
                            break;
                        }
                    case 'emergency contact number':{
                            $employee_history_data['emerg_contct'] = $value;
                            break;
                        }
                    case 'cell phone':{
                            $employee_history_data['cell_phone'] = $value;
                            break;
                        }
                    case 'present address':{
                            $employee_history_data['present_address'] = htmlspecialchars($value);
                            break;
                        }
                    case 'permanent address':{
                            $employee_history_data['parmanent_address'] = htmlspecialchars($value);
                            break;
                        }
                    case 'work from home':{
                            $employee_history_data['work_from_home'] = strtolower($value) == 'yes' ? 1 : 0;
                            break;
                        }
                    case 'transportation required':{
                            $employee_history_data['transportation_required'] = strtolower($value) == 'yes' ? 1 : 0;
                            break;
                        }
                    case 'password':{
                            $user_data['password'] = password_hash($value, PASSWORD_DEFAULT);
                            $user_data['new_algo'] = 1;
                            break;
                        }
                    case 'role':{
                            $user_rec = $this->db->where('email', $employee_rec->email)->get('user')->row();
                            if (!$user_rec) {
                                $this->session->set_flashdata('exception', 'User with email "' . $employee_rec->email . '" not found on row# ' . $row_num);
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            /**
                             * Check role exists
                             */
                            $original_role = $value;
                            $value = str_replace(' ', '_', $value);
                            $value = preg_replace('/[^\w\d]+/', '%', $value);
                            $role_id = getByWhereAsArray('sec_role_tbl, sec_user_access_tbl-sec_user_access_tbl.fk_role_id=sec_role_tbl.role_id-left', 'sec_role_tbl.role_id', [], [], 0, 0, ['sec_role_tbl.role_name' => $value]);
                            if ($role_id) {
                                $role_id = $role_id[0]['role_id'];
                            } else {
                                $this->session->set_flashdata('exception', 'Invalid role name "' . $original_role . '" in cell ' . $cell->getCoordinate());
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $this->db->where('fk_user_id', $user_rec->id)->delete('sec_user_access_tbl');
                            $this->db->insert('sec_user_access_tbl', [
                                'fk_role_id' => $role_id,
                                'fk_user_id' => $user_rec->id,
                            ]);
                            $this->activity->set_url('dashboard/role/user_access_role')->set_employee($employee_rec->employee_id)->log([
                                'role_assigned',
                                $original_role,
                            ], $employee_rec->employee_id, 'settings');
                            break;
                        }
                    case 'prefix':{
                            $employee_history_data['prefix'] = $value;
                            break;
                        }
                    case 'primary project':{
                            $employee_history_data['primary_project'] = $value;
                            break;
                        }
                    case 'team':{
                            $employee_history_data['team'] = $value;
                            break;
                        }
                    case 'campaign':{
                            $employee_history_data['campaign'] = $value;
                            break;
                        }
                    case 'pseudo':{
                            $employee_history_data['pseudo'] = $value;
                            break;
                        }
                    case 'medflow id':{
                            $employee_history_data['medflow_id'] = $value;
                            break;
                        }
                    case 'skype id':{
                            $employee_history_data['skype_id'] = $value;
                            break;
                        }
                    case 'hiring in replacement of':{
                            $employee_history_data['replacement'] = $value;
                            break;
                        }
                    case 'qualification (last degree)':{
                            $employee_history_data['degree_name'] = $value;
                            break;
                        }
                    case 'passing date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $employee_history_data['passing_year'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Passing Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'cgpa / div / %':{
                            $employee_history_data['cgp'] = $value;
                            break;
                        }
                    case 'institute':{
                            $employee_history_data['institute_name'] = $value;
                            break;
                        }
                    case 'last employer':{
                            $employee_history_data['last_employer'] = $value;
                            break;
                        }
                    case 'last employer address':{
                            $employee_history_data['last_employer_address'] = htmlspecialchars($value);
                            break;
                        }
                    case 'account title':{
                            $employee_history_data['account_title'] = $value;
                            break;
                        }
                    case 'account number':{
                            $employee_history_data['account_number'] = $value;
                            break;
                        }
                    case 'account iban':{
                            $employee_history_data['account_iban'] = $value;
                            break;
                        }
                    case 'branch code':{
                            $employee_history_data['branch_code'] = $value;
                            break;
                        }
                    case 'branch address':{
                            $employee_history_data['branch_address'] = $value;
                            break;
                        }
                    case 'employee status':{
                            $employee_history_data['status'] = preg_replace('#[^\w]#is', '-', $value);
                            break;
                        }
                    case 'exit interview conducted':{
                            $employee_history_data['exit_interview'] = strtolower($value) == 'yes' ? 1 : 0;
                            break;
                        }
                    case 'exit interview date':{
                            if (Date::isDateTime($cell)) {
                                $timestamp = Date::excelToTimestamp($value);
                                if ($timestamp) {
                                    $timestamp = date('Y-m-d', $timestamp);
                                    $employee_history_data['exit_interview_date'] = $timestamp;
                                    break;
                                }
                            }
                            $this->session->set_flashdata('exception', 'Exit Interview Date column must contain a valid date in cell ' . $cell->getCoordinate());
                            redirect($_SERVER['HTTP_REFERER']);return;
                            break;
                        }
                    case 'exit interview details':{
                            $employee_history_data['exit_interview_details'] = htmlspecialchars($value);
                            break;
                        }
                    case 'domain username':{
                            $employee_history_data['domain_name'] = $value;
                            break;
                        }
                    case 'domain password':{
                            $employee_history_data['domain_password'] = $value;
                            break;
                        }
                }
            }
            if ($employee_history_data) {
                $employee_history_data = encrypt_employee_data($employee_history_data);
                if ($this->db->where('employee_id', $employee_rec->employee_id)->update('employee_history', $employee_history_data)) {
                    $this->Employees_model->log_employee_change($employee_rec->employee_id, decrypt_employee_data($employee_history_data), (array) $employee_rec);
                }
            }
            if ($user_data) {
                $this->db->where('email', $employee_rec->email)->update('user', $user_data);
            }
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() === false) {
            $this->session->set_flashdata('exception', 'Error importing data, try again later');
        } else {
            $this->session->set_flashdata('message', 'Data updated successfully');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function leave_update()
    {
        $this->permission->method('bulk_leave_update', 'create')->redirect();
        if ($this->input->method() != 'post') {
            $data['title'] = 'Bulk Update Employee Leaves';
            $data['module'] = "employee";
            $data['page'] = "bulk_update_leaves";
            echo Modules::run('template/layout', $data);return;
        }
        $this->load->library('myupload');
        $file = $this->myupload->do_upload(FCPATH . 'uploads/temp/', 'file', true);
        if (!$file) {
            $this->session->set_flashdata('exception', 'File upload failed, try again later!');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $excel_data = $this->excel->read($file);
        $heading_row = array_shift($excel_data);
        $hrm_id_key = array_search('HRM ID', $heading_row);
        if ($hrm_id_key === false) {
            $this->session->set_flashdata('exception', 'Required "HRM ID" Column not found in sheet. Make sure first row is heading');
            redirect($_SERVER['HTTP_REFERER']);return;
        }
        $employee_rec = null;
        $this->db->trans_start();
        foreach ($excel_data as $row_num => $row_data) {
            $row_num++;
            if (emptyArray($row_data)) {
                continue;
            }
            if (empty($row_data[$hrm_id_key])) {
                $this->session->set_flashdata('exception', 'Required "HRM ID" Column empty on row #' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            } else {
                $employee_rec = $this->db->select('*')
                    ->where('hrm_id', trim($row_data[$hrm_id_key]))
                    ->from('employee_history')
                    ->get()
                    ->row();
                if (!$employee_rec) {
                    $this->session->set_flashdata('exception', 'HRM ID "' . trim($row_data[$hrm_id_key]) . '" doesn\'t exist from row# ' . $row_num);
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
                $employee_rec = decrypt_employee_data($employee_rec);
            }
            $year = date('Y');
            foreach ($heading_row as $head_key => $head_value) {
                if ($head_key == $hrm_id_key) {
                    continue;
                }
                if (empty(trim($row_data[$head_key])) && trim($row_data[$head_key]) != '0') {
                    continue;
                }

                $original_leave = $head_value;
                $head_value = str_replace(' ', '_', trim($head_value));
                $head_value = preg_replace('/[^\w\d]+/', '%', $head_value);
                $leave_type = getByWhereAsArray('leave_type', 'leave_type_id id', [], [], 0, 0, ['leave_type' => $head_value]);

                if ($leave_type) {
                    $leave_type = $leave_type[0]['id'];
                } else {
                    $this->session->set_flashdata('exception', 'Leave type "' . $original_leave . '" not found in database on row# ' . $row_num);
                    redirect($_SERVER['HTTP_REFERER']);return;
                }

                $this->db->delete('employee_leaves', [
                    'emp_id' => $employee_rec->employee_id,
                    'leave_type' => $leave_type,
                    'year' => $year,
                ]);
                $this->db->insert('employee_leaves', [
                    'emp_id' => $employee_rec->employee_id,
                    'year' => $year,
                    'leave_type' => $leave_type,
                    'leave_qouta' => floatval($row_data[$head_key]),
                ]);
            }
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() === false) {
            $this->session->set_flashdata('exception', 'Error updating leaves, try again later');
        } else {
            $this->session->set_flashdata('message', 'Leave records updated successfully');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function leave_update_sample()
    {
        $this->permission->method('bulk_leave_update', 'create')->redirect();
        $header = getByWhereAsArray('leave_type', 'leave_type name', [], ['leave_type', 'ASC']);
        if (!$header) {
            $header = [];
        }
        $header = array_column($header, 'name');
        array_unshift($header, 'HRM ID');
        return $this->better_excel->download($header, [], [], [], [], display(['bulk', 'leaves', 'import', 'sample']), 'A2', [], 100, true);
    }
    public function download_update_sample()
    {
        if($fields = $this->input->post('fields')) {
            $cols = $this->get_update_labels();
            $sheet_header = ['HRM ID'];
            if(in_array('all', $fields)) {
                $sheet_header = array_merge($sheet_header, $cols);
            } else {
                foreach ($fields as $value) {
                    $sheet_header[] = $cols[$value];
                }
            }
            $this->load->library('better_excel');
            $this->better_excel->download($sheet_header, [], [], [], [], 'Employees Bulk Update Sample - ' . formatted_date_now(), 'A2', [], 90, true);
        }
    }
    private function get_update_labels()
    {
        $data = [
            'First Name',
            'Middle Name',
            'Last Name',
            'Father Name',
            'Phone',
            'Alternative Phone',
            'Country',
            'City',
            'Division',
            'Department',
            'Designation',
            'Duty Type',
            'Probation Period (Months)',
            'Contract Period (months)',
            'Shift',
            'Hire Date',
            'Original Hire Date',
            'Separation Date',
            'Separation Reason',
            'Voluntary Resignation',
            'Rehire Date',
            'Salary Type',
            'Performance Review Duration (Months)',
            'Hired Salary',
            'Deduct Provident Fund',
            'EOBI',
            'EOBI Amount',
            'Is Supervisor',
            'Direct Reporting To',
            'Indirect Reporting To',
            'Date of Birth',
            'Gender',
            'Marital Status',
            'Religion',
            'CNIC',
            'CNIC Expiry Date',
            'Personal Email',
            'Business Email',
            'Home Phone',
            'Emergency Contact Name',
            'Emergency Contact Relation',
            'Emergency Contact Number',
            'Cell Phone',
            'Present Address',
            'Permanent Address',
            'Work From Home',
            'Transportation Required',
            'Password',
            'Role',
            'Prefix',
            'Primary Project',
            'Team',
            'Campaign',
            'Pseudo',
            'Medflow ID',
            'Skype ID',
            'Hiring In Replacement Of',
            'Last Degree',
            'Passing Date',
            'CGPA / DIV / %',
            'Institute',
            'Last Employer',
            'Last Employer Address',
            'Account Title',
            'Account Number',
            'Account IBAN',
            'Branch Code',
            'Branch Address',
            'Employee Status',
            'Exit Interview Conducted',
            'Exit Interview Date',
            'Exit Interview Details',
            'First COVID Vaccine Dose',
            'Second COVID Vaccine Dose',
            'Domain Username',
            'Domain Password',
        ];
        sort($data);
        return $data;
    }
}
