<div class="container-fluid">
    <?php if($id == $this->session->userdata('id')): ?>
    <div class="row">
        <div class="col-sm-12 text-right">
            <button type="button" class="btn btn-primary btn-logout"
                data-user="<?= $id ?>"><?= display(['sign', 'out', 'of', 'all', 'other', 'devices'], true) ?></button>
        </div>
    </div>
    <br>
    <?php endif?>
    <div class="row">
        <div class="col-sm-12">
            <table class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th><?= display('ip_address') ?></th>
                        <th><?= display('System') ?></th>
                        <th><?= display('browser') ?></th>
                        <th><?= display(['last', 'activity']) ?></th>
                        <th><?= display('action') ?></th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
<script>
$(document).ready(function() {
    window.dtable = $('table.table').DataTable($.extend({},
        window.default_datatable_opts, {
            responsive: false,
            ordering: false,
            searching: false,
            paging: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'post',
                beforeSend: function() {},
                complete: function() {}
            },
            columns: [{
                'data': 'ip_address',
            }, {
                'data': 'platform',
            }, {
                'data': 'browser',
            }, {
                'data': 'last_active',
            }, {
                'data': 'action',
                'sortable': false
            }, ],
            order: [
                [0, 'desc']
            ]
        }
    ))
    $(document).on('click', 'button.btn-logout', function(e) {
        e.preventDefault();
        let $btn = $(this);
        let $badge = $('.badge-session-count');
        myajax({
            type: "POST",
            url: "<?= base_url() ?>dashboard/user/session_quit",
            data: {
                id: $btn.data('id'),
                user: $btn.data('user')
            },
            success: function(res) {
                if (res.success) {
                    if($btn.data('id')) {
                        $badge.text(parseInt($badge.text()) - 1);
                    } else {
                        $badge.text(1);
                    }
                    Swal.fire(
                        '<?= display(['signed', 'out']) ?>!',
                        res.message,
                        'success'
                    )
                } else {
                    Swal.fire(
                        '<?= display(['signed', 'out']) ?>!',
                        res.error ??
                        '<?= display(['invalid', 'server', 'response'], true) ?>',
                        'error'
                    )
                }
                window.dtable.ajax.reload();
            }
        });
    })
});
</script>