<?php $this->load->view('dashboard/partials/angular') ?>
<script>
hrmApp.controller('dashboard_ctrl', function($scope, $http, $interval, $cookies, $uibModal) {
    $scope.get_saved_chart_type = function() {
        let obj = $cookies.getObject('hrm_dashboard_chart_type')
        if(obj) {
            if(obj.id == '<?=$this->session->userdata('id')?>') {
                return obj.type
            }
            $cookies.remove('hrm_dashboard_chart_type')
        }
        return null
    }
    $scope.employees = {
        loading: false,
        data: {},
        error: null
    }
    $scope.summary = {
        loading: false,
        data: {},
        error: null
    }
    $scope.this_month = {
        loading: false,
        attrition_rate: -1,
        data: {},
        error: null
    }
    $scope.attendance = {
        worked_hours: 0,
        checked_in: false,
        work_timer: null,
        loading: true,
        error: null
    }
    $scope.leave_types = {
        loading: false,
        data: [],
        error: null
    }
    $scope.departments = {
        loading: false,
        data: []
    }
    $scope.notices = {
        loading: false,
        error: null,
        data: [],
        page: 0,
        limit: 7,
        end: false,
        previous: () => {
            if($scope.notices.page > 0) {
                $scope.notices.end = false;
                $scope.notices.page--;
                $scope.notices._load()
            }
        },
        next: () => {
            if($scope.notices.data.length == $scope.notices.limit) {
                $scope.notices.page++;
                $scope.notices._load()
            }
        },
        _load: () => {
            $scope.notices.loading = true;
            $http.get('<?= base_url('dashboard/home/stats') ?>', {params: {type: 'notices', page: $scope.notices.page, limit: $scope.notices.limit}})
            .then((res) => {
                $scope.notices.loading = false;
                if(res.data && res.data.notices) {
                    if(res.data.notices && res.data.notices.posts.length > 0) {
                        $scope.notices.data = res.data.notices.posts
                    }
                    if(res.data.notices && res.data.notices.next < 1) {
                        $scope.notices.end = true;
                    }
                }
            }, () => {
                $scope.notices.loading = false;
                $scope.notices.error = '<?= display('unable_load_notices') ?>';
            })
        }
    }
    $scope.leaves = {
        total: 0
    }
    $scope.overview = {
        labels: [],
        data: []
    }
    $scope.pie = {
        colors: ['#C8E6C9', '#FFC0CB', '#803690', '#00ADF9', '#DCDCDC', '#FF0000', '#FFE0B2', '#FDB45C', '#949FB1', '#4D5360'],
        options: {
            animationEnabled: true,
            title: {
                display: true,
                fontColor: "#607D8B",
                fontSize: 15,
                fontFamily: 'serif',
                text: "<?= display('present_employees') ?>"
            },
            legend: {
                display: true,
                position: 'right'
            }
        },
        type: $scope.get_saved_chart_type() ?? 'pie',
        dropdown: []
    }
    $scope.type_details = {}
    $scope.change_chart = function() {
        switch ($scope.pie.type) {
            case 'pie':
            case 'doughnut':
            case 'polarArea':{
                $scope.pie.options.legend.display = true
                break;
            }
            default: {
                $scope.pie.options.legend.display = false
                break;
            }
        }
        $cookies.putObject('hrm_dashboard_chart_type', {type: $scope.pie.type, id: '<?=$this->session->userdata('id')?>'}, {
            'expires':"Mon, 31 Dec 9999 23:59:59 GMT"
        })
    }
    $scope.chart_departments = function(item) {
        $scope.pie.options.title.text = `${item.label}`;
        $scope.pie.labels = Object.keys(item.attendance).map((str) => {
                    return str.replace(/[\_\-]+/gi, '_').split('_').map((s) => {
                        return s.charAt(0).toUpperCase() + s.substr(1)
                    }).join(' ')
                })
        $scope.pie.data = Object.values(item.attendance)
    }
    <?php if($this->permission->method('manage_employee', 'update')->access() || $this->session->userdata('supervisor')):?>
    $scope.fetch_employees = function() {
        $scope.employees.loading = true
        $http.get('<?=base_url('dashboard/home/stats')?>', {params: {type: 'employees'}}).then((res) => {
            $scope.employees.loading = false;
            if (res.data) {
                $scope.employees.data = res.data.employees
            }
        }, () => {
            $scope.employees.loading = false;
            $scope.employees.error = '<?= display('unable_load_stats') ?>'
        })
    }
    $scope.fetch_attendance = function() {
        $scope.summary.loading = $scope.leave_types.loading = true
        $http.get('<?=base_url('dashboard/home/stats')?>', {params: {type: 'attendance,departments'}}).then((res) => {
            $scope.summary.loading = $scope.leave_types.loading = false;
            if (res.data) {
                $scope.summary.data = res.data.attendance.summary
                $scope.leave_types.data = res.data.attendance.leave_types
                $scope.departments.data = res.data.departments
                $scope.pie.dropdown = angular.copy(res.data.departments)
                $scope.pie.dropdown.unshift({
                    label: 'All Departments',
                    attendance: angular.copy(res.data.attendance.summary)
                })
                $scope.selected_chart_department = $scope.pie.dropdown[0]
                if (res.data.attendance.summary.paid_leave) {
                    $scope.leaves.total = res.data.attendance.summary.paid_leave
                }
                $scope.pie.labels = $scope.overview.labels = Object.keys(res.data.attendance.summary).map((str) => {
                    return str.replace(/[\_\-]+/gi, '_').split('_').map((s) => {
                        return s.charAt(0).toUpperCase() + s.substr(1)
                    }).join(' ')
                })
                $scope.pie.data = $scope.overview.data = Object.values(res.data.attendance.summary)
            }
        }, () => {
            $scope.summary.loading = $scope.leave_types.loading = false;
            $scope.summary.error = $scope.leave_types.error = '<?= display('unable_load_stats') ?>'
        })
    }
    $scope.fetch_this_month = function() {
        $scope.this_month.loading = true
        $http.get('<?=base_url('dashboard/home/stats')?>', {params: {type: 'this_month,attrition_rate'}}).then((res) => {
            $scope.this_month.loading = false;
            if (res.data) {
                $scope.this_month.data = res.data.this_month
                $scope.this_month.attrition_rate = res.data.attrition_rate
            }
        }, () => {
            $scope.this_month.loading = false;
            $scope.this_month.error = '<?= display('unable_load_stats') ?>'
        })
    }
    $scope.fetch_employees()
    $scope.fetch_attendance()
    $scope.fetch_this_month()
    $scope.change_chart()
    <?php endif ?>
    <?php if($this->session->userdata('employee_id')): ?>
    $scope.fetch_work_time = function() {
        $http.get('<?=base_url('dashboard/home/stats')?>', {params: {type: 'work_time'}}).then((res) => {
            if (!res.data) {
                console.log('Error no data received');
                return
            }
            let remote_worked_hours = res.data.work_time.reduce((sum, item) => {
                return sum + parseInt(item.duration)
            }, 0);
            if($scope.attendance.worked_hours > 0 && Math.abs(remote_worked_hours - $scope.attendance.worked_hours) > 300) {
                $scope.attendance.worked_hours = remote_worked_hours;
            } else {
                $scope.attendance.worked_hours = remote_worked_hours;
            }
            $scope.attendance.checked_in = res.data.work_time.some((item) => {
                return item.punchout_time == null
            });
            $scope.attendance.work_timer && $interval.cancel($scope.attendance.work_timer);
            if (res.data.work_time && $scope.attendance.checked_in) {
                $scope.attendance.work_timer = $interval(() => {
                    $scope.attendance.worked_hours++;
                }, 1000);
            }
            $scope.attendance.loading = false;
        }, () => {
            console.log('Attendance fetch failed');
        })
    }
    $interval($scope.fetch_work_time, 60000)
    $scope.fetch_work_time()
    <?php endif ?>
    $scope.show_stat_detail = function(type, key) {
        if(type == 'employee') {
            switch (key) {
                case 'total':
                    return;
                    break;
            }
        }
        if(!$scope.type_details[type]) {
            $scope.type_details[type] = {}
        }
        if(!$scope.type_details[type][key]) {
            $scope.type_details[type][key] = {
                loading: false,
                data: null,
                error: null
            }
        }
        if($scope.type_details[type][key].loading) {
            return
        }
        $scope.type_details[type][key].loading = true
        if($scope.type_details[type][key].data) {
            $uibModal.open({
                templateUrl: 'myModalContent.html',
                controller: function ($uibModalInstance, title, headings, items) {
                    var dm = this;
                    dm.title = title;
                    dm.headings = headings;
                    dm.items = items;

                    dm.close = function () {
                        $uibModalInstance.dismiss('cancel');
                    };
                },
                size: 'lg',
                controllerAs: 'dm',
                resolve: {
                    title: () => {
                        return $scope.type_details[type][key].data.title;
                    },
                    headings: () => {
                        return $scope.type_details[type][key].data.headings;
                    },
                    items: () => {
                        return $scope.type_details[type][key].data.items
                    }
                }
            }).result.then(() => {}, () => {})
            $scope.type_details[type][key].loading = false
        } else {
            $http.post('<?= base_url('dashboard/home/details') ?>', {type, key}).then((res) => {
                $scope.type_details[type][key].loading = false;
                if(res.data.success) {
                    $scope.type_details[type][key].data = res.data.success
                    $uibModal.open({
                        templateUrl: 'myModalContent.html',
                        controller: function ($uibModalInstance, title, headings, items) {
                            var dm = this;
                            dm.title = title;
                            dm.headings = headings;
                            dm.items = items;

                            dm.close = function () {
                                $uibModalInstance.dismiss('cancel');
                            };
                        },
                        size: 'lg',
                        controllerAs: 'dm',
                        resolve: {
                            title: () => {
                                return $scope.type_details[type][key].data.title;
                            },
                            headings: () => {
                                return $scope.type_details[type][key].data.headings;
                            },
                            items: () => {
                                return $scope.type_details[type][key].data.items
                            }
                        }
                    }).result.then(() => {}, () => {})
                }
            }, () => {
                $scope.type_details[type][key].loading = false;
                alert('<?= display('unable_load_stats') ?>')
            })
        }
    }
    $scope.notices._load()
})
</script>