<style type="text/css">
/*Graph/Chart Styling*/
.pretty .state label{display: flex;}

@media only screen and (min-width:1600px)
{
.chart-base.ng-isolate-scope {max-width: 75% !important;}
}

@media only screen and (min-width:1200px)
{
 .fixed-height-panel {
    min-height: 450px;
    max-height: 450px;
}
.chart-base.ng-isolate-scope {
    width: 100% !important;
    height: 100% !important;
    margin-left: auto;
    margin-right: auto;
}
#pie-panel{position:relative;}
#pie-panel .panel-footer{position: absolute;bottom: 0px;width: 100%;}

}

@media only screen and (max-width:1199px) and (min-width:992px)
{
.chart-base.ng-isolate-scope {
    width: 75% !important;
    height: 100% !important;
    margin-left: auto;
    margin-right: auto;
}
}

@media only screen and (max-width:991px) and (min-width:640px)
{
#stat-panels{display: grid;
grid-template-columns: 50% 50%;}
#stat-panels::before,#stat-panels::after{display:none;}

}



#ui-datepicker-div {
    top: 317px;
    left: 1081.75px;
    display: block;
    width: 180px;
    z-index: 1;
}
.chart_type_switch label {
    font-size: 12px;
}
.ui-datepicker-calendar {
    display: none;
}

.ui-datepicker-title {
    width: 100%;
    float: center;
}

.box-widget {
    border: none;
    position: relative;
}
.box {
    position: relative;
    border-radius: 3px;
    background: #ffffff;
    border-top: 3px solid #d2d6de;
    margin-bottom: 20px;
    width: 100%;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
}
.box-widget .widget-user-header {
    padding: 20px;
    border-top-right-radius: 3px;
    border-top-left-radius: 3px;
}

.widget-user-desc {
    margin-left: 75px;
    color:#fff;
    margin-top: 15px;
    margin-bottom: 15px;
    white-space: nowrap;
}
.widget-user-username {
    margin-top: 5px;
    margin-bottom: 5px;
    font-size: 20px;
    font-weight: 300;
    color:#fff;
    white-space: nowrap;
}
.widget-user-image>i {
    width: 65px;
    height: auto;
    float: left;
    font-size: 50px;
}
.no-padding {
    padding: 0 !important;
}
.box-footer {
    border-top-left-radius: 0;
    border-top-right-radius: 0;
    border-bottom-right-radius: 3px;
    border-bottom-left-radius: 3px;
    border-top: 1px solid #f4f4f4;
    padding: 10px;
    background-color: #fff;
}
.box .nav-stacked>li {
    border-bottom: 1px solid #f4f4f4;
    margin: 0;
}
.box .nav-stacked>li:first-child {
    border-bottom: 1px solid black;
}
.nav-stacked>li>a {
    border-radius: 0;
    border-top: 0;
    border-left: 3px solid transparent;
    color: #444;
}
.payment {
    max-height: 450px;
    overflow-y: auto;
}
.active_date_event,
.date_event {
    background-color: orange;
 /*   height: fit-content !important;*/
}
.active_date_event>.event,
.date_event>.event{
    color: white;
    font-size: 10px;
    text-align: left;
    margin-left: 0px;
    font-weight: normal;
}
#stat-panels i.fa {
    font-size: 10px;
    color: #05253a;
}
.lds-ellipsis {
  display: inline-block;
}
.lds-ellipsis div {
  position: absolute;
  width: 13px;
  height: 13px;
  border-radius: 50%;
  background: #000;
  animation-timing-function: cubic-bezier(0, 1, 1, 0);
  top: 12px
}
.lds-ellipsis div:nth-child(1) {
  left: 8px;
  animation: lds-ellipsis1 0.6s infinite;
}
.lds-ellipsis div:nth-child(2) {
  left: 8px;
  animation: lds-ellipsis2 0.6s infinite;
}
.lds-ellipsis div:nth-child(3) {
  left: 32px;
  animation: lds-ellipsis2 0.6s infinite;
}
.lds-ellipsis div:nth-child(4) {
  left: 56px;
  animation: lds-ellipsis3 0.6s infinite;
}
@keyframes lds-ellipsis1 {
  0% {
    transform: scale(0);
  }
  100% {
    transform: scale(1);
  }
}
@keyframes lds-ellipsis3 {
  0% {
    transform: scale(1);
  }
  100% {
    transform: scale(0);
  }
}
@keyframes lds-ellipsis2 {
  0% {
    transform: translate(0, 0);
  }
  100% {
    transform: translate(24px, 0);
  }
}
#noticeboard li{
    border-bottom: 1px solid;
    padding: 3px 0px;
}
#pie-panel {
    overflow: visible;
}
.counter-hours .timer {
    top: 12px
}
.counter-hours .card-details {
    width: fit-content;
    margin-top: 12px;
}
.bg-danger-panel {
    background-color: #d04f58e6;
}
</style>
<div class="se-pre-con">
    <div class="loader">Loading...</div>
</div>
<div ng-controller="dashboard_ctrl">
    <?php if($this->session->userdata('employee_id')): ?>
    <div class="row counter-hours">
        <div class="col-xs-12">
            <div class="panel cardbox bg-success">
                <div class="panel-body card-item panel-refresh">
                <div class="refresh-container" ng-show="attendance.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                    <div class="cardbox-icon">
                        <i class="material-icons">schedule</i>
                    </div>
                    <div class="card-details">
                        <h4><?= display('today_worked_hour') ?></h4>
                    </div>
                    <div class="timer">{{attendance.worked_hours | formatTimer}}</div>
                    <div ng-show="attendance.checked_in"><br>Checked In</div>
                    <div ng-hide="attendance.checked_in"><br>Checked Out</div>
                </div>
            </div>
        </div>
    </div>
    <?php endif?>
    <?php if($this->permission->method('manage_employee', 'update')->access() || $this->session->userdata('supervisor')):?>
    <div class="row" id="stat-panels" class="stat_panels_section">
        <div class="col-md-3">
            <div class="box box-widget widget-user-2">
                <div class="refresh-container" ng-show="employees.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                <div class="widget-user-header bg-primary">
                    <div class="widget-user-image">
                        <i class="material-icons">people</i>
                    </div>
                    <h5 class="widget-user-desc"><?= display('total_employees') ?></h5>
                </div>
                <div class="box-footer no-padding">
                    <ul class="nav nav-stacked" ng-hide="employees.error">
                        <li ng-repeat="(key, value) in employees.data">
                            <a href="#" ng-click="show_stat_detail('employee', key);$event.preventDefault();">
                                <div ng-show="type_details['employee'][key].loading" class="lds-ellipsis"><div></div><div></div><div></div><div></div></div>
                                <span ng-hide="type_details['employee'][key].loading">{{key | slug_to_readable}} <i ng-if="key != 'total'" class="fa fa-external-link" aria-hidden="true"></i></span><span class="pull-right badge bg-red">{{value}}</span>
                            </a>
                        </li>
                    </ul>
                    <p ng-show="employees.error" class="error">{{employees.error}}</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="box box-widget widget-user-2">
                <div class="refresh-container" ng-show="summary.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                <div class="widget-user-header bg-warning">
                <div class="widget-user-image">
                    <i class="material-icons">schedule</i>
                </div>
                <h5 class="widget-user-desc"><?= display('present_employees') ?></h5>
                </div>
                <div class="box-footer no-padding">
                    <ul class="nav nav-stacked" ng-hide="summary.error">
                        <li ng-repeat="(key, value) in summary.data" ng-if="value > 0">
                            <a href="#" ng-click="show_stat_detail('attendance', key);$event.preventDefault();">
                                <div ng-show="type_details['attendance'][key].loading" class="lds-ellipsis"><div></div><div></div><div></div><div></div></div>
                                <span ng-hide="type_details['attendance'][key].loading">{{key | slug_to_readable}} <i class="fa fa-external-link" aria-hidden="true"></i></span><span class="pull-right badge bg-red">{{value}}</span>
                            </a>
                        </li>
                    </ul>
                    <p ng-show="summary.error" class="error">{{summary.error}}</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="box box-widget widget-user-2">
                <div class="refresh-container" ng-show="summary.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                <div class="widget-user-header bg-success">
                <div class="widget-user-image">
                    <i class="material-icons">perm_contact_calendar</i>
                </div>
                <h5 class="widget-user-desc"><?= display('leave_employees') ?></h5>
                </div>
                <div class="box-footer no-padding">
                    <ul class="nav nav-stacked" ng-hide="leave_types.error">
                        <li ng-if="leave_types.data.length != 1">
                            <a href="#" ng-click="leaves.total > 0 && show_stat_detail('leave', 'all');$event.preventDefault();">
                                <div ng-show="type_details['leave']['all'].loading" class="lds-ellipsis"><div></div><div></div><div></div><div></div></div>
                                <span ng-hide="type_details['leave']['all'].loading">Total <i ng-if="leaves.total > 0" class="fa fa-external-link" aria-hidden="true"></i></span><span class="pull-right badge bg-red" >{{leaves.total}}</span>
                            </a>
                        </li>
                        <li ng-repeat="leave_type in leave_types.data">
                            <a href="#" ng-click="show_stat_detail('leave', leave_type.id);$event.preventDefault();">
                                <div ng-show="type_details['leave'][leave_type.id].loading" class="lds-ellipsis"><div></div><div></div><div></div><div></div></div>    
                                <span ng-hide="type_details['leave'][leave_type.id].loading">{{leave_type.label | slug_to_readable}} <i class="fa fa-external-link" aria-hidden="true"></i></span><span class="pull-right badge bg-red">{{leave_type.count}}</span>
                            </a>
                        </li>
                    </ul>
                    <p ng-show="leave_types.error" class="error">{{leave_types.error}}</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="box box-widget widget-user-2">
                <div class="refresh-container" ng-show="this_month.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                <div class="widget-user-header bg-danger-panel">
                <div class="widget-user-image">
                    <i class="material-icons">event_available</i>
                </div>
                <h5 class="widget-user-desc"><?= display('this_month') ?></h5>
                </div>
                <div class="box-footer no-padding">
                    <ul class="nav nav-stacked" ng-hide="this_month.error">
                        <li ng-repeat="(key, val) in this_month.data">
                            <a href="#" ng-click="val && show_stat_detail('this_month', key);$event.preventDefault();">
                                <div ng-show="type_details['this_month'][key].loading" class="lds-ellipsis"><div></div><div></div><div></div><div></div></div>
                                <span ng-hide="type_details['this_month'][key].loading">{{key | slug_to_readable}} <span ng-show="key == 'separations' && this_month.attrition_rate >= 0">({{this_month.attrition_rate}}%)</span> <i ng-show="val" class="fa fa-external-link" aria-hidden="true"></i></span><span class="pull-right badge bg-red">{{val}}</span>
                            </a>
                        </li>
                    </ul>
                    <p ng-show="this_month.error" class="error">{{this_month.error}}</p>
                </div>
            </div>
        </div>
    </div>
    <?php endif?>
    <div class="row d-md-flex align-items-center">
        <?php if($this->permission->method('manage_employee', 'update')->access() || $this->session->userdata('supervisor')):?>
        <div class="col-md-12 col-lg-6">
            <div class="refresh-container" ng-show="summary.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
            <div class="panel panel-bd fixed-height-panel" id="pie-panel">
                <div class="panel-heading">
                    Attendance Overview
                </div>
                <div class="panel-body" ng-hide="summary.error">
                    <ui-select ng-if="pie.dropdown.length > 2" ng-model="selected_chart_department" on-select="chart_departments($item)">
                        <ui-select-match>
                            <span ng-bind="$select.selected.label"></span>
                        </ui-select-match>
                        <ui-select-choices repeat="department in (pie.dropdown | filter: $select.search) track by $index">
                            <span ng-bind="department.label"></span>
                        </ui-select-choices>
                    </ui-select>
                    <canvas class="chart-base" chart-type="pie.type" chart-colors="pie.colors" chart-data="pie.data" chart-labels="pie.labels" chart-options="pie.options" style="width:300px;height:300px"></canvas>
                </div>
                <div class="panel-footer">
                    <div class="chart_type_switch" ng-hide="summary.error">
                        <div class="pretty p-default p-curve">
                            <input type="radio" ng-model="pie.type" ng-change="change_chart()" value="pie"/>
                            <div class="state p-primary-o">
                                <label>Pie Chart</label>
                            </div>
                        </div>
                        <div class="pretty p-default p-curve">
                            <input type="radio" ng-model="pie.type" ng-change="change_chart()" value="doughnut"/>
                            <div class="state p-info-o">
                                <label>Doughnut Chart</label>
                            </div>
                        </div>
                        <div class="pretty p-default p-curve">
                            <input type="radio" ng-model="pie.type" ng-change="change_chart()" value="bar"/>
                            <div class="state p-success-o">
                                <label>Bar Chart</label>
                            </div>
                        </div>
                        <div class="pretty p-default p-curve">
                            <input type="radio" ng-model="pie.type" ng-change="change_chart()" value="horizontalBar"/>
                            <div class="state p-danger-o">
                                <label>Horizontal Bar Chart</label>
                            </div>
                        </div>
                    </div>
                    <p ng-show="summary.error" class="error">{{summary.error}}</p>
                </div>
            </div>
        </div>
        <?php endif?>
        <div id="noticeboard" class="col-md-12 col-lg-<?= ($this->permission->method('manage_employee', 'update')->access() || $this->session->userdata('supervisor')) ? 6 : 12 ?>">
            <div class="panel panel-bd fixed-height-panel">
                <div class="panel-heading">
                    <div class="panel-title"><?= display('noticeboard') ?></div>
                </div>
                <div class="panel-body">
                    <div class="refresh-container" ng-show="notices.loading"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
                    <ul class="nav nav-stacked" ng-hide="notices.error">
                        <li ng-repeat="notice in notices.data track by $index">
                            <a href="<?= base_url('noticeboard/Notice_controller/view_details/') ?>{{notice.id}}">
                                {{notice.title}} <span ng-show="notice.viewed < 1" class="blink-text" style="color: red">New</span>
                            </a>
                        </li>
                    </ul>
                    <div style="margin-top: 10px;">
                        <a ng-show="notices.page > 0" href="#" ng-click="notices.previous();$event.preventDefault();"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</a>
                        <a ng-hide="notices.end" class="pull-right" href="#" ng-click="notices.next();$event.preventDefault();">Next <i class="fa fa-arrow-right" aria-hidden="true"></i></a>
                    </div>
                    <p ng-show="notices.error" class="error">{{notices.error}}</p>
                </div>
            </div>
       </div>
    </div>
    <div class="row">
        <!-- Radar Chart -->
        <div class="col-sm-12 col-md-12">
            <div class="refresh-container" id="calendar-spinner" style="display: none;"><i class="refresh-spinner fa fa-spinner fa-spin fa-5x"></i></div>
            <div class="panel panel-bd lobidisable">
                <div class="panel-body">
                    <div class="calendar"><?php echo $notes ?></div>
                </div>
            </div>
        </div><!-- Calender -->
    </div>
</div>
<?php if(@$promo_video) : ?>
<?php if($promo_video['size'] == 'small' ): ?>
<div class="modal fade" id="modal-video" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header" style="padding: 2px 10px;">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
            </div>
            <div class="modal-body">
                <div class="embed-responsive embed-responsive-4by3" style="padding-bottom: 100%">
                    <video controls muted loop autoplay src="<?= base_url() ?>uploads/video/<?= $promo_video['file'] ?>"></video>
                </div>
            </div>
        </div>
    </div>
</div>
<?php elseif ($promo_video['size'] == 'large') :?>
<div class="modal fade" id="modal-video" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <video style="width:100%" controls muted loop autoplay src="<?= base_url() ?>uploads/video/<?= $promo_video['file'] ?>"></video>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<?php endif?>
<script>
    $(document).ready(function () {
        $('#modal-video').modal('show')
    });
</script>
<?php endif?>
<div class="modal fade" id="leaveDetail" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <span class="s_date" style="padding-left: 10px;color:white;font-family:serif;">
                        <?php echo display('details') ?> for <span class="calendar_name"><?php echo "$month $day, $year"; ?></span>
                    </span>
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="panel panel-bd lobidisable">
                    <div class="panel-body" style="padding-top: 0px">
                        <h4 class="text-center"></h4>
                        <h4 style="color: #78909C;font-family:serif;"><b><?=display('leaves')?></b></h4>
                        <div class="payment">
                            <div class="detail_leave"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/ng-template" id="myModalContent.html">
    <div class="modal-header">
        <h3 class="modal-title">{{dm.title}}</h3>
    </div>
    <div class="modal-body">
        <table class="table table-striped table-inverse table-responsive">
            <thead class="thead-inverse">
                <tr>
                    <th ng-repeat="heading in dm.headings track by $index">{{heading}}</th>
                </tr>
            </thead>
            <tbody>
                <tr ng-repeat="tds in dm.items track by $index">
                    <td ng-repeat="td in tds track by $index">{{td}}</td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="modal-footer">
        <button class="btn btn-warning" ng-click="dm.close()">close</button>
    </div>
</script>

<?php $this->load->view('dashboard/scripts/dashboard') ?>
<script>
    var calendar = {
        month: <?= intval($mon) ?>,
        year: <?= intval($year) ?>,
        full_month: '<?= $month ?>'
    }
    $(document).ready(function () {
        $(".calendar").on('click', '.detail', function() {
            $(".s_date").html(`Details of ${$(this).attr('val')} ${calendar.full_month} ${calendar.year}`);
            var $this = $(this)
            var day = $(this).attr('val');
            var add = '<input type="hidden" name="add" value="Add New" val="' + day + '" class="add_event"/>';
            $.ajax({
                type: 'post',
                dataType: 'json',
                url: "<?php echo site_url("dashboard/home/detail_leave"); ?>",
                data: {
                    year: calendar.year,
                    mon: calendar.month,
                    day: day
                },
                beforeSend: function() {
                    $('#calendar-spinner').show()
                },
                complete: function() {
                    $('#calendar-spinner').hide()
                },
                success: function(data) {
                    var $modal = $('#leaveDetail');
                    $this.closest('table').find('.active_no_event').removeClass('active_no_event').addClass('no_event')
                    $this.addClass('active_no_event')
                    var html = '<div class="info5"><table class="table table-bordered"><thead><tr><th>Employee Name</th><th>Leave Day</th><th>Leave finish</th></tr></thead><tbody>';
                    if (data.status) {
                        var i = 1;
                        $.each(data.data, function(index, value) {
                            if (i % 2 == 0) {
                                html +=`<tr><td>${value.first_name} ${value.last_name} (${value.hrm_id})</td><td>` + value
                                    .num_aprv_day + '</td><td>' + moment(value.leave_aprv_end_date).format('DD-MM-YYYY') +
                                    '</td></tr>';
                            } else {
                                html = html +
                                    `<tr><td>${value.first_name} ${value.last_name} (${value.hrm_id})</td><td>` + value
                                    .num_aprv_day + '</td><td>' + moment(value.leave_aprv_end_date).format('DD-MM-YYYY') +
                                    '</td></tr>';
                            }
                            i++;
                        });
                    } else {
                        html = '<div class="message"><h4>' + data.title_msg + '</h4><p>' + data.msg +
                            '</p></div>';
                    }
                    html += '</tbody></table></div>';
                    $modal.find(".detail_leave").html(html);
                    $modal.modal('show')
                }
            });
        });
        $('.calendar').on('click', '.next_date, .prev_date', function () {
            let date = this.href.split('/');
            let month = date.pop()
            let year = date.pop()
            $.ajax({
                type: "POST",
                data: {
                    month: month,
                    year: year
                },
                beforeSend: function() {
                    $('#calendar-spinner').show()
                },
                complete: function() {
                    $('#calendar-spinner').hide()
                },
                success: function (res) {
                    if(res.success) {
                        calendar.month = res.success.month;
                        calendar.year = res.success.year;
                        calendar.full_month = res.success.full_month;
                        $('.calendar_name').text(`${calendar.full_month} 01, ${calendar.year}`)
                        $('.calendar').html(res.success.html)
                    }
                }
            });
        });
    });
</script>