<?php defined('BASEPATH') or exit('No direct script access allowed');
class Evencal_model extends CI_Model
{
    // for get all event date in one month
    public function getDateEvent($year, $month)
    {
        $year = ($month < 10 && strlen($month) == 1) ? "$year-0$month" : "$year-$month";
        $query = $this->db->select('date_of_approve,sum(amount) as amount')->from('grand_loan')->like('date_of_approve', $year, 'after')->get();
        if ($query->num_rows() > 0) {
            $data = array();
            foreach ($query->result_array() as $row) {
                $ddata = explode('-', $row['date_of_approve']);
                $data[(int) end($ddata)] = [];
            }
            return $data;
        } else {
            return false;
        }
    }
    // get Attendance detail for selected date
    public function getEvent($year, $month, $day)
    {
        $day = ($day < 10 && strlen($day) == 1) ? "$day" : $day;
        $year = ($month < 10 && strlen($month) == 1) ? "$year-$month-$day" : "$year-$month-$day";
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        $this->db->select("count(DISTINCT(e.atten_his_id)) as att_id,count(DISTINCT(p.employee_id)) 	as employee_id,d.*");
        $this->db->from('attendance_history e');
        $this->db->join('employee_history p', 'e.uid = p.employee_id', 'left')->join('department d', 'd.dept_id = p.dept_id', 'left');
        if ($admin != 1) {
            $employee_id = $this->session->userdata('employee_id');
            if ($is_supervisor == 1) {
                $this->db->where('p.super_visor_id', $employee_id);
                $this->db->or_where('p.employee_id', $employee_id);
                $this->db->or_where('p.indirect_super_visor_id', $employee_id);
            } else {
                $this->db->where('p.employee_id', $employee_id);
            }
        }
        $query = $this->db->where(array("DATE(e.time)" => $year))->group_by('d.dept_id')->get();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return null;
        }
    }
    //get Notice  detail for selected date
    public function getNotice($year, $month, $day)
    {
        $day = ($day < 10 && strlen($day) == 1) ? "0$day" : $day;
        $year = ($month < 10 && strlen($month) == 1) ? "$year-0$month-$day" : "$year-$month-$day";
        $this->db->select('notice_id as id,notice_type,notice_by');
        $this->db->from('notice_board');
        $this->db->where(array('notice_date' => $year));
        $query = $this->db->order_by('notice_id')->get();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return null;
        }
    }
    //Leave details
    public function getLeave($year, $month, $day)
    {
        $day = sprintf('%s-%s-%s', $year, $month, $day);
        if($this->permission->method('manage_employee', 'update')->access()) {
            $query = $this->db->query("SELECT 
                    leave_apply.leave_appl_id,
                    leave_apply.num_aprv_day,
                    leave_apply.leave_aprv_strt_date,
                    leave_apply.leave_aprv_end_date,
                    employee_history.hrm_id,
                    employee_history.first_name,
                    employee_history.last_name,
                    IFNULL(leave_applied_days.type, 'full_day') AS type
                FROM
                    leave_apply
                        LEFT JOIN
                    leave_applied_days ON leave_applied_days.leave_appl_id = leave_apply.leave_appl_id
                        AND leave_applied_days.day = ?
                        AND leave_applied_days.active = 1
                        LEFT JOIN
                    employee_history ON leave_apply.employee_id = employee_history.employee_id
                WHERE leave_apply.leave_aprv_strt_date <= ?
                        AND leave_apply.leave_aprv_end_date >= ?
                        AND leave_apply.hr_status = 'approved'",
                [$day, $day, $day]);
        } elseif ($this->session->userdata('supervisor')) {
            $this->load->model('employee/employees_model');
            $employee_ids = $this->employees_model->get_subordinates();
            if(!$employee_ids) {
                return null;
            }
            $employee_ids = array_column($employee_ids, 'employee_id');
            $query = $this->db->query("SELECT 
                    leave_apply.leave_appl_id,
                    leave_apply.num_aprv_day,
                    leave_apply.leave_aprv_strt_date,
                    leave_apply.leave_aprv_end_date,
                    employee_history.hrm_id,
                    employee_history.first_name,
                    employee_history.last_name,
                    IFNULL(leave_applied_days.type, 'full_day') AS type
                FROM
                    leave_apply
                        LEFT JOIN
                    leave_applied_days ON leave_applied_days.leave_appl_id = leave_apply.leave_appl_id
                        AND leave_applied_days.day = ?
                        AND leave_applied_days.active = 1
                        LEFT JOIN
                    employee_history ON leave_apply.employee_id = employee_history.employee_id
                WHERE
                    leave_apply.employee_id IN ?
                        AND leave_apply.leave_aprv_strt_date <= ?
                        AND leave_apply.leave_aprv_end_date >= ?
                        AND leave_apply.hr_status = 'approved'",
                [$day, $employee_ids, $day, $day]);
        } else {
            $query = $this->db->query("SELECT 
                    leave_apply.leave_appl_id,
                    leave_apply.num_aprv_day,
                    leave_apply.leave_aprv_strt_date,
                    leave_apply.leave_aprv_end_date,
                    employee_history.hrm_id,
                    employee_history.first_name,
                    employee_history.last_name,
                    IFNULL(leave_applied_days.type, 'full_day') AS type
                FROM
                    leave_apply
                        LEFT JOIN
                    leave_applied_days ON leave_applied_days.leave_appl_id = leave_apply.leave_appl_id
                        AND leave_applied_days.day = ?
                        AND leave_applied_days.active = 1
                        LEFT JOIN
                    employee_history ON leave_apply.employee_id = employee_history.employee_id
                WHERE
                    leave_apply.employee_id = ?
                        AND leave_apply.leave_aprv_strt_date <= ?
                        AND leave_apply.leave_aprv_end_date >= ?
                        AND leave_apply.hr_status = 'approved'",
                [$day, $this->session->userdata('employee_id'), $day, $day]);
        }
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return null;
        }
    }
    //Total leave Today
    public function leave_employee()
    {
        $year = date('Y-m-d');
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        $this->db->select("count(leave_apply.employee_id) as leave_total");
        $this->db->from('leave_apply')->where('leave_apply.leave_aprv_strt_date <=', $year);
        $this->db->join('employee_history as eh', 'eh.employee_id = leave_apply.employee_id');
        if ($admin != 1) {
            $employee_id = $this->session->userdata('employee_id');
            if ($is_supervisor == 1) {
                $this->db->where('eh.super_visor_id', $employee_id);
                $this->db->or_where('eh.employee_id', $employee_id);
                $this->db->or_where('eh.indirect_super_visor_id', $employee_id);
            } else {
                $this->db->where('eh.employee_id', $employee_id);
            }
        }
        $this->db->where('leave_aprv_end_date >=', $year);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return null;
        }
    }
//loan details
    public function getLoan($year, $month, $day)
    {
        $day = ($day < 10 && strlen($day) == 1) ? "0$day" : $day;
        $year = ($month < 10 && strlen($month) == 1) ? "$year-0$month-$day" : "$year-$month-$day";
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        $this->db->select("count(DISTINCT(ln.loan_id)) as loan_id,ln.amount,ln.loan_details,count(DISTINCT(p.employee_id)) as employee_id,p.first_name,p.last_name");
        $this->db->from('grand_loan ln');
        $this->db->join('employee_history p', 'ln.employee_id = p.employee_id', 'left');
        if ($admin != 1) {
            $employee_id = $this->session->userdata('employee_id');
            if ($is_supervisor == 1) {
                $this->db->where('p.super_visor_id', $employee_id);
                $this->db->or_where('p.employee_id', $employee_id);
                $this->db->or_where('p.indirect_super_visor_id', $employee_id);
            } else {
                $this->db->where('p.employee_id', $employee_id);
            }
        }
        $this->db->where(array("ln.date_of_approve" => $year));
        $query = $this->db->group_by('p.employee_id')->get();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return null;
        }
    }
    public function details($id)
    {
        return $this->db->select('*')
            ->from('notice_board')
            ->where('notice_id', $id)
            ->get()
            ->result();
    }
    public function get_events($month, $year, $shift_id = null)
    {
        if (!$shift_id) {
            $shift_id = $this->session->userdata('shift');
        }
        if ($shift_id) {
            $this->db->where('payroll_holiday_shift_wise.shift_id', $shift_id);
        }
        $full_date = sprintf('%s-%s-', $year, $month);
        $recs = $this->db->select('holiday_name, start_date, end_date')
            ->join('payroll_holiday_shift_wise', 'payroll_holiday.payrl_holi_id = payroll_holiday_shift_wise.payrl_holi_id', 'left')
            ->where('start_date >=', $full_date . '01')
            ->where('end_date <=', last_day_of_month($full_date . '01'))
            ->get('payroll_holiday')->result();

        $data = [];
        foreach ($recs as $rec) {
            if ($rec->start_date == $rec->end_date) {
                if (isset($data[$rec->start_date])) {
                    $data[$rec->start_date] .= ',' . $rec->holiday_name;
                } else {
                    $data[$rec->start_date] = $rec->holiday_name;
                }
            } else {
                $days = date_range($rec->start_date, $rec->end_date, '+1 day', 'Y-m-d');
                foreach ($days as $day) {
                    if (isset($data[$day])) {
                        $data[$day] = ',' . $rec->holiday_name;
                    } else {
                        $data[$day] = $rec->holiday_name;
                    }

                }
            }
        }
        foreach ($data as $key => $value) {
            $raw = explode(',', $value);
            $raw = array_unique($raw);
			sort($raw);
            $data[$key] = implode(', ', $raw);
        }
        return $data;
    }
}
