<?php defined('BASEPATH') or exit('No direct script access allowed');
class Cron_model extends CI_Model
{
    public function getWeeklyOffs()
    {
        if (!$days = $this->cache->get('cron.getweekly.offs')) {
            $rec = $this->db
                ->select('dayname, count(wk_id) as counts', false)
                ->from('weekly_holiday')
                ->group_by('dayname')
                ->order_by('counts', 'desc')
                ->limit(1)
                ->get()
                ->row();
            if (!$rec) {
                return [];
            }
            $days = explode(',', $rec->dayname);
            $this->cache->save('cron.getweekly.offs', $days, 300);
        }
        return $days;
    }
    public function getNightShiftStart()
    {
        if (!$start = $this->cache->get('cron.getNightShift.start')) {
            $rec = $this->db->select_max('start')->get('shift')->row();
            if (!$rec) {
                return date('Y-m-d') . ' 21:00:00';
            }
            $start = $rec->start;
            $this->cache->save('cron.getNightShift.start', $start, 300);
        }
        return date('Y-m-d') . ' ' . $start;
    }
    public function getLocalUploadDocuments()
    {
        return $this->db->select([
            'id',
            'documents',
        ])
            ->from('upload_documents_drive_ids')
            ->where(['drive_id' => null, 'IFNULL(skip, 0) =' => 0])
            ->order_by('id', 'asc')
            ->limit(20)
            ->get()
            ->result();
    }
    public function setLocalUploadDocumentsDriveId($id, $drive_id, $skip = 0)
    {
        return $this->db->insert('drive_ids', [
            'table' => 'upload_documents',
            'row_id' => $id,
            'drive_id' => $drive_id,
            'skip' => $skip,
        ]);
    }
    public function getLocalResumes()
    {
        return $this->db->select([
            'id',
            'resume',
        ])
            ->from('candidate_basic_info_drive_ids')
            ->where(['drive_id' => null, 'IFNULL(skip, 0) =' => 0])
            ->order_by('applied_on', 'asc')
            ->limit(20)
            ->get()
            ->result();
    }
    public function setLocalResumeDriveId($id, $drive_id, $skip = 0)
    {
        return $this->db->insert('drive_ids', [
            'table' => 'candidate_basic_info',
            'row_id' => $id,
            'drive_id' => $drive_id,
            'skip' => $skip,
        ]);
    }
    public function getLocalTalentResumes()
    {
        return $this->db->select([
            'id',
            'resume',
        ])
            ->from('talent_network_drive_ids')
            ->where(['drive_id' => null, 'IFNULL(skip, 0) =' => 0])
            ->order_by('id', 'asc')
            ->limit(20)
            ->get()
            ->result();
    }
    public function setLocalTalentNetworkResumes($id, $drive_id, $skip = 0)
    {
        return $this->db->insert('drive_ids', [
            'table' => 'talent_network',
            'row_id' => $id,
            'drive_id' => $drive_id,
            'skip' => $skip,
        ]);
    }
}
