<?php defined('BASEPATH') or exit('No direct script access allowed');
class Auth_model extends CI_Model
{
    public $exclude_full_permission = [
        'employee_salary_permission',
        'show_inactive_employees',
    ];
    public function checkUser($data = array())
    {
        $rec = $this->db->select("
				user.id,
				CONCAT_WS(' ', user.firstname, user.lastname) AS fullname,
				user.email,
				user.image,
				user.last_login,
				user.last_logout,
				user.ip_address,
				user.status,
				user.is_admin,
				IF (user.is_admin=1, 'Admin', 'User') as user_level,
                user.new_algo,
                user.password
			")
            ->from('user')
            ->where('email', $data['email'])
            ->where('status', 1)
            ->get();
        if ($rec->num_rows() < 1) {
            return null;
        }
        $row = $rec->row();
        if ($row->new_algo && password_verify($data['password'], $row->password)) {
            return $rec;
        } else if (md5($data['password']) == $row->password) {
            return $rec;
        }
        return null;
    }
    public function userPermission1($id = null)
    {
        $acc_tbl = $this->db->select('*')->from('sec_user_access_tbl')->where('fk_user_id', $id)->get()->result();
        if ($acc_tbl != null) {
            $role_id = [];
            foreach ($acc_tbl as $key => $value) {
                $role_id[] = $value->fk_role_id;
            }
            return $result = $this->db->select("
			module.directory,
			module_permission.fk_module_id,
			IF(SUM(module_permission.create)>=1,1,0) AS 'create',
			IF(SUM(module_permission.read)>=1,1,0) AS 'read',
			IF(SUM(module_permission.update)>=1,1,0) AS 'update',
			IF(SUM(module_permission.delete)>=1,1,0) AS 'delete'
			")
                ->from('module_permission')
                ->join('module', 'module.id = module_permission.fk_module_id', 'left')
                ->where_in('module_permission.fk_role_id', $role_id)
                ->where('module.status', 1)
                ->group_by('module_permission.fk_module_id')
                ->group_start()
                ->where('create', 1)
                ->or_where('read', 1)
                ->or_where('update', 1)
                ->or_where('delete', 1)
                ->group_end()
                ->get()
                ->result();
        } else {
            return 0;
        }
    }
    public function userPermission2($role_ids = null)
    {
        if ($role_ids) {
            return $this->db->select("
				sec_role_permission.role_id,
				sec_role_permission.menu_id,
				IF(SUM(sec_role_permission.can_create)>=1,1,0) AS 'create',
				IF(SUM(sec_role_permission.can_access)>=1,1,0) AS 'read',
				IF(SUM(sec_role_permission.can_edit)>=1,1,0) AS 'update',
				IF(SUM(sec_role_permission.can_delete)>=1,1,0) AS 'delete',
				sec_menu_item.menu_title,
				sec_menu_item.page_url,
				sec_menu_item.module
				")
                ->from('sec_role_permission')
                ->join('sec_menu_item', 'sec_menu_item.menu_id = sec_role_permission.menu_id', 'left')
                ->where_in('sec_role_permission.role_id', $role_ids)
                ->group_by('sec_role_permission.menu_id')
                ->group_start()
                ->where('can_create', 1)
                ->or_where('can_access', 1)
                ->or_where('can_edit', 1)
                ->or_where('can_delete', 1)
                ->group_end()
                ->get()
                ->result();
        } else {
            return 0;
        }
    }
    public function userPermission($id = null)
    {
        return $this->db->select("
			module.directory,
			module_permission.fk_module_id,
			module_permission.create,
			module_permission.read,
			module_permission.update,
			module_permission.delete
			")
            ->from('module_permission')
            ->join('module', 'module.id = module_permission.fk_module_id', 'left')
            ->where('module_permission.fk_user_id', $id)
            ->where('module.status', 1)
            ->group_start()
            ->where('create', 1)
            ->or_where('read', 1)
            ->or_where('update', 1)
            ->or_where('delete', 1)
            ->group_end()
            ->get()
            ->result();
    }
    public function last_login($id = null)
    {
        return $this->db->set('last_login', date('Y-m-d H:i:s'))
            ->set('ip_address', $this->input->ip_address())
            ->where('id', $this->session->userdata('id'))
            ->update('user');
    }
    public function last_logout($id = null)
    {
        return $this->db->set('last_logout', date('Y-m-d H:i:s'))
            ->where('id', $this->session->userdata('id'))
            ->update('user');
    }
    public function get_retries($email)
    {
        $res = $this->db->select('login_retries')->where('email', $email)->get('user')->row();
        if ($res) {
            $this->db->query('UPDATE user SET login_retries = login_retries + 1 WHERE email = ?;', [
                $email,
            ]);
            return $res->login_retries + 1;
        }
        return 0;
    }
    public function reset_retries($email)
    {
        $this->db->query('UPDATE user SET login_retries = 0 WHERE email = ?;', [
            $email,
        ]);
    }
    public function full_access_permissions($role_ids)
    {
        if ($role_ids) {
            return $this->db->select("
				sec_full_access_permission.module,
				sec_menu_item.menu_title,
				IF(SUM(sec_full_access_permission.can_create)>=1,1,0) AS 'create',
				IF(SUM(sec_full_access_permission.can_access)>=1,1,0) AS 'read',
				IF(SUM(sec_full_access_permission.can_edit)>=1,1,0) AS 'update',
				IF(SUM(sec_full_access_permission.can_delete)>=1,1,0) AS 'delete'
				")
                ->from('sec_full_access_permission')
                ->join('sec_menu_item', 'sec_menu_item.module = sec_full_access_permission.module', 'left')
                ->where_in('sec_full_access_permission.role_id', $role_ids)
                ->group_by('sec_menu_item.menu_title')
                ->group_start()
                ->where('can_create', 1)
                ->or_where('can_access', 1)
                ->or_where('can_edit', 1)
                ->or_where('can_delete', 1)
                ->group_end()
                ->get()
                ->result();
        } else {
            return null;
        }
    }
    public function get_permissions($user_id)
    {
        $role_ids = array_column($this->db->select('*')->from('sec_user_access_tbl')->where('fk_user_id', $user_id)->get()->result(), 'fk_role_id');
        $checkPermission = $this->userPermission2($role_ids);
        $full_permissions = $this->full_access_permissions($role_ids);
        $permission = array();
        $permission1 = array();
        $full_perms = array();
        if ($checkPermission) {
            if (!empty($checkPermission)) {
                foreach ($checkPermission as $value) {
                    if ($value->menu_title == $value->module || !$permission[$value->module]) {
                        $permission[$value->module] = array(
                            'create' => $value->create,
                            'read' => $value->read,
                            'update' => $value->update,
                            'delete' => $value->delete,
                        );
                    }
                    $permission[$value->menu_title] = array(
                        'create' => $value->create,
                        'read' => $value->read,
                        'update' => $value->update,
                        'delete' => $value->delete,
                    );
                    $permission1[$value->menu_title] = array(
                        'create' => $value->create,
                        'read' => $value->read,
                        'update' => $value->update,
                        'delete' => $value->delete,
                    );
                    //print_r($checkPermission);exit;
                }
            }
        }
        if ($full_permissions) {
            foreach ($full_permissions as $full_permission) {
                if (in_array($full_permission->menu_title, $this->exclude_full_permission)) {
                    continue;
                }
                if (!isset($full_perms[$full_permission->module])) {
                    $full_perms[$full_permission->module] = [
                        'create' => $full_permission->create == 1,
                        'read' => $full_permission->read == 1,
                        'update' => $full_permission->update == 1,
                        'delete' => $full_permission->delete == 1,
                    ];
                }
                if ($full_permission->menu_title) {
                    $full_perms[$full_permission->menu_title] = [
                        'create' => $full_permission->create == 1,
                        'read' => $full_permission->read == 1,
                        'update' => $full_permission->update == 1,
                        'delete' => $full_permission->delete == 1,
                    ];
                }
            }
        }
        return [
            'roles' => $role_ids,
            'permission' => $permission,
            'permission1' => $permission1,
            'full_permissions' => $full_perms,
        ];
    }
    public function reload_user_permissions()
    {
        $permission = $this->get_permissions($this->session->userdata('id'));
        if ($permission) {
            $_SESSION['permission'] = json_encode(@$permission['permission']);
            $_SESSION['label_permission'] = json_encode(@$permission['permission1']);
            $_SESSION['full_permissions'] = json_encode(@$permission['full_permissions']);
            $_SESSION['roles'] = @$permission['roles'];
            $_SESSION['loaded'] = date('Y-m-d H:i:s');
        }
    }
    public function verify_user($pass)
    {
        $rec = $this->db->select('password, new_algo')->from('user')->where([
            'id' => $this->session->userdata('id'),
        ])->get()->row();
        if ($rec->new_algo && password_verify($pass, $rec->password)) {
            return true;
        } else if (md5($pass) == $rec->password) {
            return true;
        }
        return false;
    }
    public function generate_reset_string($user_id)
    {
        $rand_str = random_string('alnum', 30);
        $res = $this->db->where('id', $user_id)->update('user', [
            'password_reset_token' => password_hash($rand_str, PASSWORD_DEFAULT),
        ]);
        $this->cache->save('system.ufp.' . $user_id, 1, strtotime('6 hours', 0));
        return $res ? $rand_str . $user_id : null;
    }
    public function verify_reset_string($str)
    {
        $str = $this->parse_reset_string($str);
        $rand_str = $str['hash'];
        $user_id = $str['user_id'];
        if (!$this->cache->get('system.ufp.' . $user_id)) {
            return false;
        }
        $rec = $this->db->select('password_reset_token')->where('id', $user_id)->get('user')->row();
        if (!$rec) {
            return false;
        }
        if (password_verify($rand_str, $rec->password_reset_token)) {
            return true;
        }
        return false;
    }
    public function parse_reset_string($str)
    {
        return [
            'hash' => substr($str, 0, 30),
            'user_id' => substr($str, 30),
        ];
    }
    public function change_password($user_id, $password)
    {
        $this->db->trans_start();
        $emp = $this->db->select('employee_id, email')->where('user_id', $user_id)->get('employee_details')->row();
        $this->activity->log(
            'password_reset',
            $emp->employee_id,
            'employee',
            'employee_history',
            null,
            '',
            $user_id,
            $emp->email
        );
        $this->db->where('id', $user_id)->update('user', [
            'password' => password_hash($password, PASSWORD_DEFAULT),
            'new_algo' => 1,
            'password_reset_token' => null,
        ]);
        $this->sessionmanager->destroy($user_id);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
}
