<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Home extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'evencal_model' => 'evencal',
            'home_model',
            'leave/Leave_model',
            'stats_model' => 'stats',
        ]);
        $this->load->library('calendar', $this->_setting());
    }
    public function stats()
    {
        if (!$this->input->get('type')) {
            return sendJson([]);
        }
        $type = explode(',', $this->input->get('type'));
        $this->load->model(['stats_model' => 'stats']);
        $data = [];

        if (in_array('employees', $type)) {
            $data['employees'] = $this->stats->employees();
        }
        if (in_array('attendance', $type)) {
            $data['attendance'] = $this->stats->attendance();
            if (in_array('departments', $type)) {
                $data['departments'] = $data['attendance']['departments'];
                $data['departments'] = array_values(array_filter($data['departments'], function ($v) {
                    return array_reduce($v['attendance'], function ($sum, $v2) {
                        return $sum + $v2;
                    }, 0) > 0;
                }));
            }
            unset($data['attendance']['departments']);
        }
        if (in_array('departments', $type) && !isset($data['attendance'])) {
            $data['departments'] = $this->stats->attendance()['departments'];
            $data['departments'] = array_values(array_filter($data['departments'], function ($v) {
                return array_reduce($v['attendance'], function ($sum, $v2) {
                    return $sum + $v2;
                }, 0) > 0;
            }));
        }
        if (in_array('work_time', $type)) {
            $this->load->model('attendance/attendence_model');
            $data['work_time'] = $this->attendence_model->get_current_worktime();
        }
        if (in_array('this_month', $type)) {
            $data['this_month'] = $this->stats->this_month();
        }
        if (in_array('notices', $type)) {
            $this->load->model('noticeboard/notice_model', 'notices');
            $notice_page = $_GET['page'] >= 0 ? $_GET['page'] : 0;
            $notice_limit = $_GET['limit'] >= 0 ? $_GET['limit'] : 10;
            $data['notices'] = [
                'posts' => $this->notices->get($notice_page, $notice_limit),
                'next' => count($this->notices->get($notice_page + 1, $notice_limit)),
            ];
        }
        if (in_array('attrition_rate', $type)) {
            $data['attrition_rate'] = $this->stats->get_attrition_rate();
        }
        sendJson($data);
    }
    public function details()
    {
        $post = json_decode($this->input->raw_input_stream, true);
        if ($post['type'] && $post['key']) {
            if (in_array($post['type'], ['employee', 'attendance', 'leave', 'this_month'])) {
                sendJson($this->stats->details($post['type'], $post['key']));
            }
        }
        show_404();
    }
    public function index($year = null, $month = null, $day = null)
    {
        if ($this->input->post()) {
            if ($this->input->post('month') && $this->input->post('year')) {
                $month = intval($this->input->post('month'));
                $year = intval($this->input->post('year'));
                $holidays = $this->evencal->get_events($month, $year);
                $calendar_data = [];
                foreach ($holidays as $holiday_key => $holiday) {
                    $calendar_data[date('d', strtotime($holiday_key))] = $holiday;
                }
                $html = $this->calendar->generate($year, $month, $calendar_data);
                sendJson(['success' => [
                    'month' => $month,
                    'year' => $year,
                    'full_month' => date('F', strtotime('01-' . $month . '-' . $year)),
                    'html' => preg_replace('@>[\\n\\t\\s]+<@', '><', $html),
                ]]);
            }
        }
        $year = (empty($year) || !is_numeric($year)) ? date('Y') : $year;
        $month = (is_numeric($month) && $month > 0 && $month < 13) ? $month : date('m');
        $day = (is_numeric($day) && $day > 0 && $day < 31) ? $day : date('d');

        $holidays = $this->evencal->get_events($month, $year);
        $calendar_data = [];
        foreach ($holidays as $holiday_key => $holiday) {
            $calendar_data[date('d', strtotime($holiday_key))] = $holiday;
        }
        $data = array(
            'latest_notice' => $this->db->select('notice_type as title, notice_descriptiion as description, notice_date as date')->order_by('notice_date', 'desc')->limit(1)->get('notice_board')->row(),
            'notes' => $this->calendar->generate($year, $month, $calendar_data),
            'year' => $year,
            'mon' => $month,
            'month' => $this->_month($month),
            'day' => $day,
            'module' => "dashboard",
            'page' => "home/index",
        );
        if($this->session->userdata('division_id')) {
            $data['promo_video'] = $this->_promo_vids[$this->session->userdata('division_id')];
        }
        echo Modules::run('template/layout', $data);
    }
    // for convert (int) month to (string) month in Indonesian
    public function _month($month)
    {
        $month = (int) $month;
        switch ($month) {
            case 1:$month = 'January';
                break;
            case 2:$month = 'February';
                break;
            case 3:$month = 'March';
                break;
            case 4:$month = 'April';
                break;
            case 5:$month = 'May';
                break;
            case 6:$month = 'Jun';
                break;
            case 7:$month = 'July';
                break;
            case 8:$month = 'August';
                break;
            case 9:$month = 'September';
                break;
            case 10:$month = 'October';
                break;
            case 11:$month = 'November';
                break;
            case 12:$month = 'December';
                break;
        }
        return $month;
    }
    // get detail event for selected date
    public function detail_event()
    {
        $this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
        $this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
        $this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
        if ($this->form_validation->run() == false) {
            echo json_encode(array('status' => false, 'title_msg' => 'Error', 'msg' => 'Please insert valid value'));
        } else {
            $data = $this->evencal->getEvent($this->input->post('year', true), $this->input->post('mon', true), $this->input->post('day', true));
            if ($data == null) {
                echo json_encode(array('status' => false, 'title_msg' => 'No Result', 'msg' => 'There\'s no result in this date'));
            } else {
                echo json_encode(array('status' => true, 'data' => $data));
            }
        }
    }
    public function detail_notice()
    {
        $this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
        $this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
        $this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
        if ($this->form_validation->run() == false) {
            echo json_encode(array('status' => false, 'title_msg' => 'Error', 'msg' => 'Please insert valid value'));
        } else {
            $data = $this->evencal->getNotice($this->input->post('year', true), $this->input->post('mon', true), $this->input->post('day', true));
            if ($data == null) {
                echo json_encode(array('status' => false, 'title_msg' => 'No Result', 'msg' => 'There\'s no result in this date'));
            } else {
                echo json_encode(array('status' => true, 'data' => $data));
            }
        }
    }
    public function detail_leave()
    {
        $this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
        $this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
        $this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
        if ($this->form_validation->run() == false) {
            echo json_encode(array('status' => false, 'title_msg' => 'Error', 'msg' => 'Please insert valid value'));
        } else {
            $data = $this->evencal->getLeave($this->input->post('year', true), $this->input->post('mon', true), $this->input->post('day', true));
            if ($data == null) {
                echo json_encode(array('status' => false, 'title_msg' => 'No Result', 'msg' => 'No results found for the selected day'));
            } else {
                echo json_encode(array('status' => true, 'data' => $data));
            }
        }
    }
    //loan detail on date
    public function detail_loan()
    {
        $this->form_validation->set_rules('year', 'Year', 'trim|required|is_natural_no_zero');
        $this->form_validation->set_rules('mon', 'Month', 'trim|required|is_natural_no_zero|less_than[13]');
        $this->form_validation->set_rules('day', 'Day', 'trim|required|is_natural_no_zero|less_than[32]');
        if ($this->form_validation->run() == false) {
            echo json_encode(array('status' => false, 'title_msg' => 'Error', 'msg' => 'Please insert valid value'));
        } else {
            $data = $this->evencal->getLoan($this->input->post('year', true), $this->input->post('mon', true), $this->input->post('day', true));
            if ($data == null) {
                echo json_encode(array('status' => false, 'title_msg' => 'No Result', 'msg' => 'There\'s no result in this date'));
            } else {
                echo json_encode(array('status' => true, 'data' => $data));
            }
        }
    }
    // same as index() function
    public function detail($year = null, $month = null, $day = null)
    {
        $year = (empty($year) || !is_numeric($year)) ? date('Y') : $year;
        $month = (is_numeric($month) && $month > 0 && $month < 13) ? $month : date('m');
        $day = (is_numeric($day) && $day > 0 && $day < 31) ? $day : date('d');
        $date = $this->evencal->getDateEvent($year, $month);
        $notice = $this->evencal->getNotice($year, $month, $day);
        $leave = $this->evencal->getLeave($year, $month, $day);
        $loan = $this->evencal->getLoan($year, $month, $day);
        $cur_event = $this->evencal->getEvent($year, $month, $day);
        $data = array(
            'notes' => $this->calendar->generate($year, $month, $date),
            'year' => $year,
            'mon' => $month,
            'month' => $this->_month($month),
            'day' => $day,
            'notice' => $notice,
            'loan' => $loan,
            'leave' => $leave,
            'events' => $cur_event,
            'module' => "dashboard",
            'page' => "home/index",
        );
        echo Modules::run('template/layout', $data);
    }
    //Notice details
    // setting for calendar
    public function _setting()
    {
        $weekend_col_group = '<col class="weekday" span="5"><col class="weekend_sat"><col class="weekend_sat">';
        if ($this->session->userdata('employee_id')) {
            $weekend_col_group = '';
            $weekends = get_weekend();
            if ($this->session->userdata('shift') && $weekend = $weekends[$this->session->userdata('shift')]) {
                $weekend = array_map(function ($day) {
                    return date('N', strtotime($day));
                }, $weekend);
                for ($i = 1; $i <= 7; $i++) {
                    $class_name = 'weekday';
                    if (in_array($i, $weekend)) {
                        $class_name = 'weekend_sat';
                    }
                    $weekend_col_group .= "<col class=\"{$class_name}\">";
                }
            }
        }
        return array(
            'start_day' => 'monday',
            'show_next_prev' => true,
            'next_prev_url' => '#',
            'month_type' => 'long',
            'day_type' => 'short',
            'template' =>
            '{table_open}<table class="date">{/table_open}
                {heading_row_start}&nbsp;{/heading_row_start}
                {heading_previous_cell}<caption><a href="{previous_url}" class="prev_date btn btn-success"Month">&lt;&lt;Prev</a>{/heading_previous_cell}
                {heading_title_cell}{heading}{/heading_title_cell}
                {heading_next_cell}<a href="{next_url}" class="next_date btn btn-success">Next&gt;&gt;</a></caption>{/heading_next_cell}
                {heading_row_end}' . $weekend_col_group . '{/heading_row_end}
                {week_row_start}<thead><tr>{/week_row_start}
                {week_day_cell}<th>{week_day}</th>{/week_day_cell}
                {week_row_end}</tr></thead><tbody>{/week_row_end}
                {cal_row_start}<tr>{/cal_row_start}
                {cal_cell_start}<td>{/cal_cell_start}
                {cal_cell_content}<div class="date_event detail" val="{day}"><span class="date">{day}</span><span class="event d{day}">{content}</span></div>{/cal_cell_content}
                {cal_cell_content_today}<div class="active_date_event detail" val="{day}"><span class="date">{day}</span><span class="event d{day}">{content}</span></div>{/cal_cell_content_today}
                {cal_cell_no_content}<div class="no_event detail" val="{day}"><span class="date">{day}</span><span class="event d{day}">&nbsp;</span></div>{/cal_cell_no_content}
                {cal_cell_no_content_today}<div class="active_no_event detail" val="{day}"><span class="date">{day}</span><span class="event d{day}">&nbsp;</span></div>{/cal_cell_no_content_today}
                {cal_cell_blank}&nbsp;{/cal_cell_blank}
                {cal_cell_end}</td>{/cal_cell_end}
                {cal_row_end}</tr>{/cal_row_end}
                {table_close}</tbody></table>{/table_close}',
        );
    }
    public function profile()
    {
        $data['title'] = "Profile";
        $data['module'] = "dashboard";
        $data['page'] = "home/profile";
        $id = $this->session->userdata('id'); //
        $data['user'] = $this->home_model->profile($id);
        echo Modules::run('template/layout', $data);
    }
    public function setting()
    {
        $data['title'] = "Profile Setting";
        $id = $this->session->userdata('id');
        /*-----------------------------------*/
        /* $this->form_validation->set_rules('firstname', 'First Name','required|max_length[50]');
        $this->form_validation->set_rules('lastname', 'Last Name','required|max_length[50]');
        #------------------------#
        $this->form_validation->set_rules('email', 'Email Address', "required|valid_email|max_length[100]"); */
        /*---#callback fn not supported#---*/
        // $this->form_validation->set_rules('email', 'Email Address', "required|valid_email|max_length[100]|callback_email_check[$id]|trim");
        #------------------------#
        $this->form_validation->set_rules('password', 'Password', 'max_length[32]');
        $this->form_validation->set_rules('conf_password', 'Confirm Password', 'matches[password]');
        $this->form_validation->set_rules('about', 'About', 'max_length[1000]');
        /*-----------------------------------*/
        $config['upload_path'] = './assets/img/user/';
        $config['allowed_types'] = 'gif|jpg|png';
        $this->load->library('upload', $config);
        if ($this->upload->do_upload('image')) {
            $data = $this->upload->data();
            $image = $config['upload_path'] . $data['file_name'];
            $config['image_library'] = 'gd2';
            $config['source_image'] = $image;
            $config['create_thumb'] = false;
            $config['maintain_ratio'] = true;
            $config['width'] = 115;
            $config['height'] = 90;
            $this->load->library('image_lib', $config);
            $this->image_lib->resize();
            $this->session->set_flashdata('message', "Image Upload Successfully!");
        }
        /*-----------------------------------*/
        $data['user'] = (object) $userData = array(
            'id' => $this->input->post('id'),
            'about' => $this->input->post('about', true),
            'image' => (!empty($image) ? $image : $this->input->post('old_image')),
        );
        if(!empty($this->input->post('password'))) {
            $userData['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
            $userData['new_algo'] = 1;
        }
        /*-----------------------------------*/
        if ($this->form_validation->run()) {
            if (!empty($_FILES['image']['name']) && empty($userData['image'])) {
                $this->session->set_flashdata('exception', $this->upload->display_errors());
            }
            if ($this->home_model->setting($userData)) {
                $this->session->set_userdata(array(
                    'image' => (!empty($image) ? $image : $this->input->post('old_image')),
                ));
                $this->session->set_flashdata('message', display('update_successfully'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("dashboard/home/setting");
        } else {
            $data['module'] = "dashboard";
            $data['page'] = "home/profile_setting";
            if (!empty($id)) {
                $data['user'] = $this->home_model->profile($id);
            }

            echo Modules::run('template/layout', $data);
        }
    }
    ///// Notice
    public function view_details()
    {
        $id = $this->uri->segment(4);
        $data['module'] = "dashboard";
        $data['page'] = "home/notice_details";
        $data['detls'] = $this->evencal->details($id);
        echo Modules::run('template/layout', $data);
    }
    public function incomeinfo()
    {
        $year = $this->input->post('year');
        echo json_encode($year);
    }
    public function tmce_upload()
    {
        $name = @pathinfo(@$_FILES['file']['name'], PATHINFO_FILENAME);
        $name = str_slug($name);
        if (empty($name)) {
            $name = "file_" . uniqid();
        }
        $file_path = 'uploads/temp/' . date('Y-m-d') . '/';
        if (!is_dir(FCPATH . $file_path)) {
            mkdir(FCPATH . $file_path);
        }
        $config['upload_path'] = $file_path;
        $config['allowed_types'] = '*';
        $config['file_name'] = $name;
        $this->load->library('upload', $config);
        if ($this->upload->do_upload('file')) {
            $data = array('upload_data' => $this->upload->data());
            if (isset($data['upload_data']['full_path'])) {
                $this->output
                    ->set_status_header(200)
                    ->set_output(json_encode(['location' => $file_path . $data['upload_data']['file_name']]));
            }
        } else {
            $this->output
                ->set_status_header(500)
                ->set_output($this->upload->display_errors());
        }
    }
    public function changelogs()
    {
        $content = file_get_contents(FCPATH . 'CHANGELOG.md');
        $parser = new Parsedown();
        $parser->setSafeMode(true);
        $data['content'] = $parser->text($content);
        $data['title'] = 'HRM Changelogs';
        $data['page'] = 'home/changelog';
        $data['module'] = 'dashboard';
        echo Modules::run('template/layout', $data);
    }
    public function save_user_opts()
    {
        if (!empty(trim($this->session->userdata('id')))) {
            $this->home_model->set_user_options($_POST);
        }
    }
}
