<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Email_settings extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('language');
        $this->load->model('temp_model');

    }
    public function email_templates()
    {
        $this->permission->method('email_settings', 'read')->redirect();
        $data['title'] = "Email Settings";
        $data['module'] = "dashboard";
        $data['page'] = "email_templates/templates";
        $data['divisions'] = $this->db->select('id,name,prefix')->get('divisions')->result();
        $data['templates'] = $this->temp_model->email_template();
        echo modules::run('template/layout', $data);
    }
    public function update_email_templates()
    {
        $id = $this->input->post('id');
        if($id) {
            $this->permission->method('email_settings', 'update')->redirect();
        } else {
            $this->permission->method('email_settings', 'create')->redirect();
        }
        $this->form_validation->set_rules('division_id', 'Division', 'required');
        $this->form_validation->set_rules('username', 'Username', 'required');
        if (!$id && !empty($this->input->post('password'))) {
            $this->form_validation->set_rules('password', 'Password', 'required');
        }
        $this->form_validation->set_rules('host', 'Host', 'required');
        $this->form_validation->set_rules('port', 'Port', 'required');
        $this->form_validation->set_rules('email_from', 'Email Port', 'trim|required|valid_email');
        $this->form_validation->set_rules('email_hr', 'HR CC Email', 'trim|required|valid_email');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $data['division_id'] = $this->input->post('division_id');
            $data['isSMTP'] = 1;
            $data['email_hr'] = $this->input->post('email_hr');
            $data['username'] = $this->input->post('username');
            if (!empty($this->input->post('password'))) {
                $data['password'] = $this->encryption->encrypt($this->input->post('password'));
            }
            $data['host'] = $this->input->post('host');
            $data['port'] = $this->input->post('port');
            $data['email_from'] = $this->input->post('email_from');
            if (!empty($id)) {
                $update = $this->temp_model->update_email_settings($id, $data);
                $message = 'Email Template Updated Successfully';
            } else {
                $update = $this->temp_model->create_email_settings($data);
                $message = 'Email Template Inserted Successfully';
            }
            if ($update) {
                $this->session->set_flashdata('message', $message);
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("dashboard/Email_settings/email_templates");
        } else {
            $this->email_templates();
        }
    }
    public function delete_template($id)
    {
        $this->permission->method('email_settings', 'delete')->redirect();
        // echo $this->temp_model->delete($id);exit;
        if ($this->temp_model->delete_email_settings($id)) {
            $this->session->set_flashdata('message', "Email Template Deleted Successfully!");
        } else {
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("dashboard/Email_settings/email_templates");
    }
    public function editTemplateData()
    {
        $this->permission->method('email_settings', 'update')->redirect();
        $id = $this->input->post('id');
        echo json_encode($this->temp_model->email_template($id));
    }
    public function checkDivisionExists()
    {
        $post = $this->input->post();
        $found = $this->db->where('division_id', $post['division'])
            ->get('email_templates')->result();
        if ($found) {
            echo 1;
        } else {
            echo 0;
        }
    }
    public function test_settings()
    {
        $this->permission->method('email_settings', 'read')->redirect();
        if ($this->input->post() && $this->input->is_ajax_request()) {
            $rules_config = array(
                array(
                    'field' => 'email',
                    'label' => 'Email',
                    'rules' => 'trim|required|valid_email',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() == false) {
                if (form_error('email')) {
                    sendJson(['error' => form_error('email')]);
                } else {
                    sendJson(['error' => 'Unknown error, try again later']);
                }
            }
            $division = $this->db->select('id,name,prefix')->where('id', $this->input->post('id'))->get('divisions')->row();
            $res = $this->template_mail->config($this->input->post('id'))->test_email_settings(
                $this->input->post('email'),
                sprintf('Test Email For %s Settings', $division->name),
                'If you have received this email then you have configured the email settings correctly.'
            );
            if ($res) {
                $this->activity
                ->set_url('dashboard/Email_settings/email_templates')
                ->set_division($division->id)
                ->log([
                    'email_settings_testing',
                    $this->input->post('email')
                ]);
                sendJson(['success' => sprintf('Email Sent Successfully, Check your provided email "%s"', $this->input->post('email'))]);
            } else {
                if ($this->session->userdata('email_exception')) {
                    sendJson(['error' => 'Error: ' . $this->session->userdata('email_exception')]);
                }else{
                    sendJson(['error' => 'Error while sending email, check your settings']);
                }
            }
        }
    }
}
