<?php
defined('BASEPATH') or exit('No direct script access allowed');
class CronHeavy extends MY_Controller
{
    private $run_daily = [
        'compresslogs' => 1,
        'payroll_monthly' => 1,
        'payroll_generate_slips' => 1,
        'close_leaves_quota' => 1,
        'cleanup_documents_directory' => 1,
        'cleanup_resumes' => 1,
        'cleanup_profile_pictures_directory' => 1,
        'cleanup_up_temp_directory' => 1,
        'trash_clear' => 1,
        'sync_devices_times' => 1,
        'clean_cache_dir' => 1,
    ];
    private $run_first_shift = [
        'daily_recruitment_report',
        'cleanup_sessions',
    ];
    private $run_last_shift = [
        'googleQuizReminders',
        'googleQuizWarnings',
    ];
    private $run_on_working_days = [
        'googleQuizReminders',
        'googleQuizWarnings',
        'QuizEmail',
        'googleQuizGenerateEmail',
    ];
    private $disabled_services = [
        'leave_round_robin',
        'cleanup_profile_pictures_directory',
        'cleanup_misc',
        'generate_evaluation_report',
        'generate_evaluation_expiration_emails',
    ];
    private function check_for_empty_quotas()
    {
        $this->db->query('DELETE FROM `employee_leaves` WHERE `employee_leaves`.`leave_type` NOT IN (SELECT `leave_type_id` FROM `leave_type`);');
        $this->db->query('DELETE FROM `employee_leaves` WHERE `employee_leaves`.`emp_id` NOT IN (SELECT `employee_id` FROM `employee_history`);');
        $employees = $this->db->query(
            'CALL get_employee_with_empty_leave_quota_rows()'
        )->result();
        $this->db->next_result();
        $employees = array_column($employees, 'employee_id');
        $employees = array_unique($employees);
        if ($employees) {
            $leave_ids = $this->db->select('leave_type_id as id')->not_like('leave_type', 'special', 'after')->get('leave_type')->result();
            if (!$leave_ids) {
                $this->log('Now leave types found');
                return true;
            }
            $leave_ids = array_column($leave_ids, 'id');
            $this->db->trans_start();
            $year = date('Y');
            foreach ($employees as $employee) {
                foreach ($leave_ids as $leave_id) {
                    $this->db->insert('employee_leaves', [
                        'year' => $year,
                        'emp_id' => $employee,
                        'leave_type' => $leave_id,
                        'leave_qouta' => 0,
                    ]);
                }
            }
            $this->db->trans_complete();
            if (!$this->db->trans_status()) {
                $this->log('Error generating quota for new employees');
            }
        }
        return true;
    }
    public function compresslogs()
    {
        $path = APPPATH . 'logs';
        $folders = [
            'bio_devices' => '%s.log',
            'cron' => '%s.log',
            'gforms' => '%s.log',
            'logins' => '%s.log',
            'mail' => '%s.log',
            'php' => 'log-%s.log',
            'visits' => '%s.csv',
        ];
        $date_formats = [
            'bio_devices' => 'Ymd',
            'cron' => 'Ymd',
            'gforms' => 'Ymd',
            'logins' => 'Ymd',
            'mail' => 'Ymd',
            'php' => 'Y-m-d',
            'visits' => 'Y-m-d',
        ];
        foreach ($folders as $key => $filename) {
            $todays_filename = sprintf($filename, date($date_formats[$key]));
            $files = scandir(array_to_path([$path, $key]));
            if (!$files) {
                continue;
            }
            foreach ($files as $file) {
                if (in_array($file, ['.', '..', '.gitkeep', $todays_filename]) || preg_match('@.gz$@', $file)) {
                    continue;
                }
                $full_filename = array_to_path([$path, $key, $file]);
                if ($this->gzCompressFile($full_filename)) {
                    @unlink($full_filename);
                }
            }
        }
        return true;
    }
    private function cleanup_documents_directory()
    {
        $trash = FCPATH . 'assets/employee_documents/trash';
        $files = scandir($trash);
        $files = array_diff($files, array('.', '..', '.gitkeep'));

        $backDay = strtotime('-1 month');
        foreach ($files as $file) {
            if (strtotime($file) <= $backDay) {
                $this->log('Deleting old trash: ' . $trash . DIRECTORY_SEPARATOR . $file);
                delete_directory($trash . DIRECTORY_SEPARATOR . $file);
            }
        }
        return true;
    }
    private function cleanup_resumes()
    {
        $trash = WRITEPATH . 'resume_trash';
        $files = scandir($trash);
        $files = array_diff($files, array('.', '..', '.gitkeep'));

        $backDay = strtotime('-1 month');
        foreach ($files as $file) {
            if (strtotime($file) <= $backDay) {
                $this->log('Deleting old trash: ' . $trash . DIRECTORY_SEPARATOR . $file);
                delete_directory($trash . DIRECTORY_SEPARATOR . $file);
            }
        }
        return true;
    }
    private function cleanup_misc()
    {
        $cache_flag = $this->options->get_system('cron.misc.directory');
        if ($cache_flag === false) {
            $this->log('No flag found in db. Re-generating');
            $this->options->set_system('cron.misc.directory', date('H-d-m-Y'));
        } elseif ($cache_flag == date('H-d-m-Y')) {
            return true;
        }
        if (!is_dir(WRITEPATH . 'trash')) {
            mkdir(WRITEPATH . 'trash');
        }
        $current_trash = WRITEPATH . 'trash/' . date('Y-m');
        if (!is_dir($current_trash)) {
            mkdir($current_trash);
        }
        $current_trash .= '/';

        /**
         * Letterheads
         */
        $files = scandir(FCPATH . 'application/modules/incident/assets/letter_heads');
        $files = array_diff($files, array('.', '..', '.gitkeep'));

        foreach ($files as $file) {
            $files_exists = $this->db->where('value', $file)->count_all_results('tcpdf_settings');
            if ($files_exists < 1) {
                rename(FCPATH . 'application/modules/incident/assets/letter_heads/' . $file, $current_trash . $file);
            }
        }
        $this->options->set_system('cron.misc.directory', date('H-d-m-Y'));
        return true;
    }
    private function cleanup_profile_pictures_directory()
    {
        $cache_flag = $this->options->get_system('cron.cleanup_profile_pictures_directory');
        if ($cache_flag === false) {
            $this->log('No flag found in db. Re-generating');
            $this->options->set_system('cron.cleanup_profile_pictures_directory', date('m-Y'));
        } elseif ($cache_flag == date('m-Y')) {
            return true;
        }
        if (!is_dir(WRITEPATH . 'trash')) {
            mkdir(WRITEPATH . 'trash');
        }
        $current_trash = WRITEPATH . 'trash/' . date('Y-m');
        if (!is_dir($current_trash)) {
            mkdir($current_trash);
        }
        $current_trash .= '/';

        /**
         * Employee directory
         */
        $it = new RecursiveDirectoryIterator(APPPATH . 'modules/employee/assets/images/', RecursiveDirectoryIterator::SKIP_DOTS);

        // Loop through files
        foreach (new RecursiveIteratorIterator($it) as $file) {
            if (in_array(basename($file), ['.gitkeep'])) {
                continue;
            }
            $custom_file_name = str_replace('\\', '/', str_replace(FCPATH, './', $file));
            $files_exists = $this->db->where('picture', $custom_file_name)->count_all_results('employee_history');

            if ($files_exists < 1) {
                rename($file, $current_trash . basename($file));
            }
        }
        /**
         * User directory
         */
        $files = scandir(FCPATH . 'assets/img/user/');
        $files = array_diff($files, array('.', '..', '.gitkeep'));

        foreach ($files as $file) {
            $files_exists = $this->db->where('image', './assets/img/user/' . $file)->count_all_results('user');
            if ($files_exists < 1) {
                rename(FCPATH . 'assets/img/user/' . $file, $current_trash . $file);
            }
        }
        $this->options->set_system('cron.cleanup_profile_pictures_directory', date('m-Y'));
        return true;
    }
    private function cleanup_up_temp_directory()
    {
        $files = scandir(WRITEPATH . 'temp');
        $files = array_diff($files, array('.', '..', '.gitkeep'));

        $last_week = strtotime('-1 week');
        foreach ($files as $file) {
            if (!is_dir(WRITEPATH . 'temp/' . $file)) {
                continue;
            }
            if (strtotime($file) < 1) {
                continue;
            }
            if (strtotime($file) < $last_week) {
                delete_directory(WRITEPATH . 'temp/' . $file);
            }
        }
        return true;
    }
    private function trash_clear()
    {
        $cache_flag = $this->options->get_system('cron.trash_clear');
        if ($cache_flag === false) {
            $this->log('No flag found in db. Re-generating');
            $this->options->set_system('cron.trash_clear', date('m-Y'));
        } elseif ($cache_flag == date('m-Y')) {
            return true;
        }
        $dir = WRITEPATH . 'trash/' . date('Y-m', strtotime('-2 months'));
        if (is_dir($dir)) {
            delete_directory($dir);
        }
        $this->options->set_system('cron.trash_clear', date('m-Y'));
        return true;
    }
    private function cleanup_sessions()
    {
        return $this->sessionmanager->cleanOldRecords();
    }
    private function Process_payroll()
    {
        $this->load->model('payroll/payroll_model');
        $payrolls = $this->db->select('id, type')->where('processed', 'queued')->order_by('updated_at', 'asc')->limit(2)->get('payroll')->result();
        $this->payroll_model->check();
        if (!$payrolls) {
            $this->log('Found 0 payrolls queued');
            return true;
        }
        $total_queued = count($payrolls);
        $processed = 0;
        $this->load->model('payroll/budget_model');
        foreach ($payrolls as $payroll) {
            $this->db->where('id', $payroll->id)->update('payroll', [
                'processed' => 'in-progress',
            ]);
            $success = false;
            if ($payroll->type == 'payroll') {
                $success = $this->payroll_model->generate_payroll($payroll->id, true);
            } else {
                $success = $this->budget_model->generate_budget($payroll->id, true);
            }
            if ($success) {
                $this->db->where('id', $payroll->id)->update('payroll', [
                    'processed' => 'done',
                ]);
            } else {
                $this->db->where('id', $payroll->id)->update('payroll', [
                    'processed' => 'queued',
                ]);
            }
            $processed += $success ? 1 : 0;
        }
        $this->log(sprintf('Processed %s/%s payrolls', $processed, $total_queued));
        return true;
    }
    private function payroll_generate_slips()
    {
        if (time() >= (strtotime(date('Y-m-') . '10'))) {
            $this->load->model(['payroll/payslip_model' => 'payslip']);
            $this->db->trans_start();
            $payroll_month_timestamp = strtotime('-1 month');
            $approved_payrolls = getByWhere('payroll', 'id', ['month' => date('F', $payroll_month_timestamp), 'year' => date('Y', $payroll_month_timestamp), 'cfo_status' => 'approved']);
            foreach ($approved_payrolls as $approved_payroll) {
                $this->payslip->generate($approved_payroll->id);
            }
            $this->db->trans_complete();
            return $this->db->trans_status();
        }
        return true;
    }
    private function payroll_monthly()
    {
        $cache_flag = $this->options->get_system('cron.payroll_monthly');
        if ($cache_flag === false) {
            $this->log('No flag found in db. Re-generating');
            $this->options->set_system('cron.payroll_monthly', date('m-Y'));
        } elseif ($cache_flag == date('m-Y')) {
            return true;
        }
        $payroll_month_timestamp = strtotime('-1 month');
        $this->load->model(['payroll/payroll_model' => 'payroll']);
        $divisions = getByWhere('divisions', 'id, name, url');
        foreach ($divisions as $division) {
            if ($this->payroll->exists(date('F', $payroll_month_timestamp), date('Y', $payroll_month_timestamp), $division->id)) {
                $this->log('Payroll already exists for this division, month and year');
            } elseif ($this->payroll->queue_payroll(date('F', $payroll_month_timestamp), date('Y', $payroll_month_timestamp), $division->id)) {
                $this->template_mail
                    ->send_to_department(
                        $division->id,
                        ['cfo', 'hr'],
                        sprintf('[%s] Payroll sheet generated for %s %s period', $division->name, date('F', $payroll_month_timestamp), date('Y', $payroll_month_timestamp)),
                        $this->load->view('cron/payroll_email', ['month' => date('F', $payroll_month_timestamp), 'year' => date('Y', $payroll_month_timestamp), 'division' => $division], true),
                        [],
                        [],
                        true
                    );
                $this->notify
                    ->department(['hr', 'cfo'])
                    ->send(
                        sprintf('[%s] Payroll sheet generated for %s %s period. Click here to visit', $division->name, date('F', $payroll_month_timestamp), date('Y', $payroll_month_timestamp)),
                        'payroll/pending'
                    );
                continue;
            }
            $this->log('Unable to add payroll for division ' . $division->name);
            return false;
        }
        $this->options->set_system('cron.payroll_monthly', date('m-Y'));
        return true;
    }
    private function SalarySlips()
    {
        $pending_slips = getByWhere(
            'payroll_payslips,
            employee_history-payroll_payslips.employee_id=employee_history.employee_id-left,
            payroll-payroll_payslips.payroll_id=payroll.id-left',
            'payroll_payslips.*,
            payroll.month,
            payroll.year,
            employee_history.business_email,
            employee_history.division_id,
            employee_history.first_name,
            employee_history.last_name,
            employee_history.hrm_id',
            ['payroll_payslips.status' => 'generated'],
            ['payroll_payslips.employee_id', 'asc'],
            10);

        if (!$pending_slips) {
            $this->log('No Slips Found');
            return true;
        }
        $this->load->model(['payroll/payslip_model' => 'payslip']);
        $this->payslip->cleanup();
        $this->db->trans_start();
        foreach ($pending_slips as $slip) {
            if (empty(trim($slip->business_email))) {
                $this->db->trans_start();
                $this->db
                    ->where(['payroll_id' => $slip->payroll_id, 'employee_id' => $slip->employee_id])
                    ->update('payroll_payslips', [
                        'status' => 'failed',
                    ]);
                $this->template_mail->send_to_hr(
                    $slip->division_id,
                    sprintf('[%s, %s] Salary Slip Not Sent: %s %s (%s)', ucfirst($slip->month), $slip->year, $slip->first_name, $slip->last_name, $slip->hrm_id),
                    'Reason: Business Email Address is missing.',
                );
                $this->db->trans_complete();
                continue;
            }
            $file = $this->payslip->process_slip($slip->payroll_id, $slip->employee_id, true, true);
            if (!$file) {
                continue;
            }
            $outbox_id = $this->template_mail->config($slip->division_id)->_send(
                $slip->business_email,
                null,
                sprintf('Salary Slip - %s %s', ucfirst($slip->month), $slip->year),
                $this->load->view('payroll/email/slip', ['slip' => $slip], true),
                [],
                [],
                [
                    sprintf('Salary Slip - %s %s.pdf', ucfirst($slip->month), $slip->year) => $file,
                ]
            );
            $this->db
                ->where(['payroll_id' => $slip->payroll_id, 'employee_id' => $slip->employee_id])
                ->update('payroll_payslips', [
                    'status' => 'queued',
                    'outbox_id' => $outbox_id,
                ]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    private function leave_round_robin()
    {
        $this->load->model('leave/leave_model');
        $total_leave_types = $this->db->not_like('leave_type', 'special')->count_all_results('leave_type');
        $employees = $this->leave_model->get_leave_round_rows($total_leave_types);
        $this->db->trans_start();
        $year = date('Y');
        foreach ($employees as $employee) {
            $minimum_quota_rec = $this->db->select('employee_leaves.id, leave_type.leave_type as label')
                ->join('leave_type', 'employee_leaves.leave_type = leave_type.leave_type_id', 'left')
                ->where(['employee_leaves.emp_id' => $employee->employee_id, 'employee_leaves.year' => $year, 'leave_type.leave_type <>' => null])
                ->order_by('employee_leaves.leave_qouta', 'asc')
                ->limit(1)->get('employee_leaves')->row();
            $this->db->where('id', $minimum_quota_rec->id)
                ->set('leave_qouta', 'leave_qouta + 1', false)
                ->update('employee_leaves');
            $this->activity->set_url('employee/employees/cv/' . $employee->employee_id)->log([
                'leave_auto_increment',
                $minimum_quota_rec->label,
                $employee->tenure,
                $employee->tenure > 1 ? 's' : '',
            ], $employee->employee_id, 'employee', 'employee_history', null, '', 0, 'HRM System');
        }
        $this->db->trans_complete();
        if (!$this->db->trans_status()) {
            $this->log('Unable to increment leave quotas: ' . json_encode($this->db->error()));
        }
        return true;
    }
    private function close_leaves_quota()
    {
        $cache_flag = $this->options->get_system('cron.leave.quota.closing.yearly');
        if ($cache_flag === false) {
            $this->log('No flag found in db. Re-generating');
            $this->options->set_system('cron.leave.quota.closing.yearly', date('Y'));
        } elseif ($cache_flag == date('Y')) {
            return true;
        }
        $previous_year = date('Y', strtotime('-1 year'));
        $this->db->trans_start();
        $this->db->query("INSERT INTO `employee_leaves` (`year`, `emp_id`, `leave_type`, `leave_qouta`) (
            SELECT ? as `year`, employee_leaves.emp_id, employee_leaves.leave_type, leave_type.leave_days FROM employee_leaves
            LEFT JOIN employee_history ON employee_leaves.emp_id = employee_history.employee_id
            LEFT JOIN leave_type ON employee_leaves.leave_type = leave_type.leave_type_id
            WHERE TIMESTAMPDIFF(MONTH, employee_history.hire_date, CURRENT_DATE()) > 12
            AND STATUS NOT IN ('released','terminated','not-joined','resigned')
            AND employee_leaves.year = ?)",
            [date('Y'), $previous_year]);
        $this->db->query("INSERT INTO `employee_leaves` (`year`, `emp_id`, `leave_type`, `leave_qouta`) (SELECT ? as `year`, employee_leaves.emp_id, employee_leaves.leave_type, 0 as `leave_days` FROM employee_leaves
        LEFT JOIN employee_history ON employee_leaves.emp_id = employee_history.employee_id
        WHERE TIMESTAMPDIFF(MONTH, employee_history.hire_date, CURRENT_DATE()) <= 12
        AND STATUS NOT IN ('released','terminated','not-joined','resigned')
        AND employee_leaves.year = ?)",
            [date('Y'), $previous_year]);
        $this->db->trans_complete();
        if ($this->db->trans_status()) {
            $this->log("Leaves quota for the year {$previous_year} is closed successfully");
        } else {
            $this->log("Unable to close leaves quota for the year {$previous_year}");
            return false;
        }
        $this->options->set_system('cron.leave.quota.closing.yearly', date('Y'));
        return true;
    }
    private function generate_evaluation_report()
    {
        $this->load->model('employee/evaluation_report_model');
        return $this->evaluation_report_model->auto_generate();
    }
    private function generate_evaluation_expiration_emails()
    {
        $this->load->model('employee/evaluation_report_model');
        return $this->evaluation_report_model->email_deadlines();
    }
    private function clean_0_date_columns()
    {
        $cols = [
            'passing_year',
            'hire_date',
            'original_hire_date',
            'termination_date',
            'exit_interview_date',
            'rehire_date',
            'class_acc_date',
            'resignation_date',
        ];
        $this->db->trans_begin();
        foreach ($cols as $col) {
            $this->db->where($col, '0000-00-00')->update('employee_history', [
                $col => null,
            ]);
        }
        $this->db->trans_commit();
        return $this->db->trans_status();
    }
    private function daily_recruitment_report()
    {
        $header = [
            ['Job ID', 5],
            ['Job Title', 40],
            ['Job Location', 20],
            ['No of Pending Applications', 10],
            ['Oldest Application Date', 15],
            ['Job Posting Link', 70],
        ];
        $query = $this->db->get('job_pending_application_report');
        $meta = $query->field_data();
        $recs = $query->result_array();
        if ($recs) {
            $meta = array_map(function ($m) {return $m->type;}, $meta);
            $meta[] = 888;
            $division = $this->db->select('id, url')->order_by('id')->get('divisions')->row();
            $today = formatted_date_now();

            return $this->template_mail->send_to_department(
                $division->id,
                'hr',
                'Pending Applications Report',
                $this->load->view('cron/pending_recruitment_applicaitons', [
                    'header' => $header,
                    'today' => $today,
                    'base_url' => $division->url,
                    'rows' => $recs,
                ], true),
                [],
                [],
                true
            );
        }

        return true;
    }
    private function sync_devices_times()
    {
        $this->bio_devices->syncDevicesTime();
        return true;
    }
    private function clean_cache_dir()
    {
        $files = scandir(APPPATH . 'cache');
        foreach ($files as $file) {
            if (in_array($file, ['temp', '.', '..'])) {
                continue;
            }
            $this->cache->get($file);
        }
        return true;
    }
    private function moveEmployeeFilesToDrive()
    {
        if (floor(time() / 60) % 5 !== 0) {
            $this->log('Running every five minutes only');
            return false;
        }
        $this->load->model('setting_model');
        if (!$this->setting_model->driveClient->isLoggedIn()) {
            return false;
        }
        $_trash_dir = FCPATH . 'assets/employee_documents/trash/' . date('Y-m-d') . '/';
        if (!is_dir($_trash_dir)) {
            mkdir($_trash_dir);
        }
        $files = $this->cron_model->getLocalUploadDocuments();
        if ($files) {
            $HRM_Drive = &$this->setting_model->driveInstance;
            $emp_dir = $HRM_Drive->search('employee_documents', true, $HRM_Drive->getHRMRootId());
            if (!$emp_dir) {
                $emp_dir = $HRM_Drive->createDirectory('employee_documents', $HRM_Drive->getHRMRootId());
            } else {
                $emp_dir = $emp_dir[0];
            }
            $this->db->trans_start();
            foreach ($files as $file) {
                if (empty(trim($file->documents))) {
                    $this->cron_model->setLocalUploadDocumentsDriveId($file->id, null, 1);
                    continue;
                }
                $file->path = FCPATH . 'assets/employee_documents/' . $file->documents;
                if (!file_exists($file->path)) {
                    $this->log('File doesn\'t exist: ' . $file->documents . ' - id:' . $file->id);
                    $this->cron_model->setLocalUploadDocumentsDriveId($file->id, null, 1);
                    continue;
                }
                $drive_file = $HRM_Drive->create($file->path, $emp_dir->id);
                if ($drive_file) {
                    $this->cron_model->setLocalUploadDocumentsDriveId($file->id, $drive_file->id);
                }
                $moved = rename($file->path, $_trash_dir . $file->documents);
                if (!$moved) {
                    $this->log('Unable to move file into trash: ' . $file->path);
                }
            }
            $this->db->trans_complete();
            return $this->db->trans_status();
        } else {
            $files = scandir(FCPATH . 'assets/employee_documents');
            foreach ($files as $file) {
                if (in_array($file, ['.', '..', '.gitkeep', 'trash'])) {
                    continue;
                }
                if ($this->db->where('BINARY documents = ', "'{$file}'", false)->count_all_results('upload_documents') < 1) {
                    rename(FCPATH . 'assets/employee_documents/' . $file, $_trash_dir . $file);
                }
            }
            return true;
        }
        $this->log('All files moved');
        return false;
    }
    private function moveResumesToDrive()
    {
        $this->load->model('setting_model');
        if (!$this->setting_model->driveClient->isLoggedIn()) {
            return false;
        }
        if (!is_dir($trash_dir = WRITEPATH . '/resume_trash/' . date('Y-m-d'))) {
            mkdir($trash_dir);
        }
        $resumes = $this->cron_model->getLocalResumes();
        if ($resumes) {
            $HRM_Drive = &$this->setting_model->driveInstance;
            $resume_dir = $HRM_Drive->search('resume_files', true, $HRM_Drive->getHRMRootId());
            if (!$resume_dir) {
                $resume_dir = $HRM_Drive->createDirectory('resume_files', $HRM_Drive->getHRMRootId());
            } else {
                $resume_dir = $resume_dir[0];
            }
            $this->db->trans_start();
            foreach ($resumes as $resume) {
                if (empty(trim($resume->resume))) {
                    $this->cron_model->setLocalResumeDriveId($resume->id, null, 1);
                    continue;
                }
                $resume_segments = explode('/', $resume->resume);
                $file_segment = array_pop($resume_segments);
                $date_dir_segment = array_pop($resume_segments);
                $resume->path = FCPATH . $resume->resume;
                if (!file_exists($resume->path)) {
                    $this->log('File doesn\'t exist: ' . $resume->resume . ' - id:' . $resume->id);
                    $this->cron_model->setLocalResumeDriveId($resume->id, null, 1);
                    continue;
                }
                $resume_child_dir = $HRM_Drive->search($date_dir_segment, true, $resume_dir->id);
                if (!$resume_child_dir) {
                    $resume_child_dir = $HRM_Drive->createDirectory($date_dir_segment, $resume_dir->id);
                } else {
                    $resume_child_dir = $resume_child_dir[0];
                }
                $drive_file = $HRM_Drive->create($resume->path, $resume_child_dir->id);
                if ($drive_file) {
                    $this->cron_model->setLocalResumeDriveId($resume->id, $drive_file->id);
                }
                if (!is_dir($trash_dir . DIRECTORY_SEPARATOR . $date_dir_segment)) {
                    mkdir($trash_dir . DIRECTORY_SEPARATOR . $date_dir_segment);
                }
                $moved = rename($resume->path, $trash_dir . DIRECTORY_SEPARATOR . $date_dir_segment . DIRECTORY_SEPARATOR . $file_segment);
                if (!$moved) {
                    $this->log('Unable to move file into trash: ' . $resume->path);
                }
            }
            $this->db->trans_complete();
            return $this->db->trans_status();
        }
        $this->log('All files moved');
        return false;
    }
    private function moveTalentsToDrive()
    {
        $this->load->model('setting_model');
        if (!$this->setting_model->driveClient->isLoggedIn()) {
            return false;
        }
        if (!is_dir($trash_dir = WRITEPATH . '/resume_trash/' . date('Y-m-d'))) {
            mkdir($trash_dir);
        }
        $resumes = $this->cron_model->getLocalTalentResumes();
        if ($resumes) {
            $HRM_Drive = &$this->setting_model->driveInstance;
            $resume_dir = $HRM_Drive->search('resume_files', true, $HRM_Drive->getHRMRootId());
            if (!$resume_dir) {
                $resume_dir = $HRM_Drive->createDirectory('resume_files', $HRM_Drive->getHRMRootId());
            } else {
                $resume_dir = $resume_dir[0];
            }
            $this->db->trans_start();
            foreach ($resumes as $resume) {
                if (empty(trim($resume->resume))) {
                    $this->cron_model->setLocalTalentNetworkResumes($resume->id, null, 1);
                    continue;
                }
                $resume_segments = explode('/', $resume->resume);
                $file_segment = array_pop($resume_segments);
                $date_dir_segment = array_pop($resume_segments);
                $resume->path = FCPATH . $resume->resume;
                if (!file_exists($resume->path)) {
                    $this->log('File doesn\'t exist: ' . $resume->resume . ' - id:' . $resume->id);
                    $this->cron_model->setLocalTalentNetworkResumes($resume->id, null, 1);
                    continue;
                }
                $resume_child_dir = $HRM_Drive->search($date_dir_segment, true, $resume_dir->id);
                if (!$resume_child_dir) {
                    $resume_child_dir = $HRM_Drive->createDirectory($date_dir_segment, $resume_dir->id);
                } else {
                    $resume_child_dir = $resume_child_dir[0];
                }
                $drive_file = $HRM_Drive->create($resume->path, $resume_child_dir->id);
                if ($drive_file) {
                    $this->cron_model->setLocalTalentNetworkResumes($resume->id, $drive_file->id);
                }
                if (!is_dir($trash_dir . DIRECTORY_SEPARATOR . $date_dir_segment)) {
                    mkdir($trash_dir . DIRECTORY_SEPARATOR . $date_dir_segment);
                }
                $moved = rename($resume->path, $trash_dir . DIRECTORY_SEPARATOR . $date_dir_segment . DIRECTORY_SEPARATOR . $file_segment);
                if (!$moved) {
                    $this->log('Unable to move file into trash: ' . $resume->path);
                }
            }
            $this->db->trans_complete();
            return $this->db->trans_status();
        }
        $this->log('All files moved');
        return false;
    }
    private function moveAllProfilePics()
    {
        if (!is_dir(FCPATH . 'assets/employee_pictures/')) {
            @mkdir(FCPATH . 'assets/employee_pictures/');
        }
        $recs = $this->db->select([
            'employee_id',
            'picture',
        ])
            ->like('picture', '/employee_documents/')
            ->get('employee_history')
            ->result();
        if ($recs) {
            $this->db->trans_start();
            foreach ($recs as $rec) {
                $rec_segments = explode('/', $rec->picture);
                $file_segment = array_pop($rec_segments);

                if (!empty(trim($file_segment))) {
                    $copied = @copy(FCPATH . $rec->picture, FCPATH . 'assets/employee_pictures/' . $file_segment);
                    if (!$copied) {
                        $this->log('Unable to copy picture of employee id:' . $rec->employee_id);
                        continue;
                    }
                    $this->db->where('employee_id', $rec->employee_id)->update('employee_history', [
                        'picture' => './assets/employee_pictures/' . $file_segment,
                    ]);
                }
            }
            $this->db->trans_complete();
            return $this->db->trans_status();
        }
        return true;
    }
    private function syncGoogleQuizzes()
    {
        $this->load->model('quiz/quiz_model');
        return $this->quiz_model->syncForms();
    }
    private function syncGoogleQuizzesResults()
    {
        $this->load->model('quiz/quiz_model');
        return $this->quiz_model->syncResults();
    }
    private function googleQuizReminders()
    {
        $this->load->model('quiz/email_model');
        return $this->email_model->sendReminders();
    }
    private function googleQuizWarnings()
    {
        $this->load->model('quiz/email_model');
        return $this->email_model->sendWarnings();
    }
    private function QuizEmail()
    {
        $email_recs = $this->db
            ->where([
                'status !=' => 'sent',
                'retries <=' => 5,
                'send_at <=' => date('Y-m-d H:i:s'),
            ])
            ->order_by('updated_at', 'asc')
            ->limit(20)->get('qz_email_queue')->result();
        $total_emails = count($email_recs);
        $this->log(sprintf('Found %s emails queued', $total_emails));
        if (!$email_recs) {
            return true;
        }
        $sent_emails = 0;
        $this->load->model('quiz/quiz_model');
        $oauthMailer = new OauthMailer($this->quiz_model->mailClient);
        foreach ($email_recs as $email_rec) {
            $email_rec->content = json_decode($email_rec->content, true);
            $update_rec = ['updated_at' => date('Y-m-d H:i:s')];

            $mail_res = $oauthMailer->config()->send(
                explode(',', $email_rec->eto),
                $email_rec->subject,
                $email_rec->content['body'],
                $email_rec->content['cc'],
                $email_rec->content['bcc'],
                json_decode($email_rec->content['attachments'], true)
            );
            if ($mail_res['status'] = 'success') {
                if ($email_rec->content['delete_attachment'] == true) {
                    $files = json_decode($email_rec->content['attachments'], true);
                    foreach ($files as $file) {
                        @unlink($file);
                    }
                }
                $update_rec['status'] = 'sent';
                $sent_emails++;
            } else {
                $update_rec['status'] = 'failed';
                $update_rec['error'] = $mail_res['message'];
                $update_rec['retries'] = $email_rec->retries + 1;
                $update_rec['total_retries'] = $email_rec->total_retries + 1;
            }
            $this->db->where('id', $email_rec->id)->update('qz_email_queue', $update_rec);
        }
        $this->log(sprintf('%s/%s emails sent', $sent_emails, $total_emails));
        return true;
    }
    private function googleQuizGenerateEmail()
    {
        $this->load->model('quiz/email_model');
        return $this->email_model->generateEmails();
    }
    private function fix_doc_dupes()
    {
        $recs = $this->db->query(
            "SELECT
                GROUP_CONCAT(id) as ids,
                count(id) as c,
                documents
            FROM upload_documents
            WHERE
                documents IS NOT NULL
            GROUP BY documents
            HAVING c > 1
            ORDER BY c ASC
            LIMIT 5"
        )->result();
        if ($recs) {
            $this->load->model('dashboard/setting_model');
            $this->db->trans_start();
            foreach ($recs as $rec) {
                $ids = explode(',', $rec->ids);
                array_pop($ids);
                foreach ($ids as $id) {
                    $file_name = $rec->documents;
                    while ($this->db->where('documents', $file_name)->count_all_results('upload_documents') > 0) {
                        $file_name = file_time_append($rec->documents);
                    }
                    $drive_id = $this->db->where(['id' => $id, 'drive_id !=' => null])->get('upload_documents_drive_ids')->row();
                    if ($drive_id && $this->setting_model->driveInstance) {
                        if (!$this->setting_model->driveInstance->rename($drive_id->drive_id, $file_name)) {
                            exit('rename failed for Gdrive: ' . $drive_id->drive_id . ' - ' . $rec->documents);
                        }
                    }
                    $this->db->where('id', $id)->update('upload_documents', [
                        'documents' => $file_name,
                    ]);
                }
            }
            $this->db->trans_complete();
            return $this->db->trans_status();
        }
        $this->log('no records');
        return false;
    }
    /**
     * Write your functions above this line
     */
    private function postCronCleanup()
    {
        if (!is_windows_server()) {
            exec(sprintf('chmod -R 777 %s', APPPATH . 'cache')) !== false;
            exec(sprintf('chmod -R 777 %s', APPPATH . 'logs')) !== false;
        }
        return true;
    }
    public function __construct()
    {
        parent::__construct();
        $this->load->model('cron_model');
        ob_start();
        ini_set('max_execution_time', 900);
        $this->load->model('cron_model');
    }
    public function index()
    {
        /**
         * Prevent parallel running of cron
         */
        $this->start = -microtime(true);
        $time = @file_get_contents(APPPATH . '/cronlockheavy');
        if ($time && time() - $time < 1800) {
            $this->log(sprintf('---- Cron already started at %s. Exiting.', date('Y-m-d H:i:sO', $time)), 'CRON');exit;
        }
        file_put_contents(APPPATH . '/cronlockheavy', time());
        $weekly_holidays = $this->cron_model->getWeeklyOffs();
        $lastShiftTime = $this->cron_model->getNightShiftStart();

        $this->log('---- Heavy Cron initiated', 'CRON');
        $methods = get_class_methods($this);
        sort($methods);

        $current_working_day = current_working_day(null, false);
        foreach ($methods as $method) {
            $time_start = -microtime(true);
            if (in_array($method, $this->class_functions) || in_array($method, $this->disabled_services)) {
                continue;
            }
            if (in_array($method, $this->run_on_working_days) && in_array(date('l'), $weekly_holidays)) {
                continue;
            }
            if ($this->run_daily[$method] && $this->cache->get('cron_day_exec' . $method) == date('Ymd')) {
                continue;
            }
            if (in_array($method, $this->run_first_shift) && $this->options->get_system('cron.first_shift_exec.' . $method) == $current_working_day) {
                continue;
            }
            if (in_array($method, $this->run_last_shift) && (time() < strtotime($lastShiftTime) || $this->options->get_system('cron.last_shift_exec.' . $method) == $current_working_day)) {
                continue;
            }
            try {
                if (call_user_func([$this, $method])) {
                    $this->log(sprintf('Success: %s execution successful. Took %s', $method, $this->readabletime($time_start)), 'CRON');

                    if ($this->run_daily[$method]) {
                        $this->cache->save('cron_day_exec' . $method, date('Ymd'), strtotime('+1 week', 0));
                    }
                    if (in_array($method, $this->run_first_shift)) {
                        $this->options->set_system('cron.first_shift_exec.' . $method, $current_working_day);
                    }
                    if (in_array($method, $this->run_last_shift)) {
                        $this->options->set_system('cron.last_shift_exec.' . $method, $current_working_day);
                    }
                } else {
                    $this->log(sprintf('Error: %s execution failed. Took %s', $method, $this->readabletime($time_start)), 'CRON');
                }
            } catch (\Throwable $e) {
                $this->log(sprintf('Exception: %s execution crashed. Took %s. Message: %s', $method, $this->readabletime($time_start), $e->getMessage()), 'CRON');
            }
        }
        try {
            $this->postCronCleanup();
        } catch (\Throwable $e) {
            $this->log(sprintf('Exception: %s execution crashed. Took %s. Message: %s', 'postCronCleanup', $this->readabletime($time_start), $e->getMessage()));
        }
        $this->log('---- Heavy Cron ended. Took ' . $this->readabletime($this->start), 'CRON');
        unlink(APPPATH . '/cronlockheavy');
    }
    private $logpath = APPPATH . 'logs/cron/';
    private $class_functions = [
        '__construct',
        'index',
        'log',
        '__get',
        'readabletime',
        'gzCompressFile',
        'postCronCleanup',
    ];
    private $start;
    private function readabletime($time1, $time2 = null)
    {
        if (!$time2) {
            $time2 = microtime(true);
        }
        $time2 += $time1;
        return sprintf('%f seconds', $time2);
    }
    private function gzCompressFile($source, $level = 9)
    {
        $dest = $source . '.gz';
        $mode = 'wb' . $level;
        $error = false;
        if ($fp_out = gzopen($dest, $mode)) {
            if ($fp_in = fopen($source, 'rb')) {
                while (!feof($fp_in)) {
                    gzwrite($fp_out, fread($fp_in, 1024 * 512));
                }

                fclose($fp_in);
            } else {
                $error = true;
            }
            gzclose($fp_out);
        } else {
            $error = true;
        }
        if ($error) {
            return false;
        } else {
            return $dest;
        }

    }
    private function log($message, $method = null)
    {
        if (!$method) {
            $method = debug_backtrace()[1]['function'];
        }
        $message = sprintf('%s | %s | %s', date('H:i:sO'), $method, $message);
        echo $message . '<br>';
        @file_put_contents(
            $this->logpath . date('Ymd') . '.log',
            $message . "\n",
            FILE_APPEND
        );
    }
}
