<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Cron extends MY_Controller
{
    private $run_daily = [
        'Probation_notification' => 1,
        'Contract_notification' => 1,
        'New_employee_joining' => 1,
        'birthdays' => 1,
        'hiring_anniversary' => 1,
    ];
    private $run_first_shift = [
        'change_status_resigned',
    ];
    private $run_last_shift = [
    ];
    private $run_on_working_days = [
        'Probation_notification',
        'Contract_notification',
        'New_employee_joining',
        'cnic_expiry_email',
    ];
    private $disabled_services = [
    ];
    private function Email()
    {
        $email_recs = $this->db->where(['status !=' => 'sent', 'retries <=' => 5])
            ->order_by('updated_at', 'asc')
            ->limit(20)->get('email_queue')->result();
        $total_emails = count($email_recs);
        $this->log(sprintf('Found %s emails queued', $total_emails));
        if (!$email_recs) {
            return true;
        }
        $sent_emails = 0;
        $this->load->library(['TemplateMailer' => 'mailer']);
        foreach ($email_recs as $email_rec) {
            $email_rec->content = json_decode($email_rec->content, true);
            $update_rec = ['updated_at' => date('Y-m-d H:i:s')];
            if ($this->mailer->config($email_rec->division_id)->__send(explode(',', $email_rec->eto), $email_rec->efrom, $email_rec->subject, $email_rec->content['body'], explode(',', $email_rec->content['cc']), explode(',', $email_rec->content['bcc']), json_decode($email_rec->content['attachments'], true))) {
                if ($email_rec->content['delete_attachment'] == true) {
                    $files = json_decode($email_rec->content['attachments'], true);
                    foreach ($files as $file) {
                        @unlink($file);
                    }
                }
                $update_rec['status'] = 'sent';
                $sent_emails++;
            } else {
                $update_rec['status'] = 'failed';
                $update_rec['retries'] = $email_rec->retries + 1;
                $update_rec['total_retries'] = $email_rec->total_retries + 1;
            }
            $this->db->where('id', $email_rec->id)->update('email_queue', $update_rec);
        }
        $this->log(sprintf('%s/%s emails sent', $sent_emails, $total_emails));
        return true;
    }
    private function birthdays()
    {
        $this->load->model('employee/employees_model');
        $recs = $this->employees_model->get_birthday_employees();

        if ($recs) {
            return $this->template_mail->send_to_department(
                $recs[0]->division_id,
                'birthdays',
                sprintf('Today\'s Birthdays: %s', count($recs)),
                $this->load->view('cron/birthday_email', ['date' => formatted_date_now(), 'employees' => $recs], true),
                [],
                [],
                true
            );
        }

        return true;
    }
    private function hiring_anniversary()
    {
        $cache_flag = $this->options->get_system('cron.anniversary.monthly');
        if ($cache_flag === false) {
            $this->log('No flag found in db. Re-generating');
            $this->options->set_system('cron.anniversary.monthly', date('m-Y'));
        } elseif ($cache_flag == date('m-Y')) {
            return true;
        }
        $this->load->model('employee/employees_model');
        $recs = $this->employees_model->get_hiring_anniversary();

        if ($recs) {
            $this->template_mail->send_to_department(
                $recs[0]->division_id,
                'anniversary',
                sprintf('This Month\'s Anniversaries: %s', count($recs)),
                $this->load->view('cron/anniversary_email', ['date' => formatted_date_now(), 'employees' => $recs], true),
                [],
                [],
                true
            );
        }
        $this->options->set_system('cron.anniversary.monthly', date('m-Y'));
        return true;
    }
    private function Probation_notification()
    {
        $this->load->model(['Employee/Employees_model', 'department/department_model']);
        $this->load->library(['TemplateMailer' => 'mailer']);
        $this->db->trans_start();
        $recs = $this->Employees_model->get_expiring_probations();
        foreach ($recs as $rec) {
            if (empty($rec->probation_period)) {
                continue;
            }
            $division = $this->department_model->get_division($rec->division_id);
            $this->notify
                ->department('hr', $rec->division_id)
                ->employee($rec->super_visor_id)
                ->send(
                    sprintf('%s\'s (%s) probation is about to end on %s',
                        implode(' ', [$rec->first_name, $rec->last_name]),
                        $rec->hrm_id,
                        formatted_date($rec->expires_on)
                    ),
                    'employee/Employees/update/' . $rec->employee_id
                );
            $manager_emails = $this->db->select('business_email')->where_in('employee_id', [
                $rec->super_visor_id,
                $rec->indirect_super_visor_id,
            ])
                ->where('status', 'active')->get('employee_history')->result();
            $manager_emails = array_column($manager_emails, 'business_email');
            $manager_emails = array_filter($manager_emails);
            $this->mailer->send_to_hr(
                $rec->division_id,
                sprintf('Probation Ending: %s (%s)',
                    implode(' ', [$rec->first_name, $rec->last_name]),
                    $rec->hrm_id,
                    formatted_date($rec->expires_on)
                ),
                $this->load->view('cron/probation_email', ['employee' => $rec, 'division' => $division], true),
                $manager_emails,
                [],
                true
            );
            $this->db->where('employee_id', $rec->employee_id)->update('employee_history', ['probation_notified' => 1]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    private function Contract_notification()
    {
        $this->load->model(['Employee/Employees_model', 'department/department_model']);
        $this->load->library(['TemplateMailer' => 'mailer']);
        $this->db->trans_start();
        $recs = $this->Employees_model->get_expiring_contracts();
        foreach ($recs as $rec) {
            if (empty($rec->contract_period)) {
                continue;
            }
            $division = $this->department_model->get_division($rec->division_id);
            $this->notify
                ->department('hr', $rec->division_id)
                ->employee($rec->super_visor_id)
                ->send(
                    sprintf('%s\'s (%s) contract is about to end on %s',
                        implode(' ', [$rec->first_name, $rec->last_name]),
                        $rec->hrm_id,
                        formatted_date($rec->expires_on)
                    ),
                    'employee/Employees/update/' . $rec->employee_id
                );
            $manager_emails = $this->db->select('business_email')->where_in('employee_id', [
                $rec->super_visor_id,
                $rec->indirect_super_visor_id,
            ])
                ->where('status', 'active')->get('employee_history')->result();
            $manager_emails = array_column($manager_emails, 'business_email');
            $manager_emails = array_filter($manager_emails);
            $this->mailer->send_to_hr(
                $rec->division_id,
                sprintf('Contract Ending: %s (%s)',
                    implode(' ', [$rec->first_name, $rec->last_name]),
                    $rec->hrm_id,
                    formatted_date($rec->expires_on)
                ),
                $this->load->view('cron/contract_email', ['employee' => $rec, 'division' => $division], true),
                $manager_emails,
                [],
                true
            );
            $this->db->where('employee_id', $rec->employee_id)->update('employee_history', ['contract_notified' => 1]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    private function New_employee_joining()
    {
        $this->load->model(['employee/employees_model' => 'employee', 'department/department_model']);
        $employees = $this->employee->get_todays_joining();

        $this->db->trans_start();
        foreach ($employees as $employee) {
            $division = $this->department_model->get_division($employee->division_id);
            $this->notify
                ->department('hr', $employee->division_id)
                ->send(
                    sprintf('%s\'s (%s) is joining today',
                        implode(' ', [$employee->first_name, $employee->last_name]),
                        $employee->hrm_id
                    ),
                    'recruitment/hired/list'
                );
            $this->mailer->send_to_hr(
                $employee->division_id,
                sprintf('New Joining Today: %s (%s)',
                    implode(' ', [$employee->first_name, $employee->last_name]),
                    $employee->hrm_id,
                    formatted_date($employee->expires_on)
                ),
                $this->load->view('cron/joining_email', ['employee' => $employee, 'division' => $division], true),
                [],
                [],
                true
            );
            $this->db->where('employee_id', $employee->employee_id)->update('employee_history', ['joining_notified' => 1]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    private function change_status_resigned()
    {
        $recs = $this->db
            ->select('employee_id, email, medflow_id, termination_date')
            ->where([
                'status' => 'active',
                'IFNULL(MONTH(termination_date), 0) >' => 0,
            ])
            ->where('termination_date <=', 'curdate()', false)
            ->where('IF(IFNULL(MONTH(rehire_date), 0) > 0, rehire_date, termination_date) <=', 'termination_date', false)
            ->get('employee_history')->result();
        $this->db->trans_start();
        foreach ($recs as $rec) {
            $this->db->where('employee_id', $rec->employee_id)->update('employee_history', [
                'status' => 'resigned',
            ]);
            $user_recs = $this->db->select('id')->where('email', $rec->email)->get('user')->result();
            if ($user_recs) {
                $user_recs = array_column($user_recs, 'id');
                $this->db->where_in('id', $user_recs)->update('user', [
                    'status' => '0',
                ]);
                foreach ($user_recs as $user_rec) {
                    $this->sessionmanager->destroy($user_rec);
                }
            }
            if (!empty(trim($rec->medflow_id))) {
                $this->_active_creds = $this->load->config('other_portals', true);
                foreach ($this->_active_creds as $cred_key => $cred_value) {
                    $this->load->model('recruitment/Cred' . $cred_key . '_model');
                    $this->_active_creds[$cred_key]['roles'] = $this->{'Cred' . $cred_key . '_model'}->setStatus(
                        $cred_key == 'hrm' ? $rec->email : $rec->medflow_id,
                        false
                    );
                }
            }
            $log_reason = sprintf('<br>%s: %s: %s', display('reason'), display('termination_date'), formatted_date($rec->termination_date));
            $this->activity->set_url('employee/Employees/cv/' . $rec->employee_id)->log([
                'employee_update',
                'Status',
                'Active',
                'Resigned',
            ], $rec->employee_id, 'employee', 'employee_history', 'status', '', 0, 'HRM SYSTEM', $log_reason);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    private function cnic_expiry_email()
    {
        $recs = $this->db->select('employee_id, cnic, cnic_expiry, full_name, division_id, business_email, direct_manager_email, indirect_manager_email')
            ->where('cnic_expiry <= ', 'curdate() + INTERVAL 30 Day', false)
            ->where('cnic_expiry_notified <>', 1)
            ->get('employee_details')
            ->result_array();
        if ($recs) {
            $recs = array_map('decrypt_employee_data', $recs);
            $this->db->trans_start();
            foreach ($recs as $rec) {
                $cc = [];
                $to = [];
                if ($rec['business_email']) {
                    $to[] = $rec['business_email'];
                }
                if ($rec['direct_manager_email']) {
                    $cc[] = $rec['direct_manager_email'];
                }
                if ($rec['indirect_manager_email']) {
                    $cc[] = $rec['indirect_manager_email'];
                }
                $this->template_mail
                    ->send_to_department(
                        $rec['division_id'],
                        'hr',
                        'Your CNIC is about to expire',
                        $this->load->view('cron/cnic_expiry_email', $rec, true),
                        $cc,
                        [],
                        true,
                        [],
                        false,
                        $to
                    );

                $this->db->where('employee_id', $rec['employee_id'])->update('employee_history', [
                    'cnic_expiry_notified' => 1,
                ]);
            }
            $this->db->trans_complete();
            return $this->db->trans_status();
        }
        return true;
    }
    private function process_device_attendance()
    {
        $this->load->model('attendance/attendence_model');

        $attendance_recs = [];
        $divisions = &$this->bio_devices->getDevices();
        if (!$divisions) {
            $this->log('No active attendance machines found');
            return false;
        }
        foreach ($divisions as $division_id => &$devices) {
            foreach ($devices as $machine_id => &$device) {
                $device->connect();
                $max_rec = $this->db->select_max('device_row_id')->where('device_id', $machine_id)->get('attendance_history')->row();

                $device->disableDevice();
                if ($attendance = $device->getAttendance()) {
                    foreach ($attendance as $at_rec) {
                        if ($at_rec['id'] <= $max_rec->device_row_id) {
                            continue;
                        }
                        $user = $device->getUser($at_rec['uid']);
                        if (!$user) {
                            $device->log('No user found on device with ID: ' . $at_rec['uid'] . '. Device# ' . $machine_id);
                            continue;
                        }
                        if (!$user['hrm_id']) {
                            $device->log('Unknown hrm id for user: ' . json_encode($user) . '. Device# ' . $machine_id);
                            continue;
                        }
                        $employee = $this->db->select('employee_id, shift')->where('hrm_id', $user['hrm_id'])->get('employee_history')->row();
                        if (!$employee) {
                            $device->log('No employee found on device with ID: ' . $at_rec['uid'] . ', HRM ID: ' . $user['hrm_id'] . '. Device# ' . $machine_id);
                            continue;
                        }
                        if (!$employee->shift) {
                            $device->log('Shift is not assigned to HRM ID: ' . $user['hrm_id'] . ', employee_id:' . $employee->employee_id);
                            continue;
                        }
                        $at_rec['employee_id'] = $employee->employee_id;
                        $at_rec['shift'] = $employee->shift;
                        $at_rec['machine_id'] = $machine_id;
                        $attendance_recs[] = $at_rec;
                    }
                }
                $device->enableDevice();
            }
        }
        usort($attendance_recs, function ($a, $b) {
            return $a['time'] <=> $b['time'];
        });
        $this->db->trans_start();
        foreach ($attendance_recs as $at_rec) {
            $this->attendence_model->add_machine_punch($at_rec['type'], $at_rec['state'], $at_rec['employee_id'], $at_rec['shift'], date('Y-m-d H:i:s', $at_rec['time']), $at_rec['machine_id'], $at_rec['id']);
        }
        $this->db->trans_commit();
        if ($this->db->trans_status() === false) {
            $this->log('Attendance save failed');
        }
        $this->log('Attendance rows saved: ' . count($attendance_recs));
        return $this->db->trans_status();
    }
    /**
     * Write your functions above this line
     */
    private function postCronCleanup()
    {
        if (!is_windows_server()) {
            exec(sprintf('chmod -R 777 %s', APPPATH . 'cache')) !== false;
            exec(sprintf('chmod -R 777 %s', APPPATH . 'logs')) !== false;
        }
        return true;
    }
    public function __construct()
    {
        parent::__construct();
        $this->load->model('cron_model');
        ob_start();
        ini_set('max_execution_time', 900);
        $this->load->model('cron_model');
    }
    public function index()
    {
        /**
         * Prevent parallel running of cron
         */
        $this->start = -microtime(true);
        $time = @file_get_contents(APPPATH . '/cronlock');
        if ($time && time() - $time < 1800) {
            $this->log(sprintf('---- Cron already started at %s. Exiting.', date('Y-m-d H:i:sO', $time)), 'CRON');exit;
        }
        file_put_contents(APPPATH . '/cronlock', time());
        $weekly_holidays = $this->cron_model->getWeeklyOffs();
        $lastShiftTime = $this->cron_model->getNightShiftStart();

        $this->log('---- Cron initiated', 'CRON');
        $methods = get_class_methods($this);
        sort($methods);

        $current_working_day = current_working_day(null, false);
        foreach ($methods as $method) {
            $time_start = -microtime(true);
            if (in_array($method, $this->class_functions) || in_array($method, $this->disabled_services)) {
                continue;
            }
            if (in_array($method, $this->run_on_working_days) && in_array(date('l'), $weekly_holidays)) {
                continue;
            }
            if ($this->run_daily[$method] && $this->cache->get('cron_day_exec' . $method) == date('Ymd')) {
                continue;
            }
            if (in_array($method, $this->run_first_shift) && $this->options->get_system('cron.first_shift_exec.' . $method) == $current_working_day) {
                continue;
            }
            if (in_array($method, $this->run_last_shift) && (time() < strtotime($lastShiftTime) || $this->options->get_system('cron.last_shift_exec.' . $method) == $current_working_day)) {
                continue;
            }
            try {
                if (call_user_func([$this, $method])) {
                    $this->log(sprintf('Success: %s execution successful. Took %s', $method, $this->readabletime($time_start)), 'CRON');

                    if ($this->run_daily[$method]) {
                        $this->cache->save('cron_day_exec' . $method, date('Ymd'), strtotime('+1 week', 0));
                    }
                    if (in_array($method, $this->run_first_shift)) {
                        $this->options->set_system('cron.first_shift_exec.' . $method, $current_working_day);
                    }
                    if (in_array($method, $this->run_last_shift)) {
                        $this->options->set_system('cron.last_shift_exec.' . $method, $current_working_day);
                    }
                } else {
                    $this->log(sprintf('Error: %s execution failed. Took %s', $method, $this->readabletime($time_start)), 'CRON');
                }
            } catch (\Throwable $e) {
                $this->log(sprintf('Exception: %s execution crashed. Took %s. Message: %s', $method, $this->readabletime($time_start), $e->getMessage()), 'CRON');
            }
        }
        try {
            $this->postCronCleanup();
        } catch (\Throwable $e) {
            $this->log(sprintf('Exception: %s execution crashed. Took %s. Message: %s', 'postCronCleanup', $this->readabletime($time_start), $e->getMessage()));
        }
        $this->log('---- Cron ended. Took ' . $this->readabletime($this->start), 'CRON');
        unlink(APPPATH . '/cronlock');
    }
    private $logpath = APPPATH . 'logs/cron/';
    private $class_functions = [
        '__construct',
        'index',
        'log',
        '__get',
        'readabletime',
        'gzCompressFile',
        'postCronCleanup',
    ];
    private $start;
    private function readabletime($time1, $time2 = null)
    {
        if (!$time2) {
            $time2 = microtime(true);
        }
        $time2 += $time1;
        return sprintf('%f seconds', $time2);
    }
    private function gzCompressFile($source, $level = 9)
    {
        $dest = $source . '.gz';
        $mode = 'wb' . $level;
        $error = false;
        if ($fp_out = gzopen($dest, $mode)) {
            if ($fp_in = fopen($source, 'rb')) {
                while (!feof($fp_in)) {
                    gzwrite($fp_out, fread($fp_in, 1024 * 512));
                }

                fclose($fp_in);
            } else {
                $error = true;
            }
            gzclose($fp_out);
        } else {
            $error = true;
        }
        if ($error) {
            return false;
        } else {
            return $dest;
        }

    }
    private function log($message, $method = null)
    {
        if (!$method) {
            $method = debug_backtrace()[1]['function'];
        }
        $message = sprintf('%s | %s | %s', date('H:i:sO'), $method, $message);
        echo $message . '<br>';
        @file_put_contents(
            $this->logpath . date('Ymd') . '.log',
            $message . "\n",
            FILE_APPEND
        );
    }
}
