<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Benefits extends Admin_Controller {

    // private $table  = "language";
    // private $phrase = "phrase";

    public function __construct()
    {
        parent::__construct(); 
        $this->load->helper('language');
        $this->load->model('benefits_model');
        
    } 

    public function index()
    {  
        $data['title']     = "Benefits";
        $data['module']    = "dashboard";
        $data['page']      = "benefits/lists";
        $data['benefits']  = $this->benefits_model->read();
        echo modules::run('template/layout', $data);
    }

    public function getBenefits(){
        $post= $this->input->post();
        $data = $this->benefits_model->read($post['id']);
        echo json_encode($data);

    }

    public function add_benefits(){
        $this->form_validation->set_rules('name','Name'  ,'required|is_unique[benefits.name]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $post = $this->input->post();
            $data['name'] = $post['name'];
            $data['created_at'] = date('Y-m-d');
            // $data['created_by'] = $this->session->userdata('id');
            if ($this->benefits_model->create($data)) { 
                $this->session->set_flashdata('message', "Benefit Inserted Successfully!");
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("dashboard/benefits");
        }else{
          $this->index();
        }
    }

    public function edit_benefits($id){
        $this->form_validation->set_rules('name','Name'  ,'required');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $post = $this->input->post();
            $data['name'] = $post['name'];
            
            if($this->benefits_model->match_benefits($post['name'],$id)){
               $this->session->set_flashdata('exception',  'Benefit Name field must contain a unique value.');
               redirect("dashboard/benefits");
            }

            $data['created_at'] = date('Y-m-d');
            // $data['created_by'] = $this->session->userdata('id');
            if ($this->benefits_model->update($id,$data)) { 
                $this->session->set_flashdata('message', "Benefits Inserted Successfully!");
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("dashboard/benefits");
        }else{
          $this->index();
        }
    }

    public function delete_benefits($id){
        // echo $this->temp_model->delete($id);exit;
           if($this->benefits_model->delete($id)){
                $this->session->set_flashdata('message', "Benefits Deleted Successfully!");
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("dashboard/benefits");
    }



    public function templates(){
        $data['title']     = "Templates";
        $data['module']    = "dashboard";
        $data['page']      = "temp/templates";
        $data['templates'] = $this->temp_model->template_read();
        echo modules::run('template/layout', $data);
    }

    public function getTemplateCategory(){
           $post = $_POST['searchTerm'];
            $e = $this->db->select('*')->from('template_category')->like(['name'=>$post])->get()->result();
            $data  = array();
            foreach ($e as $key => $value) {
                $data[] =array('id'=>$value->id,'text'=>$value->name);
            }
            echo json_encode($data);
            exit;
    }

    public function create_template(){
        $this->form_validation->set_rules('name','Name'  ,'required');
        $this->form_validation->set_rules('category_id','Category Name'  ,'required');
        $this->form_validation->set_rules('template','Template'  ,'required');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $post = $this->input->post();
            $data['name'] = $post['name'];
            $data['category_id'] = $post['category_id'];
            $data['template'] = $post['template'];
            $data['created_on'] = date('Y-m-d');
            $data['created_by'] = $this->session->userdata('id');
            if ($this->temp_model->create($data,'document_template')) { 
                $this->session->set_flashdata('message', "Template Inserted Successfully!");
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("dashboard/temp/templates");
        }else{
         $this->templates();
        }
    }

    public function editTemplateData(){
        $id = $this->input->post('id');
        echo json_encode($this->temp_model->template_read($id));
    }
    

    public function edit_template($id){
        $this->form_validation->set_rules('name','Name'  ,'required');
        $this->form_validation->set_rules('category_id','Category Name'  ,'required');
        $this->form_validation->set_rules('template','Template'  ,'required');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $post = $this->input->post();
            $data['name'] = $post['name'];
            $data['category_id'] = $post['category_id'];
            $data['template'] = $post['template'];
            $data['created_on'] = date('Y-m-d');
            $data['created_by'] = $this->session->userdata('id');
            if ($this->temp_model->update($id,$data,'document_template')) { 
                $this->session->set_flashdata('message', "Template Updated Successfully!");
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("dashboard/temp/templates");
        }else{
         $this->templates();
        }
    }


  public function delete_template($id){
        // echo $this->temp_model->delete($id);exit;
           if($this->temp_model->delete($id,'document_template')){
                $this->session->set_flashdata('message', "Template Deleted Successfully!");
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("dashboard/temp/templates");
    }
    
    public function getTemplateByCategory(){
        $cat = $this->input->post('category_id');
        $result = $this->db->select('*')->from('document_template')->where('category_id',$cat)->get()->result();
        echo json_encode($result);
    }



    public function getTemplateById(){
        $id = $this->input->post('id');
        $result = $this->db->select('*')->from('document_template')->where('id',$id)->get()->result();
        echo json_encode($result);
    }


}



 