<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Auth extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'auth_model',
        ));
    }
    public function shroten_work($short_url)
    {
        redirect("recruitment/Careers/job/" . $short_url);
    }
    public function index()
    {
        if ($this->session->userdata('isLogIn')) {
            redirect('dashboard/home');
        }
        if ($this->input->post()) {
            #-------------------------------------#
            $this->form_validation->set_rules('email', display('email'), 'trim|required|valid_email|max_length[100]');
            $this->form_validation->set_rules('password', display('password'), 'required|max_length[32]');
            #-------------------------------------#
            $data['user'] = (object) $userData = array(
                'email' => $this->input->post('email'),
                'password' => $this->input->post('password'),
            );
            #-------------------------------------#
            if ($this->form_validation->run()) {
                $user = $this->auth_model->checkUser($userData);
                if ($user && $user->num_rows() > 0) {
                    $permission = $this->auth_model->get_permissions($user->row()->id);
                    if ($user->row()->is_admin == 2) {
                        $row = $this->db->select('client_id,client_email')->where('client_email', $user->row()->email)->get('setup_client_tbl')->row();
                    }
                    $employee_info = $this->db->select('employee_history.*, position.position_name as designation, department.department_name,divisions.name app_name,divisions.logo app_logo')
                        ->from('employee_history')
                        ->join('department', 'employee_history.dept_id=department.dept_id', 'left')
                        ->join('divisions', 'employee_history.division_id=divisions.id', 'left')
                        ->join('position', 'employee_history.pos_id=position.pos_id', 'left')
                        ->where('employee_history.email', $user->row()->email)
                        ->get()->row();
                    $image = null;
                    if (!empty($employee_info->picture)) {
                        $image = 'employee/employees/image';
                    }
                    if (!empty($user->row()->image)) {
                        $image = $user->row()->image;
                    }
                    if ($employee_info->is_super_visor) {
                        $supervisor_check = $this->db
                            ->group_start()
                            ->where_not_in('status', ['resigned', 'released', 'terminated', 'not-joined'])
                            ->where(['employee_id <>' => $employee_info->employee_id])
                            ->group_end()
                            ->group_start()
                            ->or_where(['super_visor_id' => $employee_info->employee_id, 'indirect_super_visor_id' => $employee_info->employee_id])
                            ->group_end()
                            ->count_all_results('employee_history');
                        $employee_info->is_super_visor = $supervisor_check > 0 ? 1 : 0;
                    }
                    $sData = array(
                        'isLogIn' => true,
                        'isAdmin' => (($user->row()->is_admin == 1) ? true : false),
                        'user_type' => $user->row()->is_admin,
                        'id' => $user->row()->id,
                        'client_id' => @$row->client_id,
                        'fullname' => $user->row()->fullname,
                        'user_level' => $user->row()->user_level,
                        'email' => $user->row()->email,
                        'image' => $image,
                        'last_login' => $user->row()->last_login,
                        'last_logout' => $user->row()->last_logout,
                        'ip_address' => $user->row()->ip_address,
                        'employee_id' => $employee_info->employee_id,
                        'shift' => $employee_info->shift,
                        'dept_id' => $employee_info->dept_id,
                        'division_id' => $employee_info->division_id,
                        'division_name' => $employee_info->app_name,
                        'division_logo' => $employee_info->app_logo,
                        'dept_name' => $employee_info->department_name,
                        'designation' => $employee_info->designation,
                        'hrm_id' => $employee_info->hrm_id,
                        'first_name' => $employee_info->first_name,
                        'last_name' => $employee_info->last_name,
                        'supervisor' => $employee_info->is_super_visor,
                        'direct_supervisor' => $employee_info->super_visor_id,
                        'indirect_supervisor' => $employee_info->indirect_super_visor_id,
                        'permission' => json_encode(@$permission['permission']),
                        'label_permission' => json_encode(@$permission['permission1']),
                        'full_permissions' => json_encode(@$permission['full_permissions']),
                        'roles' => $permission['roles'],
                        'loaded' => date('Y-m-d H:i:s'),
                    );
                    //store date to session
                    $this->session->set_userdata($sData);
                    $this->load->model('home_model');
                    $this->home_model->load_user_opts();
                    //update database status
                    $this->auth_model->last_login();
                    $this->auth_model->reset_retries($this->input->post('email'));
                    $this->session->set_flashdata('message', display('welcome_back') . ' ' . $user->row()->fullname);
                    $this->session->set_flashdata('show_notifications_toaster', 1);
                    $this->load->model('employee/documents_model');
                    $this->documents_model->check_for_missing_documents($sData['employee_id']);
                    $this->sessionmanager->check();
                    if ($this->input->get('rback')) {
                        redirect($this->input->get('rback'));
                    } else {
                        redirect('dashboard/home');
                    }
                } else {
                    $this->log_to_file('Incorrect login try: ' . $userData['email']);
                    $this->session->set_flashdata('exception', display('incorrect_email_or_password'));
                }
            }
        }
        $data['title'] = display('login');
        echo Modules::run('template/login', $data);
    }
    public function logout()
    {
        $division = $this->session->userdata('division_id');
        //update database status
        $this->auth_model->last_logout();
        $this->sessionmanager->destroy($this->session->userdata('id'), $this->sessionmanager->currentId(), null, true);
        $this->session->sess_destroy();
        if ($this->input->get('rback')) {
            redirect($this->input->get('rback'));
        } else {
            if ($division) {
                redirect('game-night/' . $division);
            } else {
                redirect('login');
            }
        }
    }
    public function forgot_password()
    {
        if ($this->session->userdata('isLogIn')) {
            redirect('dashboard/home');
        }
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'hrm_id',
                    'label' => display(['Employee', 'ID']),
                    'rules' => 'trim|required|regex_match[/^\w{3}-\d{4,}$/]',
                ),
                array(
                    'field' => 'email',
                    'label' => display('business_email'),
                    'rules' => 'trim|required|valid_email',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                $fields = array_column($rules_config, 'field');
                $errors = [];
                foreach ($fields as $field) {
                    if ($err = form_error($field)) {
                        $errors[] = [$field, $err];
                    }
                }
                sendJson(['errors' => $errors]);
            }
            $rec = $this->db->select('user_id, email, division_id, full_name, business_email')
                ->where([
                    'hrm_id' => $this->input->post('hrm_id'),
                    'business_email' => $this->input->post('email'),
                ])
                ->where_in('status', ['active', 'on-hold'])
                ->get('employee_details')
                ->row();
            if (!$rec) {
                sendJson(['error' => display(['Employee', 'ID', 'or', 'business_email', "doesn't", 'match'], true)]);
            }
            if (!$rec->user_id || !$rec->email || !$rec->division_id) {
                sendJson(['error' => display(['User', 'not', 'assigned'])]);
            }
            $str = $this->auth_model->generate_reset_string($rec->user_id);
            $this->template_mail->config($rec->division_id);

            $res = $this->template_mail->__send(
                    $rec->business_email,
                    $this->template_mail->get_config('email_from'),
                    display(['forgot', 'password']),
                    $this->load->view('cron/reset_password_email', ['name' => $rec->full_name, 'url' => base_url('reset-password/' . $str)], true)
                );
            if ($res) {
                $this->session->set_flashdata('success', $message = display(['Link', 'is', 'sent', 'to', 'your', 'email'], true) . '. ' . display(['Check', 'your', 'inbox', 'for', 'further', 'instructions'], true));
                sendJson(['success' => $message, 'redirect' => base_url()]);
            } else {
                sendJson(['error' => display(['unable', 'to', 'send', 'email'], true) . '. ' . display(['try', 'again'], true)]);
            }
        }
        $data['title'] = display(['forgot', 'password']);
        echo Modules::run('template/forgot_password', $data);
    }
    public function reset_password($str)
    {
        $data['title'] = display(['forgot', 'password']);
        if (!$this->auth_model->verify_reset_string($str)) {
            echo Modules::run('template/invalid_reset_url', $data);return;
        }
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'password',
                    'label' => display('password'),
                    'rules' => 'required|min_length[6]|max_length[32]',
                ),
                array(
                    'field' => 'conf_password',
                    'label' => display(['confirm', 'password']),
                    'rules' => 'required|matches[password]',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === false) {
                $fields = array_column($rules_config, 'field');
                $errors = [];
                foreach ($fields as $field) {
                    if ($err = form_error($field)) {
                        $errors[] = [$field, $err];
                    }
                }
                sendJson(['errors' => $errors]);
            }
            $str = $this->auth_model->parse_reset_string($str);
            if ($this->auth_model->change_password($str['user_id'], $this->input->post('password'))) {
                sendJson(['success' => display(['password', 'updated', 'successfully'], true), 'redirect' => base_url()]);
            }
            sendJson(['error' => display(['unable', 'to', 'updated', 'password']) . '. ' . display(['try', 'again'])]);
        }
        echo Modules::run('template/reset_password', $data);
    }
    public function userlogin($id)
    {
        if (defined('INTERNAL_HRM') && $this->session->userdata('employee_id') == 277) {
            $user = $this->db->select("user.id, CONCAT_WS(' ', user.firstname, user.lastname) AS fullname, user.email,  user.image, user.last_login, user.last_logout, user.ip_address, user.status, user.is_admin, IF (user.is_admin=1, 'Admin', 'User') as user_level")->from('user')->where('id', $id)->get();
            if ($user->num_rows() > 0) {
                $permission = $this->auth_model->get_permissions($user->row()->id);
                $employee_info = $this->db->select('employee_history.*, position.position_name as designation, department.department_name,divisions.name app_name,divisions.logo app_logo')
                    ->from('employee_history')
                    ->join('department', 'employee_history.dept_id=department.dept_id', 'left')
                    ->join('divisions', 'employee_history.division_id=divisions.id', 'left')
                    ->join('position', 'employee_history.pos_id=position.pos_id', 'left')
                    ->where('employee_history.email', $user->row()->email)
                    ->get()->row();
                $image = null;
                if (!empty($employee_info->picture)) {
                    $image = 'employee/employees/image';
                }
                if (!empty($user->row()->image)) {
                    $image = $user->row()->image;
                }
                if ($employee_info->is_super_visor) {
                    $supervisor_check = $this->db
                        ->group_start()
                        ->where_not_in('status', ['resigned', 'released', 'terminated', 'not-joined'])
                        ->where(['employee_id <>' => $employee_info->employee_id])
                        ->group_end()
                        ->group_start()
                        ->or_where(['super_visor_id' => $employee_info->employee_id, 'indirect_super_visor_id' => $employee_info->employee_id])
                        ->group_end()
                        ->count_all_results('employee_history');
                    $employee_info->is_super_visor = $supervisor_check > 0 ? 1 : 0;
                }
                $sData = array(
                    'isLogIn' => true,
                    'isAdmin' => (($user->row()->is_admin == 1) ? true : false),
                    'user_type' => $user->row()->is_admin,
                    'id' => $user->row()->id,
                    'client_id' => 1,
                    'fullname' => $user->row()->fullname,
                    'user_level' => $user->row()->user_level,
                    'email' => $user->row()->email,
                    'image' => $image,
                    'last_login' => $user->row()->last_login,
                    'last_logout' => $user->row()->last_logout,
                    'ip_address' => $user->row()->ip_address,
                    'employee_id' => $employee_info->employee_id,
                    'shift' => $employee_info->shift,
                    'dept_id' => $employee_info->dept_id,
                    'division_id' => $employee_info->division_id,
                    'division_name' => $employee_info->app_name,
                    'division_logo' => $employee_info->app_logo,
                    'dept_name' => $employee_info->department_name,
                    'designation' => $employee_info->designation,
                    'hrm_id' => $employee_info->hrm_id,
                    'first_name' => $employee_info->first_name,
                    'last_name' => $employee_info->last_name,
                    'supervisor' => $employee_info->is_super_visor,
                    'direct_supervisor' => $employee_info->super_visor_id,
                    'indirect_supervisor' => $employee_info->indirect_super_visor_id,
                    'permission' => json_encode(@$permission['permission']),
                    'label_permission' => json_encode(@$permission['permission1']),
                    'full_permissions' => json_encode(@$permission['full_permissions']),
                    'roles' => $permission['roles'],
                    'loaded' => date('Y-m-d H:i:s'),
                );
                //store date to session
                $this->session->set_userdata($sData);
                $this->load->model('home_model');
                $this->home_model->load_user_opts();
                $this->session->set_flashdata('message', display('welcome_back') . ' ' . $user->row()->fullname);
                redirect('dashboard/home');
            }
        } else {
            redirect();
        }
    }
    public function switch()
    {
        if (defined('INTERNAL_HRM') && $this->session->userdata('employee_id') == 277) {
            $this->session->set_userdata([
                'isAdmin' => true,
                'user_type' => 1,
            ]);
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    /*
    |--------------------------------------------------------
    | Finger print Device information
    |--------------------------------------------------------
     */
    public function deviceData()
    {
        return $this->db->select('*')->from('deviceinfo')->get()->row();
    }
    private function log_to_file($message, $method = null)
    {
        $print_str = "%s | %s | %s\n%s | %s | %s\n";
        if ($method) {
            $print_str = '>>>>>>>><<<<<<<< ' . $print_str;
        }
        $ip = get_ip_address();
        $stamp = date('H:i:sO');
        @file_put_contents(
            APPPATH . 'logs/logins/' . date('Ymd') . '.log',
            sprintf($print_str, $stamp, $ip, $message, $stamp, $ip, $_SERVER['HTTP_USER_AGENT']),
            FILE_APPEND
        );
    }
    public function game_night($id)
    {
        $data['title'] = display(['game', 'night']);
        $data['id'] = $id;
        if (!@$this->_promo_vids[$id]) {
            redirect();
        }
        $data['video'] = $this->_promo_vids[$id];
        echo Modules::run('template/game_night', $data);
    }
}
