<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Award_model extends CI_Model
{
    public function award_view_($id = null)
    {
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        $employee_id = $this->session->userdata('employee_id');
        $this->db->select('count(DISTINCT(aw.award_id)) as award_id,aw.*,p.employee_id,p.first_name,p.last_name,
			(select user.firstname from user where user.id = aw.approved_by) as approvedBy,
			(select user.firstname from user where user.id = aw.rejected_by) as rejectedBy,awards.name,awards.description
			')->from('award aw')
            ->join('employee_history p', 'aw.employee_id = p.employee_id', 'left')
            ->join('awards', 'awards.id=aw.AwardID');
        $userId = $this->session->userdata('employee_id');
        if (isset($id)) {
            $this->db->where('aw.award_id', $id);
        } else {
            if ($admin != 1 && !$this->permission->full('award')->access()) {
                if ($is_supervisor != 1) {
                    $this->db->where('aw.approved', 1);
                }
            }
        }
        return $this->db->group_by('aw.award_id')->order_by('aw.award_id', 'desc')->get()->result();
    }
    public function award_view($id = null)
    {
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $this->db->select('aw.*,p.employee_id,p.first_name,p.last_name,p.first_name,p.last_name,p.super_visor_id,p.indirect_super_visor_id,
			(select user.firstname from user where user.id = aw.approved_by) as approvedBy,
			(select user.firstname from user where user.id = aw.rejected_by) as rejectedBy,awards.name,awards.description
			')->from('award aw')
            ->join('employee_history p', 'aw.employee_id = p.employee_id', 'left')
            ->join('awards', 'awards.id=aw.AwardID');
        if (isset($id)) {
            $this->db->where('aw.award_id', $id);
        } else {
            if ($admin != 1 && !$this->permission->full('award')->access()) {
                if ($is_supervisor != 1) {
                    $this->db->where('aw.approved', 1);
                }
            }
        }
        return $this->db->order_by('aw.award_id', 'asc')->get()->result();
    }
    public function award_create($data = array())
    {
		$admin = $this->session->userdata('isAdmin');
        if ($admin == 1) {
            $data['approved_date'] = date('Y-m-d');
        } else {
            $data['created_by'] = $this->session->userdata('employee_id');
        }
        $res = $this->db->insert('award', $data);
        if ($res) {
            // $this->notify->employee($data['employee_id'])->send(
            //     sprintf('You have won an award "%s"', $data['award_name']),
            //     'award/Award_controller/view_award'
            // );
            $awards = $this->db->where('id', $data['AwardID'])->get('awards')->first_row();
            $this->activity->set_url('award/Award_controller/view_award')->set_employee($data['employee_id'])->log([
                'award_assigned',
                $awards->name,
            ]);
            $empl_rec = $this->db->select('*, CONCAT_WS(\' \', first_name, last_name) as fullname')->where('employee_id', $data['employee_id'])->get('employee_history')->row();
            if ($admin != 1) {
                $this->notify->department('hr')->send(
                    sprintf('new award "%s" won by %s (%s) need your approval ', $awards->name, $empl_rec->fullname, $empl_rec->hrm_id),
                    'award/Award_controller/award_view'
                );
                //             if($this->session->userdata('employee_id') == $empl_rec->indirect_super_visor_id){
                $this->notify->employee($this->session->userdata('employee_id'))->send(
                    sprintf('Notification send for approval "%s"', $awards->name),
                    'award/Award_controller/view_award'
                );
                // }
            } else {
                $this->notify->employee($empl_rec->employee_id)->send(
                    sprintf('You have won an award "%s"', $awards->name),
                    'award/Award_controller/view_award'
                );
                $this->notify->employee($empl_rec->super_visor_id)->send(
                    sprintf('%s (%s) award has been approved ', $empl_rec->fullname, $empl_rec->hrm_id, $awards->name),
                    'award/Award_controller/view_award'
                );
            }
        }
        return $res;
    }
    public function award_delete($id = null)
    {
        $this->db->where('award_id', $id)
            ->delete('award');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function update_award($data = array())
    {
        $award_rec = $this->get_id($data['award_id']);
        if (isset($data['approved'])) {
            $this->activity
                ->set_employee($award_rec['employee_id'])
                ->set_url('award/Award_controller/view_award')
                ->log([
                    'award_status_updated',
                    $data['approved'] == 1 ? 'Approved' : 'Rejected',
                    $award_rec['award_title'],
                    $data["award_id"],
                ]);
        } else {
            $this->activity
                ->set_employee($award_rec['employee_id'])
                ->set_url('award/Award_controller/view_award')
                ->log([
                    'award_updated',
                    $award_rec['award_title'],
                    $data["award_id"],
                ]);
        }
        return $this->db->where('award_id', $data["award_id"])
            ->update("award", $data);
    }
    public function award_updateForm($id)
    {
        $this->db->where('award_id', $id);
        $query = $this->db->get('award');
        return $query->row();
    }
    public function get_subordinates($include = true, $override = false)
    {
        $this->load->model('employee/employees_model');
        return $this->employees_model->get_subordinates(null, $include, $override);
    }
    public function dropdown()
    {
        $data = [];
        if ($this->session->userdata('isAdmin') == 1 || $this->permission->full('award')->access()) {
            $data = $this->db->select('employee_id, first_name, last_name, hrm_id')->order_by('first_name', 'asc')->get('employee_history')->result_array();
        } elseif ($this->session->userdata('supervisor') == 1) {
            $data = $this->get_subordinates(false);
        } else {
            return [];
        }
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value['employee_id']] = sprintf('%s %s (%s)', $value['first_name'], $value['last_name'], $value['hrm_id']);
            }
        }
        return $list;
    }
    public function get_id($id)
    {
        $query = $this->db->select('award.*, awards.name as award_title')->join('awards', 'award.AwardID=awards.id', 'left')->get_where('award', array('award_id' => $id));
        return $query->row_array();
    }
}
