<div class="container-fluid">
    <table class="table table-hover">
        <thead>
            <tr>
                <th><?= display(['employee', 'id']) ?></th>
                <th><?= display(['employee', 'name']) ?></th>
                <th><?= display(['check', 'in', 'time']) ?></th>
                <th><?= display('hours') ?></th>
                <th class="hideexport"><?= display('actions') ?></th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
<script>
$(document).ready(function() {
    window.dtable = $('table.table').DataTable($.extend({},
        window.default_datatable_opts, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'post',
                beforeSend: function() {},
                complete: function() {}
            },
            columns: [{
                'data': 'hrm_id',
            }, {
                'data': 'first_name',
            }, {
                'data': 'punchin_time',
            }, {
                'data': 'hours',
            }, {
                'data': 'action',
                'sortable': false
            }, ],
            order: [
                [3, 'desc']
            ]
        }
    ))
    $('table').on('click', '.btn-checkout', function(e) {
        e.preventDefault();
        var $this = $(this);
        Swal.fire({
            title: `Are you sure?`,
            html: `Pressing 'Yes' will check out attendance for "<strong>${$this.data('name')}</strong>"`,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: `Yes, check out attendance`
        }).then((result) => {
            if (result.isConfirmed) {
                myajax({
                    type: "POST",
                    url: "<?= base_url() ?>attendance/home/checkout_manual",
                    data: {
                        id: $(this).data('id'),
                        eid: $(this).data('eid'),
                    },
                    success: function(res) {
                        if (res.success) {
                            Swal.fire(
                                'success',
                                res.success,
                                'success'
                            )
                            window.dtable.ajax.reload();
                        } else if (res.error) {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                res.error,
                                'error'
                            )
                        } else {
                            Swal.fire(
                                '<?= display('error') ?>!',
                                'Unknown server error, try again',
                                'error'
                            )
                        }
                    }
                });
            }
        })
    })
});
</script>