<?php
class Timeadjustment_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();

        $this->load->model('notification/notification_model');
    }
    public function add($post)
    {
        $full_name = $this->session->userdata('fullname');
        $supervisor_id = !empty($this->session->userdata('direct_supervisor')) ? $this->session->userdata('direct_supervisor') : 0;
        if ($this->session->userdata('isAdmin')) {
            $employee_details = $this->get_employee($post['employee_id']);
            $full_name = [];
            $full_name[] = $employee_details->first_name;
            $full_name[] = $employee_details->middle_name;
            $full_name[] = $employee_details->last_name;
            $full_name = ucwords(implode(' ', $full_name));
            if ($employee_details->hrm_id) {
                $full_name = $full_name . ' (' . $employee_details->hrm_id . ')';
            }
            $supervisor_id = !empty($employee_details->super_visor_id) ? $employee_details->super_visor_id : 0;
        }
        $add = [
            'checkin' => date('Y-m-d H:i:s', strtotime($post['checkin'])),
            'checkout' => date('Y-m-d H:i:s', strtotime($post['checkout'])),
            'reason' => strip_tags($post['reason']),
            'employee_id' => $this->session->userdata('isAdmin') ? $post['employee_id'] : $this->session->userdata('employee_id'),
            'supervisor' => $supervisor_id,
        ];
        $add = $this->add_fields($add);

        $res = $this->db->insert('time_adjustment', $add);
        if ($res) {
            $res = $this->db->insert_id();
            if (intval($supervisor_id) > 0) {
                $this->notify->employee($supervisor_id);
            }
            $this->notify->department('hr')->send($full_name . ' added a Time Adjustment Request ID# ' . $res, 'attendance/timeadjustment/all_requests');
            return $res;
        } else {
            return false;
        }
    }
    public function get($id)
    {
        return $this->db->where('id', $id)->get('time_adjustment')->row_array();
    }
    public function update($id, $data)
    {
        return $this->db->where('id', $id)->update('time_adjustment', $data);
    }
    public function process($id, $type)
    {
        $data = $this->get($id);

        if (!$data) {
            return;
        }
        $employees_under = array_column($this->get_subordinates(true), 'employee_id');
        $this->db->trans_start();
        if ($this->permission->method('atn_time_adjustment_list', 'update')->access() || $this->session->userdata('isAdmin')) {
            if ($type == 'approved') {
                $this->modify_attendance($data);
            }
            $res = $this->update($id, [
                'hr_status' => $type ? 'approved' : 'denied',
                'hr_approver' => $this->session->userdata('employee_id'),
            ]);
            if ($res) {
                $this->notify->employee([$data['supervisor'], $data['employee_id']])->department('hr')->send(
                    'HR ' . ($type ? 'Approved' : 'Denied') . ' Time Adjustment Request #' . $id,
                    'attendance/timeadjustment/all_requests'
                );
                $emp_info = $this->employee_info($data['employee_id']);
                $this->template_mail->config($emp_info['division_id'])
                ->_send(
                    $emp_info['email'],
                    null,
                    sprintf('Time Adjustment Request for %s (#%s) is %s', date('l, d-m-Y', strtotime($data['checkin'])), $id, ($type ? 'Approved' : 'Rejected')),
                    $this->load->view('attendance/emails/process', ['employee' => $emp_info, 'request' => $data, 'action' => ($type ? 'approved' : 'rejected')], true),
                    $emp_info['supervisor_email']
                );
                $this->activity
                    ->set_employee($data['employee_id'])
                    ->log([
                        'timeadjustment_processed',
                        'HR',
                        $type ? 'Approved' : 'Denied',
                        $id,
                        formatted_date($data['checkin']),
                    ]);
            }
        } elseif ($data['supervisor_status'] == 'pending' && in_array($data['employee_id'], $employees_under) && $data['employee_id'] != $this->session->userdata('employee_id')) {
            $res = $this->update($id, [
                'supervisor_status' => $type ? 'approved' : 'denied',
            ]);
            if ($res) {
                $this->notify->employee($data['employee_id'])->department('hr')->send(
                    sprintf('Supervisor %s %s time adjustment request #%s',
                        $this->session->userdata('fullname'),
                        ($type ? 'approved' : 'denied'),
                        $id),
                    'attendance/timeadjustment/all_requests'
                );
                $this->activity
                    ->set_employee($data['employee_id'])
                    ->log([
                        'timeadjustment_processed',
                        'Manager',
                        $type ? 'Approved' : 'Denied',
                        $id,
                        formatted_date($data['checkin']),
                    ]);
            }
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function modify_attendance($new_record)
    {
        $date = explode(' ', $new_record['checkin'])[0];
        $this->db->where(['day' => $date, 'uid' => $new_record['employee_id']])->update('attendance_history', ['active' => 0]);

        $this->load->model('attendence_model');
        return $this->attendence_model->custom_punch($new_record['employee_id'], $new_record['checkin'], $new_record['checkout'], $this->session->userdata('employee_id'));
    }
    public function get_table()
    {
        if ($this->session->userdata('isAdmin') || $this->permission->method('atn_time_adjustment_list', 'update')->access() || $this->permission->full('attendance')->access()) {
        } else {
            $employees = array_column($this->get_subordinates(true), 'employee_id');
            $this->db->where_in('tb1.employee_id', $employees);
        }
        return getByWhereAsArray(
            'time_adjustment tb1,
            employee_history tb2-tb1.employee_id=tb2.employee_id-left,
            employee_history tb3-tb1.supervisor=tb3.employee_id-left,
            employee_history tb4-tb1.hr_approver=tb4.employee_id-left',
            'tb1.*,
            CONCAT_WS(\' \', tb2.first_name, tb2.last_name) as employee_name, tb2.email,
            CONCAT_WS(\' \', tb3.first_name, tb3.last_name) as supervisor_name,
            CONCAT_WS(\' \', tb4.first_name, tb4.last_name) as hr_name',
            [],
            ['added_at', 'DESC']
        );
    }
    private function add_fields($data)
    {
        $data['added_at'] = date('Y-m-d H:i:s');
        $data['modified_at'] = date('Y-m-d H:i:s');
        return $data;
    }
    public function get_employee($id)
    {
        return $this->db->where('employee_id', $id)->get('employee_history')->row();
    }
    public function employee_info($id)
    {
        return $this->db
        ->select('eh.first_name, eh.last_name, COALESCE(eh.business_email, eh.home_email) as email, COALESCE(supervisor.business_email, supervisor.home_email) as supervisor_email, eh.division_id, d.name as division')
        ->join('divisions d', 'eh.division_id=d.id', 'left')
        ->join('employee_history supervisor', 'eh.super_visor_id=supervisor.employee_id', 'left')
        ->where('eh.employee_id', $id)
        ->get('employee_history eh')->row_array();
    }
    public function get_subordinates($override_filter = false)
    {
        $this->load->model('employee/employees_model');
        return $this->employees_model->get_subordinates(null, true, $override_filter);
    }
    public function query()
    {
        if ($this->session->userdata('isAdmin') || $this->permission->method('atn_time_adjustment_list', 'update')->access() || $this->permission->full('attendance')->access()) {
        } else {
            $employees = array_column($this->get_subordinates(true), 'employee_id');
            $this->db->where_in('tb1.employee_id', $employees);
        }
        $this->db->select('tb1.id,
        tb1.employee_id,
        tb1.checkin,
        tb1.checkout,
        tb1.reason,
        tb1.hr_status,
        tb1.supervisor_status,
        tb1.supervisor,
        tb1.added_at,
        CONCAT_WS(\' \', tb2.first_name, tb2.last_name, tb2.hrm_id) as employee_name, tb2.email')
        ->from('time_adjustment tb1')
        ->join('employee_history tb2', 'tb1.employee_id=tb2.employee_id', 'left');
        
        if($this->session->userdata('_filter_timeadjustment_status')) {
            switch ($this->session->userdata('_filter_timeadjustment_status')) {
                case 'pending-supervisor':{
                    $this->db->where(['tb1.supervisor >' => 0, 'tb1.supervisor_status' => 'pending', 'tb1.hr_status' => 'pending']);
                    break;
                }
                case 'approved-supervisor':
                case 'pending-hr':{
                    $this->db->group_start()
                    ->group_start()
                    ->where(['tb1.supervisor >' => 0, 'tb1.supervisor_status' => 'approved'])
                    ->group_end()
                    ->or_group_start()
                    ->where(['tb1.supervisor <=' => 0])
                    ->group_end()
                    ->group_end()
                    ->where(['tb1.hr_status' => 'pending']);
                    break;
                }
                case 'denied-supervisor':{
                    $this->db->where(['tb1.supervisor_status' => 'denied', 'tb1.hr_status' => 'pending']);
                    break;
                }
                case 'approved-hr':{
                    $this->db->where(['tb1.hr_status' => 'approved']);
                    break;
                }
                case 'denied-hr':{
                    $this->db->where(['tb1.hr_status' => 'denied']);
                    break;
                }
            }
        }
    }
    public function countAllRows()
    {
        $this->query();
        return $this->db->count_all_results();
    }
    public function countDatatable($orWhere, $where_arr = [])
    {
        $this->query();
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $value) {
                if(strpos($value[1], '%') === false) {
                    $this->db->or_where($value[0] . ' = ', $value[1]);
                } else {
                    $this->db->or_like($value[0], $value[1], 'after', false);
                }
            }
            $this->db->group_end();
        }
        foreach ($where_arr as $where_ar) {
            $this->db->where($where_ar[0], $where_ar[1]);
        }
        return $this->db->count_all_results();
    }
    public function getDatatable($orWhere, $where_arr = [])
    {
        $post = $this->input->post();
        $this->query();
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $value) {
                if(strpos($value[1], '%') === false) {
                    $this->db->or_where($value[0] . ' = ', $value[1]);
                } else {
                    $this->db->or_like($value[0], $value[1], 'after', false);
                }
            }
            $this->db->group_end();
        }
        foreach ($where_arr as $where_ar) {
            $this->db->where($where_ar[0], $where_ar[1]);
        }
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get()->result_array();
    }
}
