<?php
class Device_model extends CI_Model
{
    public function getDevices()
    {
        return $this->db->select('deviceinfo.*, divisions.name as division_name')
            ->join('divisions', 'deviceinfo.division_id = divisions.id', 'left')
            ->get('deviceinfo')->result();
    }
    public function getDevice($id)
    {
        return $this->db->select('deviceinfo.*, divisions.name as division_name')
            ->join('divisions', 'deviceinfo.division_id = divisions.id', 'left')
            ->where('deviceinfo.id', $id)
            ->get('deviceinfo')->row();
    }
    public function getDevicesDivision($division_id)
    {
        return $this->db->select('deviceinfo.*, divisions.name as division_name')
            ->join('divisions', 'deviceinfo.division_id = divisions.id', 'left')
            ->where('deviceinfo.division_id', $division_id)
            ->get('deviceinfo')->result();
    }
    public function getDeviceTypes()
    {
        return get_enum_values('deviceinfo', 'type');
    }
    public function save($data)
    {
        $save_data = [
            'division_id' => $data['division_id'],
            'type' => $data['type'],
            'device_ip' => $data['device_ip'],
            'port' => $data['port'],
            'password' => $this->encryption->encrypt($data['password']),
            'active' => $data['status'] == 'active' ? 1 : 0
        ];
        if (empty(@$data['id'])) {
            return $this->db->insert('deviceinfo', $save_data);
        } else {
            return $this->db->where('id', $data['id'])->update('deviceinfo', $save_data);
        }
    }
    public function delete($id)
    {
        return $this->db->where('id', $id)->delete('deviceinfo');
    }
    public function create_user($employee_id)
    {
        $pin = random_string('nozero', 4);
        $this->bio_devices->createUser($employee_id, $pin);
        return [
            'ID' => $employee_id,
            'PIN' => $pin,
            'key' => 'biomid'
        ];
    }
    public function check_connection($id)
    {
        $device = $this->getDevice($id);
        $device_inst = $this->bio_devices->getInstanceFromType($device->type, $device->device_ip, $device->port, $device->password);
        return $device_inst->connect();
    }
}
