<?php
class Attendence_model extends CI_Model
{
    public $enums = [
        'P' => 'Present',
        'LA' => 'Late Arrival',
        'EC' => 'Early Checkout',
        'UH-D' => 'Unpaid Half-Day',
        'A' => 'Absent',
        'FD' => 'Full Day',
        'OT' => 'Overtime',
    ];
    public function get_shift($id)
    {
        return $this->db->where('id', $id)->get('shift')->row();
    }
    public function get_shift_by_employee($uid)
    {
        return $this->db->where('employee_history.employee_id', $uid)->select('shift.*')->join('shift', 'employee_history.shift = shift.id', 'left')->get('employee_history')->row();
    }
    public function get_current_status($shift_id, $last_check_type, $punch_time = null, $punchout_time = null, $emp_id = null)
    {
        $shift = $this->get_shift($shift_id);
        if ($shift->flexible_shift) {
            return $this->get_current_status_flexible($shift, $last_check_type, $punch_time, $punchout_time, $emp_id);
        } else {
            return $this->get_current_status_fixed($shift, $last_check_type, $punch_time, $punchout_time, $emp_id);
        }
    }
    public function get_current_status_flexible($shift, $last_check_type, $punch_time, $punchout_time = null, $emp_id = null)
    {
        $status = null;
        switch ($last_check_type) {
            case "out":
                $status = [
                    'flag' => 'P',
                    'note_required' => false,
                ];
                break;
            case "in":
                $shift_percenage = $this->shift_percentage($shift, $punch_time, $punchout_time, $emp_id);
                if ($shift_percenage < 18) {
                    $status = [
                        'flag' => 'A',
                        'note_required' => true,
                    ];
                }
                if ($shift_percenage >= 18 && $shift_percenage < 67) {
                    $status = [
                        'flag' => 'UH-D',
                        'note_required' => true,
                    ];
                }
                if ($shift_percenage >= 67 && $shift_percenage <= 109) {
                    $status = [
                        'flag' => 'FD',
                        'note_required' => false,
                    ];
                }
                if ($shift_percenage > 109) {
                    $status = [
                        'flag' => 'OT',
                        'note_required' => false,
                    ];
                }
                break;
        }
        return $status;
    }
    public function get_current_status_fixed($shift, $last_check_type, $punch_time, $punchout_time = null, $emp_id = null)
    {
        $time = time();
        if ($punch_time) {
            $time = strtotime($punch_time);
        }

        //$todays_shift = $this->shift_to_time($shift);
        $shift_time = $this->shift_to_time($shift, $punch_time);

        $start = $shift_time['start'];

        $status = null;
        switch ($last_check_type) {
            case "out":
                /* if (strtotime($punch_time) >= $todays_shift['start'] && strtotime($punch_time) <= $todays_shift['end']) {
                $status = null;
                } else */
                $diff = $time - $start;
                if ($diff < 900) {
                    $status = [
                        'flag' => 'P',
                        'note_required' => false,
                    ];
                }
                if ($diff >= 900 && $diff < 28800) {
                    $status = [
                        'flag' => 'LA',
                        'note_required' => true,
                    ];
                }
                break;
            case "in":
                $shift_percenage = $this->shift_percentage($shift, $punch_time, $punchout_time, $emp_id);
                if ($shift_percenage < 18) {
                    $status = [
                        'flag' => 'A',
                        'note_required' => true,
                    ];
                }
                if ($shift_percenage >= 18 && $shift_percenage < 67) {
                    $status = [
                        'flag' => 'UH-D',
                        'note_required' => true,
                    ];
                }
                if ($shift_percenage >= 67 && $shift_percenage <= 109) {
                    $status = [
                        'flag' => 'FD',
                        'note_required' => false,
                    ];
                }
                if ($shift_percenage > 109) {
                    $status = [
                        'flag' => 'OT',
                        'note_required' => false,
                    ];
                }
                break;
        }
        return $status;
    }
    public function is_nightsift($shift)
    {
        if ($shift->flexible_shift) {
            return false;
        }
        $start = intval(str_replace(':', '', $shift->start));
        $end = intval(str_replace(':', '', $shift->end));

        if ($start > $end) {
            return true;
        }
        return false;
    }
    public function shift_to_time($shift, $punch_time = null)
    {
        if ($shift->flexible_shift) {
            return [];
        }
        if (!$punch_time) {
            $punch_time = date('Y-m-d h:i:s A');
        }

        $punch_date = explode(' ', $punch_time)[0] . ' ';

        if ($this->is_nightsift($shift)) {
            $start = strtotime($punch_date . $shift->start);

            $end = new DateTime($punch_date . $shift->end);
            $end = $end->modify('+1 day')->format('U');
        } else {
            $start = strtotime($punch_date . $shift->start);
            $end = strtotime($punch_date . $shift->end);
        }
        return [
            'start' => $start,
            'end' => $end,
        ];
    }
    public function get_current_worktime($employee_id = null, $day = null)
    {
        if (!$employee_id) {
            $employee_id = $this->session->userdata('employee_id');
        }
        $day = current_working_day($day);
        $day = date('Y-m-d H:i:s', strtotime($day . '-1 hour'));
        $recs = $this->db->query(
            'CALL get_current_worked_time(?, ?)',
            [$employee_id, $day]
        )->result();
        $this->db->next_result();
        if (!$recs) {
            return [];
        }
        $recs = array_filter($recs, function ($rec) {
            if (!$rec->punchout_time) {
                return true;
            }
            if (strtotime($rec->punchout_time) > strtotime('-12 hours')) {
                return true;
            }
            return false;
        });
        return array_values($recs);
    }
    public function shift_percentage($shift, $punch_time, $punchout = null, $emp_id = null)
    {
        if ($shift->flexible_shift) {
            $shift_period = $shift->flexible_hours * 3600; //convert hours to seconds
        } else {
            $shift_time = $this->shift_to_time($shift, $punch_time);
            $shift_period = $shift_time['end'] - $shift_time['start'];
        }
        $time = $punchout ? strtotime($punchout) : time();
        $current_shift_period = $time - strtotime($punch_time);

        $current_shift_period += $this->previous_punch_sum($emp_id);

        $perc = ($current_shift_period / $shift_period) * 100;

        return is_finite($perc) && $perc >= 1 ? round($perc) : 0;
    }
    public function custom_punch($uid, $start, $end, $author)
    {
        $shift = $this->get_shift_by_employee($uid);
        $status_in = $this->get_current_status($shift->id, 'out', $start, null, $uid)['flag'];
        $percentage = $this->shift_percentage($shift, $start, $end);

        $group_no = $this->generate_group_no();

        $flag = '';
        if ($percentage < 18) {
            $flag = 'A';
        } elseif ($percentage >= 18 && $percentage < 67) {
            $flag = 'UH-D';
        } elseif ($percentage >= 67) {
            $flag = 'FD';
        }
        $attendence_data = [
            'group_no' => $group_no,
            'uid' => $uid,
            'id' => 0,
            'state' => 1,
            'day' => current_working_day($start),
            'time' => $start,
            'punch_author' => $author ?? 0,
            'active' => 1,
        ];

        $insert_data = [
            array_merge($attendence_data, ['punchin_time' => $start, 'status' => 'in', 'flag' => $status_in]),
            array_merge($attendence_data, ['punchout_time' => $end, 'duration' => strtotime($end) - strtotime($start), 'status' => 'out', 'flag' => $flag]),
        ];

        foreach ($insert_data as $ins_data) {
            if ($ins_data['status'] == 'out') {
                $ins_data['time'] = date('Y-m-d H:i:s', strtotime($ins_data['time'] . ' +30 seconds'));
            }
            $this->db->insert('attendance_history', $ins_data);
        }
        $this->activity->set_employee($uid)->set_url(sprintf('attendance/home/admin_attendance/%s/%s', $uid, date('d-m-Y', strtotime($start))))->log([
            'full_attendance_inserted',
            formatted_date($start, true),
            formatted_date($end, true),
        ]);
        return true;
    }
    public function previous_punch_sum($id = null)
    {
        if (!$id) {
            $id = $this->session->userdata('employee_id');
        }
        $res = $this->db->query("SELECT
                    SUM(duration) AS duration
                FROM `attendance_history`
                WHERE `uid` = ?
                AND `active` = 1
                AND `day` = curdate()
                GROUP BY `day`",
            [$id])
            ->row();
        if ($res) {
            return intval($res->duration);
        }
        return 0;
    }
    public function get_subordinates($employee_id = null, $employee_ids = null, $dept_ids = null, $supervisorids = null, $active_only = false)
    {
        if (is_null($employee_id)) {
            $employee_id = $this->session->userdata('employee_id');
        }
        $query = "SELECT
            *
        FROM employee_history AS emp
            RIGHT JOIN (SELECT
                employee_id,
                hrm_id,
                first_name,
                last_name
            FROM employee_history
            WHERE employee_id = ?
            UNION
            SELECT
                employee_id,
                hrm_id,
                first_name,
                last_name
            FROM employee_history
            WHERE indirect_super_visor_id = ?
            UNION
            SELECT
                employee_id,
                hrm_id,
                first_name,
                last_name
            FROM employee_history
            WHERE super_visor_id = ?
            UNION
            SELECT
                employee_id,
                hrm_id,
                first_name,
                last_name
            FROM employee_history
            WHERE employee_id IN (SELECT
                employee_id
                FROM employee_history
                WHERE super_visor_id IN (SELECT
                    employee_id
                FROM employee_history
                WHERE super_visor_id = ?
                OR indirect_super_visor_id = ?)) UNION
            SELECT
                employee_id,
                hrm_id,
                first_name,
                last_name
            FROM employee_history
            WHERE employee_id IN (SELECT
                employee_id
                FROM employee_history
                WHERE indirect_super_visor_id IN (SELECT
                    employee_id
                FROM employee_history
                WHERE super_visor_id = ?
                OR indirect_super_visor_id = ?))) AS t
            ON t.employee_id = emp.employee_id";
        $query2 = [];
        if ($employee_ids) {
            $query2[] = "emp.employee_id IN ($employee_ids)";
        }
        if ($dept_ids) {
            $query2[] = "emp.dept_id IN ($dept_ids)";
        }
        if ($supervisorids) {
            $query2[] = "emp.super_visor_id IN ($supervisorids)";
        }
        if ($active_only) {
            $query2[] = "emp.status = 'active'";
        }
        if (count($query2) > 0) {
            $query .= " WHERE ";
            $query .= implode(' AND ', $query2);
        }
        return $this->db->query($query, array_fill(0, 7, intval($employee_id)))->result_array();
    }
    public function employeeAttendanceCheck($get)
    {
        $emp = [];
        if ($this->session->userdata('isAdmin') == 1 || $this->permission->full('attendance')->access() || $this->permission->method('atn_log_datewise', 'update')->access()) {
            if (!emptyArrayElements($get, ['employee_id', 'dept_id', 'supervisorid'])) {
                $this->db->group_start();
                if ($get['employee_id']) {
                    $this->db->where_in('employee_id', $get['employee_id']);
                }
                if ($get['dept_id']) {
                    $this->db->where_in('dept_id', $get['dept_id']);
                }
                if ($get['supervisorid']) {
                    $this->db->where_in('super_visor_id', $get['supervisorid']);
                }
                $this->db->group_end();
            }
            if (!$this->permission->module('show_inactive_employees')->access() || $get['status'] != 'all') {
                $this->db->group_start()
                    ->where('is_resigned', 0)
                    ->or_group_start()
                    ->where([
                        'termination_date >' => sql_date($get['start_date']),
                        'termination_date <=' => sql_date($get['end_date']),
                    ])
                    ->group_end()
                    ->group_end();
            }
            $emp = $this->db->select('employee_id')->order_by('first_name', 'asc')->get('employee_details')->result_array();
            $emp = array_column($emp, 'employee_id');
        } elseif ($this->session->userdata('supervisor')) {
            $employee_ids = null;
            $dept_ids = null;
            $supervisorids = null;
            if (!emptyArrayElements($get, ['employee_id', 'dept_id', 'supervisorid'])) {
                if ($get['employee_id']) {
                    $employee_ids = implode(',', $get['employee_id']);
                }
                if ($get['dept_id']) {
                    $dept_ids = implode(',', $get['dept_id']);
                }
                if ($get['supervisorid']) {
                    $supervisorids = implode(',', $get['supervisorid']);
                }
            }
            $emp = array_column($this->get_subordinates(null, $employee_ids, $dept_ids, $supervisorids, !$this->permission->module('show_inactive_employees')->access() || $get['status'] != 'all'), 'employee_id');
        } else {
            $emp = [$this->session->userdata('employee_id')];
        }
        return $emp;
    }

    public function get_report($emp_ids, $start, $end)
    {
        if (empty($emp_ids)) {
            return [];
        }
        if (!empty($start)) {
            $start = sql_date($start);
        }
        if (!empty($end)) {
            $end = sql_date($end);
        }
        $emps = $this->db
            ->select(
                'employee_id,
                first_name as firstname,
                last_name as lastname,
                hrm_id,
                shift_id as shift,
                shift as shift_name,
                department,
                hire_date,
                termination_date,
                status,
                is_resigned'
            )
            ->from('employee_details')
            ->where_in('employee_id', $emp_ids)
            ->order_by('hrm_id', 'asc')
            ->get()
            ->result_array();
        $emp_data = [];
        foreach ($emps as $emp_details) {
            $emp_details['attendence'] = [];
            $emp_data['e_' . $emp_details['employee_id']] = $emp_details;
        }
        $attendence = $this->db->select(
            '`day`,
            uid,
            MIN(punchin_time) AS punchin_time,
            MAX(punchout_time) AS punchout_time,
            SUM(duration) AS duration,
            GROUP_CONCAT(flag) AS status,
            GROUP_CONCAT(DISTINCT state_type_in) as state_type_in,
            GROUP_CONCAT(DISTINCT state_type_out) as state_type_out'
        )
            ->where_in('uid', $emp_ids)
            ->where([
                'day >=' => $start . ' 00:00:00',
                'day <=' => $end . ' 23:59:59',
            ])
            ->group_by(['day', 'uid'])
            ->order_by('punchin_time')
            ->get('attendance_view')
            ->result_array();
        foreach ($attendence as $attn) {
            $attn['status'] = array_unique(explode(',', $attn['status']));
            $attn['state_type_in'] = array_unique(explode(',', $attn['state_type_in']));
            $attn['state_type_out'] = array_unique(explode(',', $attn['state_type_out']));
            $emp_data['e_' . $attn['uid']]['attendence'][$attn['day']] = $attn;
        }
        return array_values($emp_data);
    }
    public function get_user_day_report($id, $date)
    {
        $emp_details = @getByWhereAsArray(
            'employee_history',
            'first_name as firstname, last_name as lastname, hrm_id',
            ['employee_id' => $id]
        )[0];
        if ($emp_details) {
            $emp_details = [
                'employee_id' => $id,
                'firstname' => $emp_details['firstname'],
                'lastname' => $emp_details['lastname'],
                'hrm_id' => $emp_details['hrm_id'],
                'attendence' => [],
            ];
        }

        $attendence = $this->db
            ->where(['uid' => $id, 'day' => $date])
            ->get('attendance_view')->result_array();
        foreach ($attendence as $attn) {
            $attn['state_type_in'] = array_unique(explode(',', $attn['state_type_in']));
            $attn['state_type_out'] = array_unique(explode(',', $attn['state_type_out']));
            $attn['flag'] = array_unique(explode(',', $attn['flag']));
            $emp_details['attendence'][] = $attn;
        }
        return $emp_details;
    }
    public function get_user_day_report2($id, $date)
    {
        $emp_details = @getByWhereAsArray(
            'employee_history',
            'first_name as firstname, last_name as lastname, hrm_id',
            ['employee_id' => $id]
        )[0];
        if ($emp_details) {
            $emp_details = [
                'employee_id' => $id,
                'firstname' => $emp_details['firstname'],
                'lastname' => $emp_details['lastname'],
                'hrm_id' => $emp_details['hrm_id'],
                'attendence' => [],
            ];
        }

        $attendence = $this->db->query(
            "SELECT
            group_no,
            MAX(punchin_time) as punchin_time,
            MAX(punchout_time) as punchout_time,
            MAX(duration) as duration,
            `day`
        FROM `attendance_history`
        WHERE `uid` = ?
        AND `active` = 1
        AND `day` = ?
        GROUP BY `group_no`
        ORDER BY punchin_time ASC",
            [$id, $date]
        )->result_array();
        foreach ($attendence as $attn) {
            $attn['flag'] = array_unique(explode(',', $attn['flag']));
            $emp_details['attendence'][] = $attn;
        }
        return $emp_details;
    }
    public function get_group($id)
    {
        $attendence = $this->db->query(
            "SELECT
            MAX(punchin_time) as punchin_time,
            MAX(punchout_time) as punchout_time
        FROM `attendance_history`
        WHERE `active` = 1
        AND `group_no` = '$id'
        GROUP BY `group_no`
        ORDER BY punchin_time ASC"
        )->row_array();
        $attendence['flag'] = array_unique(explode(',', $attendence['flag']));
        return $attendence;
    }
    public function delete_group($emp_id, $gid)
    {
        $group_date = $this->db
            ->select('day as date')
            ->where('group_no', $gid)
            ->get('attendance_history')
            ->row();
        $this->activity
            ->set_employee($emp_id)
            ->log([
                'attendance_group_deleted',
                formatted_date($group_date->date),
            ]);
        return $this->db->delete('attendance_history', [
            'group_no' => $gid,
            'uid' => $emp_id,
        ]);
    }
    public function update_group($id, $start, $end, $emp_id)
    {
        $start = date('Y-m-d H:i:s', strtotime($start));
        if ($end) {
            $end = date('Y-m-d H:i:s', strtotime($end));
        }
        $group_date = $this->db
            ->select('day as date')
            ->where(['group_no' => $id, 'uid' => $emp_id])
            ->get('attendance_history')
            ->row();
        $shift = $this->get_shift_by_employee($emp_id);
        $status_in = $this->get_current_status($shift->id, 'out', $start, null, $emp_id)['flag'];
        $this->db->trans_begin();
        $this->db->where([
            'group_no' => $id,
            'uid' => $emp_id,
            'punchin_time !=' => null,
            'active' => 1,
        ])->update('attendance_history', [
            'day' => current_working_day($start),
            'punchin_time' => $start,
            'flag' => $status_in,
        ]);

        if ($end) {
            $this->activity->set_employee($emp_id)->set_url(sprintf('attendance/home/edit_group/%s/%s', $emp_id, $id))->log([
                'attendance_group_update',
                formatted_date($group_date->date),
                formatted_date($start, true),
                formatted_date($end, true),
            ]);
        } else {
            $this->activity->set_employee($emp_id)->set_url(sprintf('attendance/home/edit_group/%s/%s', $emp_id, $id))->log([
                'attendance_group_update_in',
                formatted_date($group_date->date),
                formatted_date($start, true),
            ]);
        }
        if ($end) {
            $status = $this->get_current_status($shift->id, 'in', $start, $end, $emp_id)['flag'];
            $author = empty($this->session->userdata('employee_id')) ? $this->session->userdata('id') : $this->session->userdata('employee_id');

            $old_punchout = $this->db->where([
                'group_no' => $id,
                'uid' => $emp_id,
                'punchout_time !=' => null,
                'active' => 1,
            ])->get('attendance_history')->row();
            if ($old_punchout) {
                $this->db->where('atten_his_id', $old_punchout->atten_his_id)
                    ->update('attendance_history', [
                        'punchout_time' => $end,
                        'flag' => $status,
                        'duration' => strtotime($end) - strtotime($start),
                        'punch_author' => $author,
                    ]);
            } else {
                $this->db->insert('attendance_history', [
                    'group_no' => $id,
                    'uid' => $emp_id,
                    'id' => 0,
                    'state' => 1,
                    'day' => current_working_day($start),
                    'time' => date('Y-m-d H:i:s', strtotime($end)),
                    'punchout_time' => $end,
                    'duration' => strtotime($end) - strtotime($start),
                    'status' => 'out',
                    'punch_author' => $author,
                    'flag' => $status,
                ]);
            }
        }
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
        }
        return $this->db->trans_status();
    }
    public function get_day_leave($employee_id, $day)
    {
        $leave = $this->db->query(
            'CALL get_day_leave(?, ?);',
            [$employee_id, $day]
        )->row();
        $this->db->next_result();
        return $leave;
    }
    public function generate_group_no()
    {
        $rec = $this->db->select_max('group_no')->get('attendance_history')->row();
        if (!$rec) {
            return 1;
        }
        $rec->group_no += 1;

        return $rec->group_no;
    }
    public function last_record($employee_id = null, $date = null)
    {
        if (is_null($employee_id)) {
            $employee_id = $this->session->userdata('employee_id');
        }
        if (is_null($date)) {
            $date = date('Y-m-d H:i:s');
        }
        return $this->db
            ->where(['uid' => $employee_id, 'active' => 1])
            ->where('time <= ', $date)
            ->order_by('time', 'desc')
            ->limit(1)
            ->get('attendance_history')
            ->row();
    }
    public function old_checkins_query()
    {
        return $this->db->select(
            'attendance_view.punchin_time,
            attendance_view.group_no,
            attendance_view.uid,
            CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name) AS full_name,
            employee_history.hrm_id,
            TIMESTAMPDIFF(HOUR, attendance_view.punchin_time, SYSDATE()) AS hours'
        )
            ->from('attendance_view')
            ->join('employee_history', 'attendance_view.uid = employee_history.employee_id', 'left')
            ->where([
                'attendance_view.punchout_time' => null,
                'TIMESTAMPDIFF(HOUR, attendance_view.punchin_time, SYSDATE()) >' => 10,
            ]);
    }
    public function checkout_manual($employee_id, $group_no)
    {
        $rec = $this->db->where(['uid' => $employee_id, 'group_no' => $group_no, 'punchout_time' => null])->get('attendance_view')->row();
        if ($rec) {
            $time = date('Y-m-d H:i:s');
            $shift = $this->get_shift_by_employee($employee_id);
            $percentage = $this->shift_percentage($shift, $rec->punchin_time, $time);

            $flag = '';
            if ($percentage < 18) {
                $flag = 'A';
            } elseif ($percentage >= 18 && $percentage < 67) {
                $flag = 'UH-D';
            } elseif ($percentage >= 67) {
                $flag = 'FD';
            }

            $exists = $this->db->where(['uid' => $employee_id, 'group_no' => $group_no, 'punchout_time' => null])->count_all_results('attendance_view');
            if (!$exists) {
                return true;
            }
            $this->db->trans_start();
            $this->db->insert('attendance_history', [
                'group_no' => $group_no,
                'uid' => $employee_id,
                'id' => 0,
                'state' => 1,
                'time' => $time,
                'punch_author' => $this->session->userdata('employee_id') ?? 0,
                'active' => 1,
                'punchout_time' => $time,
                'duration' => strtotime($time) - strtotime($rec->punchin_time),
                'status' => 'out',
                'flag' => $flag,
            ]);
            $this->activity->set_employee($employee_id)->log([
                'attendance_manual_checkout',
                formatted_date($time, true),
            ]);
            $this->db->trans_complete();
            return $this->db->trans_status();
        } else {
            return true;
        }
    }
    public function countAllRows_checkins()
    {
        $this->old_checkins_query();
        return $this->db->count_all_results();
    }
    public function countDatatable_checkins($orWhere = [])
    {
        $this->old_checkins_query();
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'after', false);
            }
            $this->db->group_end();
        }
        return $this->db->count_all_results();
    }
    public function getDatatable_checkins($post, $orWhere = [])
    {
        $this->old_checkins_query();
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'after', false);
            }
            $this->db->group_end();
        }
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get()->result_array();
    }
    public function add_machine_punch($type, $state, $employee_id, $shift_id, $time, $device_id, $device_row_id)
    {
        /* $result = $this->last_record($employee_id, $time);
        if ($result->status == $type) {
            $this->_add_machine_punch($state, $employee_id, $shift_id, sql_date($time . ' -2 sec', true), $device_id, $device_row_id);
        } */
        $this->_add_machine_punch($state, $employee_id, $shift_id, $time, $device_id, $device_row_id);
    }
    private function _add_machine_punch($state, $employee_id, $shift_id, $time, $device_id, $device_row_id)
    {
        $result = $this->last_record($employee_id, $time);
        $attendence_status = [];
        if ($result) {
            switch ($result->status) {
                case "in":
                    $attendence_status[] = $this->attendence_model->get_current_status($shift_id, $result->status, $result->punchin_time);
                    break;
                case "out":
                    $attendence_status[] = $this->attendence_model->get_current_status($shift_id, $result->status, date('Y-m-d H:i:s'), $result->punchout_time);
                    break;
            }
        } else {
            $as = $this->attendence_model->get_current_status($shift_id, 'out', date('Y-m-d h:i:s A'));
            if ($as) {
                $attendence_status[] = $as;
            }
        }
        $att_time = date('Y-m-d H:i:s', strtotime($time));
        $attendance_history = [
            'uid' => $employee_id,
            'state' => 1,
            'state_type' => $state,
            'id' => 0,
            'device_id' => $device_id,
            'device_row_id' => $device_row_id,
        ];
        if ($result && $result->status == 'in') {
            $shift_percentage = $this->shift_percentage($this->get_shift($shift_id), $result->punchin_time);

            if ($shift_percentage < 18) {
                $attendence_status[] = ['flag' => 'A'];
            }
            if ($shift_percentage >= 18 && $shift_percentage < 67) {
                $attendence_status[] = ['flag' => 'UH-D'];
            }
            if ($shift_percentage >= 67) {
                $attendence_status[] = ['flag' => 'FD'];
            }
            $attendance_history['day'] = $result->day;
            $attendance_history['punchout_time'] = $att_time;
            $attendance_history['status'] = 'out';
            $attendance_history['group_no'] = (int) $result->group_no;
            $attendance_history['time'] = $att_time;
            $attendance_history['remarks_out'] = strip_tags($this->input->post('remarks'));
            $attendance_history['duration'] = strtotime($att_time) - strtotime($result->punchin_time);
            $attendance_history['punch_author'] = $employee_id;
            $attendance_history['flag'] = $attendence_status ? implode(',', array_column($attendence_status, 'flag')) : null;
        } else {
            $attendance_history['day'] = current_working_day(date('Y-m-d H:i:s', strtotime($att_time . ' +2 hours')));
            $attendance_history['status'] = 'in';
            $attendance_history['punchin_time'] = $att_time;
            $attendance_history['time'] = $att_time;
            $attendance_history['uid'] = $employee_id;
            $attendance_history['remarks_in'] = strip_tags($this->input->post('remarks'));
            $attendance_history['punch_author'] = $employee_id;
            $attendance_history['group_no'] = $this->generate_group_no();
            $attendance_history['flag'] = $attendence_status ? implode(',', array_column($attendence_status, 'flag')) : null;
        }
        $this->db->insert('attendance_history', $attendance_history);
    }
    public function stateToFa($states)
    {
        if (!is_array($states)) {
            $states = [$states];
        }
        $html = '';
        foreach ($states as $state) {
            if(empty($state)) {
                continue;
            }
            $html .= '<i data-toggle="tooltip" class="fa fa-';
            $state = explode(',', $state);
            $state = array_pop($state);
            switch ($state) {
                case 'finger':{
                        $html .= 'hand-pointer-o" title="' . display(['attendance', 'via', 'finger', 'scan'], true);
                        break;
                    }
                case 'card':{
                        $html .= 'id-card" title="' . display(['attendance', 'via', 'card', 'scan'], true);
                        break;
                    }
                case 'face':{
                        $html .= 'meh-o" title="' . display(['attendance', 'via', 'face', 'scan'], true);
                        break;
                    }
                case 'password':{
                        $html .= 'asterisk" title="' . display(['attendance', 'suing', 'password'], true);
                        break;
                    }
                default:
                    $html .= 'desktop" title="' . display(['attendance', 'via'], true) . ' HRM';
                    break;
            }
            $html .= '" aria-hidden="true" style="float:right;margin-left:3px"></i>';
        }
        return $html;
    }
}
