<?php

use GuzzleHttp\Psr7\Stream;

interface HRMFileHandlerInterface
{
    public function search(string $file_name, $isDirectory = false, $parent = null): array;
    public function get(string $file_id): ?HRMFile;
    public function getBinary(string $file_id) : ?string;
    public function getHRMRootId() : ?string;
    public function all(): array;
    public function create(string $filepath, $parent = null): ?HRMFile;
    public function createDirectory(string $dirName, $parent = null): ?HRMFile;
    public function delete(string $file_id): bool;
    public function stream(string $file_id): void;
    public static function createURL(string $file_id): string;
}
