<?php
class SessionManager
{
    private $CI = null;
    private $table = 'active_sessions';
    private $session_dir = '';
    private $session_cookie = '';
    public function __construct()
    {
        $this->CI = &get_instance();
        $this->session_dir = $this->CI->config->config['sess_save_path'];
        $this->session_cookie = $this->CI->config->config['sess_cookie_name'];
    }
    public function check()
    {
        if (!$this->CI->session->userdata('id')) {
            return false;
        }
        $this->CI->load->library('user_agent');
        if (!$id = $this->CI->session->userdata('_nonce_id')) {
            $id = $this->generateId();
            $this->CI->session->set_userdata('_nonce_id', $id);
            return $this->CI->db->insert($this->table, [
                'nonce' => $id,
                'user_id' => $this->CI->session->userdata('id'),
                'session_id' => session_id(),
                'is_mobile' => $this->CI->agent->is_mobile() ? 1 : 0,
                'ip_address' => $this->CI->input->ip_address(),
                'browser' => $this->CI->agent->browser(),
                'platform' => $this->CI->agent->platform(),
                'last_active' => date('Y-m-d H:i:s'),
            ]);
        } else {
            if ($this->CI->db->where('nonce', $id)->count_all_results($this->table) < 1) {
                $this->CI->session->unset_userdata('_nonce_id');
                return $this->check();
            }
            return $this->CI->db->where('nonce', $id)->update($this->table, [
                'user_id' => $this->CI->session->userdata('id'),
                'session_id' => session_id(),
                'ip_address' => $this->CI->input->ip_address(),
                'last_active' => date('Y-m-d H:i:s'),
            ]);
        }
    }
    public function generateId()
    {
        $this->CI->load->helper('string');

        $id = null;
        do {
            $id = random_string('alnum', 128);
        } while ($this->CI->db->where('nonce', $id)->count_all_results($this->table) > 0);

        return $id;
    }
    public function currentId()
    {
        return $this->CI->session->userdata('_nonce_id');
    }
    public function get($user_id)
    {
        return $this->CI->db->select('nonce, session_id, is_mobile, ip_address, browser, platform, last_active')->where('user_id', $user_id)->order_by('last_active', 'desc')->get($this->table)->result();
    }
    public function count($user_id = null)
    {
        if (!$user_id) {
            $user_id = $this->CI->session->userdata('id');
        }
        return $this->CI->db->where('user_id', $user_id)->count_all_results($this->table);
    }
    public function destroy($user_id, $nonce = null, $except = null, $soft_delete = false)
    {
        if ($nonce) {
            $this->CI->db->where('nonce', $nonce);
        }
        if ($except) {
            $this->CI->db->where('nonce !=', $except);
        }
        $recs = $this->CI->db->select('nonce, session_id')->where('user_id', $user_id)->get($this->table)->result();
        if (!$recs) {
            return true;
        }
        $this->CI->db->where_in('nonce', array_column($recs, 'nonce'))->delete($this->table);
        if (!$soft_delete) {
            foreach ($recs as $rec) {
                @unlink($this->session_dir . $this->session_cookie . $rec->session_id);
            }
        }
        return true;
    }
    public function cleanOldRecords($interval = '-5 days')
    {
        $intervalDate = date('Y-m-d H:i:s', strtotime($interval));
        $recs = $this->CI->db->select('nonce, session_id')->where('last_active <=', $intervalDate)->get($this->table)->result();
        if ($recs) {
            $this->CI->db->where_in('nonce', array_column($recs, 'nonce'))->delete($this->table);
            foreach ($recs as $rec) {
                @unlink($this->session_dir . $this->session_cookie . $rec->session_id);
            }
        }
        return true;
    }
}
